/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.taskdatasync;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BizTaskEntityService {
    private static final Log LOGGER = LogFactory.getLog(BizTaskEntityService.class);
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String HSTC_BIZTASKENTITY = "hstc_biztaskentity";

    public static BizTaskEntityService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public DynamicObjectCollection queryBizTaskEntityByRoute(String dbRouteKey) {
        return QueryServiceHelper.query((String)HSTC_BIZTASKENTITY, (String)"id,bizcloud,number,dbroute,isv,taskentity,taskhistoryentity", (QFilter[])new QFilter[]{new QFilter("dbroute", "=", (Object)dbRouteKey)}, (String)"createtime");
    }

    public Long saveBizTaskEntity(MainEntityType taskEntityType, MainEntityType taskHisEntityType) {
        String number = taskEntityType.getBizAppNumber();
        DynamicObject bizDy = this.getBizApp(number);
        String name = bizDy.getString("name");
        String bizcloud = bizDy.getString("bizcloud.number");
        String isv = bizDy.getString("isv");
        String dbRoute = taskEntityType.getDBRouteKey();
        String taskentity = taskEntityType.getExtendName();
        String tasktable = taskEntityType.getAlias();
        String taskhistoryentity = taskHisEntityType.getExtendName();
        String taskhistorytable = taskHisEntityType.getAlias();
        Long id = ID.genLongId();
        DynamicObject saveDy = BusinessDataServiceHelper.newDynamicObject((String)HSTC_BIZTASKENTITY);
        saveDy.set("id", (Object)id);
        saveDy.set("number", (Object)number);
        saveDy.set("name", (Object)name);
        saveDy.set("bizcloud", (Object)bizcloud);
        saveDy.set("isv", (Object)isv);
        saveDy.set("dbroute", (Object)dbRoute);
        saveDy.set("taskentity", (Object)taskentity);
        saveDy.set("tasktable", (Object)tasktable);
        saveDy.set("taskhistoryentity", (Object)taskhistoryentity);
        saveDy.set("taskhistorytable", (Object)taskhistorytable);
        saveDy.set("status", (Object)"C");
        saveDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        saveDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        saveDy.set("enable", (Object)"1");
        saveDy.set("masterid", (Object)id);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDy});
        return saveDy.getLong("id");
    }

    public DynamicObject getBizApp(String number) {
        return QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_BIZAPP, (String)"id,number,name,bizcloud.id,bizcloud.number,isv,dbroute", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
    }

    public String queryBizTaskTableNumberByTaskEntity(String taskEntityNumber, boolean isProcessing) {
        QFilter qFilter;
        String selectProperties = isProcessing ? "tasktable" : "taskhistorytable";
        DynamicObjectCollection tableDyColl = QueryServiceHelper.query((String)HSTC_BIZTASKENTITY, (String)selectProperties, (QFilter[])new QFilter[]{qFilter = new QFilter(isProcessing ? "taskentity" : "taskhistoryentity", "=", (Object)taskEntityNumber)});
        if (tableDyColl.isEmpty()) {
            return "";
        }
        return ((DynamicObject)tableDyColl.get(0)).getString(selectProperties);
    }

    public DynamicObjectCollection queryAllDbTable() {
        return QueryServiceHelper.query((String)HSTC_BIZTASKENTITY, (String)"dbroute,taskentity,tasktable,taskhistoryentity,taskhistorytable", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")});
    }

    private static class InstanceHolder {
        private static final BizTaskEntityService INSTANCE = new BizTaskEntityService();

        private InstanceHolder() {
        }
    }
}

