/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.taskdatasync.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.ssc.hstc.business.taskdatasync.cache.BizTaskAppCache;

public class BatchBizTaskAppCache
extends BizTaskAppCache {
    protected static final String BATCH_CACHE_PREFIX = "BATCH";
    protected String dataChangeType;

    protected BatchBizTaskAppCache(String dataChangeType, String bizTaskEntityNumber) {
        super(bizTaskEntityNumber, "BATCH$" + dataChangeType);
        this.dataChangeType = dataChangeType;
    }

    public Set<Long> queryCache() {
        HashSet<Long> resultSet = new HashSet<Long>(10);
        String[] cacheArr = this.cache.getSetValues(this.cacheKey);
        if (cacheArr != null) {
            for (String cacheStr : cacheArr) {
                resultSet.add(Long.parseLong(cacheStr));
            }
        }
        return resultSet;
    }

    public void saveCache(Collection<Long> taskIdSet) {
        String[] saveCacheArr = (String[])taskIdSet.stream().map(String::valueOf).toArray(String[]::new);
        this.cache.addToSet(this.cacheKey, saveCacheArr, 10);
    }

    public void removeCache(Collection<Long> taskIdSet) {
        String[] removeArr = (String[])taskIdSet.stream().map(String::valueOf).toArray(String[]::new);
        this.cache.removeSetValues(this.cacheKey, removeArr);
    }

    public static class Builder {
        private String dataChangeType;
        private String bizTaskEntityNumber;

        public Builder setBizTaskEntityNumber(String bizTaskEntityNumber) {
            this.bizTaskEntityNumber = bizTaskEntityNumber;
            return this;
        }

        public Builder setDataChangeType(String dataChangeType) {
            this.dataChangeType = dataChangeType;
            return this;
        }

        public BatchBizTaskAppCache build() {
            return new BatchBizTaskAppCache(this.dataChangeType, this.bizTaskEntityNumber);
        }
    }
}

