/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.taskdatasync.cache;

import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.hstc.business.taskdatasync.cache.BatchBizTaskAppCache;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordDataChangeTypeEnum;

public class BatchBizTaskAppCacheFactory {
    private static final Log LOGGER = LogFactory.getLog(BatchBizTaskAppCacheFactory.class);

    public static void batchSaveCache(String dataChangeType, Map<String, List<Long>> targetEntityTaskIdListMap) {
        if (targetEntityTaskIdListMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<Long>> entry : targetEntityTaskIdListMap.entrySet()) {
            String targetEntityNumber = entry.getKey();
            List<Long> taskIdList = entry.getValue();
            BatchBizTaskAppCache batchBizTaskAppCache = new BatchBizTaskAppCache.Builder().setDataChangeType(dataChangeType).setBizTaskEntityNumber(targetEntityNumber).build();
            batchBizTaskAppCache.saveCache(taskIdList);
        }
    }

    public static void batchRemoveCache(String dataChangeType, String targetEntityNumber, List<Long> taskIdList, Object batchNumber) {
        try {
            BatchBizTaskAppCache batchBizTaskAppCache = new BatchBizTaskAppCache.Builder().setDataChangeType(dataChangeType).setBizTaskEntityNumber(targetEntityNumber).build();
            batchBizTaskAppCache.removeCache(taskIdList);
        }
        catch (Exception e) {
            LOGGER.error("batchNumber:" + batchNumber + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static BatchBizTaskAppCache getBatchDeleteBizTaskAppCache(String bizTaskEntityNumber) {
        return BatchBizTaskAppCacheFactory.getBatchBizTaskAppCache(TaskRecordDataChangeTypeEnum.DELETE.getCode(), bizTaskEntityNumber);
    }

    public static BatchBizTaskAppCache getBatchInsertBizTaskAppCache(String bizTaskEntityNumber) {
        return BatchBizTaskAppCacheFactory.getBatchBizTaskAppCache(TaskRecordDataChangeTypeEnum.INSERT.getCode(), bizTaskEntityNumber);
    }

    public static BatchBizTaskAppCache getBatchUpdateBizTaskAppCache(String bizTaskEntityNumber) {
        return BatchBizTaskAppCacheFactory.getBatchBizTaskAppCache(TaskRecordDataChangeTypeEnum.UPDATE.getCode(), bizTaskEntityNumber);
    }

    private static BatchBizTaskAppCache getBatchBizTaskAppCache(String dataChangeType, String bizTaskEntityNumber) {
        return new BatchBizTaskAppCache.Builder().setDataChangeType(dataChangeType).setBizTaskEntityNumber(bizTaskEntityNumber).build();
    }
}

