/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.taskdatasync.cache;

import java.util.Collection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.hstc.business.taskdatasync.cache.FullBizTaskAppCache;

public class FullBizTaskAppCacheFactory {
    private static final Log LOGGER = LogFactory.getLog(FullBizTaskAppCacheFactory.class);

    public static void fullSaveCache(String targetEntityNumber, Object cacheValue) {
        if (StringUtils.isEmpty((CharSequence)targetEntityNumber)) {
            return;
        }
        FullBizTaskAppCache taskAppCache = new FullBizTaskAppCache.Builder().setBizTaskEntityNumber(targetEntityNumber).build();
        taskAppCache.saveCache(String.valueOf(cacheValue));
    }

    public static void fullRemoveCache(Collection<String> targetEntityNumberSet, Object cacheValue) {
        if (targetEntityNumberSet.isEmpty()) {
            return;
        }
        for (String targetEntityNumber : targetEntityNumberSet) {
            try {
                FullBizTaskAppCache taskAppCache = new FullBizTaskAppCache.Builder().setBizTaskEntityNumber(targetEntityNumber).build();
                taskAppCache.removeCache();
            }
            catch (Exception e) {
                LOGGER.error("batchNumber:" + cacheValue + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static FullBizTaskAppCache getFullBizTaskAppCache(String targetEntityNumber) {
        return new FullBizTaskAppCache.Builder().setBizTaskEntityNumber(targetEntityNumber).build();
    }
}

