/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.taskdatasync.record;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.hstc.business.taskdatasync.cache.BatchBizTaskAppCacheFactory;
import kd.ssc.hstc.business.taskdatasync.util.BizTaskEntityUtil;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordDataChangeTypeEnum;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordSyncStatusEnum;

public class TaskDataSyncRecordSaveService
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(TaskDataSyncRecordSaveService.class);
    private String taskEntityNumber;
    private String dataChangeType;
    private Boolean isFullSync;
    private List<Long> idList;
    private Long batchNumber;
    private Map<String, List<Long>> targetEntityTaskIdListMap;
    private boolean saveSuccess = true;

    public void saveTaskDataSyncRecord() {
        try {
            if (this.isFullSync.booleanValue()) {
                this.saveFullTaskDataSyncRecord();
            } else {
                this.saveBatchTaskDataSyncRecord();
            }
        }
        catch (Exception e) {
            this.saveSuccess = false;
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.deleteTaskDataSyncRecord();
            throw e;
        }
    }

    private void deleteTaskDataSyncRecord() {
        if (!this.saveSuccess) {
            LOGGER.info("TaskDataSyncRecordService save error. delete batchnumber:{}", (Object)this.batchNumber);
            DeleteServiceHelper.delete((String)"hstc_taskdatasyncrecord", (QFilter[])new QFilter[]{new QFilter("batchnumber", "=", (Object)this.batchNumber)});
        }
    }

    private void saveFullTaskDataSyncRecord() {
        DynamicObject taskdataSyncRecordDy = this.createNewRecordDy();
        DynamicObjectCollection entryentity = taskdataSyncRecordDy.getDynamicObjectCollection("entryentity");
        List bizTaskEntityList = new Parser().getFullBizTaskEntityList();
        for (String bizTaskEntity : bizTaskEntityList) {
            DynamicObjectType entryentityType = entryentity.getDynamicObjectType();
            DynamicObject row = (DynamicObject)entryentityType.createInstance();
            row.set("targetentitynumber", (Object)bizTaskEntity);
            row.set("targetdatacount", (Object)0);
            row.set("targetsyncstatus", (Object)TaskRecordSyncStatusEnum.WORKING.getCode());
            entryentity.add((Object)row);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskdataSyncRecordDy});
    }

    private void saveBatchTaskDataSyncRecord() {
        DynamicObject taskdataSyncRecordDy = this.createNewRecordDy();
        taskdataSyncRecordDy.set("datacount", (Object)this.idList.size());
        DynamicObjectCollection entryentity = taskdataSyncRecordDy.getDynamicObjectCollection("entryentity");
        Map<String, List<Long>> targetEntityTaskIdListMap = this.setAndGetTargetEntityMap();
        if (targetEntityTaskIdListMap.isEmpty()) {
            taskdataSyncRecordDy.set("syncstatus", (Object)TaskRecordSyncStatusEnum.FINISH.getCode());
            taskdataSyncRecordDy.set("syncmsg", (Object)"not data need sync.");
            taskdataSyncRecordDy.set("taskfinishtime", (Object)new Date());
        } else {
            for (Map.Entry<String, List<Long>> targetEntityEntry : targetEntityTaskIdListMap.entrySet()) {
                String targetEntity = targetEntityEntry.getKey();
                List<Long> taskIdList = targetEntityEntry.getValue();
                DynamicObjectType entryentityType = entryentity.getDynamicObjectType();
                DynamicObject row = (DynamicObject)entryentityType.createInstance();
                row.set("targetentitynumber", (Object)targetEntity);
                row.set("targetdatacount", (Object)taskIdList.size());
                row.set("targetsyncstatus", (Object)TaskRecordSyncStatusEnum.WORKING.getCode());
                entryentity.add((Object)row);
                DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
                DynamicObjectType subentryentityType = subentryentity.getDynamicObjectType();
                for (Long taskId : taskIdList) {
                    DynamicObject subRow = (DynamicObject)subentryentityType.createInstance();
                    subRow.set("taskid", (Object)taskId);
                    subentryentity.add((Object)subRow);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskdataSyncRecordDy});
    }

    private Map<String, List<Long>> setAndGetTargetEntityMap() {
        Map<String, List<Long>> targetEntityTaskIdListMap = new Parser().getBatchTargetEntityMap();
        this.targetEntityTaskIdListMap = targetEntityTaskIdListMap;
        return targetEntityTaskIdListMap;
    }

    private DynamicObject createNewRecordDy() {
        DynamicObject taskdataSyncRecordDy = BusinessDataServiceHelper.newDynamicObject((String)"hstc_taskdatasyncrecord");
        taskdataSyncRecordDy.set("batchnumber", (Object)this.batchNumber);
        taskdataSyncRecordDy.set("taskentitynumber", (Object)this.taskEntityNumber);
        taskdataSyncRecordDy.set("fullsync", (Object)this.isFullSync);
        taskdataSyncRecordDy.set("datachangetype", (Object)this.dataChangeType);
        taskdataSyncRecordDy.set("syncstatus", (Object)TaskRecordSyncStatusEnum.WORKING.getCode());
        taskdataSyncRecordDy.set("taskstarttime", (Object)new Date());
        taskdataSyncRecordDy.set("retrycount", (Object)0);
        this.setCreatAndUpdate(taskdataSyncRecordDy);
        return taskdataSyncRecordDy;
    }

    private void setCreatAndUpdate(DynamicObject taskdataSyncRecordDy) {
        taskdataSyncRecordDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        taskdataSyncRecordDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        taskdataSyncRecordDy.set("createtime", (Object)new Date());
        taskdataSyncRecordDy.set("modifytime", (Object)new Date());
    }

    public void updateFailStatus(String errMsg) {
        DynamicObject updateDy = BusinessDataServiceHelper.loadSingle((String)"hstc_taskdatasyncrecord", (String)"id,syncstatus,syncmsg", (QFilter[])new QFilter[]{new QFilter("batchnumber", "=", (Object)this.batchNumber)});
        if (updateDy != null) {
            updateDy.set("syncstatus", (Object)TaskRecordSyncStatusEnum.FAIL.getCode());
            updateDy.set("syncmsg", (Object)errMsg);
            SaveServiceHelper.update((DynamicObject)updateDy);
        }
    }

    public String getMqMessage() {
        if (!this.isFullSync.booleanValue() && this.targetEntityTaskIdListMap.isEmpty()) {
            return "";
        }
        return this.getBatchNumber() + "";
    }

    public void buildAndSaveCache() {
        if (!this.isFullSync.booleanValue()) {
            LOGGER.info("{}: ssctasksyncdata buildAndSaveCache dataChangeType:{}, targetEntityNumbers:{} ", new Object[]{this.batchNumber, this.dataChangeType, this.targetEntityTaskIdListMap.keySet()});
            BatchBizTaskAppCacheFactory.batchSaveCache(this.dataChangeType, this.targetEntityTaskIdListMap);
        }
    }

    public Long getBatchNumber() {
        return this.batchNumber;
    }

    public String toString() {
        return "TaskDataSyncDTO{taskEntityNumber='" + this.taskEntityNumber + '\'' + ", dataChangeType='" + this.dataChangeType + '\'' + ", isFullSync=" + this.isFullSync + ", idList=" + this.idList + ", batchNumber=" + this.batchNumber + '}';
    }

    public boolean isSaveSuccess() {
        return this.saveSuccess;
    }

    private class Parser {
        protected boolean isProcssing;

        public Parser() {
            this.isProcssing = StringUtils.equals((CharSequence)TaskDataSyncRecordSaveService.this.taskEntityNumber, (CharSequence)"task_task");
        }

        private List<String> getFullBizTaskEntityList() {
            String bizTaskEntityField = this.isProcssing ? "taskentity" : "taskhistoryentity";
            DynamicObjectCollection bizTaskEntityDyColl = QueryServiceHelper.query((String)"hstc_biztaskentity", (String)bizTaskEntityField, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")});
            if (bizTaskEntityDyColl.isEmpty()) {
                LOGGER.info("{}: ssctasksyncdata getFullBizTaskEntityList is empty.", (Object)TaskDataSyncRecordSaveService.this.batchNumber);
                return new ArrayList<String>();
            }
            List<String> bizTaskEntityList = bizTaskEntityDyColl.stream().filter(bizTaskEntityDy -> BizTaskEntityUtil.isWhiteMainQuery(bizTaskEntityDy.getString(bizTaskEntityField))).map(bizTaskEntityDy -> bizTaskEntityDy.getString(bizTaskEntityField)).collect(Collectors.toList());
            if (bizTaskEntityList.isEmpty()) {
                LOGGER.info("{}: ssctasksyncdata getFullBizTaskEntityList is empty. taskEntityNumber\uff1a{} ", (Object)TaskDataSyncRecordSaveService.this.batchNumber, (Object)TaskDataSyncRecordSaveService.this.taskEntityNumber);
                return new ArrayList<String>();
            }
            return bizTaskEntityList;
        }

        public Map<String, List<Long>> getBatchTargetEntityMap() {
            HashMap<String, List<Long>> targetEntityNumberMap = new HashMap<String, List<Long>>(16);
            if (StringUtils.equals((CharSequence)TaskRecordDataChangeTypeEnum.DELETE.getCode(), (CharSequence)TaskDataSyncRecordSaveService.this.dataChangeType)) {
                this.getDeleteBatchTargetEntityMap(targetEntityNumberMap);
            } else {
                this.getInsertOrUpdateBatchTargetEntityMap(targetEntityNumberMap);
            }
            LOGGER.info("{}: ssctasksyncdata targetEntityNumberMap.keySet:{}", (Object)TaskDataSyncRecordSaveService.this.batchNumber, targetEntityNumberMap.keySet());
            return targetEntityNumberMap;
        }

        private void getInsertOrUpdateBatchTargetEntityMap(Map<String, List<Long>> targetEntityNumberMap) {
            DynamicObjectCollection taskDyColl = QueryServiceHelper.query((String)TaskDataSyncRecordSaveService.this.taskEntityNumber, (String)"id,billtype.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)TaskDataSyncRecordSaveService.this.idList)});
            Map taskbillDyTaskIdListMap = taskDyColl.stream().collect(Collectors.groupingBy(taskDy -> taskDy.getLong("billtype.id"), Collectors.mapping(taskDy -> taskDy.getLong("id"), Collectors.toList())));
            Set<Long> billtypeIdSet = taskbillDyTaskIdListMap.keySet();
            String targetEntityField = this.isProcssing ? "taskpool.mainquery.number" : "taskpool.mainqueryh.number";
            DynamicObjectCollection taskbillDyColl = QueryServiceHelper.query((String)"task_taskbill", (String)("id," + targetEntityField), (QFilter[])new QFilter[]{new QFilter("id", "in", billtypeIdSet)});
            Map targetEntityNumberTaskBillIdListMap = taskbillDyColl.stream().filter(taskDy -> BizTaskEntityUtil.isWhiteMainQuery(taskDy.getString(targetEntityField))).collect(Collectors.groupingBy(taskDy -> taskDy.getString(targetEntityField), Collectors.mapping(taskDy -> taskDy.getLong("id"), Collectors.toList())));
            for (Map.Entry entry : targetEntityNumberTaskBillIdListMap.entrySet()) {
                String targetEntityNumber = entry.getKey();
                List<Long> targetTaskIdList = targetEntityNumberMap.get(targetEntityNumber);
                if (CollectionUtils.isEmpty(targetTaskIdList)) {
                    targetTaskIdList = new ArrayList<Long>();
                }
                List taskBillIdList = entry.getValue();
                for (Long taskBillId : taskBillIdList) {
                    List taskIdList = taskbillDyTaskIdListMap.get(taskBillId);
                    targetTaskIdList.addAll(taskIdList);
                }
                targetEntityNumberMap.put(targetEntityNumber, targetTaskIdList);
            }
        }

        private void getDeleteBatchTargetEntityMap(Map<String, List<Long>> targetEntityNumberMap) {
            List<String> bizTaskEntityList = this.getFullBizTaskEntityList();
            HashSet idListSet = new HashSet(TaskDataSyncRecordSaveService.this.idList);
            for (String bizTaskEntity : bizTaskEntityList) {
                DynamicObjectCollection bizTaskEntityDyColl = QueryServiceHelper.query((String)bizTaskEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", idListSet)});
                if (bizTaskEntityDyColl.isEmpty()) continue;
                List<Long> bizTaskIdList = bizTaskEntityDyColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                targetEntityNumberMap.put(bizTaskEntity, bizTaskIdList);
                bizTaskIdList.forEach(idListSet::remove);
                if (!idListSet.isEmpty()) continue;
                break;
            }
            if (!idListSet.isEmpty()) {
                LOGGER.info("{}: ssctasksyncdata getDeleteBatchTargetEntityMap not match idList:{} ", (Object)TaskDataSyncRecordSaveService.this.batchNumber, idListSet);
            }
        }
    }

    public static class Builder {
        private String taskEntityNumber;
        private String dataChangeType;
        private Boolean isFullSync;
        private List<Long> idList;

        public Builder setTaskEntityNumber(String taskEntityNumber) {
            this.taskEntityNumber = taskEntityNumber;
            return this;
        }

        public Builder setDataChangeType(String dataChangeType) {
            this.dataChangeType = dataChangeType;
            return this;
        }

        public Builder setFullSync(Boolean fullSync) {
            this.isFullSync = fullSync;
            return this;
        }

        public Builder setIdList(List<Long> idList) {
            this.idList = idList;
            return this;
        }

        public TaskDataSyncRecordSaveService build() {
            TaskDataSyncRecordSaveService taskDataSyncRecordSaveService = new TaskDataSyncRecordSaveService();
            taskDataSyncRecordSaveService.taskEntityNumber = this.taskEntityNumber;
            taskDataSyncRecordSaveService.dataChangeType = this.dataChangeType;
            taskDataSyncRecordSaveService.isFullSync = this.isFullSync != null && this.isFullSync != false;
            taskDataSyncRecordSaveService.idList = this.idList != null ? this.idList : new ArrayList(10);
            taskDataSyncRecordSaveService.batchNumber = ID.genLongId();
            return taskDataSyncRecordSaveService;
        }
    }
}

