/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.taskdatasync.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ssc.hstc.business.taskdatasync.BizTaskEntityService;
import kd.ssc.hstc.business.taskdatasync.cache.FullBizTaskAppCacheFactory;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncBusinessService;
import kd.ssc.hstc.business.taskdatasync.util.BizTaskEntityUtil;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordSyncStatusEnum;

public class FullTaskDataSyncBusinessService
extends TaskDataSyncBusinessService {
    private static final Log LOGGER = LogFactory.getLog(FullTaskDataSyncBusinessService.class);

    public FullTaskDataSyncBusinessService(DynamicObject taskdataSyncRecordDy) {
        super(taskdataSyncRecordDy);
    }

    @Override
    public void doSyncData() {
        if (this.taskdataSyncRecordEntryEntityDyColl.isEmpty()) {
            LOGGER.info("{}: ssctasksyncdata FullTask.doSyncData taskdataSyncRecordEntryEntityDyColl is empty. taskEntityNumber\uff1a{} ", (Object)this.batchNumber, (Object)this.taskEntityNumber);
            return;
        }
        int dataCount = 0;
        HashSet<String> cacheTargetEntityNumberSet = new HashSet<String>(this.taskdataSyncRecordEntryEntityDyColl.size());
        for (DynamicObject entryentity : this.taskdataSyncRecordEntryEntityDyColl) {
            String targetsyncstatus = entryentity.getString("targetsyncstatus");
            if (TaskRecordSyncStatusEnum.isFinish((String)targetsyncstatus)) continue;
            String targetEntityNumber = entryentity.getString("targetentitynumber");
            if (BizTaskEntityUtil.isBlankMainQuery(targetEntityNumber)) {
                LOGGER.info("{}: ssctasksyncdata FullTask.doFullSyncData isBlankMainQuery targetEntityNumber:{}.", (Object)this.batchNumber, (Object)targetEntityNumber);
                String tableName = BizTaskEntityService.getInstance().queryBizTaskTableNumberByTaskEntity(targetEntityNumber, this.isProcssing);
                entryentity.set("targetsyncmsg", (Object)String.format("isBlankMainQuery. tableName:%s", tableName));
                continue;
            }
            LOGGER.info("{}: ssctasksyncdata FullTask.doFullSyncData targetEntityNumber:{}.", (Object)this.batchNumber, (Object)targetEntityNumber);
            FullBizTaskAppCacheFactory.fullSaveCache(targetEntityNumber, this.batchNumber);
            cacheTargetEntityNumberSet.add(targetEntityNumber);
            dataCount += this.doFullSyncData(entryentity);
        }
        this.taskdataSyncRecordDy.set("datacount", (Object)dataCount);
        FullBizTaskAppCacheFactory.fullRemoveCache(cacheTargetEntityNumberSet, this.batchNumber);
    }

    private int doFullSyncData(DynamicObject entryentity) {
        try {
            String targetEntityNumber = entryentity.getString("targetentitynumber");
            DeleteServiceHelper.delete((String)targetEntityNumber, (QFilter[])new QFilter[]{QFilter.of((String)"1 = 1", (Object[])new Object[0])});
            List<Long> taskIdList = this.getTaskIdByTargetEntityNumber(targetEntityNumber);
            LOGGER.info("{}: ssctasksyncdata FullTask.doFullSaveSyncData,taskIdList.size:{}, targetEntityNumber:{}", new Object[]{this.batchNumber, taskIdList, targetEntityNumber});
            this.insertData(targetEntityNumber, taskIdList);
            int targetDataCount = taskIdList.size();
            entryentity.set("targetdatacount", (Object)targetDataCount);
            entryentity.set("targetsyncstatus", (Object)TaskRecordSyncStatusEnum.FINISH.getCode());
            entryentity.set("targetfinishtime", (Object)new Date());
            entryentity.set("targetsyncmsg", (Object)"");
            return targetDataCount;
        }
        catch (Exception e) {
            LOGGER.error(this.batchNumber + ": " + e.getMessage(), (Throwable)e);
            entryentity.set("targetsyncstatus", (Object)TaskRecordSyncStatusEnum.FAIL.getCode());
            entryentity.set("targetsyncmsg", (Object)"FullTask.doSyncData fail.");
            this.syncStatus = false;
            return 0;
        }
    }

    private List<Long> getTaskIdByTargetEntityNumber(String targetEntityNumber) {
        LOGGER.info("{}: ssctasksyncdata FullTask.getTaskIdByTargetEntityNumber taskEntityNumber\uff1a{} , targetEntityNumber:{}", new Object[]{this.batchNumber, this.taskEntityNumber, targetEntityNumber});
        String taskpoolMainQueryField = this.isProcssing ? "taskpool.mainquery.number" : "taskpool.mainqueryh.number";
        DynamicObjectCollection taskbillDyColl = QueryServiceHelper.query((String)"task_taskbill", (String)("id," + taskpoolMainQueryField), (QFilter[])new QFilter[]{new QFilter(taskpoolMainQueryField, "=", (Object)targetEntityNumber)});
        if (taskbillDyColl.isEmpty()) {
            LOGGER.info("{}: ssctasksyncdata FullTask.getTaskIdByTargetEntityNumber taskbillDyColl is empty.", (Object)this.batchNumber);
            return new ArrayList<Long>();
        }
        List taskBillIdList = taskbillDyColl.stream().map(taskDy -> taskDy.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection taskDyColl = QueryServiceHelper.query((String)this.taskEntityNumber, (String)"id,billtype.id", (QFilter[])new QFilter[]{new QFilter("billtype.id", "in", taskBillIdList)});
        if (taskDyColl.isEmpty()) {
            LOGGER.info("{}: ssctasksyncdata FullTask.getTaskIdByTargetEntityNumber taskDyColl is empty.", (Object)this.batchNumber);
            return new ArrayList<Long>();
        }
        Map taskbillIdTaskIdListMap = taskDyColl.stream().collect(Collectors.groupingBy(taskDy -> taskDy.getLong("billtype.id"), Collectors.mapping(taskDy -> taskDy.getLong("id"), Collectors.toList())));
        ArrayList<Long> targetTaskIdList = new ArrayList<Long>();
        for (Long taskBillId : taskBillIdList) {
            List taskIdList = taskbillIdTaskIdListMap.getOrDefault(taskBillId, new ArrayList(10));
            targetTaskIdList.addAll(taskIdList);
        }
        LOGGER.info("{}: ssctasksyncdata FullTask.getTaskIdByTargetEntityNumber init finish. targetEntityNumber", (Object)this.batchNumber, (Object)targetEntityNumber);
        return targetTaskIdList;
    }
}

