/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.business.taskdatasync.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.hstc.business.taskdatasync.service.BatchTaskDataSyncBusinessService;
import kd.ssc.hstc.business.taskdatasync.service.FullTaskDataSyncBusinessService;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncBusinessService;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordSyncStatusEnum;

public class TaskDataSyncBusinessServiceFactory {
    private static final String ENTITY_NUMBER = "hstc_taskdatasyncrecord";

    public static TaskDataSyncBusinessService createServiceByRecordId(Long recordId) {
        return TaskDataSyncBusinessServiceFactory.createService(recordId);
    }

    public static TaskDataSyncBusinessService createServiceByMessage(String message) {
        Long batchNumber = Long.parseLong(String.valueOf(message));
        DynamicObject taskdatasyncRecordDy = QueryServiceHelper.queryOne((String)ENTITY_NUMBER, (String)"id,batchnumber,syncstatus,retrycount", (QFilter[])new QFilter[]{new QFilter("batchnumber", "=", (Object)batchNumber)});
        if (taskdatasyncRecordDy == null) {
            return null;
        }
        String syncstatus = taskdatasyncRecordDy.getString("syncstatus");
        if (TaskRecordSyncStatusEnum.isFinish((String)syncstatus)) {
            return null;
        }
        int retrycount = taskdatasyncRecordDy.getInt("retrycount");
        if (retrycount >= 3) {
            return null;
        }
        Long recordId = taskdatasyncRecordDy.getLong("id");
        return TaskDataSyncBusinessServiceFactory.createService(recordId);
    }

    public static TaskDataSyncBusinessService createService(Long recordId) {
        DynamicObject taskdatasyncRecordDy = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)ENTITY_NUMBER);
        boolean isFullsync = taskdatasyncRecordDy.getBoolean("fullsync");
        if (isFullsync) {
            return new FullTaskDataSyncBusinessService(taskdatasyncRecordDy);
        }
        return new BatchTaskDataSyncBusinessService(taskdatasyncRecordDy);
    }
}

