/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.service;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRAppServiceHelper;
import kd.ssc.hstc.business.taskdatasync.BizTaskEntityService;
import kd.ssc.hstc.common.mservice.resp.MsResponse;
import kd.ssc.hstc.service.IHSTCBizTaskEntityService;

public class HSTCBizTaskEntityServiceImpl
implements IHSTCBizTaskEntityService {
    private static final Log LOGGER = LogFactory.getLog(HSTCBizTaskEntityServiceImpl.class);
    private static final String ALLOW_TASK_META_FORMDESIGNID = "47IEG6E1M0HI";
    private static final String ALLOW_TASKHIS_META_FORMDESIGNID = "47ITBG15VOWO";
    private static final String SAVE_LOCK_PREFIX = "BIZTASKENTITYLOCK_";
    private static final String DBROUTE_SECD = "secd";

    public Map<String, Object> queryBizTaskEntity(String entityNumber) {
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            String dbRouteKey = dataEntityType.getDBRouteKey();
            String bizAppNumber = dataEntityType.getBizAppNumber();
            boolean dbIgnore = dataEntityType.isDbIgnore();
            if (dbIgnore) {
                return MsResponse.error((String)"500", (String)"this entity isDbIgnore.").buildMap();
            }
            DynamicObjectCollection bizTaskEntityDyColl = BizTaskEntityService.getInstance().queryBizTaskEntityByRoute(dbRouteKey);
            if (bizTaskEntityDyColl.isEmpty()) {
                DynamicObject bizDy = BizTaskEntityService.getInstance().getBizApp(bizAppNumber);
                if (bizDy == null) {
                    return MsResponse.error((String)"500", (String)String.format("this entity has not biz, bizAppNumber: %s", bizAppNumber)).buildMap();
                }
                String appId = bizDy.getString("id");
                LOGGER.info("HSTCBizTaskEntityServiceImpl#queryBizTaskEntity entityNumber:{}, dbRouteKey:{}, bizAppNumber:{}, appId:{}", new Object[]{entityNumber, dataEntityType, bizAppNumber, appId});
                Set hrAppSet = HRAppServiceHelper.getAllHRAppIdsExceptExt();
                if (hrAppSet.contains(appId) && !StringUtils.equals((CharSequence)DBROUTE_SECD, (CharSequence)dbRouteKey)) {
                    return MsResponse.error((String)"500", (String)"this entity is hr default app.").buildMap();
                }
                Set allHrAppSet = HRAppServiceHelper.getAllHRAppIds();
                allHrAppSet.removeAll(hrAppSet);
                if (allHrAppSet.contains(appId) || StringUtils.equals((CharSequence)DBROUTE_SECD, (CharSequence)dbRouteKey)) {
                    return MsResponse.error((String)"200", (String)"").put("isCreate", (Object)true).buildMap();
                }
                return MsResponse.error((String)"500", (String)"this entity is not hr entity.").buildMap();
            }
            if (bizTaskEntityDyColl.size() == 1) {
                DynamicObject returnDy = (DynamicObject)bizTaskEntityDyColl.get(0);
                return this.bizTaskEntitySuccessResponse(returnDy);
            }
            Optional<DynamicObject> findDyOp = bizTaskEntityDyColl.stream().filter(bizTaskEntityDy -> StringUtils.equals((CharSequence)bizTaskEntityDy.getString("number"), (CharSequence)bizAppNumber)).findFirst();
            if (findDyOp.isPresent()) {
                DynamicObject returnDy = findDyOp.get();
                return this.bizTaskEntitySuccessResponse(returnDy);
            }
            DynamicObject returnDy = (DynamicObject)bizTaskEntityDyColl.get(0);
            return this.bizTaskEntitySuccessResponse(returnDy);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return MsResponse.error((String)"500", (String)"this entity has exception.").buildMap();
        }
    }

    private Map<String, Object> bizTaskEntitySuccessResponse(DynamicObject returnDy) {
        return MsResponse.ok().put("taskentity", (Object)returnDy.getString("taskentity")).put("taskhistoryentity", (Object)returnDy.getString("taskhistoryentity")).buildMap();
    }

    public Map<String, Object> saveBizTaskEntity(String taskEntityNumber, String taskHisEntityNumber) {
        try {
            if (StringUtils.isEmpty((CharSequence)taskEntityNumber) || StringUtils.isEmpty((CharSequence)taskHisEntityNumber)) {
                return MsResponse.error((String)"500", (String)"this entity isEmpty.").buildMap();
            }
            if (StringUtils.equals((CharSequence)taskEntityNumber, (CharSequence)taskHisEntityNumber)) {
                return MsResponse.error((String)"500", (String)"this entity is same entityNumber.").buildMap();
            }
            MainEntityType taskEntityType = MetadataServiceHelper.getDataEntityType((String)taskEntityNumber);
            MainEntityType taskHisEntityType = MetadataServiceHelper.getDataEntityType((String)taskHisEntityNumber);
            if (taskEntityType.isDbIgnore() || taskHisEntityType.isDbIgnore()) {
                return MsResponse.error((String)"500", (String)"this entity isDbIgnore.").buildMap();
            }
            if (!StringUtils.equals((CharSequence)taskEntityType.getBizAppNumber(), (CharSequence)taskHisEntityType.getBizAppNumber())) {
                return MsResponse.error((String)"500", (String)"this entity is not same appNumber.").buildMap();
            }
            if (!StringUtils.equals((CharSequence)taskEntityType.getDBRouteKey(), (CharSequence)taskHisEntityType.getDBRouteKey())) {
                return MsResponse.error((String)"500", (String)"this entity is not same dbRoute.").buildMap();
            }
            if (!taskEntityType.getInheritPath().contains(ALLOW_TASK_META_FORMDESIGNID) || !taskHisEntityType.getInheritPath().contains(ALLOW_TASKHIS_META_FORMDESIGNID)) {
                return MsResponse.error((String)"500", (String)"this entity is not extend hbp.").buildMap();
            }
            String bizAppNumber = taskEntityType.getBizAppNumber();
            String dbRouteKey = taskEntityType.getDBRouteKey();
            DynamicObjectCollection bizTaskEntityDyColl = BizTaskEntityService.getInstance().queryBizTaskEntityByRoute(dbRouteKey);
            if (!bizTaskEntityDyColl.isEmpty()) {
                return this.existsDataSussessResponse(bizTaskEntityDyColl, bizAppNumber);
            }
            return this.saveBizTaskEntity(dbRouteKey, bizAppNumber, taskEntityType, taskHisEntityType);
        }
        catch (Exception e) {
            return MsResponse.error((String)"500", (String)"this entity is save method fail.").buildMap();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> saveBizTaskEntity(String dbRouteKey, String bizAppNumber, MainEntityType taskEntityType, MainEntityType taskHisEntityType) {
        try (DLock lock = DLock.create((String)(SAVE_LOCK_PREFIX + dbRouteKey));){
            if (!lock.tryLock()) {
                Map map = MsResponse.error((String)"500", (String)"this entity is save lock.").buildMap();
                return map;
            }
            DynamicObjectCollection bizTaskEntityDyColl = BizTaskEntityService.getInstance().queryBizTaskEntityByRoute(dbRouteKey);
            if (!bizTaskEntityDyColl.isEmpty()) {
                Map<String, Object> map = this.existsDataSussessResponse(bizTaskEntityDyColl, bizAppNumber);
                return map;
            }
            Long successPkId = BizTaskEntityService.getInstance().saveBizTaskEntity(taskEntityType, taskHisEntityType);
            Map map = MsResponse.ok().put("successId", (Object)successPkId).buildMap();
            return map;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return MsResponse.error((String)"500", (String)"this entity is save fail.").buildMap();
        }
    }

    private Map<String, Object> existsDataSussessResponse(DynamicObjectCollection bizTaskEntityDyColl, String bizAppNumber) {
        Optional<DynamicObject> findDyOp;
        DynamicObject returnDy = (DynamicObject)bizTaskEntityDyColl.get(0);
        if (bizTaskEntityDyColl.size() > 1 && (findDyOp = bizTaskEntityDyColl.stream().filter(bizTaskEntityDy -> StringUtils.equals((CharSequence)bizTaskEntityDy.getString("number"), (CharSequence)bizAppNumber)).findFirst()).isPresent()) {
            returnDy = findDyOp.get();
        }
        return MsResponse.ok().put("successId", (Object)returnDy.getLong("id")).buildMap();
    }
}

