/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.service;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.ssc.hstc.mq.HSTCMqSendHelper;
import kd.ssc.hstc.business.taskdatasync.record.TaskDataSyncRecordSaveService;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncBusinessService;
import kd.ssc.hstc.business.taskdatasync.service.TaskDataSyncBusinessServiceFactory;
import kd.ssc.hstc.common.mservice.resp.MsResponse;
import kd.ssc.hstc.common.taskdatasync.enums.TaskRecordSyncStatusEnum;
import kd.ssc.hstc.service.ISSCTaskSyncDataService;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;

public class SSCTaskSyncDataServiceImpl
implements ISSCTaskSyncDataService {
    private static final Log LOGGER = LogFactory.getLog(SSCTaskSyncDataServiceImpl.class);
    private static final Set<String> ALLOW_TASK_ENTITYNUMBER = Sets.newHashSet((Object[])new String[]{"task_task", "task_taskhistory"});
    private static final Set<String> ALLOW_DATA_CHANGE_TYPE = Sets.newHashSet((Object[])new String[]{"insert", "update", "delete"});
    private static final String SEND_SERVICE = "1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> syncData(Map<String, Object> map) {
        long start = System.currentTimeMillis();
        TaskDataSyncRecordSaveService taskDataSyncRecordSaveService = null;
        try {
            LOGGER.info("SSCTaskSyncDataServiceImpl syncData start. ");
            MsResponse validateResponse = this.validateParam(map);
            if (validateResponse != null) {
                Map map2 = validateResponse.buildMap();
                return map2;
            }
            String taskEntityNumber = MapUtils.getString(map, (Object)"taskEntityNumber");
            Boolean isFullSync = MapUtils.getBoolean(map, (Object)"isFullSync");
            String dataChangeType = MapUtils.getString(map, (Object)"dataChangeType");
            List idList = (List)MapUtils.getObject(map, (Object)"idList");
            String sendToService = MapUtils.getString(map, (Object)"sendToService");
            LOGGER.info("SSCTaskSyncDataServiceImpl syncData param taskEntityNumber:{}, isFullSync:{}, dataChangeType:{}", new Object[]{taskEntityNumber, isFullSync, dataChangeType});
            taskDataSyncRecordSaveService = new TaskDataSyncRecordSaveService.Builder().setTaskEntityNumber(taskEntityNumber).setDataChangeType(dataChangeType).setFullSync(isFullSync).setIdList(idList).build();
            Long batchNumber = taskDataSyncRecordSaveService.getBatchNumber();
            LOGGER.info("SSCTaskSyncDataServiceImpl syncData batchNumber:{}", (Object)batchNumber);
            taskDataSyncRecordSaveService.saveTaskDataSyncRecord();
            if (taskDataSyncRecordSaveService.isSaveSuccess() && SSCTaskSyncDataServiceImpl.sendMessage(sendToService, taskDataSyncRecordSaveService)) {
                Map map3 = MsResponse.ok().put("batchNumber", (Object)batchNumber).buildMap();
                return map3;
            }
            String errMsg = String.format("SSCTaskSyncDataServiceImpl syncData saveRecord fail:%s", batchNumber);
            LOGGER.info(errMsg);
            Map map4 = MsResponse.error((String)"500", (String)errMsg).put("batchNumber", (Object)batchNumber).buildMap();
            return map4;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (taskDataSyncRecordSaveService != null) {
                taskDataSyncRecordSaveService.updateFailStatus("SSCTaskSyncDataServiceImpl fail");
            }
            Map map5 = MsResponse.error((String)"500", (String)e.getMessage()).buildMap();
            return map5;
        }
        finally {
            LOGGER.info("SSCTaskSyncDataServiceImpl syncData end. use time:{} ms.", (Object)(System.currentTimeMillis() - start));
        }
    }

    private static boolean sendMessage(String sendToService, TaskDataSyncRecordSaveService taskDataSyncRecordSaveService) {
        TaskDataSyncBusinessService service;
        String mqMessage = taskDataSyncRecordSaveService.getMqMessage();
        if (StringUtils.isEmpty((CharSequence)mqMessage)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)SEND_SERVICE, (CharSequence)sendToService) && (service = TaskDataSyncBusinessServiceFactory.createServiceByMessage((String)mqMessage)) != null) {
            DynamicObject updateRecordDy = service.syncData();
            String syncstatus = updateRecordDy.getString("syncstatus");
            return TaskRecordSyncStatusEnum.isFinish((String)syncstatus);
        }
        HSTCMqSendHelper.publishToTaskDataSyncQueue((String)mqMessage);
        taskDataSyncRecordSaveService.buildAndSaveCache();
        return true;
    }

    private MsResponse validateParam(Map<String, Object> map) {
        StringBuilder errMsgBuilder = new StringBuilder();
        String taskEntityNumber = MapUtils.getString(map, (Object)"taskEntityNumber");
        if (StringUtils.isEmpty((CharSequence)taskEntityNumber)) {
            errMsgBuilder.append(ResManager.loadKDString((String)"\u540c\u6b65\u4efb\u52a1\u5b9e\u4f53\u4e0d\u4e3a\u7a7a\uff1b", (String)"SSCTaskSyncDataServiceImpl_0", (String)"ssc-hstc-mservice", (Object[])new Object[0]));
        } else if (!ALLOW_TASK_ENTITYNUMBER.contains(taskEntityNumber)) {
            errMsgBuilder.append(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u540c\u6b65\u4efb\u52a1\u5b9e\u4f53\uff1b", (String)"SSCTaskSyncDataServiceImpl_1", (String)"ssc-hstc-mservice", (Object[])new Object[0]));
        }
        Boolean isFullSync = MapUtils.getBoolean(map, (Object)"isFullSync");
        if (isFullSync == null) {
            isFullSync = false;
            map.put("isFullSync", isFullSync);
        }
        if (!isFullSync.booleanValue()) {
            String dataChangeType = MapUtils.getString(map, (Object)"dataChangeType");
            if (StringUtils.isEmpty((CharSequence)dataChangeType)) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u6570\u636e\u53d8\u5316\u7c7b\u578b\u4e0d\u4e3a\u7a7a\uff1b", (String)"SSCTaskSyncDataServiceImpl_2", (String)"ssc-hstc-mservice", (Object[])new Object[0]));
            } else if (!ALLOW_DATA_CHANGE_TYPE.contains(dataChangeType)) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u53d8\u5316\u7c7b\u578b\uff1b", (String)"SSCTaskSyncDataServiceImpl_3", (String)"ssc-hstc-mservice", (Object[])new Object[0]));
            }
            List idObjList = (List)map.get("idList");
            if (CollectionUtils.isEmpty((Collection)idObjList)) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u6570\u636e\u53d8\u5316ID\u96c6\u5408\u4e0d\u4e3a\u7a7a\uff1b", (String)"SSCTaskSyncDataServiceImpl_4", (String)"ssc-hstc-mservice", (Object[])new Object[0]));
            } else {
                List idList = idObjList.stream().map(idObj -> NumberUtils.toLong((String)String.valueOf(idObj))).collect(Collectors.toList());
                map.put("idList", idList);
            }
        }
        if (errMsgBuilder.length() > 0) {
            return MsResponse.error((String)errMsgBuilder.toString());
        }
        return null;
    }
}

