/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.servicehelper.SSCServiceHelper;
import kd.ssc.hstc.common.mservice.resp.MsResponse;
import kd.ssc.hstc.service.ITaskService;
import kd.ssc.hstc.service.helper.MsResponseHelper;
import kd.ssc.hstc.util.ObjectUtils;

public class TaskServiceImpl
implements ITaskService {
    private static final Log LOGGER = LogFactory.getLog(TaskServiceImpl.class);

    public Map<String, Object> terminateOrDeleteTask(String entityNumber, Map<Long, Map<String, Object>> billIdMap, Map<String, Object> paramMap) {
        LOGGER.info("------------terminateOrDeleteTask entityNumber:{} ------------", (Object)entityNumber);
        return MsResponseHelper.callService(() -> {
            HashMap queryParamMap = new HashMap();
            ArrayList queryList = new ArrayList();
            billIdMap.forEach((billId, currentPersonId) -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("entityNumber", entityNumber);
                map.put("billId", billId);
                queryList.add(map);
            });
            queryParamMap.put("list", queryList);
            Map queryResultMap = (Map)SSCServiceHelper.invokeSSCTaskService((String)"ITaskService", (String)"taskQueryByBillId", (Object[])new Object[]{queryParamMap});
            if (!ObjectUtils.getBooleanValOfObject(queryResultMap.get("success"))) {
                return MsResponse.error().setMsg(String.valueOf(queryResultMap.get("msg"))).buildMap();
            }
            Map data = (Map)queryResultMap.get("data");
            List billTaskMapList = (List)data.get("billTaskMapList");
            LOGGER.info("billTaskMapList.size():{}", (Object)billTaskMapList.size());
            if (billTaskMapList.isEmpty()) {
                return MsResponse.ok().buildMap();
            }
            HashMap<Long, Long> taskIdMap = new HashMap<Long, Long>();
            ArrayList<Long> taskIdsDelete = new ArrayList<Long>();
            ArrayList<Long> taskIdsTerminate = new ArrayList<Long>();
            for (Map billTaskMap : billTaskMapList) {
                List taskList = (List)billTaskMap.get("taskList");
                for (Map task : taskList) {
                    Long taskId2 = ObjectUtils.getLongValOfObject(task.get("taskId"));
                    Long personId = ObjectUtils.getLongValOfObject(task.get("personId"));
                    taskIdMap.put(taskId2, personId);
                    String poolType = (String)task.get("poolType");
                    if ("0".equals(poolType)) {
                        taskIdsDelete.add(ObjectUtils.getLongValOfObject(task.get("taskId")));
                        continue;
                    }
                    if (!"1".equals(poolType)) continue;
                    taskIdsTerminate.add(ObjectUtils.getLongValOfObject(task.get("taskId")));
                }
            }
            if (taskIdsDelete.isEmpty() && taskIdsTerminate.isEmpty()) {
                LOGGER.info("That is not task need terminateOrDelete");
                return MsResponse.ok().setMsg("That is not task need terminateOrDelete").buildMap();
            }
            Long operatorId = ObjectUtils.getLongValOfObject(paramMap.get("operatorId"));
            if (!taskIdsDelete.isEmpty()) {
                HashMap deleteParamMap = new HashMap();
                ArrayList deleteList = new ArrayList();
                taskIdsDelete.forEach(taskId -> {
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    map.put("taskId", (Long)taskId);
                    map.put("currentPersonId", operatorId);
                    deleteList.add(map);
                });
                deleteParamMap.put("list", deleteList);
                Map deleteResultMap = (Map)SSCServiceHelper.invokeSSCTaskService((String)"ITaskService", (String)"taskDeleteByTaskId", (Object[])new Object[]{deleteParamMap});
                LOGGER.info("deleteResultMap:{}", (Object)deleteResultMap);
            }
            if (!taskIdsTerminate.isEmpty()) {
                HashMap terminateParamMap = new HashMap();
                ArrayList terminateList = new ArrayList();
                taskIdsTerminate.forEach(taskId -> {
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    map.put("taskId", (Long)taskId);
                    map.put("currentPersonId", ObjectUtils.getLongValOfObject(taskIdMap.get(taskId)));
                    map.put("operatorId", operatorId);
                    terminateList.add(map);
                });
                terminateParamMap.put("list", terminateList);
                Map terminateResultMap = (Map)SSCServiceHelper.invokeSSCTaskService((String)"ITaskService", (String)"taskApproveByTerminate", (Object[])new Object[]{terminateParamMap});
                LOGGER.info("terminateResultMap:{}", (Object)terminateResultMap);
            }
            return MsResponse.ok().buildMap();
        }, exception -> {
            LOGGER.error((Throwable)exception);
            return MsResponse.error().setMsg(exception.getMessage()).buildMap();
        });
    }

    public Map<String, Object> queryTaskRealBillId(Long taskId, Boolean processingTask) {
        LOGGER.info("------------queryTaskRealBillId taskId:{}, processingTask:{} ------------", (Object)taskId, (Object)processingTask);
        return MsResponseHelper.callService(() -> {
            String realBillId = TaskService.getInstance().queryRealBillId(taskId, processingTask.booleanValue());
            return MsResponse.ok().put("realBillId", (Object)realBillId).buildMap();
        });
    }

    public Map<String, Object> verifyBeforeCancelPend(Collection<Long> taskIds, Map<String, Object> paramMap) {
        LOGGER.info("start kd.ssc.hstc.service.TaskServiceImpl.verifyBeforeCancelPend");
        QFilter qFilter = new QFilter("id", "in", taskIds);
        DynamicObject[] taskInfos = TaskService.getInstance().queryTask("id,pendingopinion,pendingopinions", new QFilter[]{qFilter});
        if (taskInfos == null || taskInfos.length == 0) {
            LOGGER.info("cannot find tasks,taskIds:{}", taskIds);
            return this.genResponseInfo(false, ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5171\u4eab\u4efb\u52a1\u3002", (String)"TaskServiceImpl_1", (String)"ssc-hstc-mservice", (Object[])new Object[0]), taskIds);
        }
        Object cancelType = paramMap.get("cancelType");
        if (cancelType != null && "autoCancel".equals(cancelType.toString())) {
            return this.genResponseInfo(true, "success", null);
        }
        ArrayList<Long> failIds = new ArrayList<Long>(taskInfos.length);
        for (DynamicObject task : taskInfos) {
            DynamicObjectCollection pendingopinions = task.getDynamicObjectCollection("pendingopinions");
            if (pendingopinions == null || !pendingopinions.stream().anyMatch(pendingopinion -> 1950795026489448448L == pendingopinion.getLong("fbasedataid.id"))) continue;
            failIds.add(task.getLong("id"));
        }
        if (CollectionUtils.isNotEmpty(failIds)) {
            return this.genResponseInfo(false, ResManager.loadKDString((String)"\u81ea\u52a8\u6682\u6302\u7684\u5171\u4eab\u4efb\u52a1\u4e0d\u5141\u8bb8\u624b\u52a8\u53d6\u6d88\u6682\u6302\u3002", (String)"TaskServiceImpl_0", (String)"ssc-hstc-mservice", (Object[])new Object[0]), failIds);
        }
        return this.genResponseInfo(true, "success", null);
    }

    private Map<String, Object> genResponseInfo(boolean isSuccess, String msg, Collection<Long> failIds) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (isSuccess) {
            resultMap.put("success", "true");
            resultMap.put("msg", msg);
        } else {
            resultMap.put("success", "false");
            resultMap.put("errCode", "500");
            resultMap.put("msg", msg);
            resultMap.put("msgType", "error");
            resultMap.put("failIds", failIds);
        }
        return resultMap;
    }
}

