/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.task;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.bgtask.CommonBizTask;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsbp.business.addperson.entity.CalPersonAddProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class CalDoRefreshBallTask
extends CommonBizTask {
    private static final Log logger = LogFactory.getLog(CalDoRefreshBallTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        CalPersonAddProgressInfo progressInfo;
        ISWCAppCache cache = SWCAppCache.get((String)"cachekey_hsas_calperson_refresh");
        Long calTaskId = (Long)map.get("calTaskId");
        while ((progressInfo = (CalPersonAddProgressInfo)cache.get(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), CalPersonAddProgressInfo.class)) != null) {
            int finishCount = progressInfo.getFinish();
            int totalCount = progressInfo.getTotal();
            int percent = 0;
            if (totalCount > 0) {
                percent = new BigDecimal(String.valueOf(finishCount)).divide(new BigDecimal(String.valueOf(totalCount)), 2, 1).multiply(new BigDecimal("100")).intValue();
            }
            HRBackgroundTaskHelper.getInstance().feedbackProgress(this.taskId, percent, "", null);
            if (percent >= 100) break;
            if (progressInfo.getStatus() == 2) {
                CalPersonListHelper.updatePersonCount((Long)calTaskId);
                PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("calperson getrefreshlist balltask error{}", (Object)e.getMessage());
            }
        }
    }
}

