/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.TipsSupport;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.swc.hsas.common.constants.AccumulatorConstants;
import kd.swc.hsas.formplugin.web.basedata.HisBaseDataSummaryEdit;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class AccumulatorBaseEdit
extends HisBaseDataSummaryEdit
implements BeforeF7SelectListener {
    public static final String ADD_DIM_ITEM = "addDimItem";
    public static final String ADD_SALARY_ITEM = "addSalaryItem";
    public static final String ADD_BIZ_ITEM = "addBizItem";
    public static final String AREATYPE_1 = "1";
    public static final String AREATYPE_2 = "2";
    public static final String UNIQUECODE_KEY = "uniquecode";
    public static final String AREATYPE_KEY = "areatype";
    public static final String STARTDATETYPE_1 = "1";
    public static final long NUMBERIC = 1010L;
    public static final String DONOTHING_ADDACCMEMBER = "donothing_addaccmember";
    public static final String SALARYITEM = "1";
    public static final String[] FLEXCOLLASPE_OPEN = new String[]{"fs_baseinfo", "fs_datatype", "fs_accopstrategy", "accdim_flexpanelap", "fs_accperiod"};
    public static final String[] FLEXCOLLASPE_CLOSE = new String[]{"fs_baseinfo", "fs_datatype", "fs_accperiod"};
    public static final String[] ENABLE_FALSE = new String[]{"createorg", "number", "areatype", "country", "description", "fs_datatype", "fs_accperiod"};

    public void createNewData(BizDataEventArgs event) {
        this.setFlexCollapse(false, FLEXCOLLASPE_OPEN);
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"dimitem", "accmemberitem"});
        BasedataEdit startDateItem = (BasedataEdit)this.getView().getControl("startdateitem");
        startDateItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
    }

    public void afterLoadData(EventObject event) {
        this.setFlexCollapse(true, FLEXCOLLASPE_CLOSE);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setFieldTips();
        this.setCountryFiledVisible();
        this.setDataPrecisionVisible();
        this.setFieldMustInput();
        this.setStartDateTypeVisible();
        this.initAccDimensionData();
        this.initAccMemberData();
        this.initFlexVisible();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getStatus() == OperationStatus.ADDNEW) {
            this.setFlexCollapse(false, FLEXCOLLASPE_OPEN);
        }
        this.getModel().setDataChanged(false);
    }

    private void initFlexVisible() {
        String enable = (String)this.getModel().getValue("enable");
        if ("1".equals(enable)) {
            this.getView().setEnable(Boolean.FALSE, ENABLE_FALSE);
        }
    }

    private void setFieldTips() {
        HashMap controlMap = new HashMap(16);
        HashSet<String> controlSet = new HashSet<String>(4);
        controlSet.add("updatestrategy");
        controlSet.add("periodtype");
        controlSet.add("bsedstrategy");
        controlSet.add("accdimension");
        controlMap.put("hsas_accumulator", controlSet);
        HashMap<String, DynamicObject> dataModelMap = new HashMap<String, DynamicObject>(1);
        dataModelMap.put("hsas_accumulator", this.getModel().getDataEntity());
        Map result = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{controlMap, dataModelMap});
        if (result == null || result.size() == 0) {
            return;
        }
        Map dataMap = (Map)result.get("hsas_accumulator");
        if (dataMap == null || dataMap.size() == 0) {
            return;
        }
        Tips tips = null;
        TipsSupport control = null;
        for (Map.Entry entry : dataMap.entrySet()) {
            tips = new Tips();
            tips.setContent(new LocaleString(this.getTips((Set)entry.getValue())));
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            control = (TipsSupport)this.getControl((String)entry.getKey());
            control.addTips(tips);
        }
    }

    private String getTips(Set<String> set) {
        if (set == null || set.size() == 0) {
            return "";
        }
        return set.iterator().next();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String operateKey = control.getKey();
        if (SWCStringUtils.equals((String)"dimitem", (String)operateKey)) {
            boolean checkArea = AreaHelper.checkArea((DynamicObject)this.getModel().getDataEntity());
            if (!checkArea) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u540e\u518d\u9009\u62e9\u201c\u7d2f\u52a0\u5b50\u7ef4\u5ea6\u9879\u76ee\u540d\u79f0\u201d\u3002", (String)"AccumulatorBaseEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
            QFilter qFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and("enable", "=", (Object)"1");
            QFilter areaFilter = AreaHelper.addAreaFilter((long)this.getModel().getDataEntity().getLong("country.id"), (String)this.getModel().getDataEntity().getString(AREATYPE_KEY));
            if (null != areaFilter) {
                qFilters.add(areaFilter);
            }
            qFilters.add(new QFilter("id", "in", this.getHavaConfigItemIdList()));
            DynamicObjectCollection collection = this.getModel().getEntryEntity("accdimitementry");
            ArrayList<Long> fetchItemIdList = new ArrayList<Long>(collection.size());
            for (DynamicObject obj : collection) {
                fetchItemIdList.add(obj.getLong("fetchitem.id"));
            }
            QFilter salaryDataFilter = new QFilter("id", "not in", fetchItemIdList);
            qFilters.add(qFilter);
            qFilters.add(salaryDataFilter);
            this.openItemPop(qFilters, "hsbs_fetchitem", ADD_DIM_ITEM, false);
            EntryGrid entryGrid = (EntryGrid)this.getControl("accdimitementry");
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            PageCache pageCache = new PageCache(this.getView().getPageId());
            pageCache.put("opRowNum", String.valueOf(selectedRows[0]));
        } else if (SWCStringUtils.equals((String)"accmemberitem", (String)operateKey)) {
            boolean checkArea = AreaHelper.checkArea((DynamicObject)this.getModel().getDataEntity());
            if (!checkArea) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u540e\u518d\u9009\u62e9\u201c\u7d2f\u52a0\u6210\u5458\u9879\u76ee\u540d\u79f0\u201d\u3002", (String)"AccumulatorBaseEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("accmemberentry");
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            DynamicObjectCollection accMemberEntry = this.getModel().getEntryEntity("accmemberentry");
            DynamicObject accMemberObj = (DynamicObject)accMemberEntry.get(selectedRows[0]);
            String memberType = accMemberObj.getString("membertype");
            if (SWCStringUtils.isEmpty((String)memberType)) {
                return;
            }
            ArrayList<Long> salaryItemList = new ArrayList<Long>(10);
            ArrayList<Long> bizItemList = new ArrayList<Long>(10);
            for (DynamicObject object : accMemberEntry) {
                salaryItemList.add(object.getLong("salaryitem.id"));
                bizItemList.add(object.getLong("bizitem.id"));
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
            QFilter qFilter = this.getAccMemberQFilter();
            QFilter useOrgFilter = null;
            qFilters.add(qFilter);
            Long orgId = this.getModel().getDataEntity().getLong("createorg.id");
            if (SWCStringUtils.equals((String)memberType, (String)"1")) {
                qFilter.and("id", "not in", salaryItemList);
                useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)orgId);
                if (useOrgFilter != null) {
                    qFilter.and(useOrgFilter);
                }
                this.openItemPop(qFilters, "hsbs_salaryitem", ADD_SALARY_ITEM, false);
            } else {
                qFilter.and("id", "not in", bizItemList);
                useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (Long)orgId);
                if (useOrgFilter != null) {
                    qFilter.and(useOrgFilter);
                }
                this.openItemPop(qFilters, "hsbs_bizitem", ADD_BIZ_ITEM, false);
            }
            PageCache pageCache = new PageCache(this.getView().getPageId());
            pageCache.put("opRowNum", String.valueOf(selectedRows[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "accmemaddsalaryitem": 
            case "accmemaddbizitem": {
                boolean checkArea = AreaHelper.checkArea((DynamicObject)this.getModel().getDataEntity());
                if (!checkArea) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u540e\u518d\u9009\u62e9\u201c\u7d2f\u52a0\u6210\u5458\u9879\u76ee\u540d\u79f0\u201d\u3002", (String)"AccumulatorBaseEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection accMemberEntry = this.getModel().getEntryEntity("accmemberentry");
                ArrayList<Long> salaryItemList = new ArrayList<Long>(10);
                ArrayList<Long> bizItemList = new ArrayList<Long>(10);
                for (DynamicObject object : accMemberEntry) {
                    salaryItemList.add(object.getLong("salaryitem.id"));
                    bizItemList.add(object.getLong("bizitem.id"));
                }
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
                QFilter qFilter = this.getAccMemberQFilter();
                QFilter useOrgFilter = null;
                qFilters.add(qFilter);
                Long orgId = this.getModel().getDataEntity().getLong("createorg.id");
                if (SWCStringUtils.equals((String)key, (String)"accmemaddsalaryitem")) {
                    qFilter.and("id", "not in", salaryItemList);
                    useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)orgId);
                    if (useOrgFilter != null) {
                        qFilter.and(useOrgFilter);
                    }
                    this.openItemPop(qFilters, "hsbs_salaryitem", "accmemaddsalaryitem", true);
                    break;
                }
                qFilter.and("id", "not in", bizItemList);
                useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (Long)orgId);
                if (useOrgFilter != null) {
                    qFilter.and(useOrgFilter);
                }
                this.openItemPop(qFilters, "hsbs_bizitem", "accmemaddbizitem", true);
                break;
            }
        }
    }

    private QFilter getAccMemberQFilter() {
        DynamicObject accumulatorObj = this.getModel().getDataEntity();
        QFilter qFilter = new QFilter("datatype.id", "in", (Object)new Long[]{AccumulatorConstants.DATATYPE_AMOUNT, AccumulatorConstants.DATATYPE_NUM});
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        String areaType = accumulatorObj.getString(AREATYPE_KEY);
        QFilter areaFilter = null;
        if (SWCStringUtils.equals((String)areaType, (String)"1")) {
            areaFilter = new QFilter(AREATYPE_KEY, "=", (Object)"1");
        } else if (SWCStringUtils.equals((String)areaType, (String)AREATYPE_2)) {
            Long countryId = accumulatorObj.getLong("country.id");
            areaFilter = new QFilter("country.id", "in", (Object)new Long[]{0L, countryId});
        }
        qFilter.and(areaFilter);
        return qFilter;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        ListSelectedRowCollection dataColl = null;
        if (SWCStringUtils.equals((String)actionId, (String)"accmemaddsalaryitem") || SWCStringUtils.equals((String)actionId, (String)"accmemaddbizitem")) {
            dataColl = (ListSelectedRowCollection)returnData;
            this.createAccMemberEntry(actionId, dataColl);
            return;
        }
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (SWCObjectUtils.isEmpty((Object)selectedRows)) {
            return;
        }
        Long primaryKeyValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
        PageCache pageCache = new PageCache(this.getView().getPageId());
        int rowNum = 0;
        switch (actionId) {
            case "addDimItem": {
                rowNum = Integer.parseInt(pageCache.get("opRowNum"));
                DynamicObject obj = this.getSelectObj(primaryKeyValue);
                this.getModel().setValue("fetchitem", (Object)obj.getString("id"), rowNum);
                this.getModel().setValue("dimitem", (Object)obj.getString("name"), rowNum);
                this.getView().updateView("accdimitementry");
                break;
            }
            case "addSalaryItem": {
                rowNum = Integer.parseInt(pageCache.get("opRowNum"));
                this.getModel().setValue("salaryitem", (Object)primaryKeyValue, rowNum);
                this.setAccMemberItem(rowNum);
                break;
            }
            case "addBizItem": {
                rowNum = Integer.parseInt(pageCache.get("opRowNum"));
                this.getModel().setValue("bizitem", (Object)primaryKeyValue, rowNum);
                this.setAccMemberItem(rowNum);
                break;
            }
        }
        pageCache.remove("opRowNum");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        switch (name) {
            case "areatype": {
                if (!this.isAllEntryEmpty()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u5c06\u6e05\u7a7a\u201c\u7d2f\u52a0\u7ef4\u5ea6\u201d\u548c\u201c\u7d2f\u52a0\u6210\u5458\u201d\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"AccumulatorBaseEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(name), null, (String)changeData.getOldValue());
                    break;
                }
                this.setCountryFiledVisible();
                break;
            }
            case "country": {
                if (this.isAllEntryEmpty() || !SWCStringUtils.equals((String)((String)this.getModel().getValue(AREATYPE_KEY)), (String)AREATYPE_2)) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u5c06\u6e05\u7a7a\u201c\u7d2f\u52a0\u7ef4\u5ea6\u201d\u548c\u201c\u7d2f\u52a0\u6210\u5458\u201d\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"AccumulatorBaseEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(name), null, changeData.getOldValue() != null ? String.valueOf(((DynamicObject)changeData.getOldValue()).getLong("id")) : "0");
                break;
            }
            case "periodtype": {
                this.setStartDateTypeVisible();
                break;
            }
            case "datatype": {
                this.setDataPrecisionVisible();
                break;
            }
            case "startdatetype": {
                this.setStartDateOrStartDateItemVisible();
                break;
            }
            case "membertype": {
                this.changeAccMemberData(changeData);
                break;
            }
            case "accmemstartdate": {
                this.checkAccMemStartDate(changeData);
                break;
            }
            case "accmemenddate": {
                this.checkAccMemEndDate(changeData);
                break;
            }
            case "number": {
                this.initUniqueCode();
                break;
            }
            case "accmemberitem": {
                this.cleanSalaryItemAndBizItem(changeData);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String customValue = messageBoxClosedEvent.getCustomVaule();
        switch (callBackId) {
            case "areatype": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.setCountryFiledVisible();
                    this.getModel().deleteEntryData("accdimitementry");
                    this.getModel().deleteEntryData("accmemberentry");
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue(AREATYPE_KEY, (Object)customValue);
                this.getModel().endInit();
                this.getView().updateView(AREATYPE_KEY);
                break;
            }
            case "country": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.getModel().deleteEntryData("accdimitementry");
                    this.getModel().deleteEntryData("accmemberentry");
                    break;
                }
                this.getModel().beginInit();
                if (SWCStringUtils.equals((String)customValue, (String)"0")) {
                    this.getModel().setValue("country", null);
                } else {
                    this.getModel().setValue("country", (Object)Long.valueOf(customValue));
                }
                this.getModel().endInit();
                this.getView().updateView("country");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (operateKey) {
            case "newentry_accmember": {
                String number = dataEntity.getString("number");
                DynamicObjectCollection accMemberEntry = dataEntity.getDynamicObjectCollection("accmemberentry");
                String code = this.getUniquecode(accMemberEntry, number);
                EntryGrid entryGrid = (EntryGrid)this.getControl("accmemberentry");
                int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
                int index = selectedRows[0];
                this.getModel().setValue("memuniquecode", (Object)code, index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"accmemberitem"});
                break;
            }
            case "disable": 
            case "enable": 
            case "unsubmit": 
            case "save": 
            case "submit": 
            case "audit": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "unaudit": {
                this.initFlexVisible();
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs event) {
        if (SWCStringUtils.equals((String)event.getEntryProp().getName(), (String)"accmemberentry")) {
            int rowIndex = event.getInsertRow();
            DynamicObjectCollection accMemberEntry = this.getModel().getEntryEntity("accmemberentry");
            String number = (String)this.getModel().getValue("number");
            String code = this.getUniquecode(accMemberEntry, number);
            this.getModel().setValue("memuniquecode", (Object)code, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"accmemberitem"});
        }
    }

    private void cleanSalaryItemAndBizItem(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        if (SWCObjectUtils.isEmpty((Object)newValue)) {
            this.getModel().beginInit();
            this.getModel().setValue("salaryitem", null);
            this.getModel().setValue("bizitem", null);
            this.getModel().endInit();
        }
    }

    private void initAccDimensionData() {
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("accdimitementry");
        DynamicObject entry = null;
        for (int index = 0; index < entryList.size(); ++index) {
            entry = (DynamicObject)entryList.get(index);
            this.getModel().setValue("dimitem", (Object)entry.getString("fetchitem.name"), index);
        }
    }

    private void initAccMemberData() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("accmemberentry");
        for (int index = 0; index < collection.size(); ++index) {
            this.setAccMemberItem(index);
        }
    }

    private void setAccMemberItem(int rowNum) {
        DynamicObjectCollection accMemberEntry = this.getModel().getEntryEntity("accmemberentry");
        DynamicObject accMemberObj = (DynamicObject)accMemberEntry.get(rowNum);
        String memberType = accMemberObj.getString("membertype");
        DynamicObject itemObj = null;
        itemObj = SWCStringUtils.equals((String)memberType, (String)"1") ? (DynamicObject)accMemberObj.get("salaryitem") : (DynamicObject)accMemberObj.get("bizitem");
        if (itemObj != null) {
            this.getModel().setValue("accmemberitem", (Object)itemObj.getString("name"), rowNum);
        }
    }

    private DynamicObject getSelectObj(Long primaryKeyValue) {
        String selectProperties = "uniquecode,id,name";
        DynamicObject coll = new SWCDataServiceHelper("hsbs_fetchitem").queryOne(selectProperties, (Object)primaryKeyValue);
        return coll;
    }

    private void openItemPop(List<QFilter> qFilters, String showListKey, String callBackKey, boolean isMultiSelect) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)showListKey, (boolean)true);
        showParameter.setMultiSelect(isMultiSelect);
        if (qFilters != null) {
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackKey));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setStartDateTypeVisible() {
        String accPeriodType = this.getModel().getDataEntity().getString("periodtype");
        FieldEdit fixedItem = (FieldEdit)this.getControl("startdatetype");
        FieldEdit startMonth = (FieldEdit)this.getControl("startmonth");
        FieldEdit startDay = (FieldEdit)this.getControl("startday");
        FieldEdit bsedStrategy = (FieldEdit)this.getControl("bsedstrategy");
        FieldEdit startDate = (FieldEdit)this.getControl("startdate");
        if (SWCStringUtils.equals((String)accPeriodType, (String)"4")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"startdatetype"});
            fixedItem.setMustInput(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"startday"});
            startDay.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bsedstrategy"});
            bsedStrategy.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"startmonth"});
            startMonth.setMustInput(false);
            this.setStartDateOrStartDateItemVisible();
        } else if (SWCStringUtils.equals((String)accPeriodType, (String)"6")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"startdatetype"});
            fixedItem.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"startdate"});
            startDate.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"startdateitem"});
            startDate.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"startday"});
            startDay.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bsedstrategy"});
            bsedStrategy.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"startmonth"});
            startMonth.setMustInput(false);
            this.getModel().setValue("bsedstrategy", (Object)AREATYPE_2);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"startdatetype"});
            fixedItem.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"startdate"});
            startDate.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"startdateitem"});
            startDate.setMustInput(false);
            this.getView().setVisible(Boolean.TRUE, new String[]{"startday"});
            startDay.setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"bsedstrategy"});
            bsedStrategy.setMustInput(true);
            if (SWCStringUtils.equals((String)accPeriodType, (String)"3")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"startmonth"});
                startMonth.setMustInput(false);
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"startmonth"});
                startMonth.setMustInput(true);
            }
        }
    }

    private void setStartDateOrStartDateItemVisible() {
        String startDateType = this.getModel().getDataEntity().getString("startdatetype");
        FieldEdit startDateEidt = (FieldEdit)this.getControl("startdate");
        FieldEdit startDateItemEidt = (FieldEdit)this.getControl("startdateitem");
        if (SWCStringUtils.equals((String)startDateType, (String)"1")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"startdate"});
            startDateEidt.setMustInput(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"startdateitem"});
            this.getModel().setValue("startdateitem", null);
            startDateItemEidt.setMustInput(false);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"startdate"});
            this.getModel().setValue("startdate", null);
            startDateEidt.setMustInput(false);
            this.getView().setVisible(Boolean.TRUE, new String[]{"startdateitem"});
            startDateItemEidt.setMustInput(true);
        }
    }

    private void setDataPrecisionVisible() {
        DynamicObject dataEntity = (DynamicObject)this.getModel().getDataEntity().get("datatype");
        if (dataEntity == null) {
            return;
        }
        Long dataTypeId = dataEntity.getLong("id");
        FieldEdit fixedItem = (FieldEdit)this.getControl("dataprecision");
        if (1010L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"dataprecision"});
            fixedItem.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataprecision"});
            fixedItem.setMustInput(false);
        }
    }

    private void setCountryFiledVisible() {
        String areatype = this.getModel().getDataEntity().getString(AREATYPE_KEY);
        FieldEdit fixedItem = (FieldEdit)this.getControl("country");
        if (SWCStringUtils.equals((String)areatype, (String)AREATYPE_2)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"country"});
            fixedItem.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
            this.getModel().setValue("country", null);
            fixedItem.setMustInput(false);
        }
    }

    private void initUniqueCode() {
        DynamicObject accObj = this.getModel().getDataEntity();
        String number = accObj.getString("number");
        DynamicObjectCollection accMemEntry = this.getModel().getEntryEntity("accmemberentry");
        for (int index = 0; index < accMemEntry.size(); ++index) {
            String code = this.getUniquecode(accMemEntry, number);
            this.getModel().setValue("memuniquecode", (Object)code, index);
        }
    }

    private void checkAccMemEndDate(ChangeData changeData) {
        Date newValue = (Date)changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        DynamicObject dynamicObject = this.getAccMemberEntry();
        Date startDate = dynamicObject.getDate("accmemstartdate");
        if (startDate != null && newValue.before(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u9700\u5c0f\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"AccumulatorBaseEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkAccMemStartDate(ChangeData changeData) {
        Date newValue = (Date)changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        DynamicObject dynamicObject = this.getAccMemberEntry();
        Date endDate = dynamicObject.getDate("accmemenddate");
        if (endDate != null && newValue.after(endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u9700\u5c0f\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"AccumulatorBaseEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getAccMemberEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("accmemberentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        int rowNum = selectedRows[0];
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("accmemberentry");
        return (DynamicObject)entryEntity.get(rowNum);
    }

    private void changeAccMemberData(ChangeData changeData) {
        Object oldValue;
        Object newValue = changeData.getNewValue();
        if (SWCObjectUtils.equals((Object)newValue, (Object)(oldValue = changeData.getOldValue()))) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("accmemberentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        int rowNum = selectedRows[0];
        this.getModel().setValue("accmemberitem", null, rowNum);
        this.setAccMemberVisible(Boolean.TRUE);
    }

    private void setFlexCollapse(boolean flag, String[] initFlexCollaspe) {
        for (String flexCollaspe : initFlexCollaspe) {
            Container flexContainer = (Container)this.getView().getControl(flexCollaspe);
            flexContainer.setCollapse(flag);
        }
    }

    private String getUniquecode(DynamicObjectCollection accMemberEntry, String number) {
        ArrayList<Integer> uniquecodeList = new ArrayList<Integer>(accMemberEntry.size());
        for (DynamicObject memEntry : accMemberEntry) {
            String str = memEntry.getString("memuniquecode");
            if (StringUtils.isEmpty((String)str)) continue;
            uniquecodeList.add(Integer.parseInt(str.substring(str.length() - 4)));
        }
        int seq = 1;
        if (uniquecodeList.size() > 0) {
            Collections.sort(uniquecodeList);
            seq = (Integer)uniquecodeList.get(uniquecodeList.size() - 1) + 1;
        }
        return this.createUniqueCode(number, seq);
    }

    private String createUniqueCode(String number, int seq) {
        String code = String.format(Locale.ROOT, "%4d", seq);
        code = code.replace(' ', '0');
        return String.format(Locale.ROOT, "%s_%s", number, code);
    }

    private void setAccMemberVisible(Boolean flag) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("accmemberentry");
        for (int index = 0; index < entryEntity.size(); ++index) {
            this.getView().setEnable(flag, index, new String[]{"membertype", "accmemberitem", "accmemstartdate", "accmemenddate", "operator", "accpercenttype", "percentfixval"});
            DynamicObject entryObj = (DynamicObject)entryEntity.get(index);
            if (!SWCStringUtils.isEmpty((String)entryObj.getString("membertype")) || !flag.booleanValue()) continue;
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"accmemberitem"});
        }
    }

    private void setFieldMustInput() {
        FieldEdit accDimItem = (FieldEdit)this.getControl("dimitem");
        accDimItem.setMustInput(true);
        FieldEdit accMemItem = (FieldEdit)this.getControl("accmemberitem");
        accMemItem.setMustInput(true);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey;
        switch (fieldKey = arg.getProperty().getName()) {
            case "startdateitem": {
                boolean checkArea = AreaHelper.checkArea((DynamicObject)this.getModel().getDataEntity());
                if (!checkArea) {
                    arg.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u540e\u518d\u9009\u62e9\u201c\u5f00\u59cb\u65e5\u671f\u9879\u76ee\u201d\u3002", (String)"AccumulatorBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
                QFilter areaFilter = AreaHelper.addAreaFilter((long)this.getModel().getDataEntity().getLong("country.id"), (String)this.getModel().getDataEntity().getString(AREATYPE_KEY));
                if (null != areaFilter) {
                    qFilters.add(areaFilter);
                }
                qFilters.add(new QFilter("datatype.id", "=", (Object)1050L));
                qFilters.add(new QFilter("id", "in", this.getHavaConfigItemIdList()));
                ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
                showParameter.getListFilterParameter().setQFilters(qFilters);
                break;
            }
        }
    }

    private List<Long> getHavaConfigItemIdList() {
        SWCDataServiceHelper ftItemRelHelper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("configtype", "=", (Object)"0");
        qFilter.and("fetchconfig.dimensionality", "=", (Object)"0");
        qFilter.and("fetchconfig.calculationfetch", "=", (Object)"0");
        DynamicObjectCollection fetchConfigItemData = ftItemRelHelper.queryOriginalCollection("fetchitem.id", new QFilter[]{qFilter});
        if (fetchConfigItemData.size() == 0) {
            return new ArrayList<Long>(0);
        }
        return fetchConfigItemData.stream().map(obj -> obj.getLong("fetchitem.id")).collect(Collectors.toList());
    }

    private void createAccMemberEntry(String actionId, ListSelectedRowCollection dataColl) {
        String memberType;
        if (dataColl == null || dataColl.size() == 0) {
            return;
        }
        ArrayList<Long> billIds = new ArrayList<Long>(dataColl.size());
        for (ListSelectedRow listSelectedRow : dataColl) {
            billIds.add(Long.valueOf(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        QFilter filter = new QFilter("id", "in", billIds);
        filter.and(this.getAccMemberQFilter());
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SWCStringUtils.equals((String)actionId, (String)"accmemaddsalaryitem") ? "hsbs_salaryitem" : "hsbs_bizitem");
        DynamicObjectCollection items = helper.queryOriginalCollection("id,name", new QFilter[]{filter});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("memuniquecode", new Object[0]);
        vs.addField("membertype", new Object[0]);
        vs.addField("accmemberitem", new Object[0]);
        if (SWCStringUtils.equals((String)actionId, (String)"accmemaddsalaryitem")) {
            vs.addField("salaryitem", new Object[0]);
            memberType = "1";
        } else {
            vs.addField("bizitem", new Object[0]);
            memberType = AREATYPE_2;
        }
        DynamicObjectCollection accMemberEntry = this.getModel().getEntryEntity("accmemberentry");
        String number = (String)this.getModel().getValue("number");
        int maxSeq = 1;
        for (DynamicObject memEntry : accMemberEntry) {
            String str = memEntry.getString("memuniquecode");
            if (StringUtils.isEmpty((String)str)) continue;
            int tempSeq = Integer.parseInt(str.substring(str.length() - 4));
            maxSeq = Math.max(maxSeq, tempSeq);
        }
        int seq = maxSeq + 1;
        for (DynamicObject item : items) {
            vs.addRow(new Object[]{this.createUniqueCode(number, seq++), memberType, item.getString("name"), item.getLong("id")});
        }
        model.batchCreateNewEntryRow("accmemberentry", vs);
        model.endInit();
        this.getView().updateView("accmemberentry");
    }

    private boolean isAllEntryEmpty() {
        return CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("accmemberentry")) && CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("accdimitementry"));
    }
}

