/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator.accmember;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.swc.hsas.business.accumulator.accmember.AccMemberHelper;
import kd.swc.hsbp.common.enums.SWCFieldType;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class AccMemberPlugin
extends SWCDataBaseEdit {
    private static final String ACC_MEMBER_ENTRY = "accmemberentry";
    private List<Long> salaryItemIds = new ArrayList<Long>(10);
    private List<Long> buinessItemIds = new ArrayList<Long>(10);
    private DynamicObjectCollection salaryItemColl;
    private DynamicObjectCollection buinessItemColl;

    public void beforeBindData(EventObject event) {
        this.loadAccMemberEntryData();
        this.writeItemNumAndName();
        this.writeItemValue();
        this.getView().updateView(ACC_MEMBER_ENTRY);
    }

    private void writeItemValue() {
        Long calPersonId = (Long)this.getView().getFormShowParameter().getCustomParam("calPersonId");
        if (calPersonId == null || calPersonId == 0L) {
            return;
        }
        AccMemberHelper accMemberHelper = new AccMemberHelper();
        Long calTableId = accMemberHelper.getCalResultIdByCalPersonId(calPersonId);
        if (calTableId == null || calTableId == 0L) {
            return;
        }
        DynamicObject calTableInfo = accMemberHelper.getCalTableInfoByCalTableId(calTableId);
        if (SWCObjectUtils.isEmpty((Object)calTableInfo)) {
            return;
        }
        DynamicObjectCollection accMemberColl = this.getModel().getEntryEntity(ACC_MEMBER_ENTRY);
        if (accMemberColl == null || accMemberColl.size() == 0) {
            return;
        }
        for (DynamicObject dataObj : accMemberColl) {
            Long itemId = dataObj.getLong("itemid");
            if (itemId == null || itemId == 0L) continue;
            String itemType = dataObj.getString("itemtype");
            if (SWCStringUtils.equals((String)"1", (String)itemType)) {
                this.loadSLData(dataObj, itemId, calTableInfo);
                continue;
            }
            if (!SWCStringUtils.equals((String)"2", (String)itemType)) continue;
            this.loadBSData(dataObj, itemId, calTableInfo);
        }
    }

    private void loadBSData(DynamicObject entryObj, Long itemId, DynamicObject calTableInfo) {
        DynamicObjectCollection bsEntryColl = calTableInfo.getDynamicObjectCollection("hsas_calbsentry");
        if (bsEntryColl == null || bsEntryColl.size() == 0) {
            return;
        }
        DynamicObject bsDataObj = this.getBSItemObj(itemId, bsEntryColl);
        if (bsDataObj == null) {
            return;
        }
        int scale = (Integer)this.getView().getFormShowParameter().getCustomParam("scale");
        DynamicObject bizItem = bsDataObj.getDynamicObject("bizitem");
        if (SWCObjectUtils.isEmpty((Object)bizItem)) {
            return;
        }
        DynamicObject dataTypeObj = bizItem.getDynamicObject("datatype");
        if (SWCObjectUtils.isEmpty((Object)dataTypeObj)) {
            return;
        }
        Long dataTypeId = dataTypeObj.getLong("id");
        String dataTypeStr = this.getDataType(dataTypeId, this.buinessItemColl);
        if (SWCStringUtils.isEmpty((String)dataTypeStr)) {
            return;
        }
        BigDecimal accPercent = entryObj.getBigDecimal("accpercent");
        BigDecimal itemValue = null;
        if (SWCStringUtils.equals((String)dataTypeStr, (String)"amount")) {
            itemValue = bsDataObj.getBigDecimal("bscalamountvalue");
            entryObj.set("initvalue", (Object)itemValue.setScale(scale, 4).toString());
        } else if (SWCStringUtils.equals((String)dataTypeStr, (String)"num")) {
            itemValue = bsDataObj.getBigDecimal("bsnumvalue");
            entryObj.set("initvalue", (Object)itemValue.setScale(scale, 4).toString());
        }
        if (accPercent != null && itemValue != null) {
            BigDecimal resultVal = itemValue.multiply(accPercent).divide(new BigDecimal(100));
            entryObj.set("accresultvalue", (Object)resultVal.setScale(scale, 4).toString());
        }
    }

    private void loadSLData(DynamicObject entryObj, Long itemId, DynamicObject calTableInfo) {
        DynamicObjectCollection slEntryColl = calTableInfo.getDynamicObjectCollection("hsas_caltableentry");
        if (slEntryColl == null || slEntryColl.size() == 0) {
            return;
        }
        int scale = (Integer)this.getView().getFormShowParameter().getCustomParam("scale");
        DynamicObject slDataObj = this.getSLItemObj(itemId, slEntryColl);
        if (slDataObj == null) {
            return;
        }
        DynamicObject salaryItem = slDataObj.getDynamicObject("salaryitem");
        if (SWCObjectUtils.isEmpty((Object)salaryItem)) {
            return;
        }
        DynamicObject dataTypeObj = salaryItem.getDynamicObject("datatype");
        if (SWCObjectUtils.isEmpty((Object)dataTypeObj)) {
            return;
        }
        Long dataTypeId = dataTypeObj.getLong("id");
        String dataTypeStr = this.getDataType(dataTypeId, this.salaryItemColl);
        if (SWCStringUtils.isEmpty((String)dataTypeStr)) {
            return;
        }
        BigDecimal accPercent = entryObj.getBigDecimal("accpercent");
        BigDecimal itemValue = null;
        if (SWCStringUtils.equals((String)dataTypeStr, (String)"amount")) {
            itemValue = slDataObj.getBigDecimal("calamountvalue");
            entryObj.set("initvalue", (Object)itemValue.setScale(scale, 4).toString());
        } else if (SWCStringUtils.equals((String)dataTypeStr, (String)"num")) {
            itemValue = slDataObj.getBigDecimal(SWCFieldType.NUM.name().toLowerCase() + "value");
            entryObj.set("initvalue", (Object)itemValue.setScale(scale, 4).toString());
        }
        if (accPercent != null && itemValue != null) {
            BigDecimal resultVal = itemValue.multiply(accPercent).divide(new BigDecimal(100));
            entryObj.set("accresultvalue", (Object)resultVal.setScale(scale, 4).toString());
        }
    }

    private String getDataType(Long dataTypeId, DynamicObjectCollection coll) {
        if (coll == null || coll.size() == 0) {
            return "";
        }
        for (DynamicObject dataObj : coll) {
            Long id = dataObj.getLong("datatype.id");
            if (dataTypeId.longValue() != id.longValue()) continue;
            return dataObj.getString("datatype.showtype");
        }
        return "";
    }

    private DynamicObject getSLItemObj(Long itemId, DynamicObjectCollection coll) {
        for (DynamicObject dataObj : coll) {
            Long id;
            DynamicObject salaryItem = dataObj.getDynamicObject("salaryitem");
            if (SWCObjectUtils.isEmpty((Object)salaryItem) || (id = Long.valueOf(salaryItem.getLong("id"))) == null || id.longValue() != itemId.longValue()) continue;
            return dataObj;
        }
        return null;
    }

    private DynamicObject getBSItemObj(Long itemId, DynamicObjectCollection coll) {
        for (DynamicObject dataObj : coll) {
            Long id;
            DynamicObject bizItem = dataObj.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItem) || (id = Long.valueOf(bizItem.getLong("id"))) == null || id.longValue() != itemId.longValue()) continue;
            return dataObj;
        }
        return null;
    }

    private void writeItemNumAndName() {
        DynamicObjectCollection entryColl;
        AccMemberHelper helper = new AccMemberHelper();
        if (this.salaryItemIds != null && this.salaryItemIds.size() > 0) {
            this.salaryItemColl = helper.getSalaryItemInfo(this.salaryItemIds);
        }
        if (this.buinessItemIds != null && this.buinessItemIds.size() > 0) {
            this.buinessItemColl = helper.getBusinessItemInfo(this.buinessItemIds);
        }
        if ((entryColl = this.getModel().getEntryEntity(ACC_MEMBER_ENTRY)) == null || entryColl.size() == 0) {
            return;
        }
        for (DynamicObject dataObj : entryColl) {
            Long itemId = dataObj.getLong("itemid");
            String itemNumber = this.getItemNumber(this.salaryItemColl, this.buinessItemColl, itemId);
            dataObj.set("itemnumber", (Object)itemNumber);
            String itemName = this.getItemName(this.salaryItemColl, this.buinessItemColl, itemId);
            dataObj.set("itemname", (Object)itemName);
        }
    }

    private String getItemNumber(DynamicObjectCollection salaryItemColl, DynamicObjectCollection buinessItemColl, Long itemId) {
        Long id;
        if (salaryItemColl != null && salaryItemColl.size() > 0) {
            for (DynamicObject dataObj : salaryItemColl) {
                id = dataObj.getLong("id");
                if (itemId.longValue() != id.longValue()) continue;
                return dataObj.getString("number");
            }
        }
        if (buinessItemColl != null && buinessItemColl.size() > 0) {
            for (DynamicObject dataObj : buinessItemColl) {
                id = dataObj.getLong("id");
                if (itemId.longValue() != id.longValue()) continue;
                return dataObj.getString("number");
            }
        }
        return "";
    }

    private String getItemName(DynamicObjectCollection salaryItemColl, DynamicObjectCollection buinessItemColl, Long itemId) {
        Long id;
        if (salaryItemColl != null && salaryItemColl.size() > 0) {
            for (DynamicObject dataObj : salaryItemColl) {
                id = dataObj.getLong("id");
                if (itemId.longValue() != id.longValue()) continue;
                return dataObj.getString("name");
            }
        }
        if (buinessItemColl != null && buinessItemColl.size() > 0) {
            for (DynamicObject dataObj : buinessItemColl) {
                id = dataObj.getLong("id");
                if (itemId.longValue() != id.longValue()) continue;
                return dataObj.getString("name");
            }
        }
        return "";
    }

    private void loadAccMemberEntryData() {
        Long accId = (Long)this.getView().getFormShowParameter().getCustomParam("accId");
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        Long calPersonId = (Long)this.getView().getFormShowParameter().getCustomParam("calPersonId");
        if (accId == null || calTaskId == null || calPersonId == null) {
            return;
        }
        AccMemberHelper helper = new AccMemberHelper();
        DynamicObjectCollection memberColl = helper.getAccMemberInfo(accId, calTaskId);
        if (memberColl == null || memberColl.size() == 0) {
            return;
        }
        DynamicObjectCollection accDetailList = helper.getAccDetailList(calPersonId, accId);
        HashMap<Long, Object> accUseMemerMap = new HashMap<Long, Object>(1);
        for (DynamicObject obj : accDetailList) {
            String memberStr = obj.getString("memberinfo");
            if (!SWCStringUtils.isNotEmpty((String)memberStr)) continue;
            accUseMemerMap.put(obj.getLong("accresult.acc.id"), SerializationUtils.fromJsonString((String)memberStr, Map.class));
        }
        Map memberInfoMap = (Map)accUseMemerMap.get(accId);
        IDataModel model = this.getModel();
        for (DynamicObject dataObj : memberColl) {
            JSONArray memberArray;
            String memberInfoStr = dataObj.getString("accmember");
            if (SWCStringUtils.isEmpty((String)memberInfoStr) || (memberArray = JSONArray.parseArray((String)memberInfoStr)) == null || memberArray.size() == 0) continue;
            String uniqueCode = null;
            int size = memberArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = memberArray.getJSONObject(i);
                if (!jsonObj.getBooleanValue("used")) continue;
                uniqueCode = SWCStringUtils.isNotEmpty((String)jsonObj.getString("slUniqueCode")) ? jsonObj.getString("slUniqueCode") : jsonObj.getString("bsUniqueCode");
                if (memberInfoMap == null) {
                    this.writeDataToEntry(jsonObj, model);
                    continue;
                }
                if (memberInfoMap.size() == 0 || !memberInfoMap.containsKey(uniqueCode)) continue;
                this.writeDataToEntry(jsonObj, model);
            }
        }
    }

    private void writeDataToEntry(JSONObject dataObj, IDataModel model) {
        Long endDate;
        int detailIndex = model.createNewEntryRow(ACC_MEMBER_ENTRY);
        int memberType = dataObj.getIntValue("memberType");
        model.setValue("itemtype", (Object)memberType, detailIndex);
        if (memberType == 1) {
            Long salaryItemId = dataObj.getLong("salaryItemId");
            this.salaryItemIds.add(salaryItemId);
            model.setValue("itemid", (Object)salaryItemId, detailIndex);
        } else if (memberType == 2) {
            Long bizItemId = dataObj.getLong("bizItemId");
            this.buinessItemIds.add(bizItemId);
            model.setValue("itemid", (Object)bizItemId, detailIndex);
        }
        Long startDate = dataObj.getLong("startDate");
        if (startDate != null) {
            model.setValue("startdate", (Object)new Date(startDate), detailIndex);
        }
        if ((endDate = dataObj.getLong("endDate")) != null) {
            model.setValue("enddate", (Object)new Date(endDate), detailIndex);
        }
        int operator = dataObj.getIntValue("operator");
        model.setValue("operator", (Object)operator, detailIndex);
        BigDecimal percentFixVal = dataObj.getBigDecimal("percentFixVal");
        int scale = (Integer)this.getView().getFormShowParameter().getCustomParam("scale");
        if (percentFixVal != null) {
            model.setValue("accpercent", (Object)percentFixVal.setScale(scale, 4).toString(), detailIndex);
        }
    }
}

