/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator.accresultdetail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.accumulator.AccCalMutexUtils;
import kd.swc.hsas.business.accumulator.accresultdetail.AccResultDetailHelper;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class AccResultDetailPlugin
extends SWCDataBaseEdit
implements HyperLinkClickListener {
    private static final String ACC_DETAIL_ENTRY = "accdetailresultentry";
    private static final String ACC_MEMBER_PAGE = "hsas_accmember";
    private static final String MODIFY_BTN = "modify";
    private static final String SAVE_BTN = "save";
    private static final String ADD_DATA_LABEL = "adddata";
    private static final String ADJUST_ACC_RESULT_ENTRY = "adjustaccresultentry";
    private static final String ADJUST_AMOUNT = "adjustamount";
    private static final String ADJUST_REASON = "adjustreason";
    private static final String IS_CONTINUE_CLOSE = "afterconfirm";
    private static final String DONOTHING_ADJUST = "donothing_adjust";

    public void registerListener(EventObject event) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ACC_DETAIL_ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject event) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_dataprecision");
        DynamicObject[] allDataPrecisionArray = helper.query("id,scale", new QFilter[0]);
        HashMap<Long, Integer> scaleMap = new HashMap<Long, Integer>(allDataPrecisionArray.length);
        for (DynamicObject precisionObj : allDataPrecisionArray) {
            scaleMap.put(precisionObj.getLong("id"), precisionObj.getInt("scale"));
        }
        this.setAdjustEntryField(true);
        this.loadAdjustAccResultEntryData();
        this.loadBaseInfoData(scaleMap);
        this.loadAccResultDetailEntryData(scaleMap);
        this.setShowAdjustAmount(scaleMap);
        this.loadPageByPageType();
        this.setAdjustValueScal();
        this.getModel().setDataChanged(false);
    }

    private void setAdjustValueScal() {
        DynamicObject currencyObj = this.getModel().getDataEntity().getDynamicObject("currency");
        DynamicObject accObj = this.getModel().getDataEntity().getDynamicObject("acc");
        long dataTypeId = accObj.getLong("datatype.id");
        int scale = 0;
        scale = DataTypeEnum.AMOUNT.getDbId() == dataTypeId ? currencyObj.getInt("amtprecision") : ItemDataUtils.getScal((long)accObj.getLong("dataprecision.id"));
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(ADJUST_ACC_RESULT_ENTRY, "setColEditorProp", new Object[]{ADJUST_AMOUNT, "sc", scale});
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String optKey = event.getProperty().getName();
        if (SWCStringUtils.equals((String)optKey, (String)ADJUST_AMOUNT)) {
            this.setShowAdjustAmount(null);
            this.getModel().setDataChanged(true);
        } else if (SWCStringUtils.equals((String)optKey, (String)ADJUST_REASON)) {
            this.getModel().setDataChanged(true);
        }
    }

    private void setShowAdjustAmount(Map<Long, Integer> scaleMap) {
        DynamicObjectCollection adjustEntry;
        if (scaleMap == null) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_dataprecision");
            DynamicObject[] allDataPrecisionArray = helper.query("id,scale", new QFilter[0]);
            scaleMap = new HashMap<Long, Integer>(allDataPrecisionArray.length);
            for (DynamicObject precisionObj : allDataPrecisionArray) {
                scaleMap.put(precisionObj.getLong("id"), precisionObj.getInt("scale"));
            }
        }
        if ((adjustEntry = this.getModel().getEntryEntity(ADJUST_ACC_RESULT_ENTRY)) == null || adjustEntry.size() == 0) {
            return;
        }
        DynamicObject currencyObj = this.getModel().getDataEntity().getDynamicObject("currency");
        DynamicObject accObj = this.getModel().getDataEntity().getDynamicObject("acc");
        for (int i = 0; i < adjustEntry.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)adjustEntry.get(i);
            Object newVal = entryObj.get(ADJUST_AMOUNT);
            if (newVal == null) {
                this.getModel().setValue("showadjustamount", (Object)"", i);
                continue;
            }
            BigDecimal newValDecimal = (BigDecimal)newVal;
            String valStr = this.buildResultValueStr(newValDecimal, currencyObj, accObj, scaleMap);
            this.getModel().setValue("showadjustamount", (Object)valStr, i);
            this.getModel().setValue(ADJUST_AMOUNT, (Object)valStr, i);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        this.closeConfirm(event);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (SWCStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"accDetailCallBack") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put(IS_CONTINUE_CLOSE, (Object)Boolean.TRUE);
            this.getView().close();
        }
    }

    private void closeConfirm(BeforeClosedEvent event) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isComtinueChange = (Boolean)pageCache.get(IS_CONTINUE_CLOSE, Boolean.class);
        if (isComtinueChange == null) {
            isComtinueChange = Boolean.FALSE;
        }
        boolean dataChange = this.getModel().getDataChanged();
        if (!isComtinueChange.booleanValue() && dataChange) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("accDetailCallBack", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(4);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AccResultDetailPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AccResultDetailPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AccResultDetailPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBack, btnNameMaps);
            event.setCancel(true);
        }
    }

    private void loadAdjustAccResultEntryData() {
        AccResultDetailHelper helper = new AccResultDetailHelper();
        Long accResultId = (Long)this.getView().getFormShowParameter().getCustomParam("accResultId");
        DynamicObject accResultObj = helper.queryAllEntryDatas(accResultId);
        if (SWCObjectUtils.isEmpty((Object)accResultObj)) {
            return;
        }
        SWCPageCache cache = new SWCPageCache(this.getView());
        DynamicObjectCollection entryColl = accResultObj.getDynamicObjectCollection("adjustentry");
        if (entryColl == null || entryColl.size() == 0) {
            cache.put("fixRowCount", (Object)0);
            return;
        }
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>(entryColl.size());
        for (DynamicObject entryObj : entryColl) {
            entryList.add(entryObj);
        }
        Collections.sort(entryList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date date1 = o1.getDate("adjusttime");
                Date date2 = o2.getDate("adjusttime");
                if (date1.getTime() > date2.getTime()) {
                    return 1;
                }
                if (date1.getTime() < date2.getTime()) {
                    return -1;
                }
                return 0;
            }
        });
        cache.put("fixRowCount", (Object)(entryList.size() - 1));
        IDataModel model = this.getModel();
        for (DynamicObject dataObj : entryList) {
            int detailIndex = model.createNewEntryRow(ADJUST_ACC_RESULT_ENTRY);
            model.setValue("entryid", dataObj.get("id"), detailIndex);
            model.setValue(ADJUST_AMOUNT, dataObj.get(ADJUST_AMOUNT), detailIndex);
            model.setValue(ADJUST_REASON, dataObj.get("adjustdescript"), detailIndex);
            model.setValue("adjusttime", dataObj.get("adjusttime"), detailIndex);
            model.setValue("adjustuser", dataObj.get("adjustperson"), detailIndex);
        }
        this.getView().updateView(ADJUST_ACC_RESULT_ENTRY);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)"donothing_save", (String)optKey)) {
            this.doSaveCheck(args);
        } else if (DONOTHING_ADJUST.equals(optKey)) {
            Long accResultId = (Long)this.getView().getFormShowParameter().getCustomParam("accResultId");
            DynamicObject accResult = this.getModel().getDataEntity();
            AccResultDetailHelper detailHelper = new AccResultDetailHelper();
            FormShowParameter parameter = detailHelper.getAdjustPageParameter(accResult, accResultId.longValue());
            this.getView().showForm(parameter);
        }
    }

    private void doSaveCheck(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(ADJUST_ACC_RESULT_ENTRY);
        if (entryDatas == null || entryDatas.size() == 0) {
            return;
        }
        BigDecimal totalAdjustAmount = BigDecimal.ZERO;
        for (DynamicObject dataObj : entryDatas) {
            BigDecimal adjustAmount = dataObj.getBigDecimal(ADJUST_AMOUNT);
            String adjustReason = dataObj.getString(ADJUST_REASON);
            if (adjustAmount == null || SWCStringUtils.isEmpty((String)adjustReason)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8c03\u6574\u503c\u201d\u3001\u201c\u8c03\u6574\u539f\u56e0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccResultDetailPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            totalAdjustAmount = totalAdjustAmount.add(adjustAmount);
        }
        if (totalAdjustAmount.compareTo(BigDecimal.valueOf(10000000000000L)) >= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c\u503c\u5df2\u8d85\u8fc7\u5c0f\u6570\u70b9\u4f4d\u524d13\u4f4d\u6216\u8d85\u8fc7\u5c0f\u6570\u70b9\u4f4d\u540e10\u4f4d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AccResultDetailPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject obj = this.getModel().getDataEntity();
        HashMap<String, Long> personMap = new HashMap<String, Long>(2);
        personMap.put("employee", obj.getLong("employee.id"));
        personMap.put("salaryfile", obj.getLong("salaryfile.id"));
        HashMap<Long, HashMap<String, Long>> personIndexMap = new HashMap<Long, HashMap<String, Long>>(1);
        personIndexMap.put(obj.getLong("personindexid"), personMap);
        HashMap errorDataMap = new HashMap(personIndexMap.size());
        AccCalMutexUtils.checkPersonHrIsCalingAndAddMutexData(personIndexMap, errorDataMap);
        AccCalMutexUtils.addSalaryCalMutexData(personIndexMap, errorDataMap, (String)"3");
        if (errorDataMap.size() > 0) {
            this.getView().showTipNotification((String)errorDataMap.get(obj.getLong("personindexid")));
            args.setCancel(true);
            return;
        }
    }

    private void setAdjustEntryField(boolean isView) {
        if (isView) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADJUST_AMOUNT});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showadjustamount"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{ADJUST_AMOUNT});
            this.getView().setVisible(Boolean.FALSE, new String[]{"showadjustamount"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)"donothing_modify", (String)optKey)) {
            this.setAdjustEntryField(false);
            this.getView().setStatus(OperationStatus.EDIT);
            this.doModify();
        } else if (SWCStringUtils.equals((String)"donothing_save", (String)optKey)) {
            this.setAdjustEntryField(true);
            this.getView().setStatus(OperationStatus.VIEW);
            this.doSave();
        }
    }

    private void doModify() {
        this.getView().setVisible(Boolean.FALSE, new String[]{MODIFY_BTN});
        this.getView().setVisible(Boolean.TRUE, new String[]{SAVE_BTN});
        this.getView().setVisible(Boolean.TRUE, new String[]{ADD_DATA_LABEL});
        SWCPageCache cache = new SWCPageCache(this.getView());
        int fixRowCount = (Integer)cache.get("fixRowCount", Integer.class);
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(ADJUST_ACC_RESULT_ENTRY);
        this.adjustEntryEnable(entryDatas, Boolean.TRUE, fixRowCount + 1);
    }

    private void doSave() {
        try {
            this.getView().setVisible(Boolean.FALSE, new String[]{SAVE_BTN});
            this.getView().setVisible(Boolean.TRUE, new String[]{MODIFY_BTN});
            this.getView().setVisible(Boolean.FALSE, new String[]{ADD_DATA_LABEL});
            DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(ADJUST_ACC_RESULT_ENTRY);
            this.adjustEntryEnable(entryDatas, Boolean.FALSE, 0);
            Long accResultId = (Long)this.getView().getFormShowParameter().getCustomParam("accResultId");
            AccResultDetailHelper helper = new AccResultDetailHelper();
            helper.writeDateToEntry(entryDatas, accResultId);
            entryDatas = this.getModel().getEntryEntity(ADJUST_ACC_RESULT_ENTRY);
            SWCPageCache cache = new SWCPageCache(this.getView());
            cache.put("fixRowCount", (Object)(entryDatas.size() - 1));
            this.adjustEntryEnable(entryDatas, Boolean.FALSE, entryDatas.size());
            SWCDataServiceHelper dataPrecisionHelper = new SWCDataServiceHelper("hsbs_dataprecision");
            DynamicObject[] allDataPrecisionArray = dataPrecisionHelper.query("id,scale", new QFilter[0]);
            HashMap<Long, Integer> scaleMap = new HashMap<Long, Integer>(allDataPrecisionArray.length);
            for (DynamicObject precisionObj : allDataPrecisionArray) {
                scaleMap.put(precisionObj.getLong("id"), precisionObj.getInt("scale"));
            }
            this.loadBaseInfoData(scaleMap);
            this.getView().updateView(ADJUST_ACC_RESULT_ENTRY);
            String resultValue = (String)this.getModel().getValue("resultvalue");
            this.getModel().setDataChanged(false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u7d2f\u52a0\u7ed3\u679c\u503c\u8c03\u6574\u4e3a{0}\u3002", (String)"AccResultDetailPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[]{resultValue}));
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
        finally {
            Long personIndexId = (Long)this.getModel().getValue("personindexid");
            HashSet<Long> personIndexIdSet = new HashSet<Long>(1);
            personIndexIdSet.add(personIndexId);
            AccCalMutexUtils.releaseSalaryCalMutexData(personIndexIdSet, (String)"3");
        }
    }

    private void adjustEntryEnable(DynamicObjectCollection dataColl, Boolean isEdit, int fixRowCount) {
        if (dataColl == null || dataColl.size() == 0) {
            return;
        }
        int size = dataColl.size();
        for (int i = fixRowCount; i < size; ++i) {
            this.getView().setEnable(isEdit, i, new String[]{ADJUST_AMOUNT});
            this.getView().setEnable(isEdit, i, new String[]{ADJUST_REASON});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (SWCStringUtils.equals((String)"option", (String)fieldName)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_dataprecision");
            DynamicObject[] allDataPrecisionArray = helper.query("id,scale", new QFilter[0]);
            HashMap<Long, Integer> scaleMap = new HashMap<Long, Integer>(allDataPrecisionArray.length);
            for (DynamicObject precisionObj : allDataPrecisionArray) {
                scaleMap.put(precisionObj.getLong("id"), precisionObj.getInt("scale"));
            }
            Long accResultId = (Long)this.getView().getFormShowParameter().getCustomParam("accResultId");
            if (accResultId == null) {
                return;
            }
            AccResultDetailHelper accResultDetailHelper = new AccResultDetailHelper();
            DynamicObject accResultInfo = accResultDetailHelper.getAccResultDetailInfo(accResultId);
            if (SWCObjectUtils.isEmpty((Object)accResultInfo)) {
                return;
            }
            DynamicObject currencyObj = accResultInfo.getDynamicObject("currency");
            DynamicObject accObj = accResultInfo.getDynamicObject("acc");
            int scale = this.getDecimalScale(currencyObj, accObj, scaleMap);
            this.openAccMemberPage(scale);
        }
    }

    private void openAccMemberPage(int scale) {
        long calPersonId;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(ACC_MEMBER_PAGE);
        showParameter.setCaption(ResManager.loadKDString((String)"\u7d2f\u52a0\u6210\u5458\u5217\u8868", (String)"AccResultDetailPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject accObject = (DynamicObject)this.getModel().getValue("acc");
        if (!SWCObjectUtils.isEmpty((Object)accObject)) {
            showParameter.setCustomParam("accId", accObject.get("id"));
        }
        int index = this.getModel().getEntryCurrentRowIndex(ACC_DETAIL_ENTRY);
        DynamicObject selectObj = this.getModel().getEntryRowEntity(ACC_DETAIL_ENTRY, index);
        DynamicObject calTaskObj = selectObj.getDynamicObject("caltask");
        if (!SWCObjectUtils.isEmpty((Object)calTaskObj)) {
            showParameter.setCustomParam("calTaskId", calTaskObj.get("id"));
        }
        if ((calPersonId = selectObj.getLong("calpersonid")) != 0L) {
            showParameter.setCustomParam("calPersonId", (Object)calPersonId);
        }
        showParameter.setCustomParam("scale", (Object)scale);
        this.getView().showForm(showParameter);
    }

    private void loadAccResultDetailEntryData(Map<Long, Integer> scaleMap) {
        Long accResultId = (Long)this.getView().getFormShowParameter().getCustomParam("accResultId");
        if (accResultId == null) {
            return;
        }
        AccResultDetailHelper helper = new AccResultDetailHelper();
        DynamicObject[] accDetailsColl = helper.getAccDetailInfo(accResultId);
        if (accDetailsColl == null || accDetailsColl.length == 0) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"adjust"});
        HashMap<Long, Long> relationMap = new HashMap<Long, Long>(accDetailsColl.length);
        for (DynamicObject dataObj : accDetailsColl) {
            if (dataObj.getLong("calpersonid") == 0L) continue;
            relationMap.put(dataObj.getLong("id"), dataObj.getLong("calpersonid"));
        }
        Map salaryFileMap = helper.getCalPersonSalaryFileNumber(relationMap);
        HashMap<Long, Long> calTaskMap = new HashMap<Long, Long>(accDetailsColl.length);
        for (DynamicObject dataObj : accDetailsColl) {
            DynamicObject calTaskObj = dataObj.getDynamicObject("caltask");
            if (SWCObjectUtils.isEmpty((Object)calTaskObj)) continue;
            calTaskMap.put(dataObj.getLong("id"), calTaskObj.getLong("id"));
        }
        Map periodMap = helper.getCalTaskPeriodId(calTaskMap);
        IDataModel model = this.getModel();
        for (DynamicObject dataObj : accDetailsColl) {
            BigDecimal totalVal;
            String totalValStr;
            BigDecimal currentVal;
            String currentValStr;
            DynamicObject currencyObj;
            DynamicObject calTaskObj;
            int detailIndex = model.createNewEntryRow(ACC_DETAIL_ENTRY);
            long calPersonId = dataObj.getLong("calpersonid");
            if (calPersonId != 0L) {
                model.setValue("calpersonid", (Object)calPersonId, detailIndex);
            }
            long calDetailId = dataObj.getLong("id");
            if (salaryFileMap != null && salaryFileMap.size() > 0) {
                model.setValue("entryfilenumber", salaryFileMap.get(calDetailId), detailIndex);
            }
            if (!SWCObjectUtils.isEmpty((Object)(calTaskObj = dataObj.getDynamicObject("caltask")))) {
                model.setValue("caltask", (Object)calTaskObj.getLong("id"), detailIndex);
            }
            if (periodMap != null && periodMap.size() > 0) {
                model.setValue("period", periodMap.get(calDetailId), detailIndex);
            }
            if (!SWCObjectUtils.isEmpty((Object)(currencyObj = dataObj.getDynamicObject("currency")))) {
                model.setValue("entrycurrency", currencyObj.get("id"), detailIndex);
            }
            DynamicObject accObj = this.getModel().getDataEntity().getDynamicObject("acc");
            BigDecimal initVal = dataObj.getBigDecimal("initvalue");
            String initValStr = this.buildResultValueStr(initVal, currencyObj, accObj, scaleMap);
            if (SWCStringUtils.isNotEmpty((String)initValStr)) {
                model.setValue("initvalue", (Object)initValStr, detailIndex);
            }
            if (SWCStringUtils.isNotEmpty((String)(currentValStr = this.buildResultValueStr(currentVal = dataObj.getBigDecimal("currentvalue"), currencyObj, accObj, scaleMap)))) {
                model.setValue("currentvalue", (Object)currentValStr, detailIndex);
            }
            if (SWCStringUtils.isNotEmpty((String)(totalValStr = this.buildResultValueStr(totalVal = initVal.add(currentVal), currencyObj, accObj, scaleMap)))) {
                model.setValue("entryresultval", (Object)totalValStr, detailIndex);
            }
            model.setValue("entryindex", dataObj.get("index"), detailIndex);
            if (SWCObjectUtils.isEmpty((Object)calTaskObj)) continue;
            String option = ResManager.loadKDString((String)"\u67e5\u770b\u7d2f\u52a0\u6210\u5458", (String)"AccResultDetailPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            model.setValue("option", (Object)option, detailIndex);
        }
        this.getView().updateView(ACC_DETAIL_ENTRY);
    }

    private void loadBaseInfoData(Map<Long, Integer> scaleMap) {
        String periodType;
        BigDecimal resultValue;
        String resultValStr;
        String dimension1;
        Date endDate;
        DynamicObject accObj;
        DynamicObject salaryFileObj;
        Long accResultId = (Long)this.getView().getFormShowParameter().getCustomParam("accResultId");
        if (accResultId == null) {
            return;
        }
        AccResultDetailHelper helper = new AccResultDetailHelper();
        DynamicObject accResultInfo = helper.getAccResultDetailInfo(accResultId);
        if (SWCObjectUtils.isEmpty((Object)accResultInfo)) {
            return;
        }
        this.getModel().setValue("personindexid", (Object)accResultInfo.getLong("personindexid"));
        DynamicObject employeeObj = accResultInfo.getDynamicObject("employee");
        if (!SWCObjectUtils.isEmpty((Object)employeeObj)) {
            Long employeeId = employeeObj.getLong("id");
            this.getModel().setValue("employee", (Object)employeeId);
            UpdateTabNameHelper.updateTabNameBySuffixValue((IFormView)this.getView(), (String)employeeObj.getString("person.name"));
        }
        if (!SWCObjectUtils.isEmpty((Object)(salaryFileObj = accResultInfo.getDynamicObject("salaryfile")))) {
            Long salaryFileId = salaryFileObj.getLong("id");
            this.getModel().setValue("salaryfile", (Object)salaryFileId);
        }
        if (!SWCObjectUtils.isEmpty((Object)(accObj = accResultInfo.getDynamicObject("acc")))) {
            Long accId = accObj.getLong("id");
            this.getModel().setValue("acc", (Object)accId);
        }
        int instanceNum = accResultInfo.getInt("instancenum");
        this.getModel().setValue("instancenum", (Object)instanceNum);
        Date startDate = accResultInfo.getDate("startdate");
        if (startDate != null) {
            this.getModel().setValue("startdate", (Object)startDate);
        }
        if ((endDate = accResultInfo.getDate("enddate")) != null) {
            this.getModel().setValue("enddate", (Object)endDate);
        }
        if (SWCStringUtils.isEmpty((String)(dimension1 = accResultInfo.getString("dimension1")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dimension1"});
        } else {
            this.getModel().setValue("dimension1", (Object)dimension1);
        }
        String dimension2 = accResultInfo.getString("dimension2");
        if (SWCStringUtils.isEmpty((String)dimension2)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dimension2"});
        } else {
            this.getModel().setValue("dimension2", (Object)dimension2);
        }
        String dimension3 = accResultInfo.getString("dimension3");
        if (SWCStringUtils.isEmpty((String)dimension3)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dimension3"});
        } else {
            this.getModel().setValue("dimension3", (Object)dimension3);
        }
        String dimension4 = accResultInfo.getString("dimension4");
        if (SWCStringUtils.isEmpty((String)dimension4)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dimension4"});
        } else {
            this.getModel().setValue("dimension4", (Object)dimension4);
        }
        String dimension5 = accResultInfo.getString("dimension5");
        if (SWCStringUtils.isEmpty((String)dimension5)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dimension5"});
        } else {
            this.getModel().setValue("dimension5", (Object)dimension5);
        }
        DynamicObject currencyObj = accResultInfo.getDynamicObject("currency");
        if (!SWCObjectUtils.isEmpty((Object)currencyObj)) {
            Long currencyId = currencyObj.getLong("id");
            this.getModel().setValue("currency", (Object)currencyId);
        }
        if (SWCStringUtils.isNotEmpty((String)(resultValStr = this.buildResultValueStr(resultValue = accResultInfo.getBigDecimal("resultvalue"), currencyObj, accObj, scaleMap)))) {
            this.getModel().setValue("resultvalue", (Object)resultValStr);
        }
        if (SWCStringUtils.equals((String)(periodType = accResultInfo.getString("acc.periodtype")), (String)"6")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"accbsedstrategy"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"accbsedstrategy"});
        }
    }

    private String buildResultValueStr(BigDecimal resultValue, DynamicObject currencyObj, DynamicObject accObj, Map<Long, Integer> scaleMap) {
        if (resultValue != null) {
            DynamicObject dataPrecisionObj;
            if (!SWCObjectUtils.isEmpty((Object)currencyObj)) {
                int amtprecision = currencyObj.getInt("amtprecision");
                return resultValue.setScale(amtprecision, 4).toString();
            }
            if (!SWCObjectUtils.isEmpty((Object)accObj) && !SWCObjectUtils.isEmpty((Object)(dataPrecisionObj = accObj.getDynamicObject("dataprecision")))) {
                int scale = 0;
                long dataPrecisionId = dataPrecisionObj.getLong("id");
                if (scaleMap.get(dataPrecisionId) != null) {
                    scale = scaleMap.get(dataPrecisionId);
                }
                return resultValue.setScale(scale, 4).toString();
            }
        }
        return "";
    }

    private int getDecimalScale(DynamicObject currencyObj, DynamicObject accObj, Map<Long, Integer> scaleMap) {
        DynamicObject dataPrecisionObj;
        if (!SWCObjectUtils.isEmpty((Object)currencyObj)) {
            int amtprecision = currencyObj.getInt("amtprecision");
            return amtprecision;
        }
        if (!SWCObjectUtils.isEmpty((Object)accObj) && !SWCObjectUtils.isEmpty((Object)(dataPrecisionObj = accObj.getDynamicObject("dataprecision")))) {
            int scale = 2;
            long dataPrecisionId = dataPrecisionObj.getLong("id");
            if (scaleMap.get(dataPrecisionId) != null) {
                scale = scaleMap.get(dataPrecisionId);
            }
            return scale;
        }
        return 2;
    }

    private void loadPageByPageType() {
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if (SWCStringUtils.equals((String)"view", (String)pageType)) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{SAVE_BTN});
            this.getView().setVisible(Boolean.TRUE, new String[]{MODIFY_BTN});
            this.getView().setVisible(Boolean.FALSE, new String[]{ADD_DATA_LABEL});
            this.setAdjustEntryField(true);
            DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(ADJUST_ACC_RESULT_ENTRY);
            this.adjustEntryEnable(entryDatas, Boolean.FALSE, 0);
            this.getView().setStatus(OperationStatus.VIEW);
        } else if (SWCStringUtils.equals((String)MODIFY_BTN, (String)pageType)) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setVisible(Boolean.FALSE, new String[]{MODIFY_BTN});
            this.getView().setVisible(Boolean.TRUE, new String[]{SAVE_BTN});
            this.getView().setVisible(Boolean.TRUE, new String[]{ADD_DATA_LABEL});
            this.setAdjustEntryField(false);
            DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(ADJUST_ACC_RESULT_ENTRY);
            this.adjustEntryEnable(entryDatas, Boolean.FALSE, 0);
        }
    }
}

