/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator.accresultlist;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.jetbrains.annotations.NotNull;

public class AccResultBaseEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
Consumer<BeforeF7ViewDetailEvent>,
SetFilterListener {
    private static final String FIELD_ACC_KEY = "acc";
    private static final String FIELD_SALARYFILE_KEY = "salaryfile";
    private static final String FIELD_INSTANCENUM_KEY = "instancenum";
    private static final int DEFAULT_NUM = 1;
    private static final String ISADJUST_YES = "1";
    private static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit accEdit = (BasedataEdit)this.getControl(FIELD_ACC_KEY);
        accEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fileEdit = (BasedataEdit)this.getControl(FIELD_SALARYFILE_KEY);
        fileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        fileEdit.addBeforeF7ViewDetailListener((Consumer)this);
        BillList billlistap = (BillList)this.getView().getControl(BILLLISTAP);
        billlistap.addSetFilterListener((SetFilterListener)this);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.getModel().setValue(FIELD_INSTANCENUM_KEY, (Object)1);
        this.getModel().setDataChanged(false);
        BillList billlistap = (BillList)this.getView().getControl(BILLLISTAP);
        QFilter filter = this.getAccDetailQFilter();
        billlistap.getFilterParameter().getQFilters().add(filter);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "adjustentry"});
    }

    @NotNull
    private QFilter getAccDetailQFilter() {
        QFilter filter = new QFilter("accresult.id", "=", (Object)0L);
        filter.and("calpersonid", "=", (Object)0L);
        filter.and("caltask.id", "=", (Object)0L);
        return filter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            this.getModel().setValue("isadjust", (Object)ISADJUST_YES);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().updateView();
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey = event.getProperty().getName();
        if (FIELD_ACC_KEY.equals(fieldKey)) {
            this.setFieldValeAndState(event);
        } else if ("employee".equals(fieldKey)) {
            this.getModel().setValue(FIELD_SALARYFILE_KEY, null);
        } else if ("resultvalue".equals(fieldKey)) {
            this.addAdJustEntryValue(event);
        } else if ("startdate".equals(fieldKey)) {
            ChangeData changeData = event.getChangeSet()[0];
            Date startDate = (Date)changeData.getNewValue();
            DynamicObject acc = (DynamicObject)this.getModel().getValue(FIELD_ACC_KEY);
            this.setEndDateValue(startDate, acc);
        }
    }

    private void setEndDateValue(Date startDate, DynamicObject acc) {
        if (startDate == null || acc == null) {
            return;
        }
        String periodType = acc.getString("periodtype");
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        if (ISADJUST_YES.equals(periodType)) {
            startCal.add(1, 1);
            startCal.add(6, -1);
            startCal.set(11, 23);
            startCal.set(12, 59);
            startCal.set(13, 59);
            this.getModel().setValue("enddate", (Object)startCal.getTime());
        } else if ("5".equals(periodType)) {
            startCal.add(2, 6);
            startCal.add(6, -1);
            startCal.set(11, 23);
            startCal.set(12, 59);
            startCal.set(13, 59);
            this.getModel().setValue("enddate", (Object)startCal.getTime());
        } else if ("2".equals(periodType)) {
            startCal.add(2, 3);
            startCal.add(6, -1);
            startCal.set(11, 23);
            startCal.set(12, 59);
            startCal.set(13, 59);
            this.getModel().setValue("enddate", (Object)startCal.getTime());
        } else if ("3".equals(periodType)) {
            startCal.add(2, 1);
            startCal.add(6, -1);
            startCal.set(11, 23);
            startCal.set(12, 59);
            startCal.set(13, 59);
            this.getModel().setValue("enddate", (Object)startCal.getTime());
        } else {
            startCal.set(2199, 11, 31, 23, 59, 59);
            this.getModel().setValue("enddate", (Object)startCal.getTime());
        }
    }

    private void addAdJustEntryValue(PropertyChangedArgs event) {
        ChangeData changeData = event.getChangeSet()[0];
        BigDecimal resultValue = (BigDecimal)changeData.getNewValue();
        if (resultValue == null) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("adjustentry");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("adjustamount", new Object[0]);
        vs.addField("adjustdescript", new Object[0]);
        vs.addField("adjusttime", new Object[0]);
        vs.addField("adjustperson", new Object[0]);
        String adjustDescript = ResManager.loadKDString((String)"\u521d\u59cb\u5316", (String)"AccResultBaseEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        vs.addRow(new Object[]{resultValue, adjustDescript, new Date(), RequestContext.get().getCurrUserId()});
        model.batchCreateNewEntryRow("adjustentry", vs);
        model.endInit();
        this.getView().updateView("adjustentry");
    }

    private void setFieldValeAndState(PropertyChangedArgs event) {
        ChangeData changeData = event.getChangeSet()[0];
        DynamicObject accObj = (DynamicObject)changeData.getNewValue();
        if (accObj == null) {
            return;
        }
        String accDimension = accObj.getString("accdimension");
        BasedataEdit salaryFileEdit = (BasedataEdit)this.getControl(FIELD_SALARYFILE_KEY);
        if ("2".equals(accDimension)) {
            salaryFileEdit.setMustInput(true);
            this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_SALARYFILE_KEY});
        } else {
            salaryFileEdit.setMustInput(false);
            this.getModel().setValue(FIELD_SALARYFILE_KEY, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_SALARYFILE_KEY});
        }
        long dataTypeId = accObj.getLong("datatype.id");
        BasedataEdit currencyEdit = (BasedataEdit)this.getControl("currency");
        if (1020L == dataTypeId) {
            currencyEdit.setMustInput(true);
            this.getView().setEnable(Boolean.TRUE, new String[]{"currency"});
        } else {
            currencyEdit.setMustInput(false);
            this.getModel().setValue("currency", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
        }
        this.setStartAndEndDate(accObj);
    }

    private void setStartAndEndDate(DynamicObject accObj) {
        String periodType = accObj.getString("periodtype");
        Calendar nowTime = Calendar.getInstance();
        Calendar time = Calendar.getInstance();
        this.getView().setEnable(Boolean.FALSE, new String[]{"enddate"});
        if ("4".equals(periodType)) {
            nowTime.set(2199, 11, 31, 23, 59, 59);
            this.getModel().setValue("enddate", (Object)nowTime.getTime());
            if (!"2".equals(accObj.getString("startdatetype"))) {
                this.getModel().setValue("startdate", (Object)accObj.getDate("startdate"));
            }
        } else if (ISADJUST_YES.equals(periodType) || "5".equals(periodType) || "2".equals(periodType)) {
            time.set(1, nowTime.get(1));
            time.set(2, Integer.parseInt(accObj.getString("startmonth")) - 1);
            time.set(5, accObj.getInt("startday"));
            time.set(11, 0);
            time.set(12, 0);
            time.set(13, 0);
            this.getModel().setValue("startdate", (Object)time.getTime());
            this.setEndDateValue(time.getTime(), accObj);
        } else {
            time.set(1, nowTime.get(1));
            time.set(2, nowTime.get(2));
            time.set(5, accObj.getInt("startday"));
            time.set(11, 0);
            time.set(12, 0);
            time.set(13, 0);
            this.getModel().setValue("startdate", (Object)time.getTime());
            this.setEndDateValue(time.getTime(), accObj);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (FIELD_ACC_KEY.equals(fieldKey)) {
            qFilters.add(QFilter.isNull((String)"accdimitementry"));
            qFilters.add(new QFilter("periodtype", "!=", (Object)"6"));
            HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"47150e89000000ac");
            if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
                QFilter baseDataFilter;
                if (!SWCListUtils.isEmpty((List)hasPermOrgResult.getHasPermOrgs())) {
                    CalHelper.printLog((String)"accresult org is:", (Object)hasPermOrgResult.getHasPermOrgs());
                }
                if ((baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_accumulator", (List)hasPermOrgResult.getHasPermOrgs(), (boolean)true)) != null) {
                    qFilters.add(baseDataFilter);
                }
            }
            if (showParameter.getListFilterParameter().getQFilters() != null) {
                showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
            } else {
                showParameter.getListFilterParameter().setQFilters(qFilters);
            }
        } else if (FIELD_SALARYFILE_KEY.equals(fieldKey)) {
            DynamicObject data = this.getModel().getDataEntity();
            DynamicObject person = data.getDynamicObject("employee");
            if (person == null) {
                event.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u85aa\u4eba\u5458\u540e\u518d\u9009\u62e9\u6863\u6848\u7f16\u53f7\u3002", (String)"AccResultBaseEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("employee", "=", (Object)person.getLong("id"));
            qFilters.add(filter);
            HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"47150e89000000ac");
            if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
                qFilters.add(new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
            }
            if (showParameter.getListFilterParameter().getQFilters() != null) {
                showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
            } else {
                showParameter.getListFilterParameter().setQFilters(qFilters);
            }
        }
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent event) {
        BasedataEdit base = (BasedataEdit)event.getSource();
        String key = base.getFieldKey();
        if (FIELD_SALARYFILE_KEY.equals(key)) {
            event.setCancel(true);
            SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView((Long)((Long)event.getPkId()), (IFormView)this.getView(), (String)"true");
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        setFilterEvent.getQFilters().add(this.getAccDetailQFilter());
    }
}

