/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator.accresultlist;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.accumulator.AccCalMutexUtils;
import kd.swc.hsas.business.accumulator.AccResultCheckService;
import kd.swc.hsas.business.accumulator.AccResultPermService;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.EntryImportContext;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;

public class AccResultImportNewPlugin {
    private static final Log logger = LogFactory.getLog(AccResultImportNewPlugin.class);
    private static final int EMPNUMBER_INDEX = 0;
    private static final int FILENUMBER_INDEX = 1;
    private static final int ACCNUMBER_INDEX = 3;
    private static final int STARTDATE_INDEX = 6;
    private static final int CURRENCY_INDEX = 8;
    private static final int RESULTVALUE_INDEX = 9;
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static final String CONNECTOR = "@;@";
    private static final int DEFAULT_NUM = 1;
    private static final String ISADJUST_YES = "1";
    private ProgressHandler processHandler;
    private DynamicObjectCollection accResultUpdateList;
    private DynamicObjectCollection accResultSaveList;

    public AccResultImportNewPlugin(ProgressHandler processHandler) {
        this.processHandler = processHandler;
        this.accResultUpdateList = new DynamicObjectCollection();
        this.accResultSaveList = new DynamicObjectCollection();
    }

    public void dataImport(List<Map<Integer, String>> dataRow) {
        logger.info("dataImport begin");
        HashSet<String> fileNumberSet = new HashSet<String>(dataRow.size());
        Map<Integer, Map<Integer, String>> successRowMap = this.checkNullData(dataRow, fileNumberSet);
        if (successRowMap.size() == 0) {
            logger.info("all data checkNullData no pass");
            return;
        }
        HashMap<Long, Map<String, Long>> personIndexMap = new HashMap<Long, Map<String, Long>>(16);
        Map<Integer, DynamicObject> successDataMap = this.checkData(successRowMap, fileNumberSet, personIndexMap);
        if (successDataMap.size() == 0) {
            logger.info("all data checkData no pass");
            return;
        }
        HashSet<Long> personIndexIdSet = new HashSet<Long>(16);
        if ((successDataMap = this.checkPersonIsCalingOrAdjust(successDataMap, personIndexMap, personIndexIdSet)).size() == 0) {
            logger.info("all data checkPersonIsCalingOrAdjust no pass");
            return;
        }
        this.checkRepeatData(successDataMap);
        TXHandle txHandle = TX.requiresNew();
        try {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
            if (this.accResultSaveList.size() > 0) {
                helper.save(this.accResultSaveList);
            }
            if (this.accResultUpdateList.size() > 0) {
                Object[] updateArr = new DynamicObject[this.accResultUpdateList.size()];
                helper.update((DynamicObject[])this.accResultUpdateList.toArray(updateArr));
            }
        }
        catch (Exception e) {
            logger.error("dataImport save error,", (Throwable)e);
            txHandle.markRollback();
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        finally {
            txHandle.close();
            if (personIndexIdSet.size() > 0) {
                AccCalMutexUtils.releaseSalaryCalMutexData(personIndexIdSet, (String)"3");
            }
        }
        logger.info("dataImport end");
    }

    private Map<Integer, DynamicObject> checkPersonIsCalingOrAdjust(Map<Integer, DynamicObject> dataMap, Map<Long, Map<String, Long>> personIndexMap, Set<Long> personIndexIdSet) {
        HashMap<Integer, DynamicObject> successDataMap = new HashMap<Integer, DynamicObject>(dataMap.size());
        HashMap errorDataMap = new HashMap(personIndexMap.size());
        AccCalMutexUtils.checkPersonHrIsCalingAndAddMutexData(personIndexMap, errorDataMap);
        personIndexIdSet.addAll(AccCalMutexUtils.addSalaryCalMutexData(personIndexMap, errorDataMap, (String)"3"));
        if (errorDataMap.size() == 0) {
            return dataMap;
        }
        for (Map.Entry<Integer, DynamicObject> entry : dataMap.entrySet()) {
            String msg = (String)errorDataMap.get(entry.getValue().getLong("personindexid"));
            if (SWCStringUtils.isNotEmpty((String)msg)) {
                this.processHandler.putRowError(entry.getKey(), msg);
                this.processHandler.incrByProgress(0, 1);
                continue;
            }
            successDataMap.put(entry.getKey(), entry.getValue());
        }
        return successDataMap;
    }

    private Map<String, List<DynamicObject>> getImportDataMap(Map<Integer, DynamicObject> dataMap, QFilter filter) {
        HashMap<String, List<DynamicObject>> importAccDataMap = new HashMap<String, List<DynamicObject>>(dataMap.size());
        DynamicObject importAccData = null;
        ArrayList<DynamicObject> tempList = null;
        HashSet<Long> peronIndexIdSet = new HashSet<Long>(dataMap.size());
        HashSet<Long> accIdSet = new HashSet<Long>(dataMap.size());
        HashSet<Long> employeeIdSet = new HashSet<Long>(dataMap.size());
        HashSet<Long> fileIdSet = new HashSet<Long>(dataMap.size());
        for (Map.Entry<Integer, DynamicObject> entry : dataMap.entrySet()) {
            importAccData = entry.getValue();
            peronIndexIdSet.add(importAccData.getLong("personindexid"));
            accIdSet.add(importAccData.getLong("acc"));
            employeeIdSet.add(importAccData.getLong("employee"));
            fileIdSet.add(importAccData.getLong("salaryfile"));
            String key = importAccData.getLong("employee") + CONNECTOR + importAccData.getLong("salaryfile") + CONNECTOR + importAccData.getLong("acc");
            tempList = (ArrayList<DynamicObject>)importAccDataMap.get(key);
            if (tempList == null) {
                tempList = new ArrayList<DynamicObject>(10);
                importAccDataMap.put(key, tempList);
            }
            tempList.add(importAccData);
        }
        filter.and(new QFilter("employee.id", "in", employeeIdSet));
        filter.and("personindexid", "in", peronIndexIdSet);
        filter.and("acc.id", "in", accIdSet);
        filter.and("salaryfile.id", "in", fileIdSet);
        return importAccDataMap;
    }

    private void checkRepeatData(Map<Integer, DynamicObject> dataMap) {
        QFilter accResultFilter = new QFilter(ISADJUST_YES, "=", (Object)1);
        Map<String, List<DynamicObject>> tempAccMap = this.getImportDataMap(dataMap, accResultFilter);
        HashSet<Long> existAccResultIdSet = new HashSet<Long>(16);
        Map<String, List<DynamicObject>> accResultDbMap = this.getExistAccResultMap(accResultFilter, existAccResultIdSet);
        AccResultCheckService checkService = new AccResultCheckService();
        Map accDetailMap = checkService.getAccDetailMapByAccResultId(existAccResultIdSet);
        DynamicObject accResultObj = null;
        DynamicObject dbAccResult = null;
        List<DynamicObject> tempList = null;
        for (Map.Entry<Integer, DynamicObject> entry : dataMap.entrySet()) {
            String msg;
            accResultObj = entry.getValue();
            String mapKey = accResultObj.getLong("employee") + CONNECTOR + accResultObj.getLong("salaryfile") + CONNECTOR + accResultObj.getLong("acc");
            tempList = tempAccMap.get(mapKey);
            if (tempList != null && tempList.size() > 1) {
                msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u548c\u7d2f\u52a0\u5668\u5728\u6587\u4ef6\u4e2d\u5b58\u5728%s\u6761\u91cd\u590d\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_16", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), tempList.size());
                this.processHandler.putRowError(entry.getKey(), msg);
                this.processHandler.incrByProgress(0, 1);
                continue;
            }
            tempList = accResultDbMap.get(mapKey);
            if (tempList == null || tempList.size() == 0) {
                this.setAccResultObjValue(accResultObj);
                this.accResultSaveList.add((Object)accResultObj);
                this.processHandler.incrByProgress(1, 0);
                continue;
            }
            if (tempList.size() > 1) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u548c\u7d2f\u52a0\u5668\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u591a\u4e2a\u76f8\u540c\u5b9e\u4f8b\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_15", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                this.processHandler.putRowError(entry.getKey(), msg);
                this.processHandler.incrByProgress(0, 1);
                continue;
            }
            dbAccResult = tempList.get(0);
            if (accDetailMap.containsKey(dbAccResult.getLong("id"))) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u7d2f\u52a0\u5b9e\u4f8b\u4e2d\u5df2\u5b58\u5728\u901a\u8fc7\u85aa\u8d44\u6838\u7b97\u751f\u6210\u7684\u7d2f\u52a0\u660e\u7ec6\u7ed3\u679c\u3002\u65e0\u6cd5\u66f4\u65b0\u521d\u59cb\u5316\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_21", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                this.processHandler.putRowError(entry.getKey(), msg);
                this.processHandler.incrByProgress(0, 1);
                continue;
            }
            this.reSetAccResultPropValue(accResultObj, dbAccResult);
            this.accResultUpdateList.add((Object)dbAccResult);
            this.processHandler.incrByProgress(1, 0);
        }
    }

    private void reSetAccResultPropValue(DynamicObject accResultObj, DynamicObject dbAccResult) {
        dbAccResult.set("resultvalue", (Object)accResultObj.getBigDecimal("resultvalue"));
        dbAccResult.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dbAccResult.set("modifytime", (Object)new Date());
        dbAccResult.set("isadjust", (Object)ISADJUST_YES);
        DynamicObjectCollection entryList = dbAccResult.getDynamicObjectCollection("adjustentry");
        if (entryList.size() > 0) {
            entryList.clear();
        }
        DynamicObject entryObj = entryList.addNew();
        entryObj.set("seq", (Object)1);
        entryObj.set("adjustamount", (Object)accResultObj.getBigDecimal("resultvalue"));
        entryObj.set("adjustdescript", (Object)ResManager.loadKDString((String)"\u521d\u59cb\u5316", (String)"AccResultImportNewPlugin_17", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
        entryObj.set("adjusttime", (Object)new Date());
        entryObj.set("adjustperson", (Object)RequestContext.get().getCurrUserId());
    }

    private void setAccResultObjValue(DynamicObject accResultObj) {
        accResultObj.set("instancenum", (Object)1);
        accResultObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        accResultObj.set("createtime", (Object)new Date());
        accResultObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        accResultObj.set("modifytime", (Object)new Date());
        accResultObj.set("isadjust", (Object)ISADJUST_YES);
        DynamicObjectCollection entryList = accResultObj.getDynamicObjectCollection("adjustentry");
        if (entryList == null) {
            entryList = new DynamicObjectCollection();
        }
        DynamicObject entryObj = entryList.addNew();
        entryObj.set("adjustamount", (Object)accResultObj.getBigDecimal("resultvalue"));
        entryObj.set("adjustdescript", (Object)ResManager.loadKDString((String)"\u521d\u59cb\u5316", (String)"AccResultImportNewPlugin_17", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
        entryObj.set("adjusttime", (Object)new Date());
        entryObj.set("adjustperson", (Object)RequestContext.get().getCurrUserId());
        entryObj.set("seq", (Object)1);
    }

    private Map<String, List<DynamicObject>> getExistAccResultMap(QFilter accResultFilter, Set<Long> existAccResultIdSet) {
        logger.info("getExistAccResultMap begin");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
        String fields = "id,employee.id,salaryfile.id,acc.id,startdate,enddate,resultvalue,instancenum,modifytime,modifier,isadjust,adjustentry.adjustamount,adjustentry.adjustdescript,adjustentry.adjusttime,adjustentry.adjustperson,adjustentry.seq";
        DynamicObject[] result = helper.query(fields, new QFilter[]{accResultFilter});
        ArrayList<DynamicObject> tempList = null;
        HashMap<String, List<DynamicObject>> accResultMap = new HashMap<String, List<DynamicObject>>(result.length);
        for (DynamicObject obj : result) {
            existAccResultIdSet.add(obj.getLong("id"));
            String key = obj.getLong("employee.id") + CONNECTOR + obj.getLong("salaryfile.id") + CONNECTOR + obj.getLong("acc.id");
            tempList = (ArrayList<DynamicObject>)accResultMap.get(key);
            if (tempList == null) {
                tempList = new ArrayList<DynamicObject>(10);
                accResultMap.put(key, tempList);
            }
            tempList.add(obj);
        }
        logger.info("getExistAccResultMap end");
        return accResultMap;
    }

    private Map<Integer, DynamicObject> checkData(Map<Integer, Map<Integer, String>> dataRow, Set<String> fileNumberSet, Map<Long, Map<String, Long>> personIndexMap) {
        HashMap<Integer, DynamicObject> successRowMap = new HashMap<Integer, DynamicObject>(dataRow.size());
        HashSet<String> accNumberSet = new HashSet<String>(dataRow.size());
        HashSet<String> empNumberSet = new HashSet<String>(dataRow.size());
        HashSet<String> currencyNumberSet = new HashSet<String>(dataRow.size());
        for (Map<Integer, String> tempMap : dataRow.values()) {
            accNumberSet.add(tempMap.get(3));
            empNumberSet.add(tempMap.get(0));
            currencyNumberSet.add(tempMap.get(8));
        }
        AccResultPermService permService = new AccResultPermService();
        Map existAccDataMap = permService.getAccDataMap(accNumberSet);
        Set hasPermsAccIdSet = permService.getHasPermsAccDataSet(existAccDataMap);
        HashSet employeeIdSet = new HashSet(16);
        Map personMap = permService.getEmployeeDataMap(empNumberSet, employeeIdSet);
        Set hasPermsEmployeeIdSet = permService.getHasPermsEmployeeDataSet(employeeIdSet);
        Map fileMap = permService.getSalaryFileData(fileNumberSet);
        Set hasPermsSalaryFileIdSet = permService.getHasPermsSalaryFileDataSet(fileMap);
        Map<String, DynamicObject> currencyMap = this.getCurrencyData(currencyNumberSet);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_accresult");
        String msg = null;
        boolean isCheckPass = true;
        DynamicObject accResult = null;
        Map<Integer, String> row = null;
        DynamicObject accObj = null;
        for (Map.Entry<Integer, Map<Integer, String>> entry : dataRow.entrySet()) {
            row = entry.getValue();
            accResult = (DynamicObject)type.createInstance();
            isCheckPass = true;
            accObj = (DynamicObject)existAccDataMap.get(row.get(3));
            if (accObj == null) {
                msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u7d2f\u52a0\u5668\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_5", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                this.processHandler.putRowError(entry.getKey(), msg);
                this.processHandler.incrByProgress(0, 1);
                continue;
            }
            String periodType = accObj.getString("periodtype");
            if (SWCStringUtils.equals((String)periodType, (String)"6")) {
                msg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u7d2f\u52a0\u9891\u5ea6\u4e3a\u201c\u6309\u85aa\u8d44\u671f\u95f4\u201d\u7684\u7d2f\u52a0\u5668\u8fdb\u884c\u6dfb\u52a0/\u66f4\u65b0\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_22", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                this.processHandler.putRowError(entry.getKey(), msg);
                this.processHandler.incrByProgress(0, 1);
                continue;
            }
            if (!hasPermsAccIdSet.contains(accObj.getLong("id"))) {
                msg = ResManager.loadKDString((String)"\u8be5\u7d2f\u52a0\u5668\u4e0d\u5728\u7528\u6237\u6743\u9650\u5185\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_19", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                this.processHandler.putRowError(entry.getKey(), msg);
                this.processHandler.incrByProgress(0, 1);
                continue;
            }
            if (!this.checkAccData(accObj, entry, this.processHandler, fileMap, accResult, hasPermsSalaryFileIdSet, personMap, hasPermsEmployeeIdSet)) {
                isCheckPass = false;
            }
            accResult.set("acc", (Object)accObj.getLong("id"));
            long dataTypeId = accObj.getLong("datatype.id");
            DynamicObject currency = null;
            if (1020L == dataTypeId) {
                if (SWCStringUtils.isNotEmpty((String)row.get(8))) {
                    currency = currencyMap.get(row.get(8));
                    if (currency == null) {
                        msg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u5e01\u79cd\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_23", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                        this.processHandler.putRowError(entry.getKey(), msg);
                        this.processHandler.incrByProgress(0, 1);
                        continue;
                    }
                    accResult.set("currency", (Object)currency.getLong("id"));
                } else {
                    accResult.set("currency", (Object)1L);
                }
            }
            if (isCheckPass = this.checkResultValue(isCheckPass, accResult, row, accObj, entry, currency)) {
                successRowMap.put(entry.getKey(), accResult);
                this.putDataToPersonIndexMap(personIndexMap, accResult);
                continue;
            }
            this.processHandler.incrByProgress(0, 1);
        }
        return successRowMap;
    }

    private boolean checkResultValue(boolean isCheckPass, DynamicObject accResult, Map<Integer, String> row, DynamicObject accObj, Map.Entry<Integer, Map<Integer, String>> entry, DynamicObject currency) {
        BigDecimal resultValue = null;
        try {
            resultValue = new BigDecimal(row.get(9));
            String[] resultValueArr = row.get(9).split("\\.");
            if (resultValueArr.length == 2) {
                if (resultValueArr[0].length() > 13 || resultValueArr[1].length() > 10) {
                    String msg = ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u5b57\u8d85\u8fc7\u4e86\u5c0f\u6570\u70b9\u524d13\u4f4d\u6216\u5c0f\u6570\u70b9\u540e10\u4f4d\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_12", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                    isCheckPass = false;
                    this.processHandler.putRowError(entry.getKey(), msg);
                } else {
                    resultValue = this.dealResultValueScale(accObj, currency, resultValue);
                    accResult.set("resultvalue", (Object)resultValue);
                }
            } else if (row.get(9).length() > 13) {
                String msg = ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u5b57\u8d85\u8fc7\u4e86\u5c0f\u6570\u70b9\u524d13\u4f4d\u6216\u5c0f\u6570\u70b9\u540e10\u4f4d\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_12", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                isCheckPass = false;
                this.processHandler.putRowError(entry.getKey(), msg);
            } else {
                resultValue = this.dealResultValueScale(accObj, currency, resultValue);
                accResult.set("resultvalue", (Object)resultValue);
            }
        }
        catch (Exception e) {
            logger.error("parse resultValue error ", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6570\u503c\u683c\u5f0f\u7684\u201c\u7d2f\u52a0\u7ed3\u679c\u503c\u201d\u3002", (String)"AccResultImportNewPlugin_11", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            isCheckPass = false;
            this.processHandler.putRowError(entry.getKey(), msg);
        }
        return isCheckPass;
    }

    private void putDataToPersonIndexMap(Map<Long, Map<String, Long>> personIndexMap, DynamicObject accResult) {
        HashMap<String, Long> personMap = new HashMap<String, Long>(2);
        personMap.put("employee", accResult.getLong("employee"));
        personMap.put("salaryfile", accResult.getLong("salaryfile"));
        personIndexMap.put(accResult.getLong("personindexid"), personMap);
    }

    private BigDecimal dealResultValueScale(DynamicObject accObj, DynamicObject currency, BigDecimal resultValue) {
        resultValue = 1020L == accObj.getLong("datatype.id") ? (currency == null ? resultValue.setScale(4, RoundingMode.HALF_UP) : resultValue.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP)) : resultValue.setScale(accObj.getInt("dataprecision.scale"), ItemDataUtils.getRoundingMode((long)accObj.getLong("dataround.id")));
        return resultValue;
    }

    private boolean checkAccData(DynamicObject accObj, Map.Entry<Integer, Map<Integer, String>> entry, ProgressHandler processHandler, Map<String, DynamicObject> fileMap, DynamicObject accResult, Set<Long> hasPermsSalaryFileIdSet, Map<String, List<DynamicObject>> personMap, Set<Long> hasPermsEmployeeIdSet) {
        String msg;
        DynamicObjectCollection accEntry = accObj.getDynamicObjectCollection("accdimitementry");
        boolean isCheckPass = true;
        Map<Integer, String> row = entry.getValue();
        if (accEntry != null && accEntry.size() > 0) {
            msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u65b0\u589e\u5e26\u6709\u7d2f\u52a0\u5b50\u7ef4\u5ea6\u7684\u7d2f\u52a0\u7ed3\u679c\u5b9e\u4f8b\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_7", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            isCheckPass = false;
            processHandler.putRowError(entry.getKey(), msg);
        }
        Map<Long, DynamicObject> employeeMap = null;
        DynamicObject person = null;
        List<DynamicObject> tempPersonList = personMap.get(row.get(0));
        if (tempPersonList == null) {
            msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u8ba1\u85aa\u4eba\u5458\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_4", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            isCheckPass = false;
            processHandler.putRowError(entry.getKey(), msg);
            employeeMap = new HashMap<Long, DynamicObject>(0);
        } else {
            employeeMap = tempPersonList.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
            person = tempPersonList.get(0);
        }
        String accDimension = accObj.getString("accdimension");
        if ("2".equals(accDimension)) {
            if (SWCStringUtils.isEmpty((String)row.get(1))) {
                msg = ResManager.loadKDString((String)"\u7d2f\u52a0\u5668\u7ef4\u5ea6\u4e3a\u85aa\u8d44\u6863\u6848\u65f6\uff0c\u8bf7\u586b\u5199\u201c\u85aa\u8d44\u6863\u6848\u7f16\u53f7\u201d\u3002", (String)"AccResultImportNewPlugin_8", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                isCheckPass = false;
                processHandler.putRowError(entry.getKey(), msg);
            } else {
                DynamicObject file = fileMap.get(row.get(1));
                if (file == null) {
                    msg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_6", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                    isCheckPass = false;
                    processHandler.putRowError(entry.getKey(), msg);
                } else if (!hasPermsSalaryFileIdSet.contains(file.getLong("id"))) {
                    msg = ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6863\u6848\u4e0d\u5728\u7528\u6237\u6743\u9650\u5185\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_20", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                    isCheckPass = false;
                    processHandler.putRowError(entry.getKey(), msg);
                } else {
                    person = employeeMap.get(file.getLong("employee.id"));
                    if (person == null) {
                        msg = ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458\u4e0e\u85aa\u8d44\u6863\u6848\u4e0d\u5339\u914d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AccResultImportNewPlugin_14", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                        isCheckPass = false;
                        processHandler.putRowError(entry.getKey(), msg);
                    }
                    accResult.set("salaryfile", (Object)file.getLong("id"));
                }
            }
        }
        if (person != null) {
            if (hasPermsEmployeeIdSet.contains(person.getLong("id"))) {
                accResult.set("employee", (Object)person.getLong("id"));
                accResult.set("personindexid", (Object)person.getLong("person.personindexid"));
            } else {
                msg = ResManager.loadKDString((String)"\u8be5\u8ba1\u85aa\u4eba\u5458\u4e0d\u5728\u7528\u6237\u6743\u9650\u5185\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_18", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                isCheckPass = false;
                processHandler.putRowError(entry.getKey(), msg);
            }
        }
        isCheckPass = this.checkStartDate(accObj, entry, processHandler, accResult, isCheckPass);
        return isCheckPass;
    }

    private boolean checkStartDate(DynamicObject accObj, Map.Entry<Integer, Map<Integer, String>> entry, ProgressHandler processHandler, DynamicObject accResult, boolean isCheckPass) {
        String startDateStr = entry.getValue().get(6);
        Date startDate = null;
        try {
            startDate = SWCDateTimeUtils.parseDate((String)startDateStr, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            logger.error("parse startDate error ", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u65e5\u671f\u683c\u5f0f\u7684\u201c\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"AccResultImportNewPlugin_9", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            isCheckPass = false;
            processHandler.putRowError(entry.getKey(), msg);
            return isCheckPass;
        }
        String periodType = accObj.getString("periodtype");
        int startDay = accObj.getInt("startday");
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(startDate);
        tempCal.set(10, 0);
        tempCal.set(12, 0);
        tempCal.set(13, 0);
        if ("4".equals(periodType)) {
            if (!"2".equals(accObj.getString("startdatetype"))) {
                Date accStartDate = accObj.getDate("startdate");
                if (!SWCStringUtils.equals((String)SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), (String)SWCDateTimeUtils.format((Date)accStartDate, (String)"yyyy-MM-dd"))) {
                    String msg = ResManager.loadKDString((String)"\u201c\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u201d\u8bf7\u4e0e\u7d2f\u52a0\u5668\u7684\u201c\u5f00\u59cb\u6708/\u5f00\u59cb\u65e5/\u5f00\u59cb\u65e5\u671f\u201d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccResultImportNewPlugin_10", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                    isCheckPass = false;
                    processHandler.putRowError(entry.getKey(), msg);
                } else {
                    accResult.set("startdate", (Object)tempCal.getTime());
                    accResult.set("enddate", (Object)this.getEndDateValue(startDate, periodType));
                }
            } else {
                accResult.set("startdate", (Object)tempCal.getTime());
                accResult.set("enddate", (Object)this.getEndDateValue(tempCal.getTime(), periodType));
            }
        } else if (ISADJUST_YES.equals(periodType) || "5".equals(periodType) || "2".equals(periodType)) {
            tempCal.setTime(startDate);
            int startMonth = Integer.parseInt(accObj.getString("startmonth")) - 1;
            if (tempCal.get(2) != startMonth || tempCal.get(5) != startDay) {
                String msg = ResManager.loadKDString((String)"\u201c\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u201d\u8bf7\u4e0e\u7d2f\u52a0\u5668\u7684\u201c\u5f00\u59cb\u6708/\u5f00\u59cb\u65e5/\u5f00\u59cb\u65e5\u671f\u201d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccResultImportNewPlugin_10", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                isCheckPass = false;
                processHandler.putRowError(entry.getKey(), msg);
            } else {
                accResult.set("startdate", (Object)tempCal.getTime());
                accResult.set("enddate", (Object)this.getEndDateValue(tempCal.getTime(), periodType));
            }
        } else {
            tempCal.setTime(startDate);
            if (tempCal.get(5) != startDay) {
                String msg = ResManager.loadKDString((String)"\u201c\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u201d\u8bf7\u4e0e\u7d2f\u52a0\u5668\u7684\u201c\u5f00\u59cb\u6708/\u5f00\u59cb\u65e5/\u5f00\u59cb\u65e5\u671f\u201d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccResultImportNewPlugin_10", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                isCheckPass = false;
                processHandler.putRowError(entry.getKey(), msg);
            } else {
                accResult.set("startdate", (Object)tempCal.getTime());
                accResult.set("enddate", (Object)this.getEndDateValue(tempCal.getTime(), periodType));
            }
        }
        return isCheckPass;
    }

    private Date getEndDateValue(Date startDate, String periodType) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        if (ISADJUST_YES.equals(periodType)) {
            startCal.add(1, 1);
            startCal.add(6, -1);
            startCal.set(11, 23);
            startCal.set(12, 59);
            startCal.set(13, 59);
        } else if ("5".equals(periodType)) {
            startCal.add(2, 6);
            startCal.add(6, -1);
            startCal.set(11, 23);
            startCal.set(12, 59);
            startCal.set(13, 59);
        } else if ("2".equals(periodType)) {
            startCal.add(2, 3);
            startCal.add(6, -1);
            startCal.set(11, 23);
            startCal.set(12, 59);
            startCal.set(13, 59);
        } else if ("3".equals(periodType)) {
            startCal.add(2, 1);
            startCal.add(6, -1);
            startCal.set(11, 23);
            startCal.set(12, 59);
            startCal.set(13, 59);
        } else {
            startCal.set(2199, 11, 31, 23, 59, 59);
        }
        return startCal.getTime();
    }

    private Map<String, DynamicObject> getCurrencyData(Set<String> currencyNumberSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bd_currency");
        String fields = "id,number,amtprecision";
        QFilter filter = new QFilter("number", "in", currencyNumberSet);
        filter.and("enable", "=", (Object)ISADJUST_YES);
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return result.stream().collect(Collectors.toMap(obj -> obj.getString("number"), obj -> obj, (key1, key2) -> key1));
    }

    private Map<Integer, Map<Integer, String>> checkNullData(List<Map<Integer, String>> dataRow, Set<String> fileNumberSet) {
        HashMap<Integer, Map<Integer, String>> successRowMap = new HashMap<Integer, Map<Integer, String>>(16);
        Map<Integer, String> row = null;
        boolean isCheckPass = true;
        int size = dataRow.size();
        for (int index = 0; index < size; ++index) {
            String msg;
            row = dataRow.get(index);
            int excelRow = Integer.parseInt(row.get(EntryImportContext.EXCEL_ROW_NUMBER));
            isCheckPass = true;
            if (SWCStringUtils.isEmpty((String)row.get(0))) {
                msg = ResManager.loadKDString((String)"\u5de5\u53f7\u5fc5\u586b\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportNewPlugin_0", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                isCheckPass = false;
                this.processHandler.putRowError(Integer.valueOf(excelRow), msg);
            }
            if (SWCStringUtils.isEmpty((String)row.get(3))) {
                msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7d2f\u52a0\u5668\u7f16\u7801\u201d\u3002", (String)"AccResultImportNewPlugin_1", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                isCheckPass = false;
                this.processHandler.putRowError(Integer.valueOf(excelRow), msg);
            }
            if (SWCStringUtils.isEmpty((String)row.get(6))) {
                msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"AccResultImportNewPlugin_2", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                isCheckPass = false;
                this.processHandler.putRowError(Integer.valueOf(excelRow), msg);
            }
            if (SWCStringUtils.isEmpty((String)row.get(9))) {
                msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7d2f\u52a0\u7ed3\u679c\u503c\u201d\u3002", (String)"AccResultImportNewPlugin_3", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                isCheckPass = false;
                this.processHandler.putRowError(Integer.valueOf(excelRow), msg);
            }
            if (isCheckPass) {
                successRowMap.put(excelRow, row);
                if (!SWCStringUtils.isNotEmpty((String)row.get(1))) continue;
                fileNumberSet.add(row.get(1));
                continue;
            }
            this.processHandler.incrByProgress(0, 1);
        }
        return successRowMap;
    }
}

