/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator.accresultlist;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.accumulator.accresultdetail.AccResultDetailHelper;
import kd.swc.hsas.business.accumulator.accresultlist.AccResultListExportHelper;
import kd.swc.hsas.business.accumulator.accresultlist.dto.AccResultListExportDto;
import kd.swc.hsas.common.utils.TaskUtil;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AccResultListExportPlugin
extends AbstractListPlugin {
    protected static final Log logger = LogFactory.getLog(AccResultListExportPlugin.class);
    private static final String EXPORT = "donothing_exportdetail";
    private static final String ACC = "queryacc";
    private static final String START_DATE = "querystartdate";
    private static final String END_DATE = "queryenddate";
    public static final Integer PAGE_SIZE = 100;
    private static final String PROGRESS = "progress";
    private static final String COMPLETE = "complete";
    private static final String MODULE_NAME = "swc-hsas-formplugin";
    private static final String EXPORT_BILLNO_PREFIX = "EXPORT-";
    private static final String VIEW_EXPORT_RESULT = "donothing_viewexport";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (SWCStringUtils.equals((String)operateKey, (String)VIEW_EXPORT_RESULT)) {
            this.accResultExportDetails();
        }
    }

    private void accResultExportDetails() {
        ListShowParameter importDetailsShowParameter = new ListShowParameter();
        importDetailsShowParameter.setFormId("bos_list");
        importDetailsShowParameter.setBillFormId("bos_exportlog");
        importDetailsShowParameter.setCaption(ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c\u5bfc\u51fa\u7ed3\u679c", (String)"AccResultListExportPlugin_2", (String)MODULE_NAME, (Object[])new Object[0]));
        importDetailsShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String prefixName = ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c", (String)"AccResultListExportPlugin_4", (String)MODULE_NAME, (Object[])new Object[0]);
        QFilter filter = new QFilter("billno", "like", (Object)(EXPORT_BILLNO_PREFIX + prefixName + "%"));
        filter.and("creator", "=", (Object)RequestContext.get().getCurrUserId());
        ListFilterParameter filterParameter = new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{filter}), "createtime desc");
        importDetailsShowParameter.setListFilterParameter(filterParameter);
        this.getView().showForm((FormShowParameter)importDetailsShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess() && EXPORT.equals(opKey)) {
            this.doExport();
        }
    }

    public void afterExportFile(ExportFileEvent event) {
        File file;
        String preFix;
        String fileName = event.getFileName();
        if (SWCStringUtils.startsWithIgnoreCase((String)fileName, (String)(preFix = ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u7d2f\u52a0\u7ed3\u679c_", (String)"AccResultListExportPlugin_5", (String)MODULE_NAME, (Object[])new Object[0]))) && (file = event.getFile()) != null) {
            try (FileInputStream fis = new FileInputStream(file);
                 XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                 FileOutputStream out = new FileOutputStream(file);){
                Sheet sheet = wb.getSheetAt(0);
                sheet.autoSizeColumn(10);
                wb.write((OutputStream)out);
            }
            catch (Throwable ex) {
                logger.error(ex);
            }
        }
    }

    private void doExport() {
        BillList billListAp = new BillList();
        billListAp.setKey("billlistap");
        billListAp.setEntityId("hsas_accresult");
        ListView listView = (ListView)this.getView();
        billListAp.setBillFormId(listView.getBillFormId());
        billListAp.setView((IFormView)listView);
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        int size = selectedRows.size();
        long[] selectRows = new long[size];
        for (int index = 0; index < size; ++index) {
            selectRows[index] = (Long)selectedRows.get(index).getPrimaryKeyValue();
        }
        QFilter[] filters = this.getQueryFilters(selectRows);
        AccResultListExportHelper helper = new AccResultListExportHelper();
        Map headers = helper.getExportHeaders();
        AccResultListExportDto.Builder builder = new AccResultListExportDto.Builder();
        builder.setFilters(filters).setHeaders(headers);
        String downLoadTaskId = TaskUtil.getExportTaskID();
        SWCDataServiceHelper dataPrecisionHelper = new SWCDataServiceHelper("hsbs_dataprecision");
        DynamicObject[] allDataPrecisionArray = dataPrecisionHelper.query("id,scale", new QFilter[0]);
        HashMap<Long, Integer> scaleMap = new HashMap<Long, Integer>(allDataPrecisionArray.length);
        for (DynamicObject precisionObj : allDataPrecisionArray) {
            scaleMap.put(precisionObj.getLong("id"), precisionObj.getInt("scale"));
        }
        this.startExport(builder, downLoadTaskId, helper, scaleMap);
    }

    public void startExport(AccResultListExportDto.Builder builder, String downLoadTaskId, AccResultListExportHelper helper, Map<Long, Integer> scaleMap) {
        AccResultListExportDto dto = builder.build();
        QFilter[] filters = dto.getFilters();
        int totalElements = ORM.create().count("BusinessDataServiceHelper.load", "hsas_accresult", filters);
        int totalPages = (int)Math.ceil((double)totalElements * 1.0 / (double)PAGE_SIZE.intValue());
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        this.openExportProgressBar(totalElements, totalPages, countDownLatch, downLoadTaskId);
        Map headers = dto.getHeaders();
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_\u7d2f\u52a0\u7ed3\u679c\u7cfb\u7edf\u9ed8\u8ba4\u6a21\u677f_%s", (String)"AccResultListExportPlugin_1", (String)MODULE_NAME, (Object[])new Object[0]), date);
        RequestContext ctx = RequestContext.get();
        helper.mutiThreadExport(ctx, fileName, headers, totalPages, filters, countDownLatch, this.getView(), totalElements, downLoadTaskId, scaleMap);
    }

    private void openExportProgressBar(int totalCount, int totalPages, CountDownLatch countDownLatch, String downLoadTaskId) {
        String pageId = this.getView().getPageId();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_caltableexportprog");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("pageId", (Object)pageId);
        para.setCustomParam("totalCount", (Object)totalCount);
        para.setCustomParam("status", (Object)0);
        para.setCustomParam("downLoadTaskId", (Object)downLoadTaskId);
        para.setCustomParam("exportMsg", (Object)ResManager.loadKDString((String)"\u5171\u9009\u4e2d%s\u6761\u7d2f\u52a0\u7ed3\u679c", (String)"AccResultListExportPlugin_3", (String)MODULE_NAME, (Object[])new Object[0]));
        para.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"AccResultListExportPlugin_0", (String)MODULE_NAME, (Object[])new Object[0]));
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (totalPages <= 0) {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)100);
            para.setCustomParam(PROGRESS, (Object)100);
        } else {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) / (long)totalPages));
            pageCache.put(COMPLETE + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) * 100L));
        }
        pageCache.saveChanges();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "openExportProgressBar");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private QFilter[] getQueryFilters(long[] selectRows) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (selectRows != null && selectRows.length > 0) {
            QFilter selectFilter = new QFilter("id", "in", (Object)selectRows);
            return new QFilter[]{selectFilter};
        }
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection employeeList = data.getDynamicObjectCollection("employee");
        if (employeeList == null || employeeList.size() == 0) {
            QFilter qFilter = new QFilter("acc.id", "=", (Object)0L);
            qFilter.and("employee.id", "=", (Object)0L);
            qFilter.and("personindexid", "=", (Object)0L);
            return new QFilter[]{qFilter};
        }
        DynamicObjectCollection accColl = this.getModel().getDataEntity().getDynamicObjectCollection(ACC);
        if (accColl != null && accColl.size() > 0) {
            Set accIdSet = accColl.stream().map(obj -> obj.getLong("fbasedataid.id")).collect(Collectors.toSet());
            filterList.add(new QFilter("acc.id", "in", accIdSet));
        }
        QFilter dateFilter1 = null;
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(END_DATE);
        if (startDate != null && endDate != null) {
            endDate = SWCDateTimeUtils.getOffsetDate((Date)endDate, (int)1);
            dateFilter1 = new QFilter("startdate", ">=", (Object)startDate);
            dateFilter1.and("startdate", "<", (Object)endDate);
            QFilter dateFilter2 = new QFilter("enddate", ">=", (Object)startDate);
            dateFilter2.and("enddate", "<", (Object)endDate);
            QFilter dateFilter3 = new QFilter("startdate", "<=", (Object)startDate);
            dateFilter3.and("enddate", ">", (Object)endDate);
            dateFilter1 = dateFilter1.or(dateFilter2).or(dateFilter3);
        } else if (startDate != null && endDate == null) {
            dateFilter1 = new QFilter("enddate", ">=", (Object)startDate);
        } else if (startDate == null && endDate != null) {
            endDate = SWCDateTimeUtils.getOffsetDate((Date)endDate, (int)1);
            dateFilter1 = new QFilter("startdate", "<", (Object)endDate);
        }
        if (dateFilter1 != null) {
            filterList.add(dateFilter1);
        }
        Set employeeIdSet = employeeList.stream().map(obj -> obj.getLong("fbasedataid.id")).collect(Collectors.toSet());
        QFilter employeeFilter = new QFilter("employee.id", "in", employeeIdSet);
        AccResultDetailHelper detailHelper = new AccResultDetailHelper();
        Set personIndexIdSet = detailHelper.getPersonIndexIdSet(employeeIdSet);
        employeeFilter.and("personindexid", "in", (Object)personIndexIdSet);
        DynamicObjectCollection salayFileList = data.getDynamicObjectCollection("salaryfile");
        if (salayFileList != null && salayFileList.size() > 0) {
            Set fileIdSet = salayFileList.stream().map(obj -> obj.getLong("fbasedataid.id")).collect(Collectors.toSet());
            employeeFilter.and(new QFilter("salaryfile.id", "in", fileIdSet));
        }
        filterList.add(employeeFilter);
        QFilter[] retFilters = new QFilter[filterList.size()];
        filterList.toArray(retFilters);
        return retFilters;
    }
}

