/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator.accresultlist;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.formplugin.web.accumulator.accresultlist.AccResultImportAdjustDataPlugin;
import kd.swc.hsas.formplugin.web.accumulator.accresultlist.AccResultImportNewPlugin;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.common.constants.ImportConstants;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;
import kd.swc.hsbp.formplugin.imports.event.BeforeWriteTemplateEvent;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;
import kd.swc.hsbp.formplugin.imports.event.DownLoadTemplateEvent;
import kd.swc.hsbp.formplugin.imports.event.LoadCustomEntryMetasEvent;
import kd.swc.hsbp.formplugin.imports.event.OnGetImportConfigEvent;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AccResultListImportPlugin
extends SWCDataBaseEdit
implements IDataPort {
    private static Log log = LogFactory.getLog(AccResultListImportPlugin.class);
    private static final int MAXROWCOUNT = 5000;
    private static final String IMPORT_DATA = "donothing_importdata";
    private static final String IMPORT_BILLNO_PREFIX = "IMPORT_ACCRESULT_";
    private static final String IMPORTTYPE_NEW = "new";
    private static final String VIEW_IMPORT_RESULT = "donothing_importdetails";
    private static final List<String> IGNORECOLUMN_KEY_LIST = Arrays.asList("dimension1", "dimension2", "dimension3", "dimension4", "dimension5", "adjustamount", "adjustreason");

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (SWCStringUtils.equals((String)operateKey, (String)IMPORT_DATA)) {
            FormShowParameter importShowParameter = new FormShowParameter();
            importShowParameter.setCustomParam("entityid", (Object)this.getView().getEntityId());
            importShowParameter.setFormId("hsas_accresultimport");
            importShowParameter.setCustomParam("showImportType", (Object)"new,override");
            importShowParameter.setCustomParam("hideImportType", (Object)"radiofield2");
            importShowParameter.setCustomParam("entrykey", (Object)"entryentity");
            importShowParameter.setCustomParam("entryview", (Object)this.getView().getPageId());
            importShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ImportStartCloseCallBack"));
            importShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            importShowParameter.setCaption(ResManager.loadKDString((String)"\u5c06\u6570\u636e\u5bfc\u5165\u5230\u7d2f\u52a0\u5668", (String)"AccResultListImportPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().showForm(importShowParameter);
        }
    }

    public void onGetImportConfig(OnGetImportConfigEvent evt) {
        ImportConfig config = new ImportConfig();
        config.setImportType(ImportConfig.ImportType.Complete);
        config.setMaxRowCount(5000);
        StringBuilder templateFirstName = new StringBuilder();
        templateFirstName.append(ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c", (String)"AccResultListImportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        templateFirstName.append(" # hsas_accresult");
        config.setTemplateCaption(templateFirstName.toString());
        String modelName = ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c\u8c03\u6574", (String)"AccResultListImportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        config.setModelName(modelName);
        LocalDate now = LocalDate.now();
        String str = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_\u7d2f\u52a0\u7ed3\u679c\u8c03\u6574\u6570\u636e\u6a21\u677f_", (String)"AccResultListImportPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        config.setTemplateFileName(str + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth()));
        StringBuilder templateWarningInfo = new StringBuilder();
        templateWarningInfo.append(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"AccResultListImportPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append('\n');
        templateWarningInfo.append(ResManager.loadKDString((String)"2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"AccResultListImportPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append('\n');
        templateWarningInfo.append(ResManager.loadKDString((String)"#SetNULL\uff08\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\uff09", (String)"AccResultListImportPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append('\n');
        templateWarningInfo.append(ResManager.loadKDString((String)"3\u3001\u6863\u6848\u7f16\u53f7\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5fc5\u586b", (String)"AccResultListImportPlugin_23", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append('\n');
        templateWarningInfo.append(ResManager.loadKDString((String)"4\u3001\u7d2f\u52a0\u5b50\u7ef4\u5ea6\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5fc5\u586b", (String)"AccResultListImportPlugin_24", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        config.setTemplateWarningInfo(templateWarningInfo.toString());
        evt.setImportConfig(config);
    }

    public void onValidateTemplate(DataImportEvent evt) {
        AbstractFormPlugin source = (AbstractFormPlugin)evt.getSource();
        String importType = (String)source.getView().getModel().getValue("importtype");
        List dataHead = evt.getDataHead();
        List dataRow = evt.getDataRow();
        List<Map<String, Object>> columns = this.geEntryColumns(this.getView());
        HashSet<String> ignoreColumns = new HashSet<String>(16);
        if (IMPORTTYPE_NEW.equals(importType)) {
            ignoreColumns.addAll(IGNORECOLUMN_KEY_LIST);
        }
        List<EntryColumnContainer> containers = this.getEntryColumnContainers(columns, ignoreColumns);
        int headHeight = SWCExportEntryHelper.calcSheetHeadHeight(containers);
        List<Map<Integer, String>> dataHeadSource = this.getSourceHeadData(containers, headHeight);
        ValidateResults validateResult = new ValidateResults(ErrorLevel.Error);
        if (!this.isEqualCollection(dataHeadSource, dataHead)) {
            validateResult.failed();
            source.getView().showErrorNotification(ImportConstants.IMPORT_TEMPLATE_ERROR());
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\u3002", "AccResultListImportPlugin_8", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)IMPORT_DATA, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            evt.setValidateResults(validateResult);
            return;
        }
        List<Map<Integer, String>> copyList = this.copyList(dataRow);
        if (copyList == null || copyList.size() == 0) {
            validateResult.failed();
            source.getView().showMessage(ImportConstants.PARSED_INVALID_DATA(), ImportConstants.LOGGING_DATA(), MessageTypes.Default);
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", "AccResultListImportPlugin_9", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)IMPORT_DATA, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            evt.setValidateResults(validateResult);
            return;
        }
        MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f", "AccResultListImportPlugin_10", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)IMPORT_DATA, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
        evt.setValidateResults(validateResult);
    }

    public void dataImport(DataImportEvent evt) {
        String importType = evt.getImportContext().getImportType();
        List dataRow = evt.getDataRow();
        ProgressHandler processHandler = evt.getProcessHandler();
        if (IMPORTTYPE_NEW.equals(importType)) {
            AccResultImportNewPlugin importNewPlugin = new AccResultImportNewPlugin(processHandler);
            importNewPlugin.dataImport(dataRow);
        } else {
            AccResultImportAdjustDataPlugin importAdjustDataPlugin = new AccResultImportAdjustDataPlugin(processHandler);
            importAdjustDataPlugin.dataImport(dataRow);
        }
    }

    public void afterImport(DataImportEvent evt) {
        ProgressHandler processHandler = evt.getProcessHandler();
        String srcFile = evt.getFilePath();
        this.writeImportLog(processHandler.getTotal(), processHandler.getFailedRow(), this.getImportData(processHandler.getErrorLogFile(), processHandler.getFailedRow(), processHandler.getTotal(), srcFile));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (SWCStringUtils.equals((String)operateKey, (String)VIEW_IMPORT_RESULT)) {
            this.accResultImportDetails();
        }
    }

    private String getImportData(String failPath, int failed, int total, String srcFile) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("delRows", new ArrayList(1));
        dataObj.put("errFile", (Object)failPath);
        dataObj.put("failed", (Object)failed);
        dataObj.put("lastRowIndex", (Object)total);
        dataObj.put("logCache", new HashMap(1));
        dataObj.put("rowIndex", (Object)0);
        dataObj.put("srcFile", (Object)srcFile);
        dataObj.put("total", (Object)total);
        JSONObject pathObj = new JSONObject();
        pathObj.put(srcFile, (Object)dataObj);
        JSONObject retObj = new JSONObject();
        retObj.put("complete", (Object)Boolean.TRUE);
        retObj.put("info", (Object)pathObj);
        return retObj.toJSONString();
    }

    private void accResultImportDetails() {
        ListShowParameter importDetailsShowParameter = new ListShowParameter();
        importDetailsShowParameter.setFormId("bos_list");
        importDetailsShowParameter.setBillFormId("bos_importlog");
        importDetailsShowParameter.setCaption(ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c\u5bfc\u5165\u7ed3\u679c", (String)"AccResultListImportPlugin_21", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        importDetailsShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter filter = new QFilter("billno", "like", (Object)"IMPORT_ACCRESULT_%");
        filter.and("creator", "=", (Object)RequestContext.get().getCurrUserId());
        ListFilterParameter filterParameter = new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{filter}), "createtime desc");
        importDetailsShowParameter.setListFilterParameter(filterParameter);
        this.getView().showForm((FormShowParameter)importDetailsShowParameter);
    }

    private void writeImportLog(int total, int fail, String dataStr) {
        String billNo = IMPORT_BILLNO_PREFIX + this.getView().getPageId();
        String name = ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c\u6279\u91cf\u5bfc\u5165\u8be6\u60c5", (String)"AccResultListImportPlugin_20", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        Object pkId = ImportLogHelper.create((String)billNo, (String)name);
        ImportLogHelper.logAll((Object)pkId, (String)dataStr, (int)total, (int)fail);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().updateView();
    }

    public void loadCustomEntryMetas(LoadCustomEntryMetasEvent evt) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getView(), (String)"entryentity");
        AbstractFormPlugin importPlugin = (AbstractFormPlugin)evt.getSource();
        String importType = (String)importPlugin.getView().getModel().getValue("importtype");
        if (IMPORTTYPE_NEW.equals(importType)) {
            wrapper.setContainers(this.filterContainers(wrapper.getContainers()));
        }
        evt.setEntryColumnWrapper(wrapper);
    }

    private List<EntryColumnContainer> filterContainers(List<EntryColumnContainer> containers) {
        if (containers == null) {
            return containers;
        }
        ArrayList<EntryColumnContainer> list = new ArrayList<EntryColumnContainer>(containers.size());
        HashSet<String> ignoreSet = new HashSet<String>(IGNORECOLUMN_KEY_LIST.size());
        for (String ignoreStr : IGNORECOLUMN_KEY_LIST) {
            ignoreSet.add(ignoreStr);
        }
        for (EntryColumnContainer entry : containers) {
            if (ignoreSet.contains(entry.getKey())) continue;
            list.add(entry);
        }
        return list;
    }

    public void beforeWriteTemplate(BeforeWriteTemplateEvent evt) {
        AbstractFormPlugin importPlugin = (AbstractFormPlugin)evt.getSource();
        String importType = (String)importPlugin.getView().getModel().getValue("importtype");
        if (IMPORTTYPE_NEW.equals(importType)) {
            evt.setDynamicObjectCollection(new DynamicObjectCollection());
        }
    }

    public void beforeDownLoadTemplate(DownLoadTemplateEvent evt) {
        AbstractFormPlugin importPlugin = (AbstractFormPlugin)evt.getSource();
        String importType = (String)importPlugin.getView().getModel().getValue("importtype");
        if (IMPORTTYPE_NEW.equals(importType)) {
            EntityType entityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get("entryentity");
            SXSSFWorkbook wb = evt.getWb();
            SXSSFSheet sheet = wb.getSheet(entityType.getDisplayName().getLocaleValue());
            this.setWarningRow(wb, sheet);
            SXSSFRow titleRow = sheet.getRow(3);
            this.setNoMustCellTitle(titleRow, 5, wb);
            this.setMustCellTitle(titleRow, 6, wb);
            this.setMustCellTitle(titleRow, 9, wb);
        }
    }

    public void getTemplateFileName(OnGetImportConfigEvent evt) {
        AbstractFormPlugin importPlugin = (AbstractFormPlugin)evt.getSource();
        String importType = (String)importPlugin.getView().getModel().getValue("importtype");
        if (IMPORTTYPE_NEW.equals(importType)) {
            ImportConfig config = new ImportConfig();
            config.setTemplateFileName("");
            LocalDate now = LocalDate.now();
            String str = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_\u7d2f\u52a0\u7ed3\u679c\u521d\u59cb\u5316\u6570\u636e\u6a21\u677f_", (String)"AccResultListImportPlugin_26", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            config.setTemplateFileName(str + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth()));
            evt.setImportConfig(config);
        }
    }

    private void setMustCellTitle(SXSSFRow titleRow, int cellIndex, SXSSFWorkbook wb) {
        SXSSFCell cell = titleRow.getCell(cellIndex);
        String value = cell.getStringCellValue();
        value = "*" + value;
        cell.setCellValue(value);
        CellStyle style = cell.getCellStyle();
        Font requriedFont = wb.createFont();
        requriedFont.setColor((short)10);
        style.setFont(requriedFont);
    }

    private void setNoMustCellTitle(SXSSFRow titleRow, int cellIndex, SXSSFWorkbook wb) {
        SXSSFCell cell = titleRow.getCell(cellIndex);
        String value = cell.getStringCellValue();
        value = value.substring(1, value.length());
        cell.setCellValue(value);
        CellStyle style = cell.getCellStyle();
        Font font = wb.createFont();
        font.setColor((short)Short.MAX_VALUE);
        style.setFont(font);
    }

    private void setWarningRow(SXSSFWorkbook wb, SXSSFSheet sheet) {
        SXSSFRow warningRow = sheet.getRow(1);
        SXSSFCell warningCell = warningRow.getCell(0);
        StringBuilder templateWarningInfo = new StringBuilder();
        templateWarningInfo.append(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"AccResultListImportPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append('\n');
        templateWarningInfo.append(ResManager.loadKDString((String)"2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"AccResultListImportPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append('\n');
        templateWarningInfo.append(ResManager.loadKDString((String)"#SetNULL\uff08\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\uff09", (String)"AccResultListImportPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append('\n');
        templateWarningInfo.append(ResManager.loadKDString((String)"3\u3001\u6863\u6848\u7f16\u53f7\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5fc5\u586b", (String)"AccResultListImportPlugin_23", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append('\n');
        templateWarningInfo.append(ResManager.loadKDString((String)"4\u3001\u7d2f\u52a0\u7ed3\u679c\u503c\u6570\u636e\u5c0f\u6570\u4f4d\u6570\u5c06\u6309\u7d2f\u52a0\u5668\u7684\u5e01\u79cd\u7cbe\u5ea6\u6216\u6570\u636e\u7cbe\u5ea6\u8fdb\u884c\u5904\u7406", (String)"AccResultListImportPlugin_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        warningCell.setCellValue(templateWarningInfo.toString());
        CellStyle warningStyle = wb.createCellStyle();
        warningCell.setCellStyle(warningStyle);
        Font font = wb.createFont();
        warningStyle.setFont(font);
        font.setColor((short)10);
    }

    public List<Map<String, Object>> geEntryColumns(IFormView entryView) {
        Map map = SWCExportEntryHelper.invokeLoadCustomControlMetas((IFormView)entryView);
        return SWCExportEntryHelper.getEntryColumnsFromMeta((Map)((Map)map.get("metas")), (String)"entryentity");
    }

    private List<EntryColumnContainer> getEntryColumnContainers(List<Map<String, Object>> columns, Set<String> ignoreSet) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.convertToEntryColumnInfo(columns);
        List containers = wrapper.getContainers();
        SWCExportEntryHelper.removeIgnoreColumn((List)containers, ignoreSet);
        return containers;
    }

    private List<Map<Integer, String>> getSourceHeadData(List<EntryColumnContainer> containers, int headHeight) {
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions(containers);
        Map<Integer, String> entryColId = this.getEntryFiledId(captions);
        String[][] headArray = new String[headHeight][captions.size()];
        SWCExportEntryHelper.fillSheetHeadArray(containers, (String[][])headArray, (int)0, (int)0);
        List<Map<Integer, String>> headList = this.getEntryHeadStructs(headArray);
        ArrayList dataHeadSource = Lists.newArrayListWithCapacity((int)(headHeight + 1));
        dataHeadSource.add(entryColId);
        dataHeadSource.addAll(headList);
        return dataHeadSource;
    }

    private Map<Integer, String> getEntryFiledId(Map<String, KeyValue> captions) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(16);
        int index = 0;
        for (String key : captions.keySet()) {
            result.put(index, key);
            ++index;
        }
        return result;
    }

    public List<Map<Integer, String>> getEntryHeadStructs(String[][] strArray) {
        ArrayList<Map<Integer, String>> resultList = new ArrayList<Map<Integer, String>>(strArray.length);
        for (int i = 0; i < strArray.length; ++i) {
            HashMap<Integer, String> map = new HashMap<Integer, String>(strArray[i].length);
            for (int j = 0; j < strArray[i].length; ++j) {
                if (null == strArray[i][j]) continue;
                map.put(j, strArray[i][j]);
            }
            resultList.add(map);
        }
        return resultList;
    }

    public boolean isEqualCollection(List<Map<Integer, String>> beCompareList, List<Map<Integer, String>> compareList) {
        if (null == beCompareList || null == compareList || beCompareList.size() != compareList.size()) {
            return false;
        }
        for (int i = 0; i < beCompareList.size(); ++i) {
            if (this.chekMapEqual(beCompareList.get(i), compareList.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean chekMapEqual(Map<Integer, String> map, Map<Integer, String> beCompareMap) {
        if (map.size() != beCompareMap.size()) {
            return false;
        }
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            String m2value;
            String m1value = entry.getValue() == null ? "" : entry.getValue();
            if (m1value.equals(m2value = beCompareMap.get(entry.getKey()) == null ? "" : beCompareMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private List<Map<Integer, String>> copyList(List<Map<Integer, String>> dataRows) {
        ArrayList<Map<Integer, String>> deepCopyList = new ArrayList<Map<Integer, String>>(dataRows.size());
        for (Map<Integer, String> dataRow : dataRows) {
            try {
                Map newInstance = (Map)dataRow.getClass().newInstance();
                newInstance.putAll(dataRow);
                deepCopyList.add(newInstance);
            }
            catch (InstantiationException e) {
                log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Throwable)e);
            }
        }
        return deepCopyList;
    }
}

