/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.agencypay;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Label;
import kd.bos.form.control.QRCode;
import kd.bos.form.events.AfterDoOperationEventArgs;

public class AgencyPaySummaryEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.updateSummary();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "audit": 
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.updateSummary();
                break;
            }
        }
    }

    private void updateSummary() {
        IDataModel model = this.getModel();
        Object summaryName = model.getValue("billname");
        Object summaryBillNo = model.getValue("billno");
        DynamicObject summaryOrg = (DynamicObject)model.getValue("org");
        DynamicObject summaryCreator = (DynamicObject)model.getValue("creator");
        Object summaryCreatetime = model.getValue("createtime");
        model.beginInit();
        QRCode qrCode = (QRCode)this.getControl("qrcodeap");
        qrCode.setUrl((String)summaryBillNo);
        model.setValue("summarybillno", summaryBillNo);
        model.setValue("summaryname", summaryName);
        model.setValue("summarycreatetime", summaryCreatetime);
        model.endInit();
        Label labelOrg = (Label)this.getControl("summaryorg");
        labelOrg.setText(summaryOrg == null ? "-" : summaryOrg.getString("name"));
        Label labelCreator = (Label)this.getControl("summarycreator");
        labelCreator.setText(summaryCreator == null ? "-" : summaryCreator.getString("name"));
        this.getView().updateView("headpanelview");
        model.setDataChanged(false);
    }
}

