/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.approve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.approve.ApproveSettingHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import org.apache.commons.lang.StringUtils;

public class ApprovePayDetailPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Search treeColumnSearch = (Search)this.getView().getControl("treesearchap");
        treeColumnSearch.addEnterListener((SearchEnterListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btn_field_add", "selectallbtn"});
        this.addClickListeners(new String[]{"btn_field_remove"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.init();
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.buildSelectValueTree();
    }

    private void buildSelectValueTree() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        this.buildPayDetailTreeNodes(treeView);
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        IFormView view = this.getView();
        switch (key) {
            case "btn_field_add": {
                ApproveSettingHelper.addPayDetailColumn((IFormView)view, (TreeView)treeView, (String)"entryentity");
                break;
            }
            case "btnok": {
                this.saveSelect();
                break;
            }
            case "selectallbtn": {
                this.selectAllTree();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "selectall": {
                this.selectAll();
                break;
            }
        }
    }

    private void selectAll() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        String entryClickNum = this.getPageCache().get("treeClickNum");
        if (StringUtils.isEmpty((String)entryClickNum)) {
            int i;
            this.getPageCache().put("treeClickNum", "1");
            int[] rowIndexArr = new int[entryEntity.size()];
            for (i = 0; i < entryEntity.size(); ++i) {
                rowIndexArr[i] = i;
            }
            for (i = 0; i < entryEntity.size(); ++i) {
                entryGrid.selectRows(rowIndexArr, i);
            }
        } else {
            this.getPageCache().put("treeClickNum", null);
            entryGrid.selectRows(new int[0], -1);
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        Search search = (Search)searchEnterEvent.getSource();
        String key = search.getKey();
        if ("treesearchap".equals(key)) {
            ApproveSettingHelper.searchTreeNode((String)searchText, (IFormView)this.getView(), (boolean)true);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
    }

    private void init() {
        String payDetailStr = this.getView().getParentView().getModel().getDataEntity().getString("paydetail");
        if (StringUtils.isEmpty((String)payDetailStr)) {
            return;
        }
        String[] payDetailArr = payDetailStr.split(",");
        TableValueSetter entrySetter = new TableValueSetter(new String[0]);
        entrySetter.addField("fieldname", new Object[0]);
        for (String payDetail : payDetailArr) {
            entrySetter.addRow(new Object[]{payDetail});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", entrySetter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void buildPayDetailTreeNodes(TreeView treeView) {
        ArrayList<String> fieldSelectList = new ArrayList<String>(10);
        String payDetailStr = this.getView().getParentView().getModel().getDataEntity().getString("paydetail");
        if (StringUtils.isNotEmpty((String)payDetailStr)) {
            String[] fieldArr = payDetailStr.split(",");
            fieldSelectList.addAll(Arrays.asList(fieldArr));
        }
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        treeNodes.addAll(this.assemblePayDetailTreeNodeText(fieldSelectList));
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map<String, TreeNode> treeNodeMap = treeNodes.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity(), (entity1, entity2) -> entity2));
        pageCache.put("tree", (Object)SerializationUtils.serializeToBase64(treeNodeMap));
        List<TreeNode> rootNodes = this.buildTreeHierarchy(treeNodes, treeNodeMap);
        treeView.addNodes(rootNodes);
        pageCache.put("rootnode", (Object)SerializationUtils.serializeToBase64(rootNodes));
    }

    private List<TreeNode> assemblePayDetailTreeNodeText(List<String> fieldSelectList) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        int index = 0;
        Map payDetailFieldMap = ApproveSettingHelper.getPayDetailFieldMap();
        for (Map.Entry entry : payDetailFieldMap.entrySet()) {
            if (fieldSelectList.contains(entry.getKey())) continue;
            TreeNode node = new TreeNode("hsas_paydetail", "A000" + ++index, (String)entry.getValue(), entry.getKey());
            treeNodes.add(node);
        }
        return treeNodes;
    }

    private List<TreeNode> buildTreeHierarchy(List<TreeNode> treeNodes, Map<String, TreeNode> nodeMap) {
        ArrayList<TreeNode> rootNodes = new ArrayList<TreeNode>(10);
        TreeNode rootNode = new TreeNode();
        rootNode.setIsOpened(true);
        treeNodes.forEach(treeNode -> {
            TreeNode parentNode = (TreeNode)nodeMap.get(treeNode.getParentid());
            if (parentNode == null) {
                treeNode.setParentid("");
                rootNodes.add((TreeNode)treeNode);
            } else {
                parentNode.addChild(treeNode);
            }
        });
        return rootNodes;
    }

    private void saveSelect() {
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5b57\u6bb5\u5fc5\u987b\u5305\u542b\u59d3\u540d\uff0c\u8bf7\u5b8c\u6210\u52fe\u9009\u3002", (String)"CalApproveBillTplTips_49", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        StringJoiner payDetailStr = new StringJoiner(",");
        ArrayList<String> payDetails = new ArrayList<String>(10);
        for (DynamicObject fieldNameDy : entryEntity) {
            String fieldName = fieldNameDy.getString("fieldname");
            if (!StringUtils.isNotEmpty((String)fieldName)) continue;
            payDetailStr.add(fieldName);
            payDetails.add(fieldName);
        }
        String payDetail = payDetailStr.toString();
        String name = ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalApproveBillTplEdit_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        if (!payDetails.contains(name)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5b57\u6bb5\u5fc5\u987b\u5305\u542b\u59d3\u540d\uff0c\u8bf7\u5b8c\u6210\u52fe\u9009\u3002", (String)"CalApproveBillTplTips_49", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> returnMap = new HashMap<String, String>(16);
        returnMap.put("data", payDetail);
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    private void selectAllTree() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String treeNodes = (String)pageCache.get("tree", String.class);
        if (StringUtils.isEmpty((String)treeNodes)) {
            return;
        }
        Map treeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)treeNodes);
        Collection nodeValues = treeNodeMap.values();
        Set nodeKeys = treeNodeMap.keySet();
        String treeClickNum = this.getPageCache().get("treeClickNum");
        if (StringUtils.isEmpty((String)treeClickNum)) {
            this.getPageCache().put("treeClickNum", "1");
            treeView.checkNodes(new ArrayList(nodeValues));
        } else {
            this.getPageCache().put("treeClickNum", null);
            treeView.uncheckNodes(new ArrayList(nodeKeys));
        }
    }
}

