/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.approve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.swc.hsas.business.approve.ApproveSettingHelper;
import kd.swc.hsas.business.approve.ApproveSettingService;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class ApproveSelectValuePlugin
extends SWCDataBaseEdit
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    private static final String SELECTNAME = "selectName";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Search treeColumnSearch = (Search)this.getView().getControl("treesearchap");
        treeColumnSearch.addEnterListener((SearchEnterListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.buildSelectValueTree();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "saveselect": {
                this.getView().returnDataToParent((Object)this.getSelectName());
                this.getView().close();
                break;
            }
        }
    }

    private String getSelectName() {
        return this.getView().getPageCache().get(SELECTNAME);
    }

    private void setSelectName(String selectName) {
        this.getView().getPageCache().put(SELECTNAME, selectName);
    }

    private void buildSelectValueTree() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        this.buildApproveTreeNodes(treeView);
        this.getModel().setDataChanged(false);
    }

    private void buildApproveTreeNodes(TreeView treeView) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        treeNodes.addAll(this.assembleSalaryItemTreeNodeText());
        treeNodes.addAll(this.assemblePersonTreeNodeText());
        treeNodes.addAll(this.assembleSalaryFileTreeNodeText());
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map<String, TreeNode> treeNodeMap = treeNodes.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity(), (entity1, entity2) -> entity2));
        pageCache.put("tree", (Object)SerializationUtils.serializeToBase64(treeNodeMap));
        List<TreeNode> rootNodes = this.buildTreeHierarchy(treeNodes, treeNodeMap);
        treeView.addNodes(rootNodes);
        pageCache.put("rootnode", (Object)SerializationUtils.serializeToBase64(rootNodes));
    }

    private List<TreeNode> assembleSalaryItemTreeNodeText() {
        Long orgId = (Long)ObjectConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("orgId"), Long.class, (boolean)false);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        HashMap<Long, List> salaryItemTreeNodeMap = new HashMap<Long, List>(16);
        HashMap<Long, String> salaryItemTypeMap = new HashMap<Long, String>(16);
        DataSet salaryItem = ApproveSettingService.getSalaryItem((Long)orgId);
        for (Row row : salaryItem) {
            Long salaryItemTypeId2 = row.getLong("salaryitemtypeid");
            salaryItemTypeMap.put(salaryItemTypeId2, row.getString("salaryitemtypename"));
            ArrayList<TreeNode> leafTreeNodes2 = (ArrayList<TreeNode>)salaryItemTreeNodeMap.get(salaryItemTypeId2);
            TreeNode leafNode = null;
            if (leafTreeNodes2 == null) {
                leafTreeNodes2 = new ArrayList<TreeNode>(10);
                salaryItemTreeNodeMap.put(salaryItemTypeId2, leafTreeNodes2);
            }
            leafNode = new TreeNode("type_" + salaryItemTypeId2, "A" + row.getLong("id"), row.getString("name"), (Object)row.getString("datatype.storagetype"));
            leafNode.setLeaf(true);
            leafTreeNodes2.add(leafNode);
        }
        salaryItemTreeNodeMap.forEach((salaryItemTypeId, leafTreeNodes) -> {
            String salaryItemTypeName = (String)salaryItemTypeMap.get(salaryItemTypeId);
            TreeNode secondaryTreeNode = new TreeNode("hsbs_salaryitem", "type_" + salaryItemTypeId, salaryItemTypeName);
            treeNodes.add(secondaryTreeNode);
            treeNodes.addAll((Collection<TreeNode>)leafTreeNodes);
        });
        String salaryItemColumnRes = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"ApproveSettingPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        TreeNode salaryItemNode = new TreeNode("", "hsbs_salaryitem", salaryItemColumnRes);
        treeNodes.add(salaryItemNode);
        return treeNodes;
    }

    private List<TreeNode> assemblePersonTreeNodeText() {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        String salaryItemColumnRes = ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458", (String)"CalApproveBillTplEdit_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        TreeNode personNode = new TreeNode("", "hsas_person", salaryItemColumnRes);
        treeNodes.add(personNode);
        TreeNode node1 = new TreeNode("hsas_person", "A001", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalApproveBillTplEdit_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (Object)"text");
        TreeNode node2 = new TreeNode("hsas_person", "A002", ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalApproveBillTplEdit_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (Object)"text");
        treeNodes.add(node1);
        treeNodes.add(node2);
        return treeNodes;
    }

    private List<TreeNode> assembleSalaryFileTreeNodeText() {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        String salaryItemColumnRes = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848", (String)"ApproveSettingPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        TreeNode personNode = new TreeNode("", "hsbs_salarymfile", salaryItemColumnRes);
        treeNodes.add(personNode);
        TreeNode node1 = new TreeNode("hsbs_salarymfile", "A0001", ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"CalApproveBillTplEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (Object)"text");
        treeNodes.add(node1);
        return treeNodes;
    }

    private List<TreeNode> buildTreeHierarchy(List<TreeNode> treeNodes, Map<String, TreeNode> nodeMap) {
        ArrayList<TreeNode> rootNodes = new ArrayList<TreeNode>(10);
        TreeNode rootNode = new TreeNode();
        rootNode.setIsOpened(true);
        treeNodes.forEach(treeNode -> {
            TreeNode parentNode = (TreeNode)nodeMap.get(treeNode.getParentid());
            if (parentNode == null) {
                treeNode.setParentid("");
                rootNodes.add((TreeNode)treeNode);
            } else {
                parentNode.addChild(treeNode);
            }
        });
        return rootNodes;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        String allTreeNodeStr = (String)swcPageCache.get("tree", String.class);
        Map nodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)allTreeNodeStr);
        if (nodeMap != null && !nodeMap.isEmpty()) {
            TreeNode node = (TreeNode)nodeMap.get(nodeId);
            if ('A' == nodeId.charAt(0)) {
                this.setSelectName(node.getText());
            } else {
                this.setSelectName("");
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        Search search = (Search)searchEnterEvent.getSource();
        String key = search.getKey();
        if ("treesearchap".equals(key)) {
            ApproveSettingHelper.searchTreeNode((String)searchText, (IFormView)this.getView(), (boolean)true);
        }
    }
}

