/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.approve;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.QRCode;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsas.common.dto.ApproveBillAccountDTO;
import kd.swc.hsas.common.dto.ApproveBillSalaryItemDTO;
import kd.swc.hsas.common.dto.CalPersonDTO;
import kd.swc.hsas.common.enums.ApproveBillOperationEnum;
import kd.swc.hsas.common.enums.HSASErrInfoEnum;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class CalApproveBillEdit
extends AbstractBillPlugIn {
    protected static final Log logger = LogFactory.getLog(CalApproveBillEdit.class);
    protected static final String KEY_ENTRYENTITY = "entryentity";
    private static final String CHANGETPL = "changetpl";
    private static final String DELETE_DATA_CALLBACK = "delete_data_callback";

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
        String isFirstIn = this.getView().getPageCache().get("isFirstIn");
        if (StringUtils.isEmpty((CharSequence)isFirstIn)) {
            this.getView().getPageCache().put("isFirstIn", "true");
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            String msgId = (String)this.getView().getViewNoPlugin(parentPageId).getFormShowParameter().getCustomParam("msgId");
            this.getView().getPageCache().put("wfMessageId", msgId);
            this.isAbandonedStatus();
            this.showUnfoldFlex();
            if (!this.loadOverView()) {
                return;
            }
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            this.billResultChangeCannotView(billStatus);
            this.cacheItemInfo();
            this.loadSummary();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("operakey", (Object)opKey);
        boolean idConfirm = Boolean.parseBoolean(formOperate.getOption().getVariableValue("confirm", String.valueOf(false)));
        if (!idConfirm && ("save".equals(opKey) || "submit".equals(opKey))) {
            List<Long> successList;
            Map map = (Map)pageCache.get("entryCalTableIds", Map.class);
            if (map != null && map.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalApproveBillEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("save".equals(opKey)) {
                args.setCancel(true);
            }
            if (CollectionUtils.isEmpty(successList = this.initEntryEntity(map))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalApproveBillEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                this.checkIsNeedShowConfirm();
                this.updateSummary();
                this.loadSummary();
                this.loadOverView();
                return;
            }
            this.updateDeleteCalTableCache(pageCache, successList);
            this.invokeSaveOperation(opKey);
        }
        switch (opKey) {
            case "refreshoverview": {
                this.loadOverView();
                break;
            }
            case "changetpl": {
                this.changeTplConfirm();
                break;
            }
            case "unsubmit": {
                String billStatus = this.getModel().getDataEntity().getString("billstatus");
                if ("B".equals(billStatus)) {
                    return;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"CalApproveBillEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "modify": {
                long approveBillId = this.getModel().getDataEntity().getLong("id");
                ArrayList<Long> approveBillIds = new ArrayList<Long>(10);
                approveBillIds.add(approveBillId);
                Map approveBillGrpPermMaps = HSASCalApproveBillHelper.validateGrpPerm((String)ApproveBillOperationEnum.MODIFY.getPermItemId(), approveBillIds);
                if (approveBillGrpPermMaps == null) {
                    return;
                }
                if (((Boolean)approveBillGrpPermMaps.get(approveBillId)).booleanValue()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u4ec5\u6709\u5ba1\u6279\u5355\u7684\u90e8\u5206\u6570\u636e\u6743\u9650\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"CalApproveBillEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        HSASCalApproveBillHelper helper = new HSASCalApproveBillHelper();
        String operateKey = args.getOperateKey();
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("operakey", (Object)operateKey);
        switch (operateKey) {
            case "modify": {
                this.checkIsNeedHideInfo(operationResult);
                break;
            }
            case "submit": {
                this.showSubmitBillResult(operationResult, helper);
                this.removePageCache(operationResult);
                break;
            }
            case "unsubmit": {
                this.showUnsubmitResult(operationResult, helper);
                break;
            }
            case "save": {
                this.checkIsNeedUpdateSummary(args, operationResult);
                this.checkIsNeedShowConfirm();
                this.removePageCache(operationResult);
                this.getPageCache().remove("currentIndex");
                this.loadSummary();
                this.loadOverView();
                break;
            }
        }
        this.updateCalPayRollTaskStatus(operateKey);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "changetpl": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.changeTpl();
                break;
            }
            case "delete_data_callback": {
                if (!MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actId;
        super.closedCallBack(event);
        switch (actId = event.getActionId()) {
            case "changeTplClose": {
                Map returnData = (Map)event.getReturnData();
                if (MapUtils.isEmpty((Map)returnData)) {
                    return;
                }
                Long approveBillTplHisId = (Long)returnData.get("approveBillTplHisId");
                if (null == approveBillTplHisId) {
                    return;
                }
                this.getModel().setValue("approvebilltplv", (Object)approveBillTplHisId);
                this.getModel().setValue("approvebilltpl", returnData.get("approveBillTplId"));
                this.getView().updateView("approvebilltplv");
                this.getView().getPageCache().remove("entryPayDetailIds");
                this.getView().getPageCache().put("changeTpl", "changeTpl");
                this.getView().getPageCache().remove("currentIndex");
                IAppCache appCache = AppCache.get((String)this.getView().getPageId());
                appCache.remove("deleteCalTableIds");
                appCache.remove("saveFailList");
                this.checkData();
                if (!this.loadOverView()) {
                    return;
                }
                this.loadSummary();
                this.dealPayDetail();
                this.cacheItemInfo();
                break;
            }
        }
    }

    private void dealPayDetail() {
        Boolean isPayDetail = ApproveBillService.isPayDetail((DynamicObject)this.getModel().getDataEntity().getDynamicObject("approvebilltplv"));
        DynamicObjectCollection calEntryEntity = this.getModel().getEntryEntity("calentryentity");
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (isPayDetail.booleanValue()) {
            HashMap<Long, Long> calPersonAndCalTableMap = new HashMap<Long, Long>(calEntryEntity.size());
            for (DynamicObject calDy : calEntryEntity) {
                long calPersonId = calDy.getLong("calpersonid");
                calPersonAndCalTableMap.put(calPersonId, calDy.getLong("caltableid"));
            }
            pageCache.put("changeTplCalPersons", calPersonAndCalTableMap.keySet());
            Map payDetails = HSASCalApproveBillHelper.queryPayDetails(calPersonAndCalTableMap.keySet());
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("calentryentity");
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("seq", new Object[0]);
            vs.addField("caltableid", new Object[0]);
            vs.addField("calpersonid", new Object[0]);
            vs.addField("paydetailid", new Object[0]);
            int entryRowCount = 0;
            for (Map.Entry calPersonAndCalTableEntry : calPersonAndCalTableMap.entrySet()) {
                Long calPersonId = (Long)calPersonAndCalTableEntry.getKey();
                if (!CollectionUtils.isEmpty((Map)payDetails)) {
                    Set payDetailIdSet = (Set)payDetails.get(calPersonId);
                    if (!CollectionUtils.isEmpty((Collection)payDetailIdSet)) {
                        for (Long payDetailId : payDetailIdSet) {
                            vs.addRow(new Object[]{++entryRowCount, calPersonAndCalTableMap.get(calPersonId), calPersonId, payDetailId});
                        }
                        continue;
                    }
                    vs.addRow(new Object[]{++entryRowCount, calPersonAndCalTableMap.get(calPersonId), calPersonId, 0L});
                    continue;
                }
                vs.addRow(new Object[]{++entryRowCount, calPersonAndCalTableMap.get(calPersonId), calPersonId, 0L});
            }
            model.batchCreateNewEntryRow("calentryentity", vs);
            model.endInit();
            this.getView().updateView("calentryentity");
        } else {
            pageCache.remove("changeTplCalPersons");
            for (DynamicObject dynamicObject : calEntryEntity) {
                dynamicObject.set("paydetailid", (Object)0L);
            }
            this.getView().updateView("calentryentity");
        }
        this.getModel().setDataChanged(false);
    }

    protected void invokeSaveOperation(String opKey) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("pageId", this.getView().getPageId());
        option.setVariableValue("confirm", "true");
        option.setVariableValue("source", "FormBill");
        option.setVariableValue("operatype", opKey);
        this.getView().invokeOperation("save", option);
    }

    protected void updateDeleteCalTableCache(SWCPageCache pageCache, List<Long> successList) {
        Set changeTplCalPersons;
        IAppCache appCache = AppCache.get((String)this.getView().getPageId());
        HashSet updatePayDetailCalPersonIds = new HashSet(successList.size());
        Set allAddCalPersonIds = (Set)pageCache.get("allAddCalPersons", Set.class);
        if (!CollectionUtils.isEmpty((Collection)allAddCalPersonIds)) {
            allAddCalPersonIds.removeIf(id -> !successList.contains(Long.valueOf(id)));
            allAddCalPersonIds.forEach(calPersonId -> updatePayDetailCalPersonIds.add(Long.valueOf(calPersonId)));
        }
        if (!CollectionUtils.isEmpty((Collection)(changeTplCalPersons = (Set)pageCache.get("changeTplCalPersons", Set.class)))) {
            changeTplCalPersons.removeIf(id -> !successList.contains(id));
            changeTplCalPersons.forEach(calPersonId -> updatePayDetailCalPersonIds.add(calPersonId));
        }
        appCache.put("updatePayDetailCalPersons", updatePayDetailCalPersonIds);
        Map deleteCalTableIdMap = (Map)pageCache.get("deleteCalTableIds", Map.class);
        if (deleteCalTableIdMap == null) {
            return;
        }
        if (deleteCalTableIdMap.isEmpty()) {
            appCache.put("deleteCalTableIds", new ArrayList());
        } else {
            appCache.put("deleteCalTableIds", deleteCalTableIdMap.keySet());
        }
    }

    protected List<Long> initEntryEntity(Map<String, Integer> map) {
        if (CollectionUtils.isEmpty(map)) {
            return new ArrayList<Long>();
        }
        List<Long> successList = this.getMatchCalTableInfo(map);
        this.initApproveBillEntryInfo(successList);
        return successList;
    }

    protected List<Long> getMatchCalTableInfo(Map<String, Integer> map) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectCalFields = "id,calresultid,calstatus,empnumber,name,onholdstatus";
        Set<String> keySetStr = map.keySet();
        List keySet = keySetStr.stream().map(Long::parseLong).collect(Collectors.toList());
        DynamicObject[] calPersonList = calPersonHelper.query(selectCalFields, new QFilter[]{new QFilter("id", "in", keySet)});
        ArrayList<Long> successList = new ArrayList<Long>(10);
        ArrayList<String> failMessage = new ArrayList<String>(10);
        ArrayList<String> saveFailList = new ArrayList<String>(10);
        StringBuilder sb = new StringBuilder();
        List calPersonDTOList = ApproveBillService.queryApproveBillByCalPersonId(keySet);
        calPersonDTOList = calPersonDTOList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CalPersonDTO>(Comparator.comparing(cal -> cal.getCalPersonId() + "-" + cal.getId()))), ArrayList::new));
        Map<Long, List<CalPersonDTO>> calPersonMap = calPersonDTOList.stream().collect(Collectors.groupingBy(CalPersonDTO::getCalPersonId));
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        HashMap<String, Integer> deleteCalTableIdMap = (HashMap<String, Integer>)pageCache.get("deleteCalTableIds", Map.class);
        Long approveBillId = this.getModel().getDataEntity().getLong("id");
        boolean isOnHold = ApproveBillService.getApproveBillTplIsOnHold((DynamicObject)this.getModel().getDataEntity().getDynamicObject("approvebilltplv"));
        for (DynamicObject calPerson : calPersonList) {
            String calstate = calPerson.getString("calstatus");
            Long id = calPerson.getLong("id");
            if (CalStateEnum.AUDIT.getCode().equals(calstate) || CalStateEnum.APPROVALED_NOT_PASS.getCode().equals(calstate) || CalStateEnum.WAIT_APPROVALED.getCode().equals(calstate)) {
                boolean isOnHoldError;
                boolean bl = isOnHoldError = SWCStringUtils.equals((String)String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()), (String)calPerson.getString("onholdstatus")) || !isOnHold && SWCStringUtils.equals((String)String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()), (String)calPerson.getString("onholdstatus"));
                if (isOnHoldError) {
                    if (CollectionUtils.isEmpty((Map)deleteCalTableIdMap)) {
                        deleteCalTableIdMap = new HashMap<String, Integer>(16);
                    }
                    deleteCalTableIdMap.put(String.valueOf(id), 1);
                    this.buildErrorMsg(failMessage, saveFailList, sb, calPerson, id);
                    continue;
                }
                List<CalPersonDTO> calPersonDTOS = calPersonMap.get(id);
                boolean isExist = false;
                if (calPersonDTOS != null) {
                    for (CalPersonDTO calPersonDTO : calPersonDTOS) {
                        if (calPersonDTO.getId().equals(approveBillId)) continue;
                        isExist = true;
                        break;
                    }
                }
                if (isExist) {
                    this.buildErrorMsg(failMessage, saveFailList, sb, calPerson, id);
                    continue;
                }
                successList.add(id);
                continue;
            }
            this.buildErrorMsg(failMessage, saveFailList, sb, calPerson, id);
        }
        pageCache.put("deleteCalTableIds", (Object)deleteCalTableIdMap);
        String message = isOnHold ? ResManager.loadKDString((String)"\u5171{0}\u6761\u6838\u7b97\u8bb0\u5f55\uff0c{1}\u6761\u4fdd\u5b58\u6210\u529f\uff0c{2}\u6761\u6838\u7b97\u72b6\u6001\u4e0d\u4e3a\u201c\u5ba1\u6279\u4e0d\u901a\u8fc7\u201d\u6216\u201c\u5df2\u5ba1\u6838\u201d\u6216\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u201c\u6b62\u201d\uff0c\u65e0\u6cd5\u6dfb\u52a0\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u5254\u9664\u3002", (String)"CalApproveBillEdit_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5171{0}\u6761\u6838\u7b97\u8bb0\u5f55\uff0c{1}\u6761\u4fdd\u5b58\u6210\u529f\u3002{2}\u6761\u6838\u7b97\u72b6\u6001\u4e0d\u4e3a\u201c\u5ba1\u6279\u4e0d\u901a\u8fc7\u201d\u6216\u201c\u5df2\u5ba1\u6838\u201d\u3001\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u201c\u505c\u201d\u6216\u201c\u6b62\u201d\uff0c\u65e0\u6cd5\u6dfb\u52a0\u3002\u5df2\u81ea\u52a8\u5254\u9664\u3002", (String)"CalApproveBillEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String title = MessageFormat.format(message, map.size(), successList.size(), failMessage.size());
        IAppCache appCache = AppCache.get((String)this.getView().getPageId());
        appCache.put("entryCalTableIds", successList);
        appCache.put("failMessage", failMessage);
        appCache.put("saveFailTitle", (Object)title);
        appCache.put("saveFailList", saveFailList);
        return successList;
    }

    private void checkData() {
        boolean isOnHold;
        QFilter filter;
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectCalFields = "id";
        DynamicObjectCollection calEntryEntity = this.getModel().getEntryEntity("calentryentity");
        Set calPersonSet = calEntryEntity.stream().map(entry -> entry.getLong("calpersonid")).collect(Collectors.toSet());
        DynamicObject[] calPersonList = calPersonHelper.query(selectCalFields, new QFilter[]{new QFilter("id", "in", calPersonSet), filter = (isOnHold = ApproveBillService.getApproveBillTplIsOnHold((DynamicObject)this.getModel().getDataEntity().getDynamicObject("approvebilltplv"))) ? new QFilter("onholdstatus", "=", (Object)String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode())) : new QFilter("onholdstatus", "in", Arrays.asList(String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()), String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode())))});
        if (calPersonList != null && calPersonList.length > 0) {
            if (isOnHold) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5207\u6362\u6a21\u677f\u6210\u529f\uff0c%d\u6761\u6838\u7b97\u8bb0\u5f55\u505c\u7f13\u53d1\u72b6\u6001\u4e3a \u201c\u6b62\u201d\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u5254\u9664\u3002", (String)"CalApproveBillList_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]), calPersonList.length));
            } else {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5207\u6362\u6a21\u677f\u6210\u529f\uff0c%d\u6761\u6838\u7b97\u8bb0\u5f55\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u201c\u505c\u201d\u6216\u201c\u6b62\u201d\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u5254\u9664\u3002", (String)"CalApproveBillList_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]), calPersonList.length));
            }
            HashMap<String, Integer> deleteCalTableIdMap = new HashMap<String, Integer>(16);
            HashMap<String, Integer> entryCalTableIdMap = new HashMap<String, Integer>(16);
            for (DynamicObject calEntry : calEntryEntity) {
                entryCalTableIdMap.put(calEntry.getString("calpersonid"), 1);
            }
            for (DynamicObject calPerson : calPersonList) {
                entryCalTableIdMap.remove(calPerson.getString("id"));
                deleteCalTableIdMap.put(calPerson.getString("id"), 1);
            }
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put("deleteCalTableIds", deleteCalTableIdMap);
            pageCache.put("entryCalTableIds", entryCalTableIdMap);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5207\u6362\u6210\u529f\u3002", (String)"CalApproveBillEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().getPageCache().remove("entryCalTableIds");
            this.getView().getPageCache().remove("deleteCalTableIds");
        }
    }

    private void buildErrorMsg(List<String> failMessage, List<String> saveFailList, StringBuilder sb, DynamicObject calPerson, Long id) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map entryCalTableIds = (Map)pageCache.get("entryCalTableIds", Map.class);
        entryCalTableIds.remove(String.valueOf(id));
        pageCache.put("entryCalTableIds", (Object)entryCalTableIds);
        String personNumber = calPerson.getString("empnumber");
        String personName = calPerson.getString("name");
        sb.setLength(0);
        sb.append(personName).append('(').append(personNumber).append(')');
        String msg = ResManager.loadKDString((String)"%s\u7684\u6838\u7b97\u8bb0\u5f55\u5df2\u88ab\u5254\u9664\u3002", (String)"CalApproveBillEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        failMessage.add(String.format(Locale.ROOT, msg, sb.toString()));
        saveFailList.add(String.valueOf(id));
    }

    protected void initApproveBillEntryInfo(List<Long> successList) {
        if (CollectionUtils.isEmpty(successList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", successList);
        DynamicObject[] queryResults = helper.query("id,calresultid,personhrv.id,salaryfile.id", new QFilter[]{filter});
        HashSet<Long> personIdSet = new HashSet<Long>(16);
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(16);
        HashMap<Long, Long> calTableCalPersonMap = new HashMap<Long, Long>(queryResults.length);
        for (DynamicObject calPersonDy : queryResults) {
            long personId = calPersonDy.getLong("personhrv.id");
            long salaryFileId = calPersonDy.getLong("salaryfile.id");
            personIdSet.add(personId);
            salaryFileIdSet.add(salaryFileId);
            calTableCalPersonMap.put(calPersonDy.getLong("id"), calPersonDy.getLong("calresultid"));
        }
        Boolean isPayDetail = ApproveBillService.isPayDetail((DynamicObject)this.getModel().getDataEntity().getDynamicObject("approvebilltplv"));
        Map<Long, Set<Long>> payDetails = this.queryPayDetails(calTableCalPersonMap, isPayDetail);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("calentryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("caltableid", new Object[0]);
        vs.addField("calpersonid", new Object[0]);
        vs.addField("paydetailid", new Object[0]);
        int entryRowCount = 0;
        for (Long idLong : successList) {
            if (!CollectionUtils.isEmpty(payDetails) && isPayDetail.booleanValue()) {
                Set<Long> payDetailIdSet = payDetails.get(idLong);
                if (!CollectionUtils.isEmpty(payDetailIdSet)) {
                    for (Long payDetailId : payDetailIdSet) {
                        vs.addRow(new Object[]{++entryRowCount, calTableCalPersonMap.get(idLong), idLong, payDetailId});
                    }
                    continue;
                }
                vs.addRow(new Object[]{++entryRowCount, calTableCalPersonMap.get(idLong), idLong, 0L});
                continue;
            }
            vs.addRow(new Object[]{++entryRowCount, calTableCalPersonMap.get(idLong), idLong, 0L});
        }
        DynamicObject calApproveBillDy = this.getModel().getDataEntity();
        calApproveBillDy.set("totalpersonnum", (Object)personIdSet.size());
        calApproveBillDy.set("totalsalaryfilenum", (Object)salaryFileIdSet.size());
        model.batchCreateNewEntryRow("calentryentity", vs);
        model.endInit();
    }

    private Map<Long, Set<Long>> queryPayDetails(Map<Long, Long> calTableCalPersonMap, Boolean isPayDetail) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Set allAddCalPersonIds = (Set)pageCache.get("allAddCalPersons", Set.class);
        Map<Long, Set<Long>> payDetails = new HashMap<Long, Set<Long>>(calTableCalPersonMap.size());
        if (isPayDetail.booleanValue()) {
            if (!CollectionUtils.isEmpty((Collection)allAddCalPersonIds)) {
                HashSet unPayDetailCalPersonIds = new HashSet(allAddCalPersonIds.size());
                allAddCalPersonIds.forEach(calPersonId -> unPayDetailCalPersonIds.add(Long.valueOf(calPersonId)));
                payDetails = HSASCalApproveBillHelper.queryPayDetails(unPayDetailCalPersonIds);
            }
            DynamicObjectCollection calEntryEntity = this.getModel().getEntryEntity("calentryentity");
            for (DynamicObject calDy : calEntryEntity) {
                long calPersonId2 = calDy.getLong("calpersonid");
                long payDetailId = calDy.getLong("paydetailid");
                if (!CollectionUtils.isEmpty((Collection)allAddCalPersonIds) && allAddCalPersonIds.contains(String.valueOf(calPersonId2))) continue;
                Set<Long> idSet = payDetails.get(calPersonId2);
                if (!CollectionUtils.isEmpty(idSet)) {
                    idSet.add(payDetailId);
                    payDetails.put(calPersonId2, idSet);
                    continue;
                }
                HashSet<Long> payDetailSet = new HashSet<Long>(16);
                payDetailSet.add(payDetailId);
                payDetails.put(calPersonId2, payDetailSet);
            }
        }
        return payDetails;
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.updateSummary();
    }

    protected void loadSummary() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flexpanelap");
        formShowParameter.setFormId("hsas_calapprovebilldetail");
        String ispreview = (String)this.getView().getFormShowParameter().getCustomParam("ispreview");
        if (StringUtils.isNotEmpty((CharSequence)ispreview)) {
            formShowParameter.setCustomParam("ispreview", (Object)ispreview);
            this.getView().showTipNotification(HSASErrInfoEnum.APPROVE_BILL_PREVIEW_TIPS.getMsg(new Object[]{200}));
        }
        String pageId = formShowParameter.getPageId();
        this.getView().getPageCache().put("approveDetailPageId", pageId);
        this.getView().showForm(formShowParameter);
        this.getView().getModel().setDataChanged(false);
    }

    private void removePageCache(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            this.getPageCache().remove("changeTpl");
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.remove("allAddCalPersons");
            pageCache.remove("changeTplCalPersons");
            IAppCache appCache = AppCache.get((String)this.getView().getPageId());
            appCache.remove("updatePayDetailCalPersons");
        }
    }

    private void updateCalPayRollTaskStatus(String operateKey) {
        switch (operateKey) {
            case "submit": 
            case "unsubmit": 
            case "save": {
                List<Long> calTaskIds = this.getCalTaskId();
                for (Long calTaskId : calTaskIds) {
                    PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
                }
                break;
            }
        }
    }

    protected boolean loadOverView() {
        DynamicObjectCollection overViewDyCollection = null;
        String ispreview = (String)this.getView().getFormShowParameter().getCustomParam("ispreview");
        if (StringUtils.isNotEmpty((CharSequence)ispreview)) {
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            Long pkId = (Long)billShowParameter.getPkId();
            SWCDataServiceHelper approveBillHelper = new SWCDataServiceHelper("hsas_approvebill");
            QFilter filter = new QFilter("id", "=", (Object)pkId);
            DynamicObject approveBill = approveBillHelper.queryOne("id, approvebilltpl", new QFilter[]{filter});
            Long approveBillTplId = approveBill.getLong("approvebilltpl.id");
            SWCDataServiceHelper apvSchemeHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
            DynamicObject apvSchemeDy = apvSchemeHelper.loadSingle((Object)approveBillTplId);
            overViewDyCollection = apvSchemeDy.getDynamicObjectCollection("overviewentryentity");
        } else {
            DynamicObject apvSchemeDy = this.getModel().getDataEntity().getDynamicObject("approvebilltplv");
            if (null == apvSchemeDy) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u6a21\u677f\u529f\u80fd\u5df2\u4e0a\u7ebf\uff0c\u5bfc\u81f4\u5386\u53f2\u6570\u636e\u65e0\u6cd5\u4f7f\u7528\uff0c\u8bf7\u9009\u62e9\u5ba1\u6279\u5355\u6a21\u677f\u751f\u6210\u65b0\u7684\u5ba1\u6279\u5355\u3002", (String)"CalApproveBillEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
                return false;
            }
            overViewDyCollection = apvSchemeDy.getDynamicObjectCollection("overviewentryentity");
        }
        boolean haveEnable = false;
        for (DynamicObject overViewDy : overViewDyCollection) {
            if (!overViewDy.getBoolean("isenable")) continue;
            haveEnable = true;
            break;
        }
        if (!haveEnable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"overallview"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"overallview"});
            List<Long> calTaskIds = this.getCalTaskId();
            SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
            DynamicObjectCollection tasks = taskHelper.queryOriginalCollection("id,calrulev.totalsalary.id,calrulev.netsalary.id", new QFilter("id", "in", calTaskIds).toArray());
            if (calTaskIds.size() > tasks.size()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"overallview"});
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"PaySalaryAccountConfigList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener(DELETE_DATA_CALLBACK, (IFormPlugin)this));
                return false;
            }
            FormShowParameter para = new FormShowParameter();
            para.getOpenStyle().setShowType(ShowType.InContainer);
            para.getOpenStyle().setTargetKey("overallview");
            para.setFormId("hsas_approveoverview");
            this.getView().showForm(para);
        }
        return true;
    }

    private List<Long> getCalPersonIds() {
        ArrayList<Long> calPersonIds;
        block3: {
            block2: {
                calPersonIds = new ArrayList<Long>(10);
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                Map map = (Map)pageCache.get("entryCalTableIds", Map.class);
                Map deleteMap = (Map)pageCache.get("deleteCalTableIds", Map.class);
                if (!MapUtils.isNotEmpty((Map)map) && !MapUtils.isNotEmpty((Map)deleteMap)) break block2;
                if (!MapUtils.isNotEmpty((Map)map)) break block3;
                Set ids = map.keySet();
                for (String calPersonIdStr : ids) {
                    if (!StringUtils.isNotBlank((CharSequence)calPersonIdStr) || "0".equals(calPersonIdStr)) continue;
                    calPersonIds.add(Long.valueOf(calPersonIdStr));
                }
                break block3;
            }
            DynamicObjectCollection calEntryEntity = this.getModel().getEntryEntity("calentryentity");
            for (DynamicObject calDy : calEntryEntity) {
                long calPersonId = calDy.getLong("calpersonid");
                if (0L == calPersonId) continue;
                calPersonIds.add(calPersonId);
            }
        }
        return calPersonIds;
    }

    public void showUnfoldFlex() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"showup"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"showdown"});
        this.getView().getPageCache().put("showOneLine", "true");
    }

    protected void checkIsNeedShowConfirm() {
        IAppCache appCache = AppCache.get((String)this.getView().getPageId());
        List failMessage = (List)appCache.get("failMessage", List.class);
        if (failMessage != null && !failMessage.isEmpty()) {
            String title = (String)appCache.get("saveFailTitle", String.class);
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"CalApproveBillEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)title, (List)failMessage);
            this.getView().showForm(parameters);
        }
    }

    protected void checkIsNeedHideInfo(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"billname", "adminorg", "description", "attachmentpanel"});
            Container panel = (Container)this.getView().getControl("flexpanelap71");
            panel.setCollapse(false);
            String approveDetailPageId = this.getView().getPageCache().get("approveDetailPageId");
            if (StringUtils.isNotEmpty((CharSequence)approveDetailPageId)) {
                IFormView approveDetailView = this.getView().getView(approveDetailPageId);
                approveDetailView.setVisible(Boolean.TRUE, new String[]{"baradd", "bardel"});
                this.getView().sendFormAction(approveDetailView);
            }
        }
    }

    protected void showSubmitBillResult(OperationResult operationResult, HSASCalApproveBillHelper helper) {
        if (operationResult.isSuccess()) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setEnable(Boolean.TRUE, new String[]{"unsubmitpay"});
            String approveDetailPageId = this.getView().getPageCache().get("approveDetailPageId");
            IFormView approveDetailView = this.getView().getView(approveDetailPageId);
            approveDetailView.setVisible(Boolean.FALSE, new String[]{"baradd", "bardel"});
            this.getView().sendFormAction(approveDetailView);
        }
    }

    protected void showUnsubmitResult(OperationResult operationResult, HSASCalApproveBillHelper helper) {
        if (operationResult.isSuccess()) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify"});
            this.getView().updateView("billstatus");
        }
    }

    protected void checkIsNeedUpdateSummary(AfterDoOperationEventArgs args, OperationResult operationResult) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operatype = formOperate.getOption().getVariableValue("operatype");
        if (!"save".equals(operatype)) {
            operationResult.setShowMessage(false);
        }
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.updateSummary();
        }
    }

    private void updateSummary() {
        IDataModel model = this.getModel();
        Object summaryName = model.getValue("billname");
        Object summaryBillNo = model.getValue("billno");
        DynamicObject summaryOrg = (DynamicObject)model.getValue("org");
        DynamicObject summaryCreator = (DynamicObject)model.getValue("creator");
        Object summaryCreatetime = model.getValue("createtime");
        model.beginInit();
        QRCode qrCode = (QRCode)this.getControl("qrcodeap");
        qrCode.setUrl((String)summaryBillNo);
        model.setValue("summarybillno", summaryBillNo);
        model.setValue("summaryname", summaryName);
        if (summaryOrg != null) {
            model.setValue("summaryorg", (Object)summaryOrg.getString("name"));
        }
        if (summaryCreator != null) {
            model.setValue("summarycreator", (Object)summaryCreator.getString("name"));
        }
        model.setValue("summarycreatetime", summaryCreatetime);
        model.endInit();
        this.getView().updateView("headpanelview");
        this.getView().updateView("overallview");
        model.setDataChanged(false);
    }

    public void beforeBindData(EventObject eventObject) {
        SWCPageCache pageCache;
        BillOperationStatus formStatus;
        super.beforeBindData(eventObject);
        UpdateTabNameHelper.updateTabName((IFormView)this.getView(), (String)"billno");
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if ("D".equals(billStatus) || "E".equals(billStatus) || "C".equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
        }
        if (BillOperationStatus.VIEW == (formStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"billname", "org", "adminorg", "description", "attachmentpanel"});
            Container panel = (Container)this.getView().getControl("flexpanelap71");
            panel.setCollapse(true);
        }
        if (SWCStringUtils.isEmpty((String)((String)(pageCache = new SWCPageCache(this.getView())).get("openway", String.class)))) {
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            IFormView grandParentView = this.getView().getViewNoPlugin(parentPageId);
            if (grandParentView != null) {
                SWCPageCache grandPageCache = new SWCPageCache(grandParentView);
                pageCache.put("openway", grandPageCache.get("openway", String.class));
                pageCache.put("isneedcollapse", grandPageCache.get("isneedcollapse", String.class));
            }
        }
    }

    private void billResultChangeCannotView(String approveStatus) {
        if ("E".equals(approveStatus) || "F".equals(approveStatus)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
            DynamicObjectCollection calEntryEntity = this.getModel().getEntryEntity("calentryentity");
            Set calTableIdSet = calEntryEntity.stream().map(entry -> entry.getLong("caltableid")).collect(Collectors.toSet());
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", calTableIdSet)};
            Integer calTableCount = helper.count(filters);
            if (calTableCount.intValue() != calTableIdSet.size()) {
                this.showTipsAndSetVisible();
            } else {
                DynamicObject maxDateDy;
                Date modifyTime = (Date)this.getModel().getValue("modifytime");
                DynamicObject[] calTableInfos = helper.query("id, modifytime", filters);
                Set calTableInfoSet = Arrays.stream(calTableInfos).filter(obj -> obj.getDate("modifytime") != null).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(calTableInfoSet) && SWCDateTimeUtils.dayAfter((Date)((Date)(maxDateDy = calTableInfoSet.stream().max(Comparator.comparing(obj -> obj.getDate("modifytime"))).get()).get("modifytime")), (Date)modifyTime)) {
                    this.showTipsAndSetVisible();
                }
            }
        }
    }

    private void showTipsAndSetVisible() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u7ed3\u679c\u5df2\u88ab\u4fee\u6539\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"CalApproveBillEdit_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().setVisible(Boolean.FALSE, new String[]{"overallview", "flexpanelap7"});
    }

    public void pageRelease(EventObject eventObject) {
        super.pageRelease(eventObject);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        this.clearPageCache(pageCache);
        IAppCache appCache = AppCache.get((String)this.getView().getPageId());
        appCache.remove("entryCalTableIds");
        appCache.remove("deleteCalTableIds");
        appCache.remove("failMessage");
        appCache.remove("saveFailTitle");
        appCache.remove("saveFailList");
        appCache.remove("allAddCalPersons");
    }

    protected void clearPageCache(SWCPageCache pageCache) {
        pageCache.remove("entryCalTableIds");
        pageCache.remove("origCalTableIds");
        pageCache.remove("deleteCalTableIds");
        pageCache.remove("LatestItemInfo");
        pageCache.remove("operakey");
    }

    private void changeTpl() {
        DynamicObjectCollection calEntryEntity = this.getModel().getEntryEntity("calentryentity");
        HashMap calPersonCalTableMap = new HashMap(calEntryEntity.size());
        calEntryEntity.forEach(calDy -> calPersonCalTableMap.put(String.valueOf(calDy.getLong("calpersonid")), String.valueOf(calDy.getLong("caltableid"))));
        Set<Long> calPersonSet = calPersonCalTableMap.keySet().stream().map(Long::parseLong).collect(Collectors.toSet());
        Long payRollGroupId = this.getModel().getDataEntity().getLong("payrollgroup.id");
        Long orgId = this.getModel().getDataEntity().getLong("org.id");
        String orgName = this.getModel().getDataEntity().getString("org.name");
        FormShowParameter show = new FormShowParameter();
        show.setFormId("hsas_calviewapprovebill");
        show.getOpenStyle().setShowType(ShowType.Modal);
        show.setShowTitle(false);
        show.setCustomParam("isChangeTpl", (Object)"true");
        show.setCustomParam("calPersonCalTableMap", calPersonCalTableMap);
        show.setCustomParam("calPersonOnHoldSet", (Object)JSON.toJSONString(this.getCalPersonOnHoldSet(calPersonSet)));
        show.setCustomParam("calTaskId", (Object)SWCArrayUtils.objectArray2String((Object[])this.getCalTaskId().toArray(), (String)","));
        show.setCustomParam("orgId", (Object)String.valueOf(orgId));
        show.setCustomParam("orgName", (Object)orgName);
        show.setCustomParam("payrollgroupId", (Object)payRollGroupId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "changeTplClose");
        show.setCloseCallBack(closeCallBack);
        this.getView().showForm(show);
    }

    private Set<String> getCalPersonOnHoldSet(Set<Long> calPersonIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIds);
        filter.and(new QFilter("onholdstatus", "=", (Object)String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode())));
        DynamicObjectCollection coll = helper.queryColl("id", filter.toArray(), "");
        HashSet<String> calPersonOnHoldSet = new HashSet<String>(16);
        coll.forEach(data -> calPersonOnHoldSet.add(data.getString("id")));
        return calPersonOnHoldSet;
    }

    private void changeTplConfirm() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6a21\u677f\u540e\uff0c\u5c06\u5e94\u7528\u65b0\u7684\u5ba1\u6279\u5355\u6a21\u677f\u91cd\u65b0\u751f\u6210\u5ba1\u6279\u5355\u5185\u5bb9\u3002\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"CalApproveBillEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGETPL));
    }

    private void isAbandonedStatus() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if ("F".equals(billStatus)) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_submit"});
            this.getView().updateView("bar_modify");
            this.getView().updateView("bar_submit");
        }
    }

    private List<Long> getCalTaskId() {
        ArrayList<Long> calTaskIds = new ArrayList(10);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity != null) {
            DynamicObjectCollection caltasks = dataEntity.getDynamicObjectCollection("caltasks");
            for (DynamicObject caltask : caltasks) {
                calTaskIds.add(caltask.getLong("fbasedataid_id"));
            }
        }
        calTaskIds = calTaskIds.stream().distinct().collect(Collectors.toList());
        return calTaskIds;
    }

    private void cacheItemInfo() {
        Long approveBillId = this.getModel().getDataEntity(true).getLong("id");
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hsas_itemaccount");
        DynamicObject itemAccountDy = helper.loadDynamicObject(new QFilter("approvebill", "=", (Object)approveBillId));
        if (HRObjectUtils.isEmpty((Object)itemAccountDy)) {
            return;
        }
        int totalAccount = itemAccountDy.getInt("totalaccount");
        DynamicObjectCollection entryEntity = itemAccountDy.getDynamicObjectCollection(KEY_ENTRYENTITY);
        LinkedHashMap<String, ApproveBillSalaryItemDTO> approveBillSalaryItemDTOMap = new LinkedHashMap<String, ApproveBillSalaryItemDTO>(entryEntity.size());
        ApproveBillAccountDTO approveBillAccountDTO = new ApproveBillAccountDTO(Integer.valueOf(totalAccount), approveBillSalaryItemDTOMap);
        approveBillAccountDTO.setApproveBillId(approveBillId);
        for (DynamicObject entry : entryEntity) {
            String itemFieldCode;
            if (!entry.containsProperty(itemFieldCode = entry.getString("itemfieldcode"))) continue;
            long itemId = entry.getLong(itemFieldCode + ".id");
            ApproveBillSalaryItemDTO approveBillSalaryItemDTO = new ApproveBillSalaryItemDTO(Long.valueOf(0L), Long.valueOf(itemId), itemFieldCode, totalAccount);
            approveBillSalaryItemDTO.setZeroItemAccount(Integer.valueOf(entry.getInt("zeroitemnum")));
            approveBillSalaryItemDTO.setOtherItemAccount(Integer.valueOf(entry.getInt("otheritemnum")));
            String key = itemFieldCode + itemId;
            approveBillSalaryItemDTOMap.put(key, approveBillSalaryItemDTO);
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put("LatestItemInfo", (Object)approveBillAccountDTO);
    }
}

