/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.approve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.approve.ApproveSettingHelper;
import kd.swc.hsas.formplugin.web.dto.AgeSpecialDTO;
import kd.swc.hsas.formplugin.web.dto.AgeSpecialEntryDTO;
import kd.swc.hsas.formplugin.web.dto.ApvSpecialDTO;
import kd.swc.hsas.formplugin.web.dto.ApvSpecialEntryDTO;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.StringUtils;

public class CalApproveBillSpecialPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
BeforeFilterF7SelectListener {
    private static Log logger = LogFactory.getLog(CalApproveBillSpecialPlugin.class);
    private static List<TreeNode> apvSchemeNodes = new ArrayList<TreeNode>(10);
    private static List<TreeNode> ageSchemeNodes = new ArrayList<TreeNode>(10);
    private static final String KEY_RADIOGROUPFIELD = "radiogroupfield";
    private static final String FLEX_AGE = "ageflexpanelap";
    private static final Map<Integer, String> pageMap = new HashMap<Integer, String>(16);
    private static final Set<String> compareTypes;

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView apvTreeView = (TreeView)this.getView().getControl("apvtreeviewap");
        TreeView ageTreeView = (TreeView)this.getView().getControl("agetreeviewap");
        this.addClickListeners(new String[]{"btn_apv_add"});
        this.addClickListeners(new String[]{"btn_apv_remove"});
        this.addClickListeners(new String[]{"btn_age_add"});
        this.addClickListeners(new String[]{"btn_age_remove"});
        apvTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        ageTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        this.init();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String condition = (String)showParameter.getCustomParam("condition");
        if (StringUtils.isNotBlank((String)condition)) {
            this.setDataFilter(condition);
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        List filterColumns = filterGrid.getFilterColumns();
        for (Map column : filterColumns) {
            List list = (List)column.get("compareTypes");
            column.put("compareTypes", list.stream().filter(typeDto -> compareTypes.contains(typeDto.getId())).collect(Collectors.toList()));
        }
        this.getView().updateView("filtergridap");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if (StringUtils.equals((String)KEY_RADIOGROUPFIELD, (String)fieldKey)) {
            ChangeData[] changeData = args.getChangeSet();
            String newValue = (String)changeData[0].getNewValue();
            if ("1".equals(newValue)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_AGE});
                ArrayList nodeIdList = new ArrayList(10);
                ageSchemeNodes.forEach(node -> nodeIdList.add(node.getId()));
                TreeView ageTreeView = (TreeView)this.getView().getControl("agetreeviewap");
                ageTreeView.uncheckNodes(nodeIdList);
                this.getModel().deleteEntryData("agentspecialruleentity");
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_AGE});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IFormView view = this.getView();
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        EntryGrid apvEntryGrid = (EntryGrid)view.getControl("approvespecialruleentity");
        EntryGrid ageEntryGrid = (EntryGrid)view.getControl("agentspecialruleentity");
        TreeView apvTreeView = (TreeView)this.getView().getControl("apvtreeviewap");
        TreeView ageTreeView = (TreeView)this.getView().getControl("agetreeviewap");
        DynamicObjectCollection apvEntryEntity = this.getModel().getEntryEntity("approvespecialruleentity");
        DynamicObjectCollection ageEntryEntity = this.getModel().getEntryEntity("agentspecialruleentity");
        switch (key) {
            case "apvtotop": {
                ApproveSettingHelper.moveEntryTop((IFormView)view, (DynamicObjectCollection)apvEntryEntity, (String)"approvespecialruleentity");
                this.getView().updateView("approvespecialruleentity");
                break;
            }
            case "apvtodown": {
                ApproveSettingHelper.moveEntryDown((IFormView)view, (DynamicObjectCollection)apvEntryEntity, (String)"approvespecialruleentity");
                this.getView().updateView("approvespecialruleentity");
                break;
            }
            case "agetotop": {
                ApproveSettingHelper.moveEntryTop((IFormView)view, (DynamicObjectCollection)ageEntryEntity, (String)"agentspecialruleentity");
                this.getView().updateView("agentspecialruleentity");
                break;
            }
            case "agetodown": {
                ApproveSettingHelper.moveEntryDown((IFormView)view, (DynamicObjectCollection)ageEntryEntity, (String)"agentspecialruleentity");
                this.getView().updateView("agentspecialruleentity");
                break;
            }
            case "deletapveentry": {
                int[] apvSelectRows = apvEntryGrid.getSelectRows();
                ArrayList<Object> apvSelectedEntryEntity = new ArrayList<Object>(10);
                for (int row : apvSelectRows) {
                    apvSelectedEntryEntity.add(apvEntryEntity.get(row));
                }
                ApproveSettingHelper.removeShowColumn((TreeView)apvTreeView, apvSelectedEntryEntity, (String)"approvespecialruleentity");
                break;
            }
            case "deleteageentry": {
                int[] ageSelectRows = ageEntryGrid.getSelectRows();
                ArrayList<Object> ageSelectedEntryEntity = new ArrayList<Object>(10);
                for (int row : ageSelectRows) {
                    ageSelectedEntryEntity.add(ageEntryEntity.get(row));
                }
                ApproveSettingHelper.removeShowColumn((TreeView)ageTreeView, ageSelectedEntryEntity, (String)"agentspecialruleentity");
                break;
            }
            case "saveselect": {
                this.getDataSelect();
                break;
            }
            case "donothing_nextpage": {
                FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
                FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
                if (!this.validateFilter(filterCondition)) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "donothing_lastpage": {
                this.toLastPage();
                break;
            }
            case "donothing_nextpage": {
                this.toNextPage();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        TreeView apvTreeView = (TreeView)this.getView().getControl("apvtreeviewap");
        TreeView ageTreeView = (TreeView)this.getView().getControl("agetreeviewap");
        IFormView view = this.getView();
        switch (key) {
            case "btn_apv_add": {
                ApproveSettingHelper.addShowColumn((IFormView)view, (TreeView)apvTreeView, (String)"approvespecialruleentity");
                break;
            }
            case "btn_age_add": {
                ApproveSettingHelper.addShowColumn((IFormView)view, (TreeView)ageTreeView, (String)"agentspecialruleentity");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        String fieldName;
        switch (fieldName = beforeFilterF7SelectEvent.getFieldName()) {
            case "hrpi_empjobrel.joblevel.name": {
                beforeFilterF7SelectEvent.addCustomQFilter(new QFilter("joblevelscm.iscurrentversion", "=", (Object)"1"));
                break;
            }
            case "hrpi_empjobrel.jobgrade.name": {
                beforeFilterF7SelectEvent.addCustomQFilter(new QFilter("jobgradescm.iscurrentversion", "=", (Object)"1"));
                break;
            }
        }
    }

    private void init() {
        this.initFilterCondition();
        this.setTab(1);
    }

    private void initApproveView(DynamicObjectCollection entryEntity) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TreeView apvTreeView = (TreeView)this.getView().getControl("apvtreeviewap");
        apvSchemeNodes = new ArrayList<TreeNode>(10);
        ApproveSettingHelper.buildLeftTree(apvSchemeNodes, (DynamicObjectCollection)entryEntity, (TreeView)apvTreeView);
        String apv = (String)showParameter.getCustomParam("approvespecialruleentity");
        TableValueSetter apvSpecialSetter = new TableValueSetter(new String[0]);
        if (null != apv) {
            ApvSpecialEntryDTO apvSpecialEntryDTO = (ApvSpecialEntryDTO)SerializationUtils.fromJsonString((String)apv, ApvSpecialEntryDTO.class);
            apvSpecialSetter = ApproveSettingHelper.createApvSpecialEntryTableSetter((TableValueSetter)apvSpecialSetter);
            for (ApvSpecialDTO apvSpecialDTO : apvSpecialEntryDTO.getApvSpecialDTOList()) {
                apvSpecialSetter.addRow(new Object[]{apvSpecialDTO.getApvspecialschename(), apvSpecialDTO.getApvspecialschentry()});
            }
        }
        model.beginInit();
        model.batchCreateNewEntryRow("approvespecialruleentity", apvSpecialSetter);
        model.endInit();
        this.getView().updateView("approvespecialruleentity");
        this.getView().updateView("agentspecialruleentity");
        DynamicObjectCollection apvEntryEntity = this.getModel().getEntryEntity("approvespecialruleentity");
        Map<String, TreeNode> apvTreeNodeMap = apvSchemeNodes.stream().collect(Collectors.toMap(TreeNode::getId, treeNode -> treeNode, (o1, o2) -> o1));
        ApproveSettingHelper.showColumn((TreeView)apvTreeView, (List)apvEntryEntity, apvTreeNodeMap, (String)"approvespecialruleentity");
    }

    private void initAgentView(DynamicObjectCollection entryEntity) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TreeView ageTreeView = (TreeView)this.getView().getControl("agetreeviewap");
        ageSchemeNodes = new ArrayList<TreeNode>(10);
        ApproveSettingHelper.buildLeftTree(ageSchemeNodes, (DynamicObjectCollection)entryEntity, (TreeView)ageTreeView);
        Boolean isSame = (Boolean)showParameter.getCustomParam("issame");
        if (Boolean.FALSE.equals(isSame)) {
            this.getModel().setValue(KEY_RADIOGROUPFIELD, (Object)"2");
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_AGE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_AGE});
        }
        String age = (String)showParameter.getCustomParam("agentspecialruleentity");
        TableValueSetter ageSpecialSetter = new TableValueSetter(new String[0]);
        if (null != age) {
            AgeSpecialEntryDTO ageSpecialEntryDTO = (AgeSpecialEntryDTO)SerializationUtils.fromJsonString((String)age, AgeSpecialEntryDTO.class);
            if (null == ageSpecialEntryDTO || CollectionUtils.isEmpty(ageSpecialEntryDTO.getAgeSpecialDTOList())) {
                this.getModel().setValue(KEY_RADIOGROUPFIELD, (Object)"1");
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_AGE});
            } else {
                ageSpecialSetter = ApproveSettingHelper.createAgeSpecialEntryTableSetter((TableValueSetter)ageSpecialSetter);
                for (AgeSpecialDTO ageSpecialDTO : ageSpecialEntryDTO.getAgeSpecialDTOList()) {
                    ageSpecialSetter.addRow(new Object[]{ageSpecialDTO.getAgespecialschename(), ageSpecialDTO.getAgespecialschentry()});
                }
            }
        }
        model.beginInit();
        model.batchCreateNewEntryRow("agentspecialruleentity", ageSpecialSetter);
        model.endInit();
        this.getView().updateView(KEY_RADIOGROUPFIELD);
        this.getView().updateView("agentspecialruleentity");
        DynamicObjectCollection ageEntryEntity = this.getModel().getEntryEntity("agentspecialruleentity");
        Map<String, TreeNode> ageTreeNodeMap = ageSchemeNodes.stream().collect(Collectors.toMap(TreeNode::getId, treeNode -> treeNode, (o1, o2) -> o1));
        ApproveSettingHelper.showColumn((TreeView)ageTreeView, (List)ageEntryEntity, ageTreeNodeMap, (String)"agentspecialruleentity");
    }

    private void initFilterCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        filterCondition.getFilterRow().clear();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hsas_approvespclrlquery");
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)queryEntityType);
        List childEntities = queryEntityType.getJoinEntitys();
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        for (JoinEntity joinEntity : childEntities) {
            fieldMap.put(joinEntity.getAlias(), joinEntity.getDisplayName());
        }
        List selectFields = queryEntityType.getSelectFields();
        ArrayList<String> fieldIds = new ArrayList<String>(selectFields.size());
        for (QuerySelectField querySelectField : selectFields) {
            fieldIds.add(querySelectField.getAlias());
        }
        ArrayList<Map> filterList = new ArrayList<Map>(10);
        for (Map map : filterColumns) {
            String fieldName = (String)map.get("fieldName");
            String fieldLang = (String)ApproveSettingHelper.getApproveBillTplSpRuleMap().get(fieldName);
            if (null == fieldLang || !fieldIds.contains(fieldName)) continue;
            boolean filterTag = false;
            for (Map.Entry entry : fieldMap.entrySet()) {
                if (fieldName.equals((String)entry.getKey() + ".number") || fieldName.equals((String)entry.getKey() + ".name")) {
                    filterTag = true;
                }
                map.put("fieldCaption", fieldLang);
            }
            if (!filterTag) {
                filterList.add(map);
                continue;
            }
            logger.info(ResManager.loadKDString((String)"\u6392\u9664\u8fc7\u6ee4\u5b57\u6bb5:%s", (String)"CalApproveBillTplEdit_25", (String)"swc-hsas-formplugin", (Object[])new Object[]{map.get("fieldCaption")}));
        }
        filterGrid.setFilterColumns(filterList);
        filterGrid.setEntityNumber("hsas_approvespclrlquery");
        filterGrid.SetValue(filterCondition);
        this.getView().updateView("filtergridap");
    }

    private void getDataSelect() {
        HashMap<String, String> data = new HashMap<String, String>();
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        if (this.validateFilter(filterCondition)) {
            return;
        }
        String filterJson = SerializationUtils.toJsonString((Object)filterCondition);
        data.put("datafilter", filterJson);
        DynamicObjectCollection apvEntryEntity = this.getModel().getEntryEntity("approvespecialruleentity");
        if (apvEntryEntity.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u663e\u793a\u7684\u5ba1\u6279\u4eba\u89c6\u56fe\u3002", (String)"CalApproveBillTplTips_26", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection ageEntryEntity = this.getModel().getEntryEntity("agentspecialruleentity");
        String groupChoose = this.getModel().getDataEntity().getString(KEY_RADIOGROUPFIELD);
        if (StringUtils.equals((String)groupChoose, (String)"2") && ageEntryEntity.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ee3\u529e\u4eba\u5ba1\u6279\u65f6\u9700\u8981\u663e\u793a\u7684\u89c6\u56fe\u3002", (String)"CalApproveBillTplTips_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        data.put("approvespecialruleentity", (String)apvEntryEntity);
        data.put("agentspecialruleentity", (String)ageEntryEntity);
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private boolean validateFilter(FilterCondition filterCondition) {
        List filterList = filterCondition.getFilterRow();
        if (filterList == null || filterList.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6761\u4ef6\u3002", (String)"CalApproveBillTplTips_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setDataFilter(String dataFilter) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)dataFilter, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.SetValue(filterCondition);
        filterGrid.getFilterGridState().setState(filterCondition);
        this.getView().updateView("filtergridap");
    }

    private void toLastPage() {
        int curPage = this.getModel().getDataEntity().getInt("curpage");
        this.toPage(curPage - 1);
    }

    private void toNextPage() {
        int curPage = this.getModel().getDataEntity().getInt("curpage");
        this.toPage(curPage + 1);
    }

    private void toPage(int page) {
        int minPage = 1;
        int maxPage = pageMap.size();
        if (page <= maxPage && page >= minPage) {
            this.setTab(page);
        }
    }

    private void setTab(int toPage) {
        switch (toPage) {
            case 1: {
                this.showPageOne();
                break;
            }
            case 2: {
                this.showPageTwo();
                break;
            }
        }
        String tabKey = pageMap.get(toPage);
        Tab tab = (Tab)this.getControl("tabap");
        if (SWCStringUtils.isNotEmpty((String)tabKey)) {
            tab.activeTab(tabKey);
        }
    }

    private void showPageOne() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"labelap", "filtergridap", "nextpage"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pagetwo", "lastpage", "btnok"});
        this.getModel().setValue("curpage", (Object)1);
    }

    private void showPageTwo() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"labelap", "filtergridap", "nextpage"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"pagetwo", "lastpage", "btnok"});
        String init = this.getView().getPageCache().get("init");
        if (!StringUtils.equals((String)init, (String)"true")) {
            DynamicObjectCollection schemeEntryEntity = this.getView().getParentView().getModel().getEntryEntity("schemeentryentity");
            this.initApproveView(schemeEntryEntity);
            this.initAgentView(schemeEntryEntity);
            this.getView().getPageCache().put("init", "true");
        }
        this.getModel().setValue("curpage", (Object)2);
    }

    static {
        pageMap.put(1, "firstpage");
        pageMap.put(2, "secondpage");
        compareTypes = new HashSet<String>(Arrays.asList(CompareTypeEnum.IN.getId(), CompareTypeEnum.NOTIN.getId()));
    }
}

