/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.approve;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.approve.ApproveBillTplService;
import kd.swc.hsas.business.approve.ApproveSettingHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class CalApproveBillTplList
extends AbstractListPlugin {
    protected static final Log logger = LogFactory.getLog(CalApproveBillTplList.class);

    public void preOpenForm(PreOpenFormEventArgs event) {
        super.preOpenForm(event);
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_approvebilltpl", (String)"47150e89000000ac");
        FormShowParameter showParameter = (FormShowParameter)event.getSource();
        if (!hasPerm && !((FormShowParameter)event.getSource()).isHasRight()) {
            showParameter.setListentimerElapsed(true);
            event.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u65e0\"\u85aa\u8d44\u5ba1\u6279\u5355\u6a21\u677f\"\u7684\"\u67e5\u8be2\"\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalApproveBillTplList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            event.setCancelMessage(msg);
        }
    }

    public void setFilter(SetFilterEvent event) {
        QFilter qFilter = new QFilter("iseffect", "=", (Object)Boolean.TRUE);
        event.addCustomQFilter(qFilter);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.isShowConfirm();
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tbl_auditconfirmchange"});
    }

    private void isShowConfirm() {
        if (BaseDataHisHelper.isHisList((IFormView)this.getView()) || ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp()) {
            return;
        }
        String isShowConfirm = this.getView().getPageCache().get("isShowComfirm");
        if ("true".equals(isShowConfirm)) {
            return;
        }
        this.getView().getPageCache().put("isShowComfirm", "true");
        SWCDataServiceHelper approveMsgHelper = new SWCDataServiceHelper("hsas_approveschememsg");
        QFilter tplFilter = ApproveBillTplService.packageTplFilterForSchemeMsg();
        QFilter solvedFilter = new QFilter("issolved", "=", (Object)Boolean.FALSE);
        DynamicObject[] approveMsgArr = approveMsgHelper.query("id,creator.id,modifytime,modifier.id,issolved,approvebilltpl.schemeentryentity,reportscheme", new QFilter[]{solvedFilter, tplFilter});
        if (null == approveMsgArr || 0 == approveMsgArr.length) {
            return;
        }
        Date modifyTime = new Date();
        ArrayList ignoreList = Lists.newArrayListWithExpectedSize((int)approveMsgArr.length);
        block0: for (DynamicObject msg : approveMsgArr) {
            DynamicObject approveBillTpl = msg.getDynamicObject("approvebilltpl");
            DynamicObjectCollection schemeEntryEntity = approveBillTpl.getDynamicObjectCollection("schemeentryentity");
            for (DynamicObject schm : schemeEntryEntity) {
                if (schm.getLong("reportscheme.id") != msg.getLong("reportscheme.id")) continue;
                continue block0;
            }
            msg.set("issolved", (Object)Boolean.TRUE);
            msg.set("modifytime", (Object)modifyTime);
            ignoreList.add(msg);
        }
        if (!ignoreList.isEmpty()) {
            approveMsgHelper.update(ignoreList.toArray(new DynamicObject[0]));
            if (ignoreList.size() == approveMsgArr.length) {
                return;
            }
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hsas_approveschemecomfirm");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_approveschemecomfirm"));
        String pageId = formShowParameter.getPageId();
        this.getView().getPageCache().put("confirmPageId", pageId);
        this.getView().showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        switch (key) {
            case "referenceap": {
                this.setListShowParam("hsas_apvreferencelist");
                break;
            }
            case "managesharedap": {
                this.setListShowParam("hsas_apveditsharelist");
                break;
            }
            case "viewdetail": {
                ListSelectedRow currrentRow = listView.getCurrentSelectedRowInfo();
                Long pkId = Long.valueOf(currrentRow.getPrimaryKeyValue().toString());
                BaseShowParameter formShowParameter = new BaseShowParameter();
                formShowParameter.setFormId("hsas_approvebilltpl");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setPkId((Object)pkId);
                formShowParameter.setStatus(OperationStatus.VIEW);
                formShowParameter.setCustomParam("viewdetail", (Object)"viewdetail");
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        ArrayList<Long> pkIdList = new ArrayList<Long>(10);
        for (ListSelectedRow row : selectedRows) {
            Long pkId = (Long)row.getPrimaryKeyValue();
            pkIdList.add(pkId);
        }
        switch (key) {
            case "shareCheck": {
                this.shareCheckClose(messageBoxClosedEvent, pkIdList);
                break;
            }
            case "cancelShareCheck": {
                this.cancelShareCheckClose(messageBoxClosedEvent, pkIdList);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        Map returnData = (Map)event.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = event.getActionId()) {
            case "hsas_apvreferencelist": {
                this.referenceCancelListClose(returnData);
                break;
            }
            case "hsas_apveditsharelist": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "hsas_approveschemecomfirm": {
                this.showApproveSchemeMsgList(returnData);
                break;
            }
        }
    }

    private void showApproveSchemeMsgList(Map<String, Object> returnData) {
        String showDetail = (String)returnData.get("showdetail");
        if ("showdetail".equals(showDetail)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hsas_approveschememodify");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().getPageCache().put("approveSchemeMsgListPageId", formShowParameter.getPageId());
            this.getView().showForm(formShowParameter);
        }
    }

    private void cancelShareCheckClose(MessageBoxClosedEvent messageBoxClosedEvent, List<Long> pkIdList) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            int notShareNum = ApproveSettingHelper.setShareScheme(pkIdList);
            int size = pkIdList.size();
            if (0 < notShareNum) {
                FormShowParameter parameters = ApproveSettingHelper.getOperationResultParameter((String)MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u4efd\u5ba1\u6279\u5355\u6a21\u677f\uff0c{1}\u4efd\u53d6\u6d88\u5171\u4eab\u6210\u529f\uff0c{2}\u4efd\u8fd8\u672a\u5171\u4eab\uff0c\u65e0\u9700\u53d6\u6d88\u5171\u4eab\u3002", (String)"CalApproveBillTplEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), size, size - notShareNum, notShareNum));
                this.getView().showForm(parameters);
            } else {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u5171\u4eab\u6210\u529f", (String)"CalApproveBillTplEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void shareCheckClose(MessageBoxClosedEvent messageBoxClosedEvent, List<Long> pkIdList) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            int shareNum = ApproveSettingHelper.setHasShareScheme(pkIdList);
            int total = pkIdList.size();
            if (0 < shareNum) {
                FormShowParameter parameters = ApproveSettingHelper.getOperationResultParameter((String)MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u4efd\u5ba1\u6279\u5355\u6a21\u677f\uff0c{1}\u4efd\u5171\u4eab\u6210\u529f\uff0c{2}\u4efd\u5df2\u5171\u4eab\uff0c\u65e0\u9700\u518d\u6b21\u5171\u4eab\u3002", (String)"CalApproveBillTplEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), total, total - shareNum, shareNum));
                this.getView().showForm(parameters);
            } else {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5171\u4eab\u6210\u529f", (String)"CalApproveBillTplEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void referenceCancelListClose(Map<String, Object> returnData) {
        String operation = (String)returnData.get("operation");
        if ("savereference".equals(operation)) {
            this.copyApvBillTpl(returnData);
        } else {
            this.showApvBillTpl(returnData);
        }
        this.getView().invokeOperation("refresh");
    }

    private void copyApvBillTpl(Map<String, Object> returnData) {
        String name = (String)returnData.get("operaresultName");
        Long id = (Long)returnData.get("operaresultId");
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hsas_approvebilltpl");
        showParameter.setPkId((Object)id);
        showParameter.setCustomParam("name", (Object)name);
        showParameter.setCustomParam("iscopy", (Object)Boolean.TRUE);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showApvBillTpl(Map<String, Object> returnData) {
        String name = (String)returnData.get("operaresultName");
        Long id = (Long)returnData.get("operaresultId");
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hsas_approvebilltpl");
        showParameter.setPkId((Object)id);
        showParameter.setCaption(name);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setListShowParam(String formId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId(formId);
        listShowParameter.setBillFormId("hsas_approvebilltplf7");
        listShowParameter.setLookUp(true);
        if ("hsas_apvreferencelist".equals(formId)) {
            listShowParameter.setMultiSelect(false);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5f15\u7528\u5ba1\u6279\u5355\u636e\u5171\u4eab\u6a21\u677f", (String)"CalApproveBillTplEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        } else {
            listShowParameter.setMultiSelect(true);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u7ba1\u7406\u5ba1\u6279\u5355\u636e\u5171\u4eab\u6a21\u677f", (String)"CalApproveBillTplEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter filter = new QFilter("issharescheme", "=", (Object)Boolean.TRUE);
        filter.and(new QFilter("iseffect", "=", (Object)Boolean.TRUE));
        listFilterParameter.setFilter(filter);
        listShowParameter.setListFilterParameter(listFilterParameter);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

