/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bankcardoperating;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class BankCardOperatingPlugin
extends SWCDataBaseList {
    private static final String KEY_ID = "id";
    private static final String KEY_BILL_FORM_ID = "BillFormId";
    private static final String KEY_OP_VIEWBANKCARD = "donothing_viewbankcard";
    private static final String KEY_OP_IMPORTBANKCARD = "donothing_importbankcard";
    private static final String KEY_OP_BANKCARDIMPORTDETAILS = "donothing_bankcardimportdetails";
    private static final String KEY_OP_OPERATE_KEY = "OperateKey";
    private static final String KEY_EMPLOYEE_ID = "employee.id";
    private static final String KEY_BOS_LIST = "bos_list";
    private static final String KEY_BOS_IMPORTLOG = "bos_importlog";
    private static final String KEY_NAME = "name";
    private static final String KEY_BILLNO = "billno";
    private static final String KEY_SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static final String KEY_HRPI_PERBANKCARD = "hrpi_perbankcard";
    private static final String KEY_BANK_CARD_OPERATING_PLUGIN_0 = "BankCardOperatingPlugin_0";
    private static final String KEY_BANK_CARD_OPERATING_PLUGIN_1 = "BankCardOperatingPlugin_1";
    private static final String KEY_BANK_CARD_OPERATING_PLUGIN_2 = "BankCardOperatingPlugin_2";
    private static final String KEY_BANK_CARD_OPERATING_PLUGIN_3 = "BankCardOperatingPlugin_3";
    private static final String KEY_BANK_CARD_OPERATING_PLUGIN_4 = "BankCardOperatingPlugin_4";
    private static final String KEY_BANK_CARD_OPERATING_PLUGIN_5 = "BankCardOperatingPlugin_5";
    private static final String KEY_BANK_CARD_OPERATING_PLUGIN_6 = "BankCardOperatingPlugin_6";
    private static final String KEY_BANK_CARD_OPERATING_PLUGIN_7 = "BankCardOperatingPlugin_7";
    private static final String KEY_IMPORT_PLUGIN = "ImportPlugin";
    private static final String KEY_PLUGIN_ADDRESS = "kd.swc.hsas.formplugin.web.salaryfile.PersonBankCardImportPlugin";
    private static final String KEY_LIST_NAME = "ListName";
    private static final String KEY_BANK_CARD_IMPORT_PERM_ID = "2=R54LBNB728";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_importbankcard": {
                this.importBankCard();
                break;
            }
            case "donothing_bankcardimportdetails": {
                this.bankCardImportDetails();
                break;
            }
            case "donothing_viewbankcard": {
                this.viewBankCard();
                args.setCancel(true);
                break;
            }
        }
    }

    private void importBankCard() {
        FormShowParameter importFormShowParameter = new FormShowParameter();
        importFormShowParameter.setCustomParam(KEY_BILL_FORM_ID, (Object)"hsas_perbankcardtransfer");
        importFormShowParameter.setFormId("hsas_importbankcard");
        importFormShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        importFormShowParameter.setCustomParam(KEY_OP_OPERATE_KEY, (Object)KEY_OP_IMPORTBANKCARD);
        importFormShowParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u5361\u5bfc\u5165\u8d77\u59cb\u9875\u9762", (String)KEY_BANK_CARD_OPERATING_PLUGIN_0, (String)KEY_SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
        importFormShowParameter.setCustomParam(KEY_IMPORT_PLUGIN, (Object)KEY_PLUGIN_ADDRESS);
        importFormShowParameter.setCustomParam(KEY_LIST_NAME, (Object)ResManager.loadKDString((String)"\u94f6\u884c\u5361", (String)KEY_BANK_CARD_OPERATING_PLUGIN_1, (String)KEY_SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
        importFormShowParameter.setCustomParam("RealPermissionEntityId", (Object)"hsas_salaryfile");
        importFormShowParameter.setCustomParam("ServiceAppId", (Object)"hsas");
        importFormShowParameter.setCustomParam("CheckRightAppId", (Object)"hsas");
        importFormShowParameter.setCustomParam("PermissionItemId", (Object)KEY_BANK_CARD_IMPORT_PERM_ID);
        importFormShowParameter.setCustomParam("OperateName", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u94f6\u884c\u5361", (String)KEY_BANK_CARD_OPERATING_PLUGIN_7, (String)KEY_SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
        this.getView().showForm(importFormShowParameter);
    }

    private void bankCardImportDetails() {
        ListShowParameter importDetailsShowParameter = new ListShowParameter();
        importDetailsShowParameter.setBillFormId(KEY_BOS_IMPORTLOG);
        importDetailsShowParameter.setFormId(KEY_BOS_LIST);
        importDetailsShowParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u5361\u5bfc\u5165\u7ed3\u679c", (String)KEY_BANK_CARD_OPERATING_PLUGIN_2, (String)KEY_SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
        importDetailsShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String mainEntityName = EntityMetadataCache.getDataEntityType((String)"hsas_perbankcardtransfer").getDisplayName().toString();
        QFilter filter = new QFilter(KEY_NAME, "=", (Object)mainEntityName);
        String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\u94f6\u884c\u5361{1}", (String)"BankCardOperatingPlugin_8", (String)KEY_SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), "IMPORT-", "-%");
        filter.and(KEY_BILLNO, "like", (Object)msg);
        ListFilterParameter filterParameter = new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{filter}), null);
        importDetailsShowParameter.setListFilterParameter(filterParameter);
        this.getView().showForm((FormShowParameter)importDetailsShowParameter);
    }

    private void viewBankCard() {
        DynamicObject[] salaryFileResults;
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId(KEY_BOS_LIST);
        listShowParameter.setBillFormId("hsas_perbankcardinsf");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Long currUserId = RequestContext.get().getCurrUserId();
        String viewId = "47150e89000000ac";
        boolean viewPermission = SWCPermissionServiceHelper.hasPerm((long)currUserId, (String)"hsas_perbankcardinsf", (String)viewId);
        if (!viewPermission) {
            String errorMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u94f6\u884c\u5361\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)KEY_BANK_CARD_OPERATING_PLUGIN_3, (String)KEY_SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u94f6\u884c\u5361\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", KEY_BANK_CARD_OPERATING_PLUGIN_3, KEY_SWC_HSAS_FORMPLUGIN);
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)KEY_OP_VIEWBANKCARD, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            return;
        }
        ArrayList<Long> salaryIdlist = new ArrayList<Long>(16);
        HashSet<Long> employeeSet = new HashSet<Long>(16);
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            Long salaryId = (Long)selectedRow.getPrimaryKeyValue();
            salaryIdlist.add(salaryId);
        }
        SWCDataServiceHelper salaryHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter salaryFilter = new QFilter(KEY_ID, "in", salaryIdlist);
        for (DynamicObject salaryFileResult : salaryFileResults = salaryHelper.query(KEY_EMPLOYEE_ID, new QFilter[]{salaryFilter})) {
            Long employeeId = salaryFileResult.getLong(KEY_EMPLOYEE_ID);
            employeeSet.add(employeeId);
        }
        QFilter personFilter = new QFilter(KEY_EMPLOYEE_ID, "in", employeeSet);
        personFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        listShowParameter.getListFilterParameter().setFilter(personFilter);
        SWCDataServiceHelper nullBankCardHelper = new SWCDataServiceHelper(KEY_HRPI_PERBANKCARD);
        DynamicObject[] nullQuery = nullBankCardHelper.query(new QFilter[]{personFilter});
        if (nullQuery.length == 0) {
            String nullBankCardError = ResManager.loadKDString((String)"\u9009\u4e2d\u6863\u6848\u6240\u5c5e\u7684\u8ba1\u85aa\u4eba\u5458\u672a\u7ef4\u62a4\u94f6\u884c\u5361\uff0c\u65e0\u5bf9\u5e94\u53ef\u67e5\u8be2\u6570\u636e\u3002", (String)KEY_BANK_CARD_OPERATING_PLUGIN_4, (String)KEY_SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showTipNotification(nullBankCardError);
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u9009\u4e2d\u6863\u6848\u6240\u5c5e\u7684\u8ba1\u85aa\u4eba\u5458\u672a\u7ef4\u62a4\u94f6\u884c\u5361\uff0c\u65e0\u5bf9\u5e94\u53ef\u67e5\u8be2\u6570\u636e\u3002", KEY_BANK_CARD_OPERATING_PLUGIN_4, KEY_SWC_HSAS_FORMPLUGIN);
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)KEY_OP_VIEWBANKCARD, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            return;
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
        MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u67e5\u770b\u94f6\u884c\u5361\u6210\u529f\u3002", KEY_BANK_CARD_OPERATING_PLUGIN_6, KEY_SWC_HSAS_FORMPLUGIN);
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)KEY_OP_VIEWBANKCARD, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
    }
}

