/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bankoffer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsas.business.approve.ApproveSettingHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BankOfferDSelectConPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Search treeColumnSearch = (Search)this.getView().getControl("treesearchap");
        treeColumnSearch.addEnterListener((SearchEnterListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.buildSelectValueTree();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control sControl = (Control)evt.getSource();
        switch (sControl.getKey()) {
            case "btnok": {
                String nodeStr = this.getView().getPageCache().get("selectField");
                if (StringUtils.isBlank((CharSequence)nodeStr)) {
                    this.getView().close();
                    return;
                }
                TreeNode node = (TreeNode)SerializationUtils.deSerializeFromBase64((String)nodeStr);
                TreeNode rootNode = this.getSelectRootNode(node);
                HashMap<String, String> selectMap = new HashMap<String, String>(16);
                selectMap.put("fieldselect", node.getId());
                selectMap.put("fieldvalue", node.getText());
                selectMap.put("fieldquerytable", rootNode == null ? "" : rootNode.getId());
                this.getView().returnDataToParent(selectMap);
                this.getView().close();
                break;
            }
        }
    }

    private void buildSelectValueTree() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        this.buildApproveTreeNodes(treeView);
        this.getModel().setDataChanged(false);
    }

    private void buildApproveTreeNodes(TreeView treeView) {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hsas_bankofferexport");
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        TreeNode payDetailNode = new TreeNode("", queryEntityType.getName(), ResManager.loadKDString((String)"\u53d1\u653e\u660e\u7ec6", (String)"BankOfferTpl_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        payDetailNode.setIsOpened(true);
        treeNodes.add(payDetailNode);
        treeNodes.addAll(this.assemblePayDetailTreeNodeText(queryEntityType, payDetailNode));
        QueryEntityType personEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hsas_bankofferexport_person");
        TreeNode personNode = new TreeNode("", personEntityType.getName(), ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f", (String)"BankOfferTpl_24", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        personNode.setIsOpened(true);
        treeNodes.add(personNode);
        treeNodes.addAll(this.assemblePayDetailTreeNodeText(personEntityType, personNode));
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map<String, TreeNode> treeNodeMap = treeNodes.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity(), (entity1, entity2) -> entity2));
        pageCache.put("tree", (Object)SerializationUtils.serializeToBase64(treeNodeMap));
        List<TreeNode> rootNodes = this.buildTreeHierarchy(treeNodes, treeNodeMap);
        treeView.addNodes(rootNodes);
        pageCache.put("rootnode", (Object)SerializationUtils.serializeToBase64(rootNodes));
    }

    private List<TreeNode> assemblePayDetailTreeNodeText(QueryEntityType queryEntityType, TreeNode parentNode) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        List joinEntity = queryEntityType.getJoinEntitys();
        ArrayList<String> entityList = new ArrayList<String>(10);
        for (JoinEntity entity : joinEntity) {
            TreeNode node = new TreeNode(parentNode.getId(), entity.getEntityName(), entity.getDisplayName());
            treeNodes.add(node);
            entityList.add(entity.getEntityName());
        }
        List selectFields = queryEntityType.getSelectFields();
        for (QuerySelectField selectField : selectFields) {
            String alias = selectField.getAlias();
            String key = entityList.stream().filter(alias::startsWith).findFirst().orElseGet(() -> ((TreeNode)parentNode).getId());
            TreeNode node = new TreeNode(key, alias, selectField.getDisplayName());
            node.setLeaf(true);
            treeNodes.add(node);
        }
        return treeNodes;
    }

    private List<TreeNode> buildTreeHierarchy(List<TreeNode> treeNodes, Map<String, TreeNode> nodeMap) {
        ArrayList<TreeNode> rootNodes = new ArrayList<TreeNode>(10);
        TreeNode rootNode = new TreeNode();
        rootNode.setIsOpened(true);
        treeNodes.forEach(treeNode -> {
            TreeNode parentNode = (TreeNode)nodeMap.get(treeNode.getParentid());
            if (parentNode == null) {
                treeNode.setParentid("");
                rootNodes.add((TreeNode)treeNode);
            } else {
                parentNode.addChild(treeNode);
            }
        });
        return rootNodes;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        String allTreeNodeStr = (String)swcPageCache.get("tree", String.class);
        Map nodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)allTreeNodeStr);
        if (nodeMap != null && !nodeMap.isEmpty()) {
            TreeNode node = (TreeNode)nodeMap.get(nodeId);
            if (node.isLeaf()) {
                this.getView().getPageCache().put("selectField", SerializationUtils.serializeToBase64((Object)node));
            } else {
                this.getView().getPageCache().put("selectField", null);
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        Search search = (Search)searchEnterEvent.getSource();
        String key = search.getKey();
        if ("treesearchap".equals(key)) {
            ApproveSettingHelper.searchTreeNode((String)searchText, (IFormView)this.getView(), (boolean)true);
        }
    }

    private TreeNode getSelectRootNode(TreeNode node) {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        String allTreeNodeStr = (String)swcPageCache.get("tree", String.class);
        Map nodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)allTreeNodeStr);
        TreeNode treeNode = (TreeNode)nodeMap.get(node.getParentid());
        while (treeNode != null && SWCStringUtils.isNotEmpty((String)treeNode.getParentid())) {
            treeNode = (TreeNode)nodeMap.get(treeNode.getParentid());
        }
        return treeNode;
    }
}

