/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bankoffer;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsas.business.cal.helper.CreateDynamicEntryHelper;
import kd.swc.hsas.common.constants.BankOfferConstants;

public class BankOfferExcelPreviewPlugin
extends AbstractFormPlugin {
    private static final String EMPTY = "";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs metasArgs) {
        super.loadCustomControlMetas(metasArgs);
        FormShowParameter formShowParameter = (FormShowParameter)metasArgs.getSource();
        String maxCol = (String)formShowParameter.getCustomParam("maxCol");
        if (StringUtils.isBlank((CharSequence)maxCol)) {
            return;
        }
        EntryAp entryAp = this.createEntryAp(Integer.valueOf(maxCol));
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        metasArgs.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        String maxCol = (String)this.getView().getFormShowParameter().getCustomParam("maxCol");
        if (StringUtils.isBlank((CharSequence)maxCol)) {
            return;
        }
        MainEntityType oldMainType = args.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        Integer cols = Integer.valueOf(maxCol);
        Integer i = 1;
        while (i <= cols) {
            String colName = BankOfferExcelPreviewPlugin.convertToColName(i);
            TextProp textProp = new TextProp();
            textProp.setDisplayName(new LocaleString(colName));
            textProp.setName("excel" + colName);
            textProp.setDbIgnore(true);
            textProp.setAlias(EMPTY);
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        args.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String maxCol = (String)this.getView().getFormShowParameter().getCustomParam("maxCol");
        if (StringUtils.isBlank((CharSequence)maxCol)) {
            return;
        }
        EntryAp entryAp = this.createEntryAp(Integer.valueOf(maxCol));
        this.buildRuntimeControl(entryAp);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
    }

    public void createNewData(BizDataEventArgs args) {
        this.createExcelRowsOverView(args);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
        String maxCol = (String)this.getView().getFormShowParameter().getCustomParam("maxCol");
        if (StringUtils.isBlank((CharSequence)maxCol)) {
            return;
        }
        Integer cols = Integer.valueOf(maxCol);
        if (cols < BankOfferConstants.COL_SEVEN) {
            cols = BankOfferConstants.COL_SEVEN;
        }
        for (int i = 1; i <= cols; ++i) {
            String colName = BankOfferExcelPreviewPlugin.convertToColName(i);
            fieldMap.put("o", EMPTY);
            fieldMap.put("k", "excel" + colName.toLowerCase());
            fieldMap.put("r", -1);
            fieldMap.put("l", Boolean.FALSE);
            proxy.setLockState("entryentity", fieldMap);
        }
    }

    private void buildRuntimeControl(EntryAp entryAp) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                List items = ((Container)fieldEdit).getItems();
                items.forEach(item -> {
                    item.setView(this.getView());
                    entryGrid.getItems().add(item);
                });
                continue;
            }
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    private EntryAp createEntryAp(Integer cols) {
        EntryAp entryAp = CreateDynamicEntryHelper.createEntryAp((String)"entryentity");
        List entryApItems = entryAp.getItems();
        if (cols < BankOfferConstants.COL_SEVEN) {
            cols = BankOfferConstants.COL_SEVEN;
        }
        for (int i = 1; i <= cols; ++i) {
            String colName = BankOfferExcelPreviewPlugin.convertToColName(i);
            EntryFieldAp textFieldAp = CreateDynamicEntryHelper.createTextFieldAp((LocaleString)new LocaleString(colName), (String)("excel" + colName));
            textFieldAp.setWidth(new LocaleString("100px"));
            textFieldAp.setLock(EMPTY);
            entryApItems.add(textFieldAp);
        }
        return entryAp;
    }

    private void createExcelRowsOverView(BizDataEventArgs eventArgs) {
        DynamicObject newRow;
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection excelCollection = this.getView().getParentView().getModel().getEntryEntity("exceltitleent");
        for (DynamicObject excelDy : excelCollection) {
            newRow = new DynamicObject(rows.getDynamicObjectType());
            DynamicObjectCollection headContentCollection = excelDy.getDynamicObjectCollection("headcontententity");
            Boolean isEmpty = excelDy.getBoolean("isempty");
            if (Boolean.FALSE.equals(isEmpty)) {
                for (DynamicObject headContentDy : headContentCollection) {
                    String subContent = headContentDy.getString("subheadcontent");
                    String selectField = headContentDy.getString("selectfield");
                    String filedShowType = headContentDy.getString("fieldshowtype");
                    String showValue = EMPTY;
                    String headType = headContentDy.getString("headtype");
                    if ("1".equals(headType)) {
                        if ("2".equals(filedShowType)) {
                            showValue = (String)BankOfferHelper.getFieldToDemoMap().get(selectField);
                        } else {
                            String name = subContent.split("\\.")[0];
                            showValue = name + "\uff1a" + (String)BankOfferHelper.getFieldToDemoMap().get(selectField);
                        }
                    } else {
                        showValue = subContent;
                    }
                    newRow.set("excel" + headContentDy.getString("collocation").toUpperCase(), (Object)showValue);
                }
            }
            rows.add((Object)newRow);
        }
        int needAddRows = BankOfferConstants.ROW_TEN - excelCollection.size();
        for (int i = 0; i < needAddRows; ++i) {
            newRow = new DynamicObject(rows.getDynamicObjectType());
            rows.add((Object)newRow);
        }
        eventArgs.setDataEntity((Object)dataEntity);
    }

    public static String convertToColName(int colIndex) {
        StringBuilder strRtn = new StringBuilder();
        if (colIndex <= 0) {
            return EMPTY;
        }
        int numTemp = colIndex;
        while (numTemp > 0) {
            char ch;
            int numMod = numTemp % 26;
            numTemp /= 26;
            if (numMod == 0) {
                ch = 'Z';
                --numTemp;
            } else {
                ch = (char)(65 + numMod - 1);
            }
            strRtn.insert(0, ch);
        }
        return strRtn.toString();
    }
}

