/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.accountconfig;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hsas.common.constants.PaySalaryAccountConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PaySalaryAccountConfigBasePlugin
extends SWCDataBaseEdit
implements PaySalaryAccountConstants,
BeforeF7SelectListener {
    private static final String SALARYITEMBACK = "donothing_salaryitem";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("oppaysubject");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("opentryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            Object source = pkEvent.getSource();
            int seq = pkEvent.getRowData().getInt("seq");
            if (source instanceof DecimalEdit) {
                String payWay = pkEvent.getRowData().getString("oppaymentway");
                if ("oppayamount".equals(((DecimalEdit)source).getKey())) {
                    if ("0".equals(payWay)) {
                        ((DecimalEdit)source).setEnable("", false, seq - 1);
                    } else {
                        ((DecimalEdit)source).setEnable("", true, seq - 1);
                    }
                }
                if ("oppayscale".equals(((DecimalEdit)source).getKey())) {
                    if ("0".equals(payWay)) {
                        ((DecimalEdit)source).setEnable("", true, seq - 1);
                    } else {
                        ((DecimalEdit)source).setEnable("", false, seq - 1);
                    }
                }
            }
            if (source instanceof ComboEdit) {
                Long payKindId = pkEvent.getRowData().getLong("oppaytype.paycategory.id");
                if ("opbankpurposeshow".equals(((ComboEdit)source).getKey())) {
                    if (!PaySalaryAccountConstants.NEEDBANKCARDIDS.contains(payKindId)) {
                        ((ComboEdit)source).setEnable("", false, seq - 1);
                    } else {
                        ((ComboEdit)source).setEnable("", true, seq - 1);
                    }
                }
                if ("oppayrollacrelationshow".equals(((ComboEdit)source).getKey())) {
                    if (!PaySalaryAccountConstants.NEEDBANKCARDIDS.contains(payKindId)) {
                        ((ComboEdit)source).setEnable("", false, seq - 1);
                    } else {
                        ((ComboEdit)source).setEnable("", true, seq - 1);
                    }
                }
            }
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String control = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (control) {
            case "oppaysubject": {
                Long countryId = this.getModel().getDataEntity().getLong("country.id");
                QFilter filter = new QFilter("country.id", "=", (Object)countryId);
                Long useOrgId = this.getModel().getDataEntity().getLong("useorg.id");
                filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"hsbs_paysubject", (Long)useOrgId));
                showParameter.getListFilterParameter().setFilter(filter);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity;
        int size;
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (SWCStringUtils.equals((String)opKey, (String)"newentry") && (size = (entryEntity = this.getModel().getEntryEntity("opentryentity")).size()) > 0) {
            DynamicObject dynamicObjects = (DynamicObject)entryEntity.get(size - 1);
            DynamicObject payType = dynamicObjects.getDynamicObject("oppaytype");
            DynamicObject relation = dynamicObjects.getDynamicObject("oppayrollacrelationdata");
            if (payType == null) {
                this.getModel().setValue("oppaytype", null, size - 1);
            }
            if (relation == null) {
                this.getModel().setValue("oppayrollacrelation", (Object)"0", size - 1);
                this.getModel().setValue("oppayrollacrelationdata", null, size - 1);
                this.getPageCache().put("isNotChange", "true");
                this.getModel().setValue("oppayrollacrelationshow", (Object)"0", size - 1);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        Object newObj = e.getChangeSet()[0].getNewValue();
        String newValue = newObj != null ? newObj.toString() : null;
        Object oldObj = e.getChangeSet()[0].getOldValue();
        String oldValue = oldObj != null ? oldObj.toString() : null;
        switch (fieldKey) {
            case "opsalaryitemshow": {
                this.dealSalaryItemChange(newValue, oldValue);
                break;
            }
            case "oppaycurrencyshow": {
                String formId = "bd_currency";
                this.dealChange(fieldKey, newValue, oldValue, formId, "oppaycurrency");
                break;
            }
            case "oppaymentway": {
                this.dealPayWayChange(newValue);
                break;
            }
            case "oppaytype": {
                this.dealPayTypeChange(newValue);
                break;
            }
            case "opbankpurposeshow": {
                String formId = "hbss_bankpurpose";
                this.dealChange(fieldKey, newValue, oldValue, formId, "opbankpurpose");
                break;
            }
            case "oppayrollacrelationshow": {
                String isNotChange = this.getPageCache().get("isNotChange");
                if (SWCStringUtils.isNotEmpty((String)isNotChange)) {
                    this.getPageCache().remove("isNotChange");
                    return;
                }
                String formId = "hbss_payrollacrelation";
                this.dealChange(fieldKey, newValue, oldValue, formId, "oppayrollacrelation");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "opsalaryitemshow": 
            case "oppaycurrencyshow": 
            case "opbankpurposeshow": 
            case "oppayrollacrelationshow": {
                this.setRowValue(actionId, event);
                break;
            }
        }
    }

    private void dealSalaryItemChange(String newValue, String oldValue) {
        String formId = "hsbs_salaryitem";
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int index = proxy.getEntryState("opentryentity").getFocusRow();
        if (StringUtils.equals((CharSequence)"1", (CharSequence)newValue)) {
            this.showF7SelectListForm("opsalaryitemshow", formId);
            this.getView().getPageCache().put("opsalaryitemshow", oldValue);
            this.getView().getPageCache().put("opsalaryitemshowIndex", String.valueOf(index));
        } else {
            this.getModel().beginInit();
            if (-1 == index) {
                this.getModel().endInit();
                this.getView().updateView("opentryentity");
                return;
            }
            this.getModel().setValue("opsalaryitem", (Object)newValue, index);
            this.getModel().setValue("opsalaryitemdata", (Object)"", index);
            this.getModel().endInit();
            this.getView().updateView("opentryentity", index);
        }
    }

    private void dealPayWayChange(String payWayNew) {
        if (null != payWayNew) {
            this.getModel().beginInit();
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            int index = proxy.getEntryState("opentryentity").getFocusRow();
            if (-1 == index) {
                this.getModel().endInit();
                return;
            }
            if ("0".equals(payWayNew)) {
                this.getModel().setValue("oppayamount", null, index);
            } else if ("1".equals(payWayNew)) {
                DynamicObject amountSetting;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("opentryentity");
                if (!this.checkIsHavePayProportionSalaryItem(entryEntity, amountSetting = (DynamicObject)entryEntity.get(index))) {
                    this.getModel().createNewEntryRow("opentryentity", index + 1, null);
                    this.setPayProportionEntryData(amountSetting, index + 1);
                    proxy.getEntryState("opentryentity").setFocusRow(index + 1);
                }
                this.getModel().setValue("oppayscale", null, index);
                if ("0".equals(this.getModel().getValue("oppaycurrency"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u7ef4\u62a4\u7684\u53d1\u653e\u91d1\u989d\u5c0f\u6570\u4f4d\u4e0d\u8d85\u8fc7\u6838\u7b97\u5e01\u79cd\u7cbe\u5ea6\u8981\u6c42\uff0c\u5426\u5219\u5c06\u5f71\u54cd\u540e\u7eed\u751f\u6210\u53d1\u653e\u8bbe\u7f6e\u3002", (String)"PayAccountUseConfigPlugin_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                }
            }
            this.getModel().endInit();
            this.getView().updateView("opentryentity");
        }
    }

    private void dealPayTypeChange(String payTypeNew) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int index = proxy.getEntryState("opentryentity").getFocusRow();
        if (null != payTypeNew) {
            if (-1 == index) {
                this.getModel().endInit();
                this.getView().updateView("opentryentity");
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("opentryentity");
            DynamicObject amountSetting = (DynamicObject)entryEntity.get(index);
            Long payCategoryId = amountSetting.getLong("oppaytype.paycategory.id");
            if (!PaySalaryAccountConstants.NEEDBANKCARDIDS.contains(payCategoryId)) {
                this.getModel().setValue("opbankpurposeshow", (Object)"", index);
                this.getModel().setValue("opbankpurpose", (Object)"", index);
                this.getModel().setValue("opbankpurposedata", null, index);
                this.getModel().setValue("oppayrollacrelationshow", (Object)"", index);
                this.getModel().setValue("oppayrollacrelation", (Object)"", index);
                this.getModel().setValue("oppayrollacrelationdata", null, index);
            }
        }
        this.getModel().endInit();
        this.getView().updateView("opentryentity", index);
    }

    private void dealChange(String fieldKey, String newValue, String oldValue, String formId, String field) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int index = proxy.getEntryState("opentryentity").getFocusRow();
        if (StringUtils.equals((CharSequence)"1", (CharSequence)newValue)) {
            this.getView().getPageCache().put(fieldKey, oldValue);
            this.getView().getPageCache().put(fieldKey + "Index", String.valueOf(index));
            this.showF7SelectListForm(fieldKey, formId);
        } else {
            if ("oppaycurrencyshow".equals(fieldKey) && "1".equals(this.getModel().getValue("oppaymentway", index))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u7ef4\u62a4\u7684\u53d1\u653e\u91d1\u989d\u5c0f\u6570\u4f4d\u4e0d\u8d85\u8fc7\u6838\u7b97\u5e01\u79cd\u7cbe\u5ea6\u8981\u6c42\uff0c\u5426\u5219\u5c06\u5f71\u54cd\u540e\u7eed\u751f\u6210\u53d1\u653e\u8bbe\u7f6e\u3002", (String)"PayAccountUseConfigPlugin_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
            this.getModel().beginInit();
            if (-1 == index) {
                this.getModel().endInit();
                this.getView().updateView("opentryentity");
                return;
            }
            this.getModel().setValue(field + "data", (Object)"", index);
            this.getModel().setValue(field, (Object)newValue, index);
            this.getView().updateView("opentryentity", index);
        }
    }

    private boolean checkIsHavePayProportionSalaryItem(DynamicObjectCollection entryEntity, DynamicObject amountSetting) {
        String salaryMark = amountSetting.getString("opsalaryitem");
        Long salaryItemId = amountSetting.getLong("opsalaryitemdata.id");
        Optional<DynamicObject> optional = entryEntity.stream().filter(e -> SWCStringUtils.equals((String)salaryMark, (String)e.getString("opsalaryitem")) && salaryItemId.equals(e.getLong("opsalaryitemdata.id")) && "0".equals(e.getString("oppaymentway"))).findAny();
        return optional.isPresent();
    }

    private void setRowValue(String actionId, ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
        this.getModel().beginInit();
        int index = Integer.parseInt(this.getView().getPageCache().get(actionId + "Index"));
        if (-1 == index) {
            this.getModel().endInit();
            return;
        }
        if (selectedRows != null && !selectedRows.isEmpty()) {
            ListSelectedRow selectedRow = selectedRows.get(0);
            this.getModel().setValue(actionId, (Object)selectedRow.getName());
            String data = actionId.replace("show", "");
            this.getModel().setValue(data, (Object)"1", index);
            this.getModel().setValue(data + "data", selectedRow.getPrimaryKeyValue(), index);
        } else {
            String oldName = this.getView().getPageCache().get(actionId);
            this.getModel().setValue(actionId, (Object)oldName, index);
        }
        this.getModel().endInit();
        this.getView().updateView("opentryentity");
    }

    private void showF7SelectListForm(String sign, String formId) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)formId, (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sign));
        List filterList = showParameter.getListFilterParameter().getQFilters();
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        if ("opsalaryitemshow".equals(sign)) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            Long useOrgId = dataEntity.getLong("useorg.id");
            Long countryId = dataEntity.getLong("country.id");
            filterList.add(BaseDataServiceHelper.getBaseDataFilter((String)formId, (Long)useOrgId));
            filterList.add(new QFilter("country", "in", Arrays.asList(countryId, 0L)));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setPayProportionEntryData(DynamicObject amountSetting, int index) {
        this.getModel().setValue("opsalaryitemshow", (Object)amountSetting.getString("opsalaryitemshow"), index);
        this.getModel().setValue("opsalaryitem", (Object)amountSetting.getString("opsalaryitem"), index);
        this.getModel().setValue("opsalaryitemdata", (Object)amountSetting.getDynamicObject("opsalaryitemdata"), index);
        this.getModel().setValue("oppaycurrencyshow", (Object)amountSetting.getString("oppaycurrencyshow"), index);
        this.getModel().setValue("oppaycurrency", (Object)amountSetting.getString("oppaycurrency"), index);
        this.getModel().setValue("oppaycurrencydata", (Object)amountSetting.getDynamicObject("oppaycurrencydata"), index);
        this.getModel().setValue("oppaymentway", (Object)"0", index);
        this.getModel().setValue("oppayscale", (Object)100, index);
        this.getModel().setValue("oppayamount", (Object)0, index);
        this.getModel().setValue("oppaysubject", (Object)amountSetting.getDynamicObject("oppaysubject"), index);
        this.getModel().setValue("oppaytype", (Object)amountSetting.getDynamicObject("oppaytype"), index);
        this.getModel().setValue("opbankpurposeshow", (Object)amountSetting.getString("opbankpurposeshow"), index);
        this.getModel().setValue("opbankpurpose", (Object)amountSetting.getString("opbankpurpose"), index);
        this.getModel().setValue("opbankpurposedata", (Object)amountSetting.getDynamicObject("opbankpurposedata"), index);
        this.getModel().setValue("oppayrollacrelationshow", (Object)amountSetting.getString("oppayrollacrelationshow"), index);
        this.getModel().setValue("oppayrollacrelation", (Object)amountSetting.getString("oppayrollacrelation"), index);
        this.getModel().setValue("oppayrollacrelationdata", (Object)amountSetting.getDynamicObject("oppayrollacrelationdata"), index);
    }
}

