/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.accountconfig;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.lang.StringUtils;

public class PaySalaryAccountConfigList
extends SWCDataBaseList {
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";
    private static final String IGNORE_VALIDATE = "1";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tbl_auditconfirmchange"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String operateKey;
        FormOperate formOperate = (FormOperate)beforeDoOperationEventArgs.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "audit": 
            case "enable": {
                if (!this.checkMultiSelect(formOperate.getListSelectedData(), beforeDoOperationEventArgs, operateKey)) break;
                this.checkAuditAndEnableData(formOperate.getListSelectedData(), beforeDoOperationEventArgs);
                break;
            }
            case "disable": {
                this.checkDisableData(formOperate.getListSelectedData(), beforeDoOperationEventArgs);
                break;
            }
            case "submit": {
                formOperate.getOption().setVariableValue("ignoreValidate", IGNORE_VALIDATE);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        if (returnData != null && ((Boolean)returnData.get("isOk")).booleanValue()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            switch (actionId) {
                case "audit": {
                    operateOption.setVariableValue("id", returnData.get("id").toString());
                    this.getView().invokeOperation("audit", operateOption);
                    break;
                }
                case "enable": {
                    operateOption.setVariableValue("id", returnData.get("id").toString());
                    this.getView().invokeOperation("enable", operateOption);
                    break;
                }
                case "disable": {
                    operateOption.setVariableValue("isIgnore", returnData.get("isIgnore").toString());
                    operateOption.setVariableValue("num", returnData.get("num") == null ? "" : returnData.get("num").toString());
                    this.getView().invokeOperation("disable", operateOption);
                    break;
                }
            }
            this.getView().invokeOperation("refresh", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ((StringUtils.equals((String)"enable", (String)operateKey) || StringUtils.equals((String)"audit", (String)operateKey)) && args.getOperationResult().isSuccess()) {
            RefObject id = new RefObject();
            FormOperate operate = (FormOperate)args.getSource();
            if (operate.getOption().tryGetVariableValue("id", id)) {
                PaySalarySettingHelper.disableOrEnableBo(Collections.singletonList(Long.parseLong((String)id.getValue())), (boolean)true);
            }
        }
    }

    private DynamicObject getDataById(Long id, SWCDataServiceHelper serviceHelper) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return serviceHelper.queryOne("id,name,useorg,enable,status", new QFilter[]{filter});
    }

    private boolean checkSelectData(String operateKey, ListSelectedRow selectedRow) {
        boolean isLegal = false;
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payaccountcfg");
        DynamicObject data = this.getDataById((Long)selectedRow.getPrimaryKeyValue(), serviceHelper);
        switch (operateKey) {
            case "audit": {
                if (!"B".equals(data.get("status")) || !IGNORE_VALIDATE.equals(data.get("enable"))) break;
                isLegal = true;
                break;
            }
            case "enable": {
                if (!"C".equals(data.get("status")) || !"0".equals(data.get("enable"))) break;
                isLegal = true;
                break;
            }
        }
        return isLegal;
    }

    private boolean checkMultiSelect(ListSelectedRowCollection collection, BeforeDoOperationEventArgs args, String operateKey) {
        if (collection.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u6279\u91cf%s\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PaySalaryAccountConfigList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            msg = StringUtils.equals((String)"audit", (String)operateKey) ? String.format(Locale.ROOT, msg, ResManager.loadKDString((String)"\u5ba1\u6838", (String)"PaySalaryAccountConfigList_6", (String)"swc-hsas-formplugin", (Object[])new Object[0])) : String.format(Locale.ROOT, msg, ResManager.loadKDString((String)"\u542f\u7528", (String)"PaySalaryAccountConfigList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private void checkAuditAndEnableData(ListSelectedRowCollection collection, BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
            ListSelectedRow selectedRow = collection.get(0);
            if (this.checkSelectData(operate.getOperateKey(), selectedRow)) {
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payaccountcfg");
                DynamicObject data = serviceHelper.queryOne("id,name,useorg,country", selectedRow.getPrimaryKeyValue());
                Long useOrgId = data.getLong("useorg.id");
                Long countryId = data.getLong("country.id");
                Long fId = data.getLong("id");
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                QFilter enableFilter = new QFilter("enable", "=", (Object)IGNORE_VALIDATE);
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hsas_payaccountcfg", (Long)useOrgId);
                orgFilter.and(new QFilter("country.id", "=", (Object)countryId));
                QFilter idFilter = new QFilter("id", "!=", (Object)fId);
                QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
                QFilter[] filters = new QFilter[]{statusFilter, enableFilter, orgFilter, idFilter, hisCurrFilter};
                DynamicObject auditData = PaySalarySettingHelper.getAuditAndEnableData((QFilter[])filters);
                if (auditData != null && auditData.getLong("id") != 0L) {
                    this.showEditAuditConfirmForm(auditData, operate.getOperateKey());
                    args.setCancel(true);
                }
            }
        }
    }

    private void checkDisableData(ListSelectedRowCollection collection, BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        RefObject afterConfirm = new RefObject();
        RefObject isIgnore = new RefObject();
        if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
            QFilter hisCurrFilter;
            QFilter enableFilter;
            QFilter statusFilter;
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payaccountcfg");
            QFilter filter = new QFilter("id", "in", (Object)collection.getPrimaryKeyValues());
            DynamicObject[] datas = serviceHelper.query("id,name,useorg,country,enable,status", new QFilter[]{filter, statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)IGNORE_VALIDATE), hisCurrFilter = BaseDataHisHelper.getHisCurrFilter()});
            if (datas.length >= 1 && collection.size() > 1) {
                this.showEditAuditConfirmFormMulti(datas, operate.getOperateKey(), collection.size());
                args.setCancel(true);
            }
            if (datas.length == 1 && collection.size() == 1) {
                this.showEditAuditConfirmForm(datas[0], operate.getOperateKey());
                args.setCancel(true);
            }
        } else if (operate.getOption().tryGetVariableValue("isIgnore", isIgnore)) {
            operate.getOption().setVariableValue("isIgnore", (String)isIgnore.getValue());
        }
    }

    private void showEditAuditConfirmForm(DynamicObject auditData, String actionId) {
        String context;
        FormShowParameter parameters = new FormShowParameter();
        parameters.setFormId("hsas_editauditconfirm");
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        if (StringUtils.equals((String)"disable", (String)actionId)) {
            context = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\uff0c\u82e5\u7981\u7528\u6210\u529f\uff0c\u201c{0}\u201d({1})\u4e0b\u5c06\u65e0\u53ef\u7528\u914d\u7f6e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PaySalaryAccountConfigList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            parameters.setCustomParam("isFtitle", (Object)Boolean.FALSE);
            parameters.setCustomParam("isRadioField", (Object)Boolean.FALSE);
        } else {
            context = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4e0b\u5b58\u5728\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u6570\u636e\uff0c\u662f\u5426\u66ff\u6362\uff1f", (String)"PaySalaryAccountConfigList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            parameters.setCustomParam("isFtitle", (Object)Boolean.TRUE);
            parameters.setCustomParam("isRadioField", (Object)Boolean.FALSE);
            parameters.setCustomParam("id", auditData.get("id"));
        }
        context = MessageFormat.format(context, auditData.get("useorg.name"), auditData.get("country.name"));
        parameters.setCustomParam("context", (Object)context);
        this.getView().showForm(parameters);
    }

    private void showEditAuditConfirmFormMulti(DynamicObject[] auditDatas, String actionId, int num) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.setFormId("hsas_editauditconfirm");
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        String context = "";
        if (StringUtils.equals((String)"disable", (String)actionId)) {
            context = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e2d\u5b58\u5728\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u6570\u636e\u3002\u82e5\u7981\u7528\u6210\u529f\uff0c{0}\u4e0b\u5c06\u6ca1\u6709\u914d\u7f6e\u53ef\u88ab\u4f7f\u7528\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"PaySalaryAccountConfigList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            parameters.setCustomParam("isFtitle", (Object)Boolean.FALSE);
            parameters.setCustomParam("isRadioField", (Object)Boolean.TRUE);
            parameters.setCustomParam("num", (Object)num);
        }
        ArrayList<String> msgList = new ArrayList<String>(auditDatas.length);
        for (DynamicObject auditData : auditDatas) {
            StringBuilder msg = new StringBuilder();
            msg.append(auditData.get("useorg.name")).append('(').append(auditData.get("country.name")).append(')');
            msgList.add(msg.toString());
        }
        context = MessageFormat.format(context, StringUtils.join(msgList, (char)'\u3001'));
        parameters.setCustomParam("context", (Object)context);
        this.getView().showForm(parameters);
    }
}

