/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.accountconfig;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hsas.business.approve.ApproveSettingHelper;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.common.constants.PaySalaryAccountConstants;
import kd.swc.hsas.common.dto.PaySalAccountConfigDTO;
import kd.swc.hsas.formplugin.web.basedata.accountconfig.PaySalaryAccountConfigBasePlugin;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaySalaryAccountConfigPlugin
extends PaySalaryAccountConfigBasePlugin {
    private Log log = LogFactory.getLog(PaySalaryAccountConfigPlugin.class);
    private static final String COUNTRY = "country";
    private static final String AUDIT = "audit";
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";
    private static final String SAVE = "save";
    private static final String CLOSE = "close";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";
    private static final String SPECIALENTITY = "specialentryentity";
    private static final String VIEW = "donothing_view";
    private static final String CHECK = "donothing_check";
    private static final String ADDSPECIAL = "add_special";
    private static final String CALL_BACK_COUNTRY = "call_back_country";
    private static final String CALL_SELECT_COUNTRY = "call_select_country";
    private static final String CALL_BACK_SPECIAL = "call_back_special";
    private static final String CALL_BACK_CHECK_DATA = "call_back_check_data";
    private static final String AUDITCONFIRMCHANGE = "auditconfirmchange";

    @Override
    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(SPECIALENTITY);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
                for (OperationColItem operationColItem : operationColItems) {
                    boolean isModify;
                    String operationKey = operationColItem.getOperationKey();
                    boolean bl = isModify = BillOperationStatus.ADDNEW.equals((Object)billStatus) || BillOperationStatus.EDIT.equals((Object)billStatus) && BaseDataHisHelper.isCurrPage((IFormView)this.getView());
                    if (!isModify && CHECK.equals(operationKey)) {
                        operationColItem.setVisible(false);
                    }
                    if (!isModify || !VIEW.equals(operationKey)) continue;
                    operationColItem.setVisible(false);
                }
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        this.setLabelValue("labelap", ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u6bcf\u4e00\u884c\u89c4\u5219\u90fd\u80fd\u5b9a\u4f4d\u5230\u552f\u4e00\u7684\u94f6\u884c\u5361,\u5426\u5219\u5c06\u5f71\u54cd\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e\u7684\u81ea\u52a8\u751f\u6210\u3002", (String)"PaySalaryAccountConfigPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        switch (operationStatus) {
            case VIEW: 
            case EDIT: {
                this.preloadDefaultRule();
                SWCPageCache cache = new SWCPageCache(this.getView());
                cache.put("specialRuleList", this.preloadSpecialRuleToCache());
                this.getView().updateView(SPECIALENTITY);
                break;
            }
            case ADDNEW: {
                this.preloadDefaultRule();
                this.getModel().setValue("ctrlstrategy", (Object)"7");
                SWCPageCache cache = new SWCPageCache(this.getView());
                cache.put("specialRuleList", this.preloadSpecialRuleToCache());
                this.getView().updateView(SPECIALENTITY);
                break;
            }
        }
        ((ComboEdit)this.getControl("opsalaryitemshow")).setMustInput(true);
        ((ComboEdit)this.getControl("oppaycurrencyshow")).setMustInput(true);
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", COUNTRY});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        Object oldObj = e.getChangeSet()[0].getOldValue();
        switch (fieldKey) {
            case "country": {
                if (this.getModel().getEntryEntity("opentryentity").isEmpty() && this.getModel().getEntryEntity(SPECIALENTITY).isEmpty()) {
                    return;
                }
                this.changeCountry();
                String id = oldObj == null ? null : ((DynamicObject)oldObj).getString("id");
                this.getView().getPageCache().put(COUNTRY, id);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String operateKey;
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "auditconfirmchange": {
                if (SWCStringUtils.isEmpty((String)operate.getOption().getVariableValue("ignoreCheck", null)) && !this.checkData(beforeDoOperationEventArgs, operateKey)) {
                    return;
                }
                if (!AUDITCONFIRMCHANGE.equals(operateKey)) break;
                this.checkAuditAndEnableData(beforeDoOperationEventArgs);
                break;
            }
            case "audit": 
            case "enable": {
                this.checkAuditAndEnableData(beforeDoOperationEventArgs);
                break;
            }
            case "disable": {
                this.checkDisableData(beforeDoOperationEventArgs);
                break;
            }
            case "newentry": 
            case "add_special": {
                if (!this.isNotSelectCountry()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u56fd\u5bb6/\u5730\u533a\u3002", (String)"PaySalaryAccountConfigBasePlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                beforeDoOperationEventArgs.setCancel(true);
                break;
            }
            case "donothing_view": {
                FormShowParameter showParameter = this.getSpecialForm();
                showParameter.setStatus(OperationStatus.VIEW);
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                int index = proxy.getEntryState(SPECIALENTITY).getFocusRow();
                this.openSpecialRuleForm(showParameter, true, index);
                break;
            }
            case "donothing_check": {
                FormShowParameter showParameter = this.getSpecialForm();
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                int index = proxy.getEntryState(SPECIALENTITY).getFocusRow();
                this.openSpecialRuleForm(showParameter, true, index);
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "submit": 
            case "save": 
            case "unsubmit": 
            case "disable": 
            case "audit": 
            case "enable": 
            case "auditconfirmchange": {
                if ("unsubmit".equals(operateKey)) {
                    ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.EDIT);
                }
                OperationResult operationResult = args.getOperationResult();
                RefObject id = new RefObject();
                if (operationResult.isSuccess() && ((FormOperate)args.getSource()).getOption().tryGetVariableValue("id", id)) {
                    PaySalarySettingHelper.disableOrEnableBo(Collections.singletonList(Long.parseLong((String)id.getValue())), (boolean)true);
                }
                this.getView().updateView(SPECIALENTITY);
                break;
            }
            case "add_special": {
                FormShowParameter showParameter = this.getSpecialForm();
                this.openSpecialRuleForm(showParameter, false, this.getModel().getDataEntity(true).getDynamicObjectCollection(SPECIALENTITY).size());
                break;
            }
            case "movesepentryup": 
            case "movesepentrydown": {
                SWCPageCache cache = new SWCPageCache(this.getView());
                cache.put("specialRuleList", this.preloadSpecialRuleToCache());
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "call_back_special": {
                Map returnData = (Map)event.getReturnData();
                if (returnData == null) {
                    return;
                }
                if (!((Boolean)returnData.get("isOk")).booleanValue()) break;
                Integer seq = (Integer)returnData.get("seq");
                SWCPageCache cache = new SWCPageCache(this.getView());
                List specialRuleList = (List)cache.get("specialRuleList", ArrayList.class);
                try {
                    PaySalAccountConfigDTO dto = (PaySalAccountConfigDTO)SWCJSONUtils.cast((String)((String)specialRuleList.get(seq)), PaySalAccountConfigDTO.class);
                    this.setSpecialEntity(seq, dto);
                }
                catch (IOException e) {
                    this.log.info("JSON error");
                }
                break;
            }
            case "audit": 
            case "enable": 
            case "disable": 
            case "auditconfirmchange": {
                Map returnData = (Map)event.getReturnData();
                if (returnData == null) {
                    return;
                }
                if (!((Boolean)returnData.get("isOk")).booleanValue()) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
                operateOption.setVariableValue("ignoreCheck", "1");
                Long id = (Long)returnData.get("id");
                if (id != null) {
                    operateOption.setVariableValue("id", String.valueOf(id));
                }
                this.getView().invokeOperation(actionId, operateOption);
                break;
            }
            case "call_select_country": {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
                this.getModel().beginInit();
                if (selectedRows != null && !selectedRows.isEmpty()) {
                    ListSelectedRow selectedRow = selectedRows.get(0);
                    this.getModel().setValue(COUNTRY, selectedRow.getPrimaryKeyValue());
                }
                this.getModel().endInit();
                this.getView().updateView(COUNTRY);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "call_back_country": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.clearRuleEntry();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue(COUNTRY, (Object)this.getView().getPageCache().get(COUNTRY));
                this.getModel().endInit();
                this.getView().updateView(COUNTRY);
                break;
            }
            case "call_back_check_data": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operation = OperateOption.create();
                operation.setVariableValue("ignoreCheck", "1");
                this.getView().invokeOperation(this.getView().getPageCache().get("operateKey"), operation);
                break;
            }
        }
    }

    private void setSpecialEntity(int seq, PaySalAccountConfigDTO dto) {
        DynamicObjectCollection specialRuleCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(SPECIALENTITY);
        String ruleContent = dto.getPayRuleDetailDTO().getRuleContent();
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleContent, FilterCondition.class);
        List filterRow = filterCondition.getFilterRow();
        String showRuleData = ApproveSettingHelper.getConditionTxt((List)filterRow, (Map)ApproveSettingHelper.getPaySalaryAccountSpRuleMap());
        if (seq >= specialRuleCollection.size()) {
            DynamicObject newData = specialRuleCollection.addNew();
            newData.set("empscope", (Object)showRuleData);
            newData.set("rulecontent", (Object)ruleContent);
            PaySalarySettingHelper.setSpecialRuleDataToSubEntry((int)seq, (PaySalAccountConfigDTO)dto, (IFormView)this.getView());
        } else {
            this.getModel().setValue("empscope", (Object)showRuleData, seq);
            this.getModel().setValue("rulecontent", (Object)ruleContent, seq);
            PaySalarySettingHelper.setSpecialRuleDataToSubEntry((int)seq, (PaySalAccountConfigDTO)dto, (IFormView)this.getView());
        }
        this.getView().updateView(SPECIALENTITY, seq);
    }

    private boolean isNotSelectCountry() {
        return null == this.getModel().getDataEntity().getDynamicObject(COUNTRY);
    }

    private void clearRuleEntry() {
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.deleteEntryData("opentryentity");
        model.deleteEntryData(SPECIALENTITY);
    }

    private void openSpecialRuleForm(FormShowParameter showParameter, boolean isModify, int seq) {
        showParameter.setCustomParam("countryId", (Object)this.getModel().getDataEntity().getLong("country.id"));
        showParameter.setCustomParam("useOrgId", (Object)this.getModel().getDataEntity().getLong("useorg.id"));
        showParameter.setCustomParam("seq", (Object)seq);
        showParameter.setCustomParam("isModify", (Object)isModify);
        this.getView().showForm(showParameter);
    }

    private FormShowParameter getSpecialForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_SPECIAL));
        parameter.setFormId("hsas_payaccountusecfg");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        return parameter;
    }

    private boolean checkData(BeforeDoOperationEventArgs args, String operateKey) {
        boolean isEmpty;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("opentryentity");
        DynamicObjectCollection specialEntity = this.getModel().getEntryEntity(SPECIALENTITY);
        boolean bl = isEmpty = !(entryEntity != null && !entryEntity.isEmpty() || specialEntity != null && !specialEntity.isEmpty());
        if (isEmpty) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u53d1\u653e\u89c4\u5219\u3002", (String)"PaySalaryAccountConfigPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        if (entryEntity == null || entryEntity.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u89c4\u5219\uff0c\u8bf7\u786e\u4fdd\u7279\u6b8a\u89c4\u5219\u5df2\u5305\u542b\u6240\u6709\u4eba\u5458\u3002\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"PaySalaryAccountConfigPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.showSecondForm(msg, operateKey);
            args.setCancel(true);
            return false;
        }
        boolean isAllTarget = entryEntity.stream().noneMatch(obj -> PaySalaryAccountConstants.NOTTARGET.contains(obj.getString("opsalaryitem")));
        if (isAllTarget) {
            String msg = ResManager.loadKDString((String)"\u9ed8\u8ba4\u89c4\u5219\u8bbe\u7f6e\u4e2d\u672a\u5bf9\u201c\u5176\u4ed6\u201d\u5b9e\u53d1\u9879\u76ee\u8fdb\u884c\u8bbe\u7f6e\u3002\u8bf7\u786e\u8ba4\u6240\u6709\u5b9e\u53d1\u9879\u76ee\u90fd\u5df2\u8bbe\u7f6e\uff0c\u907f\u514d\u9057\u6f0f\u3002\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"PaySalaryAccountConfigPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.showSecondForm(msg, operateKey);
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private void showSecondForm(String msg, String operateKey) {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PaySalaryAccountConfigPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"PaySalaryAccountConfigPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmCallBackListener listener = new ConfirmCallBackListener(CALL_BACK_CHECK_DATA);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, listener, btnNameMaps);
        this.getView().getPageCache().put("operateKey", operateKey);
    }

    private void changeCountry() {
        String msg = ResManager.loadKDString((String)"\u5207\u6362\u540e\u5c06\u6e05\u7a7a\u5df2\u914d\u7f6e\u7684\u9ed8\u8ba4\u89c4\u5219\u548c\u7279\u6b8a\u89c4\u5219\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"PaySubjectEdit_BLUE_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PaySalaryAccountConfigPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"PaySalaryAccountConfigPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmCallBackListener listener = new ConfirmCallBackListener(CALL_BACK_COUNTRY);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, listener, btnNameMaps);
    }

    private void checkAuditAndEnableData(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm) && this.checkSelectData(operate.getOperateKey())) {
            Long useOrgId = this.getModel().getDataEntity().getLong("useorg.id");
            Long countryId = this.getModel().getDataEntity().getLong("country.id");
            String number = this.getModel().getDataEntity().getString("number");
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hsas_payaccountcfg", (Long)useOrgId);
            orgFilter.and(new QFilter("country.id", "=", (Object)countryId));
            QFilter idFilter = new QFilter("number", "!=", (Object)number);
            QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
            QFilter[] filters = new QFilter[]{statusFilter, enableFilter, orgFilter, idFilter, hisCurrFilter};
            DynamicObject auditData = PaySalarySettingHelper.getAuditAndEnableData((QFilter[])filters);
            if (auditData != null) {
                this.showEditAuditConfirmForm(auditData, operate.getOperateKey());
                args.setCancel(true);
            }
        }
    }

    private void checkDisableData(BeforeDoOperationEventArgs args) {
        DynamicObject data;
        FormOperate operate = (FormOperate)args.getSource();
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm) && "C".equals((data = this.getModel().getDataEntity()).get("status")) && "1".equals(data.get(ENABLE))) {
            this.showEditAuditConfirmForm(data, operate.getOperateKey());
            args.setCancel(true);
        }
    }

    private boolean checkSelectData(String operateKey) {
        boolean isLegal = false;
        String status = this.getModel().getDataEntity().getString("status");
        String enable = this.getModel().getDataEntity().getString(ENABLE);
        switch (operateKey) {
            case "audit": {
                if (!"B".equals(status) || !"1".equals(enable)) break;
                isLegal = true;
                break;
            }
            case "enable": {
                if (!"C".equals(status) || !"0".equals(enable)) break;
                isLegal = true;
                break;
            }
            case "auditconfirmchange": {
                isLegal = true;
                break;
            }
        }
        return isLegal;
    }

    private void showEditAuditConfirmForm(DynamicObject auditData, String actionId) {
        String context;
        FormShowParameter parameters = new FormShowParameter();
        parameters.setFormId("hsas_editauditconfirm");
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        if (StringUtils.equals((CharSequence)DISABLE, (CharSequence)actionId)) {
            context = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\uff0c\u82e5\u7981\u7528\u6210\u529f\uff0c\u201c{0}\u201d({1})\u4e0b\u5c06\u65e0\u53ef\u7528\u914d\u7f6e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PaySalaryAccountConfigList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            parameters.setCustomParam("isFtitle", (Object)Boolean.FALSE);
            parameters.setCustomParam("isRadioField", (Object)Boolean.FALSE);
        } else {
            context = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4e0b\u5b58\u5728\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u6570\u636e\uff0c\u662f\u5426\u66ff\u6362\uff1f", (String)"PaySalaryAccountConfigList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            parameters.setCustomParam("isFtitle", (Object)Boolean.TRUE);
            parameters.setCustomParam("isRadioField", (Object)Boolean.FALSE);
            parameters.setCustomParam("id", (Object)auditData.getLong("id"));
        }
        context = MessageFormat.format(context, auditData.getString("useorg.name"), auditData.getString("country.name"));
        parameters.setCustomParam("context", (Object)context);
        this.getView().showForm(parameters);
    }

    private void setLabelValue(String fieldKey, String value) {
        Label label = (Label)this.getControl(fieldKey);
        if (!SWCStringUtils.isEmpty((String)value)) {
            label.setText(value);
        }
    }

    private List<String> preloadSpecialRuleToCache() {
        DynamicObjectCollection specialRuleEntity = this.getModel().getEntryEntity(SPECIALENTITY);
        ArrayList<String> specialRuleList = new ArrayList<String>(10);
        for (DynamicObject specialRule : specialRuleEntity) {
            String ruleContent = specialRule.getString("rulecontent");
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleContent, FilterCondition.class);
            List filterRow = filterCondition.getFilterRow();
            String showRuleData = ApproveSettingHelper.getConditionTxt((List)filterRow, (Map)ApproveSettingHelper.getPaySalaryAccountSpRuleMap());
            specialRule.set("empscope", (Object)showRuleData);
            DynamicObjectCollection subEntryEntity = specialRule.getDynamicObjectCollection("subentryentity");
            PaySalAccountConfigDTO paySalAccountConfigDTO = PaySalarySettingHelper.getSpecialRuleDataToCache((DynamicObjectCollection)subEntryEntity, (String)ruleContent);
            try {
                specialRuleList.add(SWCJSONUtils.toString((Object)paySalAccountConfigDTO));
            }
            catch (IOException e) {
                this.log.info("JSON ERROR");
            }
        }
        return specialRuleList;
    }

    private void preloadDefaultRule() {
        DynamicObjectCollection defaultRuleEntity = this.getModel().getEntryEntity("opentryentity");
        for (DynamicObject defaultRule : defaultRuleEntity) {
            String salaryItemMark = defaultRule.getString("opsalaryitem");
            String salaryItemShow = defaultRule.getLong("opsalaryitemdata.id") == 0L ? salaryItemMark : defaultRule.getString("opsalaryitemdata.name");
            defaultRule.set("opsalaryitemshow", (Object)salaryItemShow);
            String payCurrencyMark = defaultRule.getString("oppaycurrency");
            String payCurrencyShow = defaultRule.getLong("oppaycurrencydata.id") == 0L ? payCurrencyMark : defaultRule.getString("oppaycurrencydata.name");
            defaultRule.set("oppaycurrencyshow", (Object)payCurrencyShow);
            String bankPurposeMark = defaultRule.getString("opbankpurpose");
            String bankPurposeShow = defaultRule.getLong("opbankpurposedata.id") == 0L ? bankPurposeMark : defaultRule.getString("opbankpurposedata.name");
            defaultRule.set("opbankpurposeshow", (Object)bankPurposeShow);
            String relationMark = defaultRule.getString("oppayrollacrelation");
            String relationShow = defaultRule.getLong("oppayrollacrelationdata.id") == 0L ? relationMark : defaultRule.getString("oppayrollacrelationdata.name");
            defaultRule.set("oppayrollacrelationshow", (Object)relationShow);
        }
        this.getView().updateView("opentryentity");
    }
}

