/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.calrule;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.IBaseDataService;
import kd.bos.util.JSONUtils;
import kd.swc.hsas.business.CalRuleHelper;
import kd.swc.hsas.business.calitem.CalItemGroupHelper;
import kd.swc.hsas.business.calitem.TaxCalHSASServiceHelper;
import kd.swc.hsas.business.service.CalItemGroupServiceHelper;
import kd.swc.hsas.formplugin.web.basedata.HisBaseDataSummaryEdit;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.cost.CostHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalRuleEdit
extends HisBaseDataSummaryEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(CalRuleEdit.class);
    private static final String CALLBACKID_SAVE = "ILOVEYOUBABY";
    private static final String CALLBACKID_SUBMIT = "SORRYYOUAREAGOODMAN";
    private static final String CALLBACKID_AUDIT = "IAMFINE";
    private static final String SAVE_AFTERCONFIRM = "notfirstsave";
    private static final String SUBMIT_AFTERCONFIRM = "notfirstsubmit";
    private static final String AUDIT_AFTERCONFIRM = "notfirstaudit";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String CALRULEITEMENTRY = "calruleitementry";
    private static final String FIELD_SALARYITEM = "salaryitem";
    private static final String FIELD_ISPAYOUTITEM = "ispayoutitem";
    private static final String FIELD_ISCOSTALLOT = "iscostallot";
    private static final String FIELD_SALARYITEMTYPE = "salaryitemtype";
    private static final String FIELD_DATASOURCE = "datasource";
    private static final String FIELD_FORMULA = "formula";
    private static final String FIELD_CALITEMGROUP = "calitemgroup";
    private static final String FIELD_OPENTAXCAL = "opentaxcal";
    private static final String OPENTAXCAL_CHANGE_EVENT_CALLBACK = "opentaxcalchangecallback";
    private static final String OPERATIONCOLUMN = "operationcolumn";
    private static final String TOTAL_SALARY = "totalsalary";
    private static final String NET_SALARY = "netsalary";
    private static final String ISCONVERT = "isconvert";
    private static final String CUSTOMPRORATIONRULE = "customprorationrule";
    private static final String FIELD_AREATYPE = "areatype";
    private static final String FIELD_COUNTRY = "country";
    private static final String CALLBACK_AREATYPE = "areaType";
    private static final String FIELD_ALLOWRESULTCOVER = "allowresultcover";
    private static final String MOVEENTRYUP = "moveentryup";
    private static final String MOVEENTRYDOWN = "moveentrydown";
    private static final String INTELLIGENTSORTING = "donothing_intelligentsorting";
    private static final String AFTERCALTYPE = "aftercaltype";
    private static final String TOTALSALARY = "totalsalary";
    private static final String NETSALARY = "netsalary";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
        BasedataEdit formula = (BasedataEdit)this.getView().getControl(FIELD_FORMULA);
        formula.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit totalSalaryEdit = (BasedataEdit)this.getView().getControl("totalsalary");
        totalSalaryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit netSalaryEdit = (BasedataEdit)this.getView().getControl("netsalary");
        netSalaryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit salaryItemEdit = (BasedataEdit)this.getView().getControl(FIELD_SALARYITEM);
        salaryItemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prorationRuleEdit = (BasedataEdit)this.getView().getControl(CUSTOMPRORATIONRULE);
        prorationRuleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initialize() {
        LOGGER.info("start initialize");
        EntryGrid entryGrid = (EntryGrid)this.getControl(CALRULEITEMENTRY);
        entryGrid.addPackageDataListener(pkEvent -> {
            pkEvent.getRowData().set("calindex", pkEvent.getRowData().get("seq"));
            if (pkEvent.getSource() instanceof OperationColumn && OPERATIONCOLUMN.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                DynamicObject formula = pkEvent.getRowData().getDynamicObject(FIELD_FORMULA);
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (formula != null) continue;
                    operationColItem.setVisible(false);
                }
            }
        });
        LOGGER.info("end initialize");
        super.initialize();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        LOGGER.info("start afterLoadData");
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection calruleItemEntryColl = dataModel.getEntryEntity(CALRULEITEMENTRY);
        int i = 1;
        for (DynamicObject dynamicObject : calruleItemEntryColl) {
            dynamicObject.set("seq", (Object)i);
            ++i;
        }
        this.getModel().setDataChanged(false);
        LOGGER.info("end afterLoadData");
    }

    public void beforeBindData(EventObject e) {
        List<DynamicObject> payRollScenes;
        DynamicObject dataEntity;
        String hisversion;
        List<DynamicObject> payRollScenes2;
        super.beforeBindData(e);
        LOGGER.info("start beforeBindData");
        String isFirstCopy = "isFirstCopy";
        IPageCache pageCache = this.getPageCache();
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy") && !Boolean.FALSE.toString().equals(pageCache.get(this.getView().getPageId() + isFirstCopy))) {
            CalItemGroupHelper calItemGroupHelper;
            DynamicObject[] calRuleItemEntryInfos;
            List<String> warnMsgList;
            IDataModel dataModel = this.getModel();
            DynamicObjectCollection calruleItemEntryColl = dataModel.getEntryEntity(CALRULEITEMENTRY);
            ArrayList<DynamicObject> salaryItem = new ArrayList<DynamicObject>(calruleItemEntryColl.size());
            HashSet<Long> entityIds = new HashSet<Long>(calruleItemEntryColl.size());
            ArrayList<Integer> indexList = new ArrayList<Integer>(calruleItemEntryColl.size());
            for (int i = 0; i < calruleItemEntryColl.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)calruleItemEntryColl.get(i);
                if (dynamicObject == null) continue;
                DynamicObject salaryItemObj = dynamicObject.getDynamicObject(FIELD_SALARYITEM);
                if (salaryItemObj == null) {
                    long entryBoId = dynamicObject.getLong("entryboid");
                    if (entryBoId != 0L) {
                        entityIds.add(entryBoId);
                    }
                    indexList.add(i);
                    continue;
                }
                salaryItem.add(dynamicObject);
            }
            if (indexList.size() > 0) {
                IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
                int[] rows = indexList.stream().mapToInt(Integer::intValue).toArray();
                model.deleteEntryRows(CALRULEITEMENTRY, rows);
                this.getView().updateView(CALRULEITEMENTRY);
            }
            if (entityIds.size() > 0 && (warnMsgList = Arrays.stream(calRuleItemEntryInfos = (calItemGroupHelper = new CalItemGroupHelper()).getCalRuleItemEntryInfos(entityIds)).filter(param -> param.getString("salaryitem.name") != null).map(param -> MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5df2\u88ab\u7981\u7528\uff0c\u5df2\u4ece\u5f53\u524d\u8ba1\u7b97\u89c4\u5219\u4e2d\u79fb\u51fa\u3002", (String)"CalRuleEdit_30", (String)"swc-hsas-formplugin", (Object[])new Object[0]), param.getString("salaryitem.name"))).collect(Collectors.toList())).size() > 0) {
                String totalMessage = ResManager.loadKDString((String)"\u51711\u4e2a\u5355\u636e\uff0c\u590d\u5236\u6210\u529f1\u5f20\uff0c\u5931\u8d250\u5f20\u3002", (String)"CalRuleEdit_31", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.showOperationResult(ResManager.loadKDString((String)"\u590d\u5236\u8ba1\u7b97\u89c4\u5219", (String)"CalRuleEdit_32", (String)"swc-hsas-formplugin", (Object[])new Object[0]), totalMessage, warnMsgList);
            }
            int index = 0;
            for (DynamicObject dynamicObject : salaryItem) {
                this.setEntryFieldState(dynamicObject, index);
                ++index;
            }
        }
        this.loadOpenTaxCal();
        this.addRequired();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String option = (String)customParams.get("option");
        String action = (String)customParams.get("his_action");
        Long boId = (Long)customParams.get("boid");
        if (Objects.nonNull(action) && (SWCStringUtils.equals((String)action, (String)"open_insert_data_page") || SWCStringUtils.equals((String)action, (String)"open_data_page")) && (payRollScenes2 = this.querypayRollScenes(boId)).size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u5df2\u88ab\u85aa\u8d44\u6838\u7b97\u573a\u666f\u5f15\u7528\uff0c\u201c\u6838\u7b97\u540e\u5904\u7406\u7c7b\u578b\u201d\u8bf7\u4e0e\u53d8\u66f4\u524d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"CalRuleEdit_45", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        if (SWCStringUtils.equals((String)option, (String)"showhisversion") && SWCStringUtils.isEmpty((String)(hisversion = (dataEntity = this.getModel().getDataEntity()).getString("hisversion"))) && (payRollScenes = this.querypayRollScenes(boId)).size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u5df2\u88ab\u85aa\u8d44\u6838\u7b97\u573a\u666f\u5f15\u7528\uff0c\u201c\u6838\u7b97\u540e\u5904\u7406\u7c7b\u578b\u201d\u8bf7\u4e0e\u53d8\u66f4\u524d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"CalRuleEdit_45", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        LOGGER.info("end beforeBindData");
    }

    private List<DynamicObject> querypayRollScenes(Long boId) {
        DynamicObject[] query;
        ArrayList<Long> pkList = new ArrayList<Long>(10);
        pkList.add(boId);
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        String selectProperties = "name,number,aftercaltype,status,datastatus";
        QFilter pkFilter = new QFilter("calrule.id", "in", pkList);
        QFilter[] filters = new QFilter[]{pkFilter};
        for (DynamicObject dynamicObject : query = helper.query(selectProperties, filters)) {
            if (dynamicObject.getString("datastatus").equals("-2") && dynamicObject.getString("status").equals("C")) continue;
            dynamicObjectList.add(dynamicObject);
        }
        return dynamicObjectList;
    }

    private void loadOpenTaxCal() {
        Boolean enableTaxCal = this.getTaxCalEnable();
        if (enableTaxCal.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_OPENTAXCAL});
            ComboEdit taxCal = (ComboEdit)this.getView().getControl(FIELD_OPENTAXCAL);
            taxCal.setMustInput(true);
            String openTaxCal = (String)this.getModel().getValue(FIELD_OPENTAXCAL);
            if (SWCStringUtils.isEmpty((String)openTaxCal)) {
                this.getModel().setValue(FIELD_OPENTAXCAL, (Object)"1");
            }
            this.getView().updateView(FIELD_COUNTRY);
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(FIELD_OPENTAXCAL, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_OPENTAXCAL});
            this.getModel().endInit();
            this.getView().updateView(FIELD_OPENTAXCAL);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "confirmchange": 
            case "save": {
                if (args.cancel) {
                    return;
                }
                this.getModel().setValue("isdraft", (Object)Boolean.FALSE);
                RefObject afterConfirm = new RefObject();
                if (!formOperate.getOption().tryGetVariableValue("handleItemDependonCallback", afterConfirm)) {
                    this.getPageCache().put("confirmShow", "1");
                    if (!this.checkAndConfirmItemDependon(args, opKey)) {
                        return;
                    }
                }
                if (formOperate.getOption().tryGetVariableValue(SAVE_AFTERCONFIRM, afterConfirm)) break;
                this.getPageCache().put("confirmShow", "1");
                boolean save_hasPayOutItem = this.checkHasPayOutItem();
                if (!save_hasPayOutItem) {
                    String msg = ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u89c4\u5219\u65e0\u5b9e\u53d1\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u85aa\u8d44\u53d1\u653e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalRuleEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    formOperate.getOption().setVariableValue("confirmNoPayItem", msg);
                }
                this.setConfirmNoFormulaMsg(formOperate);
                break;
            }
            case "submit": {
                boolean submit_hasPayOutItem;
                this.getModel().setValue("isdraft", (Object)Boolean.FALSE);
                formOperate.getOption().setVariableValue("isDetail", Boolean.TRUE.toString());
                RefObject subAfterConfirm = new RefObject();
                if (!formOperate.getOption().tryGetVariableValue("handleItemDependonCallback", subAfterConfirm) && !this.checkAndConfirmItemDependon(args, opKey)) {
                    return;
                }
                if (formOperate.getOption().tryGetVariableValue(SUBMIT_AFTERCONFIRM, subAfterConfirm) || (submit_hasPayOutItem = this.checkHasPayOutItem())) break;
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u89c4\u5219\u65e0\u5b9e\u53d1\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u85aa\u8d44\u53d1\u653e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalRuleEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                formOperate.getOption().setVariableValue("confirmNoPayItem", msg);
                break;
            }
            case "audit": {
                boolean audit_hasPayOutItem;
                RefObject auditAfterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(AUDIT_AFTERCONFIRM, auditAfterConfirm) || (audit_hasPayOutItem = this.checkHasPayOutItem())) break;
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u89c4\u5219\u65e0\u5b9e\u53d1\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u85aa\u8d44\u53d1\u653e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalRuleEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                if (SWCStringUtils.equals((String)this.getView().getEntityId(), (String)"hsas_calrule")) {
                    formOperate.getOption().setVariableValue("confirmNoPayItem", msg);
                    break;
                }
                args.setCancel(true);
                ConfirmCallBackListener autCallBack = new ConfirmCallBackListener(CALLBACKID_AUDIT);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, autCallBack);
                break;
            }
            case "donothing_intelligentsorting": {
                this.openSalaryItemTypeF7();
                args.setCancel(true);
                break;
            }
            case "viewsalaryitem": {
                int index = this.getModel().getEntryCurrentRowIndex(CALRULEITEMENTRY);
                DynamicObject obj = this.getModel().getEntryRowEntity(CALRULEITEMENTRY, index);
                DynamicObject formulaObj = obj.getDynamicObject(FIELD_FORMULA);
                if (formulaObj != null) {
                    CalItemGroupHelper.opeanSalaryItemPage((IFormView)this.getView(), (DynamicObject)formulaObj);
                }
                args.setCancel(true);
                break;
            }
            case "saveasdraft": {
                this.getModel().setValue("isdraft", (Object)Boolean.TRUE);
                break;
            }
        }
    }

    private void setConfirmNoFormulaMsg(FormOperate formOperate) {
        DynamicObject totalSalaryItem = (DynamicObject)this.getModel().getValue("totalsalary");
        DynamicObject netSalaryItem = (DynamicObject)this.getModel().getValue("netsalary");
        if (totalSalaryItem == null || netSalaryItem == null) {
            return;
        }
        String totalSalaryItemNumber = totalSalaryItem.getString("number");
        String netSalaryItemNumber = netSalaryItem.getString("number");
        DynamicObjectCollection calruleitementry = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        boolean hasSetupTotalSalary = false;
        boolean hasSetupNetSalary = false;
        for (DynamicObject dynamicObject : calruleitementry) {
            if (totalSalaryItemNumber.equals(dynamicObject.getString("salaryitem.number")) && dynamicObject.getString("formula.number") == null) {
                hasSetupTotalSalary = true;
            }
            if (!netSalaryItemNumber.equals(dynamicObject.getString("salaryitem.number")) || dynamicObject.getString("formula.number") != null) continue;
            hasSetupNetSalary = true;
        }
        if (hasSetupNetSalary && hasSetupTotalSalary) {
            formOperate.getOption().setVariableValue("confirmAllSalNoFormulaMsg", MessageFormat.format(ResManager.loadKDString((String)"\u603b\u85aa\u8d44\u9879\u76ee\u201c{0}\u201d\u3001\u51c0\u85aa\u8d44\u9879\u76ee\u201c{1}\u201d\u672a\u8bbe\u7f6e\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalRuleEdit_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]), totalSalaryItem.getString("name"), netSalaryItem.getString("name")));
        } else if (hasSetupTotalSalary) {
            formOperate.getOption().setVariableValue("confirmTotalSalNoFormulaMsg", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u603b\u85aa\u8d44\u9879\u76ee\u201c%s\u201d\u672a\u8bbe\u7f6e\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalRuleEdit_21", (String)"swc-hsas-formplugin", (Object[])new Object[0]), totalSalaryItem.getString("name")));
        } else if (hasSetupNetSalary) {
            formOperate.getOption().setVariableValue("confirmNetSalNoFormulaMsg", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u51c0\u85aa\u8d44\u9879\u76ee\uff08%s\uff09\u672a\u8bbe\u7f6e\u8ba1\u7b97\u516c\u5f0f\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"CalRuleEdit_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]), netSalaryItem.getString("name")));
        }
    }

    private boolean checkHasPayOutItem() {
        DynamicObjectCollection calruleitementry = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        String afterCalType = this.getModel().getDataEntity().getString(AFTERCALTYPE);
        if (calruleitementry == null || calruleitementry.isEmpty()) {
            return true;
        }
        if (SWCStringUtils.equals((String)afterCalType, (String)"2")) {
            return true;
        }
        if (SWCStringUtils.equals((String)afterCalType, (String)"1")) {
            for (DynamicObject dynamicObject : calruleitementry) {
                String ispayoutitem = dynamicObject.getString(FIELD_ISPAYOUTITEM);
                if (!SWCStringUtils.equals((String)ispayoutitem, (String)"1")) continue;
                return true;
            }
        }
        return false;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "additem": {
                this.openSalaryItemF7();
                break;
            }
            case "addformula": {
                this.openFormulaF7();
                break;
            }
            case "deleteentry": {
                this.deleteEntry();
                break;
            }
            case "showallformula": {
                this.showAllFormula();
                break;
            }
            case "move": {
                this.openMovePage();
                break;
            }
        }
    }

    private void setEntryFieldState(DynamicObject dynamicObject, int index) {
        DynamicObject calitemgroupObj = dynamicObject.getDynamicObject(FIELD_CALITEMGROUP);
        if (!SWCBaseUtils.isEmpty((DynamicObject)calitemgroupObj)) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{FIELD_SALARYITEM, FIELD_SALARYITEMTYPE, FIELD_DATASOURCE, FIELD_FORMULA});
        } else {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{FIELD_SALARYITEM, FIELD_SALARYITEMTYPE, FIELD_DATASOURCE});
            String dataSource = dynamicObject.getString(FIELD_DATASOURCE);
            if (dataSource != null && SWCStringUtils.equals((String)"1", (String)dataSource)) {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{FIELD_FORMULA});
            } else if (dataSource != null && SWCStringUtils.equals((String)"6", (String)dataSource)) {
                this.getModel().beginInit();
                this.getModel().setValue(FIELD_ALLOWRESULTCOVER, (Object)"0", index);
                this.getModel().endInit();
                this.getView().setEnable(Boolean.FALSE, index, new String[]{FIELD_ALLOWRESULTCOVER});
                this.getView().setEnable(Boolean.FALSE, index, new String[]{FIELD_FORMULA});
            } else if (dataSource != null && SWCStringUtils.equals((String)"8", (String)dataSource)) {
                this.getModel().setValue(FIELD_ALLOWRESULTCOVER, (Object)"0", index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{FIELD_FORMULA});
            } else {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{FIELD_FORMULA});
            }
        }
        DynamicObject salaryItemObj = dynamicObject.getDynamicObject(FIELD_SALARYITEM);
        if (null != salaryItemObj) {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{FIELD_DATASOURCE, FIELD_ALLOWRESULTCOVER, FIELD_ISPAYOUTITEM, FIELD_ISCOSTALLOT});
            long showType = salaryItemObj.getLong("datatype.id");
            if (showType == 1020L || showType == 1010L) {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{ISCONVERT});
            } else {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{ISCONVERT});
            }
            String taxTag = salaryItemObj.getString("taxtag");
            String openTaxCal = (String)this.getModel().getValue(FIELD_OPENTAXCAL);
            if (SWCStringUtils.equals((String)"1", (String)openTaxCal) && SWCStringUtils.equals((String)"2", (String)taxTag)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{FIELD_ISPAYOUTITEM});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{FIELD_FORMULA, FIELD_DATASOURCE, FIELD_ALLOWRESULTCOVER, FIELD_ISPAYOUTITEM, FIELD_ISCOSTALLOT});
        }
    }

    private void deleteEntry() {
        String entryKey = CALRULEITEMENTRY;
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState(entryKey).getSelectedRows();
        if (rowIndexs.length > 0) {
            this.checkEntryDataAndOpenConfirmPage(rowIndexs);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"CalRuleEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void checkEntryDataAndOpenConfirmPage(int[] rowIndexs) {
        DynamicObjectCollection entryList = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        List dependOnSItemList = CalItemGroupHelper.getFormualDependSItemCodeList((DynamicObjectCollection)entryList);
        DynamicObject entry = null;
        int successCount = 0;
        DynamicObject itemGroup = null;
        ArrayList<Integer> groupIndexList = new ArrayList<Integer>(rowIndexs.length);
        ArrayList<Integer> formulaIndexList = new ArrayList<Integer>(rowIndexs.length);
        for (int index : rowIndexs) {
            entry = (DynamicObject)entryList.get(index);
            itemGroup = entry.getDynamicObject(FIELD_CALITEMGROUP);
            if (itemGroup != null) {
                groupIndexList.add(index);
                continue;
            }
            if (dependOnSItemList.contains(entry.getString("salaryitem.uniquecode"))) {
                formulaIndexList.add(index);
                continue;
            }
            ++successCount;
        }
        SWCPageCache page = new SWCPageCache(this.getView());
        page.put("formulaIndexList", formulaIndexList);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsas_deleteconfirm");
        parameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"CalRuleEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "deleteentry_confirmcallback");
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCustomParam("totalCount", (Object)rowIndexs.length);
        parameter.setCustomParam("successNum", (Object)successCount);
        parameter.setCustomParam("formulaWarningNum", (Object)formulaIndexList.size());
        parameter.setCustomParam("groupWarningNum", (Object)groupIndexList.size());
        parameter.setCustomParam("pageFlag", (Object)"hsas_calrule");
        this.getView().showForm(parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String[] keys = new String[]{"netsalary", "totalsalary"};
        String[] entryEntityKeys = new String[]{CALRULEITEMENTRY};
        if (CALLBACKID_SAVE.equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(SAVE_AFTERCONFIRM, "true");
                this.getView().invokeOperation("save", operateOption);
            }
        } else if (CALLBACKID_SUBMIT.equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(SUBMIT_AFTERCONFIRM, "true");
                this.getView().invokeOperation("submit", operateOption);
            }
        } else if (CALLBACKID_AUDIT.equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(AUDIT_AFTERCONFIRM, "true");
                this.getView().invokeOperation("audit", operateOption);
            }
        } else if (CALLBACK_AREATYPE.equals(messageBoxClosedEvent.getCallBackId())) {
            AreaHelper.confirmAfterModifyAraeType((MessageBoxClosedEvent)messageBoxClosedEvent, (IDataModel)this.getModel(), (IFormView)this.getView(), (String[])keys, (String[])entryEntityKeys);
        } else if (FIELD_COUNTRY.equals(messageBoxClosedEvent.getCallBackId())) {
            AreaHelper.confirmAfterModifyCountry((MessageBoxClosedEvent)messageBoxClosedEvent, (IDataModel)this.getModel(), (IFormView)this.getView(), (String[])keys, (String[])entryEntityKeys);
        } else if (SWCStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)OPENTAXCAL_CHANGE_EVENT_CALLBACK)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            this.openTaxCalCallBackEvent(result);
        } else if (SWCStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"checkAndConfirmItemDependon")) {
            this.handleItemDependonCallback(messageBoxClosedEvent);
        }
    }

    private void openTaxCalCallBackEvent(MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            String pageId = this.getView().getPageId();
            SWCPageCache cache = new SWCPageCache(this.getView());
            cache.put(pageId + "_isOpenTaxCalCancel", (Object)Boolean.FALSE);
            this.changeOpenTaxCalEvent();
            int index = 0;
            IDataModel dataModel = this.getModel();
            DynamicObjectCollection calruleItemEntryColl = dataModel.getEntryEntity(CALRULEITEMENTRY);
            ArrayList<DynamicObject> salaryItem = new ArrayList<DynamicObject>(calruleItemEntryColl.size());
            for (int i = 0; i < calruleItemEntryColl.size(); ++i) {
                DynamicObject salaryItemObj;
                DynamicObject dynamicObject = (DynamicObject)calruleItemEntryColl.get(i);
                if (dynamicObject == null || (salaryItemObj = dynamicObject.getDynamicObject(FIELD_SALARYITEM)) == null) continue;
                salaryItem.add(dynamicObject);
            }
            for (DynamicObject dynamicObject : salaryItem) {
                this.setEntryFieldState(dynamicObject, index);
                ++index;
            }
            return;
        }
        String pageId = this.getView().getPageId();
        SWCPageCache cache = new SWCPageCache(this.getView());
        Map cacheMap = (Map)cache.get(pageId + "_opentaxcalchange", Map.class);
        cache.put(pageId + "_isOpenTaxCalCancel", (Object)Boolean.TRUE);
        String oldValue = (String)cacheMap.get("oldValue");
        this.getModel().setValue(FIELD_OPENTAXCAL, (Object)oldValue);
    }

    private void changeOpenTaxCalEvent() {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        if (entryColl == null || entryColl.size() == 0) {
            return;
        }
        ArrayList<Long> salaryItemIdList = new ArrayList<Long>(entryColl.size());
        for (DynamicObject entryObj : entryColl) {
            DynamicObject salaryItemObj = entryObj.getDynamicObject(FIELD_SALARYITEM);
            if (salaryItemObj == null) continue;
            salaryItemIdList.add(salaryItemObj.getLong("id"));
        }
        if (salaryItemIdList == null || salaryItemIdList.size() == 0) {
            return;
        }
        String selectProperties = "id,name,number,ispayoutitem,taxtag,iscostallot,salaryitemtype,salaryitemtype.id,salaryitemtype.name,salaryitemtype.number";
        QFilter filter = new QFilter("id", "in", salaryItemIdList);
        DynamicObject[] coll = new SWCDataServiceHelper("hsbs_salaryitem").query(selectProperties, new QFilter[]{filter}, "number asc");
        DynamicObjectCollection oldEntryDataColl = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        HashMap<Long, Map<String, String>> oldTaxAndDataSourceMap = new HashMap<Long, Map<String, String>>(16);
        for (DynamicObject entryDataObj : oldEntryDataColl) {
            HashMap<String, String> entryDataMap = new HashMap<String, String>(2);
            DynamicObject salaryItemObj = entryDataObj.getDynamicObject(FIELD_SALARYITEM);
            if (SWCObjectUtils.isEmpty((Object)salaryItemObj)) continue;
            entryDataMap.put("taxtag", salaryItemObj.getString("taxtag"));
            entryDataMap.put(FIELD_DATASOURCE, entryDataObj.getString(FIELD_DATASOURCE));
            oldTaxAndDataSourceMap.put(salaryItemObj.getLong("id"), entryDataMap);
        }
        IDataModel dataModel = this.getModel();
        this.getPageCache().put("hasCheckDelete", "1");
        dataModel.deleteEntryData(CALRULEITEMENTRY);
        this.loadItemToEntity(coll, dataModel, oldTaxAndDataSourceMap);
    }

    private int[] getDeleteRowIndexs(int[] rowIndexs, Map<String, Boolean> map) {
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        ArrayList<Long> calitemgroupObjIds = new ArrayList<Long>();
        Boolean isFormulaDependSItem = map.get("isFormulaDependSItem");
        Boolean isCalItemGroupSItem = map.get("isCalItemGroupSItem");
        SWCPageCache page = new SWCPageCache(this.getView());
        List formulaIndexList = (List)page.get("formulaIndexList", List.class);
        page.remove("formulaIndexList");
        DynamicObjectCollection coll = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        for (int index : rowIndexs) {
            DynamicObject dynamicObject = (DynamicObject)coll.get(index);
            DynamicObject calitemgroupObj = (DynamicObject)dynamicObject.get(FIELD_CALITEMGROUP);
            if (!SWCBaseUtils.isEmpty((DynamicObject)calitemgroupObj)) {
                long id;
                if (isCalItemGroupSItem != null && !isCalItemGroupSItem.booleanValue() || calitemgroupObjIds.contains(id = calitemgroupObj.getLong("id"))) continue;
                calitemgroupObjIds.add(id);
                continue;
            }
            if ((formulaIndexList == null || formulaIndexList.contains(index)) && !isFormulaDependSItem.booleanValue()) continue;
            rowIndexList.add(index);
        }
        if (calitemgroupObjIds.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                long id;
                DynamicObject dynamicObject = (DynamicObject)coll.get(i);
                DynamicObject calitemgroupObj = (DynamicObject)dynamicObject.get(FIELD_CALITEMGROUP);
                if (SWCBaseUtils.isEmpty((DynamicObject)calitemgroupObj) || !calitemgroupObjIds.contains(id = calitemgroupObj.getLong("id"))) continue;
                rowIndexList.add(i);
            }
            Collections.sort(rowIndexList);
        }
        rowIndexs = new int[rowIndexList.size()];
        for (int i = 0; i < rowIndexList.size(); ++i) {
            rowIndexs[i] = (Integer)rowIndexList.get(i);
        }
        return rowIndexs;
    }

    private void openSalaryItemF7() {
        if (!this.checkAreaAndCountry() || !this.checkBsed()) {
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsbs_salaryitem", (boolean)true);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsbs_salaryitem"));
        showParameter.setListFilterParameter(new ListFilterParameter(this.getSalaryItemFilter(), null));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openSalaryItemTypeF7() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        HashSet<Long> ids = new HashSet<Long>(entryEntity.size());
        boolean hasNullEntry = false;
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            for (DynamicObject entry : entryEntity) {
                if (entry.getDynamicObject(FIELD_SALARYITEM) == null) {
                    hasNullEntry = true;
                    break;
                }
                ids.add(entry.getLong("salaryitem.salaryitemtype.id"));
            }
        }
        if (hasNullEntry) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u4e3a\u7a7a\u6216\u5b58\u5728\u7a7a\u884c\uff0c\u8bf7\u5148\u7ef4\u62a4\u85aa\u916c\u9879\u76ee\u540e\u518d\u8fdb\u884c\u667a\u80fd\u6392\u5e8f\u3002", (String)"CalRuleEdit_39", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsbs_salaryitemtype", (boolean)true);
        showParameter.setHasRight(false);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6309\u85aa\u916c\u9879\u76ee\u7c7b\u522b\u6392\u5e8f", (String)"CalRuleEdit_44", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, INTELLIGENTSORTING));
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(new QFilter("id", "in", ids));
        showParameter.setListFilterParameter(new ListFilterParameter(filterList, null));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<QFilter> getSalaryItemFilter() {
        List<Long> billIds;
        DynamicObject mainOrgObj;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        MainEntityType billEntityType = this.getModel().getDataEntityType();
        String mainOrgProp = billEntityType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrgProp) && (mainOrgObj = (DynamicObject)this.getModel().getValue(mainOrgProp)) != null && mainOrgObj.getPkValue() != null) {
            long orgID = (Long)mainOrgObj.getPkValue();
            IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
            QFilter qFilter = baseDataService.getBaseDataFilter("hsbs_salaryitem", Long.valueOf(orgID));
            qFilters.add(qFilter);
        }
        if ((billIds = this.getEntryItemIds()).size() > 0) {
            qFilters.add(new QFilter("id", "not in", billIds));
        }
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        String areaType = this.getModel().getDataEntity().getString(FIELD_AREATYPE);
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        QFilter areaFilter = AreaHelper.addAreaFilter((long)countryId, (String)areaType);
        if (null != areaFilter) {
            qFilters.add(areaFilter);
        }
        return qFilters;
    }

    private List<Long> getEntryItemIds() {
        DynamicObjectCollection coll = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (DynamicObject dynamicObject : coll) {
            long salaryitemId;
            DynamicObject salaryitemObj = (DynamicObject)dynamicObject.get(FIELD_SALARYITEM);
            if (SWCBaseUtils.isEmpty((DynamicObject)salaryitemObj) || billIds.contains(salaryitemId = salaryitemObj.getLong("ID"))) continue;
            billIds.add(salaryitemId);
        }
        return billIds;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String callStr = e.getActionId();
        Object returnData = e.getReturnData();
        ListSelectedRowCollection dataColl = null;
        switch (callStr) {
            case "hsbs_salaryitem": {
                dataColl = (ListSelectedRowCollection)returnData;
                this.addItemsToEntity(dataColl);
                break;
            }
            case "hsas_formula": {
                dataColl = (ListSelectedRowCollection)returnData;
                this.addFormulaRows(dataColl);
                break;
            }
            case "deleteentry_confirmcallback": {
                this.getPageCache().put("hasCheckDelete", "1");
                this.deleteEntryData((Map)returnData);
                break;
            }
            case "callbackmovesync": {
                if (returnData == null) {
                    return;
                }
                int rowNumber = (Integer)((Map)returnData).get("rownumber");
                int calRuleItemEntry = this.getView().getModel().getEntryCurrentRowIndex(CALRULEITEMENTRY);
                if (--rowNumber == calRuleItemEntry) {
                    return;
                }
                this.setMove((Map)returnData);
                break;
            }
            case "donothing_intelligentsorting": {
                dataColl = (ListSelectedRowCollection)returnData;
                this.resetEntitySort(dataColl);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.flushEntitySort();
        this.setEntryFieldState(this.getModel());
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (!SWCStringUtils.equals((String)this.getPageCache().get("hasCheckDelete"), (String)"1")) {
            this.getPageCache().put("currentSelectedRow", String.valueOf(e.getRowIndexs()[0]));
            this.checkEntryDataAndOpenConfirmPage(e.getRowIndexs());
            e.setCancel(true);
            return;
        }
        this.getPageCache().put("hasCheckDelete", "0");
    }

    private void resetEntitySort(ListSelectedRowCollection dataColl) {
        LinkedList resultList;
        DynamicObjectCollection entryEntity;
        if (CollectionUtils.isEmpty((Collection)dataColl)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        List itemTypeIdList = dataColl.stream().map(data -> Long.valueOf(data.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (!CalRuleHelper.resortEntryByItemTypeId(itemTypeIdList, (DynamicObjectCollection)(entryEntity = this.getModel().getEntryEntity(CALRULEITEMENTRY)), resultList = new LinkedList())) {
            return;
        }
        this.getPageCache().put("hasCheckDelete", "1");
        this.getModel().deleteEntryData(CALRULEITEMENTRY);
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(FIELD_CALITEMGROUP, new Object[0]);
        vs.addField(FIELD_SALARYITEM, new Object[0]);
        vs.addField(FIELD_DATASOURCE, new Object[0]);
        vs.addField(FIELD_ISPAYOUTITEM, new Object[0]);
        vs.addField(FIELD_ISCOSTALLOT, new Object[0]);
        vs.addField(FIELD_FORMULA, new Object[0]);
        vs.addField("calindex", new Object[0]);
        vs.addField(FIELD_ALLOWRESULTCOVER, new Object[0]);
        model.beginInit();
        for (DynamicObject dynamicObject : resultList) {
            String salaryItem = dynamicObject.getString("salaryitem.id");
            String dataSource = dynamicObject.getString(FIELD_DATASOURCE);
            String isPayoutItem = dynamicObject.getString(FIELD_ISPAYOUTITEM);
            String isCostallot = dynamicObject.getString(FIELD_ISCOSTALLOT);
            String formula = dynamicObject.getString("formula.id");
            String allowrResultCover = dynamicObject.getString(FIELD_ALLOWRESULTCOVER);
            int seq = dynamicObject.getInt("seq");
            long templateId = dynamicObject.getLong("calitemgroup.id");
            vs.addRow(new Object[]{templateId != 0L ? templateId : 0L, salaryItem, dataSource, isPayoutItem, isCostallot, formula, seq, allowrResultCover});
        }
        model.batchCreateNewEntryRow(CALRULEITEMENTRY, vs);
        model.endInit();
        this.getView().updateView(CALRULEITEMENTRY);
        this.setEntryFieldState(dataModel);
    }

    private void flushEntitySort() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        for (DynamicObject entryDy : entryEntity) {
            int seq = entryDy.getInt("seq");
            this.getModel().setValue("calindex", (Object)seq, seq - 1);
        }
    }

    private void deleteEntryData(Map<String, Boolean> map) {
        int[] rowIndexs;
        if (map == null) {
            this.getPageCache().put("hasCheckDelete", "0");
            return;
        }
        String entryKey = CALRULEITEMENTRY;
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        String currentSelectedRowStr = this.getPageCache().get("currentSelectedRow");
        if (SWCStringUtils.isEmpty((String)currentSelectedRowStr)) {
            rowIndexs = proxy.getEntryState(entryKey).getSelectedRows();
        } else {
            rowIndexs = new int[]{Integer.parseInt(currentSelectedRowStr)};
            this.getPageCache().put("currentSelectedRow", null);
        }
        if (rowIndexs.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"CalRuleEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        rowIndexs = this.getDeleteRowIndexs(rowIndexs, map);
        this.clearSalaryStatistics(rowIndexs);
        model.deleteEntryRows(entryKey, rowIndexs);
        this.getView().updateView(CALRULEITEMENTRY);
        this.flushEntitySort();
        this.setEntryFieldState(this.getModel());
    }

    private void clearSalaryStatistics(int[] rowIndexs) {
        String totalSalaryItemNumber = null;
        String netSalaryItemNumber = null;
        Object totalSalaryItem = this.getModel().getValue("totalsalary");
        Object netSalaryItem = this.getModel().getValue("netsalary");
        if (totalSalaryItem != null) {
            totalSalaryItemNumber = ((DynamicObject)totalSalaryItem).getString("number");
        }
        if (netSalaryItem != null) {
            netSalaryItemNumber = ((DynamicObject)netSalaryItem).getString("number");
        }
        for (int index : rowIndexs) {
            DynamicObject entry = this.getModel().getEntryRowEntity(CALRULEITEMENTRY, index);
            String itemNumber = entry.getString("salaryitem.number");
            if (itemNumber == null) continue;
            if (itemNumber.equals(totalSalaryItemNumber)) {
                this.getModel().setValue("totalsalary", null);
            }
            if (!itemNumber.equals(netSalaryItemNumber)) continue;
            this.getModel().setValue("netsalary", null);
        }
    }

    private Boolean getTaxCalEnable() {
        DynamicObject countryObj;
        Boolean openTaxCal = Boolean.FALSE;
        String areatype = (String)this.getModel().getValue(FIELD_AREATYPE);
        if (SWCStringUtils.equals((String)areatype, (String)"2") && !SWCObjectUtils.isEmpty((Object)(countryObj = (DynamicObject)this.getModel().getValue(FIELD_COUNTRY)))) {
            long countryId = countryObj.getLong("id");
            openTaxCal = TaxCalServiceHelper.getTaxCalEnableStatusByCountryId((long)countryId);
        }
        return openTaxCal;
    }

    private void addRequired() {
        String afterCalType = (String)this.getModel().getValue(AFTERCALTYPE);
        if (SWCStringUtils.equals((String)afterCalType, (String)"1")) {
            FieldEdit netsalaryField = (FieldEdit)this.getControl("netsalary");
            netsalaryField.setMustInput(true);
            FieldEdit totalsalaryField = (FieldEdit)this.getControl("totalsalary");
            totalsalaryField.setMustInput(true);
        }
    }

    private void showOperationResult(String operateName, String title, List<String> failList) {
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, failList);
        this.getView().showForm(parameters);
    }

    private void setEntryFieldState(IDataModel dataModel) {
        DynamicObjectCollection calruleItemEntryColl = dataModel.getEntryEntity(CALRULEITEMENTRY);
        int index = 0;
        for (DynamicObject dynamicObject : calruleItemEntryColl) {
            this.setEntryFieldState(dynamicObject, index);
            ++index;
        }
    }

    private void addItemsToEntity(ListSelectedRowCollection dataColl) {
        if (dataColl == null || dataColl.size() == 0) {
            return;
        }
        IDataModel dataModel = this.getModel();
        ArrayList<Long> billIds = new ArrayList<Long>(dataColl.size());
        for (ListSelectedRow listSelectedRow : dataColl) {
            billIds.add(Long.valueOf(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        String selectProperties = "id,name,number,ispayoutitem,taxtag,iscostallot,salaryitemtype,salaryitemtype.id,salaryitemtype.name,salaryitemtype.number";
        QFilter filter = new QFilter("id", "in", billIds);
        DynamicObject[] coll = new SWCDataServiceHelper("hsbs_salaryitem").query(selectProperties, new QFilter[]{filter}, "number asc");
        this.loadItemToEntity(coll, dataModel, null);
        int index = 0;
        DynamicObjectCollection calruleItemEntryColl = dataModel.getEntryEntity(CALRULEITEMENTRY);
        ArrayList<DynamicObject> salaryItem = new ArrayList<DynamicObject>(calruleItemEntryColl.size());
        for (int i = 0; i < calruleItemEntryColl.size(); ++i) {
            DynamicObject salaryItemObj;
            DynamicObject dynamicObject = (DynamicObject)calruleItemEntryColl.get(i);
            if (dynamicObject == null || (salaryItemObj = dynamicObject.getDynamicObject(FIELD_SALARYITEM)) == null) continue;
            salaryItem.add(dynamicObject);
        }
        for (DynamicObject dynamicObject : salaryItem) {
            this.setEntryFieldState(dynamicObject, index);
            ++index;
        }
    }

    private void loadItemToEntity(DynamicObject[] coll, IDataModel dataModel, Map<Long, Map<String, String>> oldTaxAndDataSourceMap) {
        List salaryIds = Arrays.stream(coll).map(param -> param.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter(FIELD_SALARYITEM, "in", salaryIds);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        QFilter countryFilter = AreaHelper.addCountryFilter((long)countryId);
        qFilter.and(countryFilter);
        long orgId = this.getModel().getDataEntity().getLong("createorg.id");
        qFilter.and(new QFilter("createorg", "=", (Object)orgId));
        Date bsed = this.getView().getModel().getDataEntity().getDate("bsed");
        Map<Object, Object> formulaMap = new HashMap(16);
        if (bsed != null) {
            qFilter.and(new QFilter("firstbsed", "<=", (Object)bsed));
            CalItemGroupServiceHelper calItemGroupServiceHelper = new CalItemGroupServiceHelper();
            List dynamicObjectList = calItemGroupServiceHelper.selectSalaryItem(qFilter);
            formulaMap = dynamicObjectList.stream().collect(Collectors.toMap(key -> key.getLong("salaryitem.id"), value -> value, (v1, v2) -> v1));
        }
        ArrayList<String> failList = new ArrayList<String>();
        int total = 0;
        int success = 0;
        int fail = 0;
        int index = 0;
        List<Long> entryItemIds = this.getEntryItemIds();
        String openTaxCal = (String)this.getModel().getValue(FIELD_OPENTAXCAL);
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(FIELD_SALARYITEM, new Object[0]);
        vs.addField(FIELD_DATASOURCE, new Object[0]);
        vs.addField(FIELD_ISPAYOUTITEM, new Object[0]);
        vs.addField(FIELD_ISCOSTALLOT, new Object[0]);
        vs.addField(FIELD_FORMULA, new Object[0]);
        vs.addField(FIELD_ALLOWRESULTCOVER, new Object[0]);
        for (DynamicObject dynamicObject : coll) {
            ++total;
            long salaryItemId = dynamicObject.getLong("id");
            String salaryItemName = dynamicObject.getString("name");
            if (entryItemIds.contains(salaryItemId)) {
                ++fail;
                failList.add(ResManager.loadKDString((String)"{0}\uff1a\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\u3002", (String)"CalRuleEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[]{salaryItemName}));
                continue;
            }
            ++success;
            String isPayoutItem = dynamicObject.getString(FIELD_ISPAYOUTITEM);
            boolean isCostAllot = dynamicObject.getBoolean(FIELD_ISCOSTALLOT);
            String taxTag = dynamicObject.getString("taxtag");
            String datasource = "1";
            datasource = oldTaxAndDataSourceMap == null || oldTaxAndDataSourceMap.size() == 0 ? TaxCalHSASServiceHelper.getDatasourceByTaxServiceAndOpenTaxCal((String)taxTag, (String)openTaxCal) : this.getDataSourceOldEntryData(oldTaxAndDataSourceMap, salaryItemId, taxTag, openTaxCal);
            ++index;
            long id = 0L;
            DynamicObject formulaObj = (DynamicObject)formulaMap.get(dynamicObject.getLong("id"));
            if (!SWCObjectUtils.isEmpty((Object)formulaObj) && SWCStringUtils.equals((String)"1", (String)datasource)) {
                id = formulaObj.getLong("id");
            }
            if (datasource != null && SWCStringUtils.equals((String)"6", (String)datasource)) {
                vs.addRow(new Object[]{salaryItemId, datasource, isPayoutItem, isCostAllot ? "1" : "0", id, "0"});
                continue;
            }
            vs.addRow(new Object[]{salaryItemId, datasource, isPayoutItem, isCostAllot ? "1" : "0", id, "1"});
        }
        model.batchCreateNewEntryRow(CALRULEITEMENTRY, vs);
        model.endInit();
        this.getView().updateView(CALRULEITEMENTRY);
        if (fail != 0) {
            String totalMessage = ResManager.loadKDString((String)"\u5171\u6dfb\u52a0{0}\u4e2a\u85aa\u916c\u9879\u76ee\uff0c{1}\u4e2a\u6dfb\u52a0\u6210\u529f\uff0c{2}\u4e2a\u6dfb\u52a0\u5931\u8d25\u3002", (String)"CalRuleEdit_12", (String)"swc-hsas-formplugin", (Object[])new Object[]{total, success, fail});
            this.showOperationResult(ResManager.loadKDString((String)"\u6dfb\u52a0\u85aa\u916c\u9879\u76ee", (String)"CalRuleEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]), totalMessage, failList);
        }
    }

    private String getDataSourceOldEntryData(Map<Long, Map<String, String>> oldTaxAndDataSourceMap, long salaryItemId, String taxTag, String openTaxCal) {
        Map<String, String> dataMap = oldTaxAndDataSourceMap.get(salaryItemId);
        if (dataMap == null || dataMap.size() == 0) {
            return "1";
        }
        String oldTaxTag = dataMap.get("taxtag");
        String oldDataSource = dataMap.get(FIELD_DATASOURCE);
        if (SWCStringUtils.equals((String)oldTaxTag, (String)"2")) {
            return TaxCalHSASServiceHelper.getDatasourceByTaxServiceAndOpenTaxCal((String)taxTag, (String)openTaxCal);
        }
        return oldDataSource;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (fieldKey.equals(FIELD_SALARYITEM)) {
            ChangeData data = e.getChangeSet()[0];
            int parentRowIndex = e.getChangeSet()[0].getParentRowIndex();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject obj = (DynamicObject)data.getNewValue();
            DynamicObject oldObj = (DynamicObject)data.getOldValue();
            if (obj != null) {
                this.setValueBySalaryItem(obj, oldObj, rowIndex, parentRowIndex);
            }
            this.setEntryFieldState(this.getModel());
        } else if (fieldKey.equals(FIELD_DATASOURCE)) {
            ChangeData data = e.getChangeSet()[0];
            String dataSource = (String)data.getNewValue();
            int parentRowIndex = e.getChangeSet()[0].getParentRowIndex();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (SWCStringUtils.equals((String)"1", (String)dataSource)) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{FIELD_FORMULA});
            } else if (SWCStringUtils.equals((String)"6", (String)dataSource)) {
                this.getModel().setValue(FIELD_ALLOWRESULTCOVER, (Object)"0", rowIndex, parentRowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{FIELD_ALLOWRESULTCOVER});
                this.getModel().setValue(ISCONVERT, (Object)"1", rowIndex, parentRowIndex);
            } else if (SWCStringUtils.equals((String)"8", (String)dataSource)) {
                this.getModel().setValue(ISCONVERT, (Object)"1", rowIndex, parentRowIndex);
                boolean isSuccess = this.checkInsuranceSourceItemType(parentRowIndex, rowIndex);
                if (isSuccess) {
                    this.getModel().setValue(FIELD_ALLOWRESULTCOVER, (Object)"0", rowIndex, parentRowIndex);
                    this.getModel().setValue(FIELD_FORMULA, null, rowIndex, parentRowIndex);
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{FIELD_ALLOWRESULTCOVER});
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{FIELD_FORMULA});
                }
            } else {
                this.getModel().setValue(ISCONVERT, (Object)"1", rowIndex, parentRowIndex);
                this.getModel().setValue(FIELD_FORMULA, null, rowIndex, parentRowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{FIELD_FORMULA});
            }
            this.hideOperationColumn(data);
        } else if (fieldKey.equals(FIELD_ISPAYOUTITEM)) {
            ChangeData data = e.getChangeSet()[0];
            String ispayoutitem = (String)data.getNewValue();
            if ("1".equals(ispayoutitem)) {
                int dataIndex = data.getRowIndex();
                DynamicObject item = (DynamicObject)this.getModel().getValue(FIELD_SALARYITEM, dataIndex);
                String datatypeNumber = item.getString("datatype.number");
                if (!"1020_S".equals(datatypeNumber)) {
                    this.getModel().setValue(FIELD_ISPAYOUTITEM, (Object)"0", dataIndex);
                    this.getView().updateView(CALRULEITEMENTRY);
                    String errMsg = ResManager.loadKDString((String)"\u53ea\u53ef\u5c06\u6570\u636e\u7c7b\u578b\u4e3a\u201c\u91d1\u989d\u201d\u7684\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e3a\u201c\u5b9e\u53d1\u9879\u76ee\u201d\u3002", (String)"CalRuleEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(errMsg);
                    this.setEntryFieldState(this.getModel());
                }
            }
        } else if (fieldKey.equals(FIELD_FORMULA)) {
            ChangeData data = e.getChangeSet()[0];
            DynamicObject formula = (DynamicObject)data.getNewValue();
            if (formula != null) {
                this.getView().updateView(CALRULEITEMENTRY, data.getRowIndex());
                this.setEntryFieldState(this.getModel());
            }
            this.hideOperationColumn(data);
        } else if (fieldKey.equals(ISCONVERT)) {
            ChangeData data = e.getChangeSet()[0];
            int parentRowIndex = e.getChangeSet()[0].getParentRowIndex();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            String isConvert = (String)data.getNewValue();
            if (SWCStringUtils.equals((String)"1", (String)isConvert)) {
                this.getModel().setValue(CUSTOMPRORATIONRULE, null, rowIndex, parentRowIndex);
            }
        } else if (fieldKey.equals(FIELD_AREATYPE)) {
            this.checkOpenConfirmPage(e.getChangeSet(), Boolean.TRUE);
            this.loadOpenTaxCal();
        } else if (fieldKey.equals(FIELD_COUNTRY)) {
            this.checkOpenConfirmPage(e.getChangeSet(), Boolean.FALSE);
            this.loadOpenTaxCal();
        } else if (SWCStringUtils.equals((String)fieldKey, (String)FIELD_OPENTAXCAL)) {
            this.openTaxCalChangeEvent(e);
        } else if (SWCStringUtils.equals((String)fieldKey, (String)AFTERCALTYPE)) {
            String afterCalType = this.getModel().getDataEntity().getString(AFTERCALTYPE);
            if (SWCStringUtils.equals((String)afterCalType, (String)"2")) {
                FieldEdit netsalaryField = (FieldEdit)this.getControl("netsalary");
                netsalaryField.setMustInput(false);
                FieldEdit totalsalaryField = (FieldEdit)this.getControl("totalsalary");
                totalsalaryField.setMustInput(false);
            } else {
                FieldEdit netsalaryField = (FieldEdit)this.getControl("netsalary");
                netsalaryField.setMustInput(true);
                FieldEdit totalsalaryField = (FieldEdit)this.getControl("totalsalary");
                totalsalaryField.setMustInput(true);
            }
        }
    }

    private boolean checkInsuranceSourceItemType(int parentRowIndex, int rowIndex) {
        long salaryItemTypeId;
        DynamicObject salaryItem = (DynamicObject)this.getModel().getValue(FIELD_SALARYITEM, rowIndex, parentRowIndex);
        if (salaryItem != null && (salaryItemTypeId = salaryItem.getLong("salaryitemtype.id")) != 1393357138549742592L) {
            this.getModel().setValue(FIELD_DATASOURCE, null, rowIndex, parentRowIndex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u85aa\u916c\u9879\u76ee\u7c7b\u522b\u4e3a\u201c\u793e\u4f1a\u4fdd\u9669\u6263\u51cf\u201d\u7684\u85aa\u916c\u9879\u76ee\uff0c\u53ef\u8bbe\u7f6e\u6570\u636e\u6765\u6e90\u4e3a\u201c\u793e\u4fdd\u4e91\u670d\u52a1\u201d\u3002", (String)"CalRuleEdit_40", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setValueBySalaryItem(DynamicObject newItem, DynamicObject oldItem, int rowIndex, int parentRowIndex) {
        if (newItem == null) {
            return;
        }
        long salaryItemId = newItem.getLong("id");
        QFilter qFilter = new QFilter(FIELD_SALARYITEM, "=", (Object)salaryItemId);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        QFilter countryFilter = AreaHelper.addCountryFilter((long)countryId);
        qFilter.and(countryFilter);
        long orgId = this.getModel().getDataEntity().getLong("createorg.id");
        qFilter.and(new QFilter("createorg", "=", (Object)orgId));
        Date bsed = this.getView().getModel().getDataEntity().getDate("bsed");
        Long formulaId = null;
        if (bsed != null) {
            qFilter.and(new QFilter("firstbsed", "<=", (Object)bsed));
            CalItemGroupServiceHelper calItemGroupServiceHelper = new CalItemGroupServiceHelper();
            List formulaList = calItemGroupServiceHelper.selectSalaryItem(qFilter);
            if (!CollectionUtils.isEmpty((Collection)formulaList)) {
                formulaId = ((DynamicObject)formulaList.get(0)).getLong("id");
            }
        }
        String taxTag = newItem.getString("taxtag");
        String openTaxCal = (String)this.getModel().getValue(FIELD_OPENTAXCAL);
        String dataSource = TaxCalHSASServiceHelper.getDatasourceByTaxServiceAndOpenTaxCal((String)taxTag, (String)openTaxCal);
        if (formulaId != null && !SWCStringUtils.equals((String)"1", (String)dataSource)) {
            formulaId = null;
        }
        this.getModel().setValue(FIELD_DATASOURCE, (Object)dataSource, rowIndex, parentRowIndex);
        this.getModel().setValue(FIELD_FORMULA, (Object)formulaId, rowIndex, parentRowIndex);
        this.getModel().setValue(FIELD_ISPAYOUTITEM, (Object)newItem.getLong(FIELD_ISPAYOUTITEM), rowIndex, parentRowIndex);
        this.getModel().setValue(FIELD_ISCOSTALLOT, (Object)(newItem.getBoolean(FIELD_ISCOSTALLOT) ? "1" : "0"), rowIndex, parentRowIndex);
        DynamicObject totalSalary = (DynamicObject)this.getModel().getValue("totalsalary");
        DynamicObject netSalary = (DynamicObject)this.getModel().getValue("netsalary");
        long oldItemId = oldItem == null ? 0L : oldItem.getLong("id");
        if (totalSalary != null && totalSalary.getLong("id") == oldItemId) {
            this.getModel().setValue("totalsalary", null);
        }
        if (netSalary != null && netSalary.getLong("id") == oldItemId) {
            this.getModel().setValue("netsalary", null);
        }
    }

    private void openTaxCalChangeEvent(PropertyChangedArgs e) {
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        if (entryDatas == null || entryDatas.size() == 0) {
            return;
        }
        SWCPageCache cache = new SWCPageCache(this.getView());
        Boolean isCancel = (Boolean)cache.get(this.getView().getPageId() + "_isOpenTaxCalCancel", Boolean.class);
        if (isCancel != null && isCancel.booleanValue()) {
            cache.remove(this.getView().getPageId() + "_isOpenTaxCalCancel");
            return;
        }
        ChangeData[] changeDatas0 = e.getChangeSet();
        ChangeData data = changeDatas0[0];
        String oldValue = (String)data.getOldValue();
        String newValue = (String)data.getNewValue();
        if (SWCStringUtils.equals((String)oldValue, (String)"1") && SWCStringUtils.equals((String)newValue, (String)"0")) {
            String pageId = this.getView().getPageId();
            HashMap<String, String> cacheMap = new HashMap<String, String>(2);
            cacheMap.put("oldValue", oldValue);
            cacheMap.put("newValue", newValue);
            cache.put(pageId + "_opentaxcalchange", cacheMap);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u9700\u8981\u624b\u5de5\u7ef4\u62a4\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u7684\u6570\u636e\u6765\u6e90\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"CalRuleEdit_33", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OPENTAXCAL_CHANGE_EVENT_CALLBACK));
        } else if (SWCStringUtils.equals((String)oldValue, (String)"0") && SWCStringUtils.equals((String)newValue, (String)"1")) {
            String pageId = this.getView().getPageId();
            HashMap<String, String> cacheMap = new HashMap<String, String>(2);
            cacheMap.put("oldValue", oldValue);
            cacheMap.put("newValue", newValue);
            cache.put(pageId + "_opentaxcalchange", cacheMap);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u7684\u6570\u636e\u6765\u6e90\u5c06\u81ea\u52a8\u8c03\u6574\u4e3a\u4e2a\u7a0e\u4e91\u670d\u52a1\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"CalRuleEdit_34", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OPENTAXCAL_CHANGE_EVENT_CALLBACK));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "save": 
            case "saveandnew": {
                ((EntryGrid)this.getControl(CALRULEITEMENTRY)).clearEntryState();
                this.setEntryFieldState(this.getModel());
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "unaudit": 
            case "disable": 
            case "enable": {
                ((EntryGrid)this.getControl(CALRULEITEMENTRY)).clearEntryState();
                break;
            }
            case "moveentryup": 
            case "moveentrydown": {
                this.flushEntitySort();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        AreaHelper.initAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
        this.setCostItemVisible();
        this.getView().setVisible(Boolean.valueOf(CostHelper.isEnableCost()), new String[]{FIELD_ISCOSTALLOT});
        DynamicObjectCollection calruleItemEntryColl = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        this.getModel().beginInit();
        for (int i = 0; i < calruleItemEntryColl.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)calruleItemEntryColl.get(i);
            String dataSource = dynamicObject.getString(FIELD_DATASOURCE);
            if (!SWCStringUtils.equals((String)"4", (String)dataSource) && !SWCStringUtils.equals((String)"6", (String)dataSource)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{FIELD_FORMULA});
        }
        this.getModel().endInit();
        this.getView().updateView(CALRULEITEMENTRY);
        this.getModel().setDataChanged(false);
    }

    private void setCostItemVisible() {
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)0L);
        if (paramMap != null) {
            Boolean isshowcostitem = (Boolean)paramMap.get("isshowcostitem");
            this.getView().setVisible(isshowcostitem, new String[]{FIELD_ISCOSTALLOT});
        }
    }

    private void openFormulaF7() {
        DynamicObject mainOrgObj;
        if (!this.checkAreaAndCountry() || !this.checkBsed()) {
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_formula", (boolean)true);
        showParameter.setHasRight(true);
        MainEntityType billEntityType = this.getModel().getDataEntityType();
        String mainOrgProp = billEntityType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrgProp) && (mainOrgObj = (DynamicObject)this.getModel().getValue(mainOrgProp)) != null && mainOrgObj.getPkValue() != null) {
            long orgID = (Long)mainOrgObj.getPkValue();
            IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
            QFilter qFilter = baseDataService.getBaseDataFilter("hsas_formula", Long.valueOf(orgID));
            qFilters.add(qFilter);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_formula"));
        List<Long> billIds = this.getEntryItemIds();
        if (billIds.size() > 0) {
            qFilters.add(new QFilter(FIELD_SALARYITEM, "not in", billIds));
        }
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("usetype", "=", (Object)"0"));
        String areaType = this.getModel().getDataEntity().getString(FIELD_AREATYPE);
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        QFilter areaFilter = AreaHelper.addAreaFilter((long)countryId, (String)areaType);
        if (null != areaFilter) {
            qFilters.add(areaFilter);
        }
        Date bsedDate = this.getModel().getDataEntity().getDate("bsed");
        QFilter dateFilter = new QFilter("firstbsed", "<=", (Object)bsedDate);
        qFilters.add(dateFilter);
        showParameter.getListFilterParameter().setQFilters(qFilters);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean checkBsed() {
        if (this.getModel().getValue("bsed") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u751f\u6548\u65e5\u671f\u3002", (String)"CalRuleEdit_35", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkAreaAndCountry() {
        if (!AreaHelper.checkArea((DynamicObject)this.getModel().getDataEntity())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u540e\uff0c\u518d\u9009\u62e9\u201c\u85aa\u916c\u9879\u76ee\u6784\u6210\u53ca\u8ba1\u7b97\u516c\u5f0f\u201d\u548c\u201c\u603b\u85aa\u8d44\u4e0e\u51c0\u85aa\u8d44\u201d\u3002", (String)"CalRuleEdit_26", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkSalaryItemExist(int index) {
        if (this.getModel().getValue(FIELD_SALARYITEM, index) == null) {
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u8bf7\u5148\u586b\u5199\u85aa\u916c\u9879\u76ee\u3002", (String)"CalRuleEdit_36", (String)"swc-hsas-formplugin", (Object[])new Object[0]), index + 1));
            return false;
        }
        return true;
    }

    private void addFormulaRows(ListSelectedRowCollection data) {
        if (data == null || data.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(FIELD_SALARYITEM, new Object[0]);
        vs.addField(FIELD_DATASOURCE, new Object[0]);
        vs.addField(FIELD_FORMULA, new Object[0]);
        vs.addField(FIELD_ISPAYOUTITEM, new Object[0]);
        vs.addField(FIELD_ISCOSTALLOT, new Object[0]);
        model.beginInit();
        DynamicObject salaryItem = null;
        ArrayList<String> errorMsgList = new ArrayList<String>(10);
        Map dataMap = CalItemGroupServiceHelper.getSelectFormulaMap((ListSelectedRowCollection)data, errorMsgList);
        DynamicObject tempFormula = null;
        for (Map.Entry entry : dataMap.entrySet()) {
            tempFormula = (DynamicObject)entry.getValue();
            salaryItem = tempFormula.getDynamicObject(FIELD_SALARYITEM);
            boolean isCostAllot = salaryItem.getBoolean(FIELD_ISCOSTALLOT);
            vs.addRow(new Object[]{salaryItem.getPkValue(), 1, tempFormula.getPkValue(), salaryItem.getString(FIELD_ISPAYOUTITEM), isCostAllot ? "1" : "0"});
        }
        model.batchCreateNewEntryRow(CALRULEITEMENTRY, vs);
        model.endInit();
        this.getView().updateView(CALRULEITEMENTRY);
        if (errorMsgList.size() > 0) {
            String totalMessage = MessageFormat.format(ResManager.loadKDString((String)"\u5171\u6dfb\u52a0{0}\u4e2a\u516c\u5f0f\uff0c{1}\u4e2a\u6dfb\u52a0\u6210\u529f\uff0c{2}\u4e2a\u6dfb\u52a0\u5931\u8d25\u3002", (String)"CalRuleEdit_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]), data.size(), dataMap.size(), errorMsgList.size());
            this.showOperationResult(ResManager.loadKDString((String)"\u6dfb\u52a0\u516c\u5f0f", (String)"CalRuleEdit_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]), totalMessage, errorMsgList);
        }
    }

    private void hideOperationColumn(ChangeData data) {
        DynamicObject entryObj = data.getDataEntity();
        DynamicObject formula = entryObj.getDynamicObject(FIELD_FORMULA);
        if (formula != null) {
            return;
        }
        int index = data.getRowIndex();
        EntryGrid grid = (EntryGrid)this.getControl(CALRULEITEMENTRY);
        ArrayList<String> operationKeys = new ArrayList<String>(1);
        operationKeys.add("viewsalaryitem");
        grid.hideOperateItems(OPERATIONCOLUMN, index, operationKeys);
    }

    private void showAllFormula() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        ArrayList<Long> formulaBaseIdList = new ArrayList<Long>(collection.size());
        DynamicObject itemObj = null;
        for (DynamicObject entry : collection) {
            itemObj = (DynamicObject)entry.get(FIELD_FORMULA);
            if (itemObj == null) continue;
            formulaBaseIdList.add(itemObj.getLong("id"));
        }
        CalItemGroupHelper.showAllFormula(formulaBaseIdList, (IFormView)this.getView(), (String)this.getModel().getDataEntity().getString("name"));
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey;
        switch (fieldKey = arg.getProperty().getName()) {
            case "formula": {
                if (this.checkBsed() && this.checkSalaryItemExist(this.getModel().getEntryCurrentRowIndex(CALRULEITEMENTRY))) {
                    int index = this.getModel().getEntryCurrentRowIndex(CALRULEITEMENTRY);
                    DynamicObject obj = this.getModel().getEntryRowEntity(CALRULEITEMENTRY, index);
                    Long salaryItemId = obj.getLong("salaryitem.id");
                    ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
                    QFilter qFilter = new QFilter(FIELD_SALARYITEM, "=", (Object)salaryItemId);
                    long countryId = this.getModel().getDataEntity().getLong("country.id");
                    QFilter countryFilter = AreaHelper.addCountryFilter((long)countryId);
                    qFilter.and(countryFilter);
                    Date bsedDate = this.getModel().getDataEntity().getDate("bsed");
                    QFilter dateFilter = new QFilter("firstbsed", "<=", (Object)bsedDate);
                    qFilter.and(new QFilter("usetype", "=", (Object)"0"));
                    qFilter.and(dateFilter);
                    param.getListFilterParameter().setFilter(qFilter);
                    break;
                }
                arg.setCancel(true);
                break;
            }
            case "totalsalary": {
                this.openSelectedSalaryItemF7(arg);
                break;
            }
            case "netsalary": {
                this.openSelectedSalaryItemF7(arg);
                break;
            }
            case "salaryitem": {
                if (this.checkAreaAndCountry() && this.checkBsed()) {
                    ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
                    param.getListFilterParameter().getQFilters().addAll(this.getSalaryItemFilter());
                    break;
                }
                arg.setCancel(true);
                break;
            }
            case "customprorationrule": {
                this.addProrationRuleFilter(arg);
                break;
            }
        }
    }

    private void addProrationRuleFilter(BeforeF7SelectEvent arg) {
        ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
        DynamicObject data = this.getModel().getDataEntity();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        long countryId = data.getLong("country.id");
        QFilter countryFilter = AreaHelper.addCountryFilter((long)countryId);
        long createOrgId = data.getLong("createorg.id");
        IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
        QFilter qFilter = baseDataService.getBaseDataFilter("hsas_prorationrule", Long.valueOf(createOrgId));
        Date bsed = data.getDate("bsed");
        QFilter filter = new QFilter("firstbsed", "<=", (Object)bsed);
        qFilters.add(countryFilter);
        qFilters.add(qFilter);
        qFilters.add(filter);
        showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
    }

    private void openSelectedSalaryItemF7(BeforeF7SelectEvent arg) {
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        String AMOUNT_TYPE = "1020_S";
        Set set = dyObjs.stream().filter(dyObj -> StringUtils.equals((CharSequence)dyObj.getString("salaryitem.datatype.number"), (CharSequence)"1020_S")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(set)) {
            List selectedSalaryItems = dyObjs.stream().map(dyObj -> dyObj.getLong("salaryitem.id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", selectedSalaryItems);
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u85aa\u916c\u9879\u76ee\uff0c\u8bf7\u5148\u5728\u201c\u85aa\u916c\u9879\u76ee\u6784\u6210\u53ca\u8ba1\u7b97\u516c\u5f0f\u201d\u4e2d\u6dfb\u52a0\u201c\u91d1\u989d\u201d\u7c7b\u578b\u7684\u85aa\u916c\u9879\u76ee\u3002", (String)"CalRuleEdit_20", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            arg.setCancel(true);
        }
    }

    private void checkOpenConfirmPage(ChangeData[] changeSets, Boolean isAraeType) {
        DynamicObjectCollection calruleitementry = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        Object netsalary = this.getModel().getDataEntity().get("netsalary");
        Object totalsalary = this.getModel().getDataEntity().get("totalsalary");
        if (calruleitementry.isEmpty() && null == netsalary && null == totalsalary) {
            AreaHelper.setAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
            return;
        }
        if (null == changeSets || changeSets.length == 0) {
            return;
        }
        String customValue = "";
        String callBack = "";
        if (isAraeType.booleanValue()) {
            ChangeData changeData = changeSets[0];
            Object oldValue = changeData.getOldValue();
            if (oldValue != null) {
                customValue = (String)changeData.getOldValue();
            }
            callBack = CALLBACK_AREATYPE;
        } else {
            ChangeData changeData = changeSets[0];
            Object oldValue = changeData.getOldValue();
            if (oldValue != null) {
                DynamicObject country = (DynamicObject)oldValue;
                Object countryId = country.get("id");
                customValue = String.valueOf(countryId);
            }
            callBack = FIELD_COUNTRY;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u5c06\u6e05\u7a7a\u201c\u85aa\u916c\u9879\u76ee\u6784\u6210\u53ca\u8ba1\u7b97\u516c\u5f0f\u201d\u548c\u201c\u603b\u85aa\u8d44\u4e0e\u51c0\u85aa\u8d44\u201d\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"CalRuleEdit_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(callBack), null, customValue);
    }

    private void openMovePage() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState(CALRULEITEMENTRY).getSelectedRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"CalRuleEdit_41", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rowIndexs.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"CalRuleEdit_42", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calorderadjustment");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObjectCollection dyEntryEntity = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        int entryEntitysize = dyEntryEntity.size();
        showParameter.setCustomParam("max", (Object)String.valueOf(entryEntitysize));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callbackmovesync");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void setMove(Map<String, Object> returnData) {
        Object rowNumberObj = returnData.get("rownumber");
        String clickStatus = (String)returnData.get("clickStatus");
        if (!SWCStringUtils.equals((String)clickStatus, (String)"ok") || rowNumberObj == null) {
            return;
        }
        int rowNumber = Integer.parseInt(rowNumberObj.toString());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState(CALRULEITEMENTRY).getSelectedRows();
        DynamicObjectCollection dyEntryEntity = this.getModel().getEntryEntity(CALRULEITEMENTRY);
        int entryEntitysize = dyEntryEntity.size();
        if (rowNumber > entryEntitysize) {
            rowNumber = entryEntitysize;
        } else if (rowNumber < 1) {
            rowNumber = 1;
        }
        ArrayList<Integer> moveList = new ArrayList<Integer>(entryEntitysize);
        if (rowIndexs[0] == --rowNumber) {
            return;
        }
        if (rowIndexs[0] > rowNumber) {
            for (int index = rowNumber; index <= rowIndexs[0] - 1; ++index) {
                moveList.add(index);
            }
            int[] moveArray = new int[moveList.size()];
            for (int index = 0; index < moveList.size(); ++index) {
                moveArray[index] = (Integer)moveList.get(index);
            }
            this.getModel().moveEntryRowsDown(CALRULEITEMENTRY, moveArray);
            if (rowIndexs[0] == entryEntitysize - 1) {
                this.getView().updateView(CALRULEITEMENTRY);
            }
        } else if (rowIndexs[0] < rowNumber) {
            for (int index = rowIndexs[0] + 1; index <= rowNumber; ++index) {
                moveList.add(index);
            }
            int[] moveArray = new int[moveList.size()];
            for (int index = 0; index < moveList.size(); ++index) {
                moveArray[index] = (Integer)moveList.get(index);
            }
            this.getModel().moveEntryRowsUp(CALRULEITEMENTRY, moveArray);
            if (rowIndexs[0] == 0) {
                this.getView().updateView(CALRULEITEMENTRY);
            }
        }
        this.flushEntitySort();
    }

    private boolean checkAndConfirmItemDependon(BeforeDoOperationEventArgs args, String opKey) {
        ArrayList uniqueCodeList = new ArrayList(10);
        if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(CALRULEITEMENTRY))) {
            return true;
        }
        Map tempDataMap = CalItemGroupHelper.checkFormulaDependOnSItemIsExist((DynamicObject)this.getModel().getDataEntity(), (String)"hsas_calrule", uniqueCodeList);
        if (uniqueCodeList.size() == 0) {
            return true;
        }
        SWCDataServiceHelper salaryItemHelper = new SWCDataServiceHelper("hsbs_salaryitem");
        String fields = "name,uniquecode";
        QFilter qFilter = new QFilter("uniquecode", "in", uniqueCodeList);
        DynamicObject[] result = salaryItemHelper.query(fields, new QFilter[]{qFilter});
        HashMap<String, String> salaryItemMap = new HashMap<String, String>(result.length);
        for (DynamicObject salaryItem2 : result) {
            salaryItemMap.put(salaryItem2.getString("uniquecode"), salaryItem2.getString("name"));
        }
        if (tempDataMap == null || tempDataMap.size() == 0) {
            return true;
        }
        String confirmMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e2d\u4f7f\u7528\u7684\u85aa\u916c\u9879\u76ee\u672a\u5168\u90e8\u6dfb\u52a0\uff0c\u662f\u5426\u8981\u4e00\u952e\u6dfb\u52a0\uff1f", (String)"CalRuleEdit_37", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String message = this.dealErrorData(salaryItemMap, tempDataMap);
        HashMap<String, Object> valueMap = new HashMap<String, Object>(2);
        List salaryItemIdList = Arrays.stream(result).map(salaryItem -> salaryItem.getLong("id")).collect(Collectors.toList());
        valueMap.put("salaryItemIdList", salaryItemIdList);
        valueMap.put("operationKey", opKey);
        String valueMapStr = null;
        try {
            valueMapStr = JSONUtils.toString(valueMap);
        }
        catch (Exception e) {
            LOGGER.error("\u9879\u76ee\u4f9d\u8d56\u53c2\u6570\u7f16\u7801\u5931\u8d25");
        }
        this.getView().showConfirm(confirmMsg, message, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("checkAndConfirmItemDependon"), null, valueMapStr);
        args.setCancel(true);
        return false;
    }

    private void handleItemDependonCallback(MessageBoxClosedEvent messageBoxClosedEvent) {
        HashMap valueMap;
        try {
            valueMap = (HashMap)JSONUtils.cast((String)messageBoxClosedEvent.getCustomVaule(), Map.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u7801\u5931\u8d25");
            valueMap = new HashMap(0);
        }
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            List salaryItemIdList = (List)valueMap.get("salaryItemIdList");
            if (CollectionUtils.isEmpty((Collection)salaryItemIdList)) {
                return;
            }
            List itemIdList = salaryItemIdList.stream().map(itemId -> itemId instanceof Long ? ((Long)itemId).longValue() : ((Integer)itemId).longValue()).collect(Collectors.toList());
            String selectProperties = "id,name,number,ispayoutitem,taxtag,iscostallot,salaryitemtype,salaryitemtype.id,salaryitemtype.name,salaryitemtype.number";
            QFilter filter = new QFilter("id", "in", itemIdList);
            DynamicObject[] coll = new SWCDataServiceHelper("hsbs_salaryitem").query(selectProperties, new QFilter[]{filter}, "number asc");
            IDataModel dataModel = this.getModel();
            this.loadItemToEntity(coll, dataModel, null);
        } else {
            String operationKey = (String)valueMap.get("operationKey");
            if (SWCStringUtils.isEmpty((String)operationKey)) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("handleItemDependonCallback", "true");
            this.getView().invokeOperation(operationKey, operateOption);
        }
    }

    private String dealErrorData(Map<String, String> salaryItemMap, Map<String, List<String>> errorDataMap) {
        StringBuilder message = new StringBuilder();
        StringBuilder param = new StringBuilder();
        String msg = ResManager.loadKDString((String)"{0}\uff1a\u8ba1\u7b97\u516c\u5f0f\u4f7f\u7528\u7684\u85aa\u916c\u9879\u76ee\u672a\u5168\u90e8\u6dfb\u52a0\uff0c\u7f3a\u5c11{1}\u3002", (String)"CalRuleEdit_38", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        for (Map.Entry<String, List<String>> entry : errorDataMap.entrySet()) {
            param.setLength(0);
            for (String itemCode : entry.getValue()) {
                param.append(salaryItemMap.get(itemCode)).append('\u3001');
            }
            if (message.length() > 0) {
                message.append('\n');
            }
            message.append(MessageFormat.format(msg, entry.getKey(), param.substring(0, param.length() - 1)));
        }
        return message.toString();
    }
}

