/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcolla;

import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.infos.ResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabBatchCloseEvent;
import kd.bos.form.control.events.TabBatchCloseListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.swc.hsas.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hsas.common.constants.PayRollActGrpConstants;
import kd.swc.hsas.common.dto.HRPolicyDTO;
import kd.swc.hsas.common.dto.HRRuleDTO;
import kd.swc.hsas.common.dto.PayRollActSearchDTO;
import kd.swc.hsas.common.dto.ResponseDTO;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.ReflectUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public abstract class AbstractPayRollActGrpEdit
extends AbstractFormPlugin
implements TabSelectListener,
TreeNodeClickListener,
SearchEnterListener,
ClickListener,
RowClickEventListener,
BeforeF7SelectListener,
TabBatchCloseListener,
PayRollActGrpConstants {
    private static final Log LOGGER = LogFactory.getLog(AbstractPayRollActGrpEdit.class);
    private static final String LAST_VALUE = "lastValue";
    private static final String NEW_VALUE = "newValue";
    private static final int TREE_NODE_DEPTH = 3;
    public static final String RULE_ENGINE_DATA_MODE = "ruleEngineDataMode";
    public static final String CONFIRM_CALLBACK_SCENE_CHANGED = "CONFIRM_CALLBACK_SCENE_CHANGED";
    public static final String CACHE_SCENE_CHANGED_DATA = "CACHE_SCENE_CHANGED_DATA";
    public static final String CALLBACK_CTRLSTRATEGY_CHANGED = "CALLBACK_CTRLSTRATEGY_CHANGED";
    public static final String CACHE_CTRL_CHANGED_DATA = "CACHE_CTRL_CHANGED_DATA";

    protected abstract Boolean getPolicyEnable(String var1);

    abstract void afterGetExePreRulePolicy(HRPolicyDTO var1, String var2);

    protected abstract void afterGetFiledRulePolicyList(List<HRPolicyDTO> var1, String var2);

    abstract OperationStatus getPageStatus();

    public void afterCreateNewData(EventObject eventObject) {
        this.initRuleEngineDataCache();
    }

    private void initRuleEngineDataCache() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.isEmpty()) {
            return;
        }
        String status = this.getModel().getDataEntity().getString("status");
        Boolean isCopy = (Boolean)customParams.get("isCopy");
        Boolean isChange = (Boolean)customParams.get("isChange");
        Boolean flag = isCopy != null && isCopy != false || isChange != null && isChange != false;
        if (flag.booleanValue()) {
            this.getView().getFormShowParameter().setCustomParam(RULE_ENGINE_DATA_MODE, (Object)"NEW");
            this.getModel().setValue("policy", null);
            this.createFieldRulePolicyCache();
            this.createExePreRuleCache();
            return;
        }
    }

    private List<HRPolicyDTO> getFieldRulePolicyList() throws IOException {
        ArrayList<HRPolicyDTO> resultList = new ArrayList<HRPolicyDTO>(10);
        String fieldRuleCacheData = this.getPageCache().get("FIELD_RULE_TREE_DATA");
        if (SWCStringUtils.isEmpty((String)fieldRuleCacheData)) {
            return resultList;
        }
        List firstLeverTreeNodes = (List)SWCJSONUtils.cast((String)fieldRuleCacheData, List.class, (Class[])new Class[]{TreeNode.class});
        List secondLeverTreeNodes = PayRollActGrpHelper.getAllChildrenTreeNodeList((List)firstLeverTreeNodes);
        List thirdChildrenTreeNodeList = PayRollActGrpHelper.getAllChildrenTreeNodeList((List)secondLeverTreeNodes);
        if (CollectionUtils.isEmpty((Collection)thirdChildrenTreeNodeList)) {
            return resultList;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map policyPageIdMap = (Map)swcPageCache.get("CACHE_NODE_PAGE_ID_MAP", Map.class);
        Map createdFieldRuleMap = (Map)swcPageCache.get("CACHE_CREATED_FIELD_RULE_DATA", Map.class);
        for (TreeNode treeNode : thirdChildrenTreeNodeList) {
            String firstName;
            String tempPolicyStr;
            IFormView subView;
            String pageId;
            String nodeId = treeNode.getId();
            HRPolicyDTO policy = null;
            if (!CollectionUtils.isEmpty((Map)policyPageIdMap) && !SWCStringUtils.isEmpty((String)(pageId = (String)policyPageIdMap.get(nodeId))) && null != (subView = this.getView().getView(pageId)) && subView.getModel().isDataLoaded()) {
                policy = PayRollActGrpHelper.getFullHrPolicyFromView((IFormView)this.getView(), (String)pageId);
            }
            if (!CollectionUtils.isEmpty((Map)createdFieldRuleMap) && policy == null && !StringUtils.isEmpty((Object)(tempPolicyStr = (String)createdFieldRuleMap.get(nodeId)))) {
                policy = (HRPolicyDTO)SWCJSONUtils.cast((String)tempPolicyStr, HRPolicyDTO.class);
            }
            if (null == policy) continue;
            firstName = firstName.substring(0, (firstName = String.valueOf(this.getModel().getValue("name"))).length() > 20 ? 19 : firstName.length());
            String secondName = treeNode.getText();
            secondName = secondName.substring(0, secondName.length() > 10 ? 9 : secondName.length());
            String prefixName = ResManager.loadKDString((String)"{0}-{1}", (String)"AbstractPayRollActGrpEdit_12", (String)"swc-hsas-formplugin", (Object[])new Object[]{firstName, secondName});
            policy.setName(prefixName + '-' + policy.getNumber().substring(5));
            policy.setPolicyMode("FirstMatch");
            List defaultEntryBuList = PayRollActGrpHelper.getDefaultEntryBuList((IFormView)this.getView());
            policy.setEntryBuList(defaultEntryBuList);
            policy.setNodeId(nodeId);
            resultList.add(policy);
        }
        return resultList;
    }

    private HRPolicyDTO getPolicyByNodeId(String nodeId, Map<String, String> nodePageIdMap) throws IOException {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        if (CollectionUtils.isEmpty(nodePageIdMap)) {
            nodePageIdMap = (Map)swcPageCache.get("CACHE_NODE_PAGE_ID_MAP", Map.class);
        }
        HRPolicyDTO hrPolicy = null;
        Map createdFieldRuleMap = (Map)swcPageCache.get("CACHE_CREATED_FIELD_RULE_DATA", Map.class);
        if (!CollectionUtils.isEmpty((Map)createdFieldRuleMap)) {
            LOGGER.info("[payrollactg] !CollectionUtils.isEmpty(createdFieldRuleMap) = {}", (Object)createdFieldRuleMap);
            String ruleStr = (String)createdFieldRuleMap.get(nodeId);
            if (!SWCStringUtils.isEmpty((String)ruleStr)) {
                hrPolicy = (HRPolicyDTO)SWCJSONUtils.cast((String)ruleStr, HRPolicyDTO.class);
            }
        }
        if (nodePageIdMap != null && nodePageIdMap.size() > 0) {
            IFormView subView;
            LOGGER.info("[payrollactg] nodePageIdMap != null && nodePageIdMap.size() > 0 = {}", (Object)nodePageIdMap);
            String pageId = (String)nodePageIdMap.get(nodeId);
            if (!SWCStringUtils.isEmpty((String)pageId) && null != (subView = this.getView().getView(pageId)) && subView.getModel().isDataLoaded()) {
                hrPolicy = PayRollActGrpHelper.getFullHrPolicyFromView((IFormView)this.getView(), (String)pageId);
            }
        }
        if (null == hrPolicy) {
            LOGGER.info("[payrollactg] null == hrPolicy = {}", (Object)nodeId);
            hrPolicy = PayRollActGrpHelper.getHrPolicyFromSubEntity((IFormView)this.getView(), (String)nodeId);
        }
        return hrPolicy;
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.reloadPayRollActgTplData(dataEntity.getDynamicObject("payrollactgtpl"));
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getModel().setItemValueByNumber("bizapp", "hsas");
        this.getModel().setDataChanged(false);
        this.setMapRuleFlexVisible(Boolean.FALSE, Boolean.FALSE);
        this.reloadExePreRuleDesignCache();
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"msgsubscriber"});
        }
        try {
            this.reloadMapRuleTreeView(null, true);
        }
        catch (IOException ex) {
            throw PayRollActGrpHelper.getDefaultException((Exception)ex);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("ruledesignstr".equals(key)) {
            evt.setCancel(this.validateBeforePopRuleDesign());
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey = event.getProperty().getName();
        try {
            switch (fieldKey) {
                case "payrollactgtpl": {
                    this.payRollActGrpTplPropertyChanged(event);
                    break;
                }
                case "msgsubscriber": {
                    break;
                }
                case "payrollact": {
                    this.initMapRuleTree(event);
                    this.abstractSortEntryEntity();
                    break;
                }
                case "actgfieldmapobjview": {
                    this.clearFieldMapValue(event);
                    this.fieldMapEntrySaveData();
                    this.fieldMapEntryRefreshLayout();
                    break;
                }
                case "fieldmapview": {
                    this.fieldMapEntrySaveData();
                    this.fieldMapEntryRefreshLayout();
                    break;
                }
                case "ruledesignstr": {
                    this.clearExePreRuleDesignData(event);
                    break;
                }
                case "scene": {
                    this.onScenePropertyChanged(event);
                    break;
                }
                case "ctrlstrategy": {
                    this.onCtrlStrategyPropertyChanged(event);
                    break;
                }
            }
        }
        catch (IOException ex) {
            throw PayRollActGrpHelper.getDefaultException((Exception)ex);
        }
    }

    private void onCtrlStrategyPropertyChanged(PropertyChangedArgs event) {
        ChangeData changeData = event.getChangeSet()[0];
        String newValue = (String)changeData.getNewValue();
        String oldValue = (String)changeData.getOldValue();
        if ("7".equals(newValue) && !"7".equals(oldValue)) {
            IPageCache pageCache = this.getView().getPageCache();
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u63a7\u5236\u7b56\u7565\u4e3a\u79c1\u6709\u5c06\u6e05\u7a7a\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u4e2d\u7684\u5b57\u6bb5\u89c4\u5219\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AbstractPayRollActGrpEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACK_CTRLSTRATEGY_CHANGED, (IFormPlugin)this), null, oldValue);
        } else if ("7".equals(oldValue) && !"7".equals(newValue)) {
            Map nodePageMap = (Map)new SWCPageCache(this.getView()).get("CACHE_NODE_PAGE_ID_MAP", Map.class);
            if (CollectionUtils.isEmpty((Map)nodePageMap)) {
                return;
            }
            nodePageMap.forEach((nodePage, pageId) -> {
                IFormView view = this.getView().getView(pageId);
                if (view.getModel().isDataLoaded()) {
                    view.addClientCallBack("CLIENT_CALLBACK_UPDATE_F7_FILTER");
                    this.getView().sendFormAction(view);
                }
            });
        }
    }

    private void onScenePropertyChanged(PropertyChangedArgs event) {
        ChangeData changeSet = event.getChangeSet()[0];
        DynamicObject newValue = (DynamicObject)changeSet.getNewValue();
        DynamicObject oldValue = (DynamicObject)changeSet.getOldValue();
        if (oldValue == null) {
            this.clearPolicyAndRuleData();
            return;
        }
        this.getView().getPageCache().put(CACHE_SCENE_CHANGED_DATA, String.valueOf(oldValue.getLong("id")));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u573a\u666f\u5c06\u6e05\u7a7a\u534f\u4f5c\u6d3b\u52a8\u8bbe\u7f6e\u7684\u6267\u884c\u524d\u63d0\u6761\u4ef6\u548c\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u7684\u5b57\u6bb5\u89c4\u5219\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AbstractPayRollActGrpEdit_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_SCENE_CHANGED, (IFormPlugin)this));
    }

    private void onSceneChangedCallback(MessageBoxClosedEvent event) {
        String oldValue = this.getView().getPageCache().get(CACHE_SCENE_CHANGED_DATA);
        this.getView().getPageCache().remove(CACHE_SCENE_CHANGED_DATA);
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.registerListeners();
            this.clearPolicyAndRuleData();
        }
        if (MessageBoxResult.Cancel.equals((Object)result)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.setValue("scene", SWCStringUtils.isNotEmpty((String)oldValue) && !"null".equalsIgnoreCase(oldValue) ? oldValue : null);
            model.endInit();
            this.getView().updateView("scene");
        }
    }

    private void clearPolicyAndRuleData() {
        this.clearPolicyAndRuleData(true);
    }

    private void clearPolicyAndRuleData(boolean isClearExePreCondition) {
        this.clearAllFieldRuleData(isClearExePreCondition);
        DynamicObjectCollection reloadData = this.getModel().getEntryEntity("entryentity");
        Map fieldMap = PayRollActGrpHelper.getAllTriggerCollaIsFiledMaps((DynamicObjectCollection)reloadData);
        try {
            this.reloadFieldRuleTree(reloadData, fieldMap, true);
            List<String> fieldRuleThirdNodeList = this.getFieldRuleThirdNodeList();
            this.clearPolicyTabPages(fieldRuleThirdNodeList);
            this.updateFieldRuleCache(fieldRuleThirdNodeList);
        }
        catch (IOException ex) {
            LOGGER.info("clearPolicyAndRuleData error.", (Object)ex);
            throw PayRollActGrpHelper.getDefaultException((Exception)ex);
        }
        Tab control = (Tab)this.getView().getControl("tabap");
        control.activeTab("fieldruletabpageap");
        control.selectTab("fieldruletabpageap");
    }

    public void clearAllFieldRuleData(boolean isClearExePreCondition) {
        int entryCount = this.getModel().getEntryRowCount("entryentity");
        if (isClearExePreCondition) {
            for (int i = 0; i < entryCount; ++i) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", i);
                this.getModel().setValue("ruledesign", null, i);
                this.getModel().setValue("ruledesignnumber", null, i);
                this.getModel().setValue("ruledesignstr", null, i);
                DynamicObjectCollection fieldRuleEntry = entryRowEntity.getDynamicObjectCollection("fieldrulesubentryentity");
                if (CollectionUtils.isEmpty((Collection)fieldRuleEntry)) continue;
                this.getModel().setValue("fieldrulesubentryentity", null, i);
            }
        }
        this.getModel().deleteEntryData("fieldrulesubentryentity");
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put("CACHE_CREATED_FIELD_RULE_DATA", null);
        swcPageCache.put("CACHE_NODE_PAGE_ID_MAP", null);
        swcPageCache.put("CACHE_CURRENT_FIELD_RULE_FOCUS_NODE_ID", null);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "tplcallback": {
                this.payrollActGrpTplCallback(messageBoxClosedEvent);
                break;
            }
            case "msgcallback": {
                break;
            }
            case "CALL_BACK_CLEAR_FIELD_MAP_VIEW": {
                this.clearFieldMapValueCallBack(messageBoxClosedEvent);
                break;
            }
            case "CONFIRM_CALLBACK_SCENE_CHANGED": {
                this.onSceneChangedCallback(messageBoxClosedEvent);
                break;
            }
            case "CALLBACK_CTRLSTRATEGY_CHANGED": {
                this.onCtrlStrategyCallBack(messageBoxClosedEvent);
                break;
            }
        }
    }

    private void onCtrlStrategyCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String oldValue = messageBoxClosedEvent.getCustomVaule();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.registerListeners();
            this.clearPolicyAndRuleData(false);
        } else if (MessageBoxResult.Cancel.equals((Object)result)) {
            this.getModel().setValue("ctrlstrategy", (Object)oldValue);
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TextEdit ruleDesign = (TextEdit)this.getView().getControl("ruledesignstr");
        ruleDesign.addButtonClickListener((ClickListener)this);
        Tab fieldMapTab = (Tab)this.getView().getControl("tabap");
        fieldMapTab.addTabSelectListener((TabSelectListener)this);
        fieldMapTab.addTabBatchCloseListener((TabBatchCloseListener)this);
        TreeView fieldMapTree = (TreeView)this.getView().getControl("fieldmaptree");
        fieldMapTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView fieldRuleTree = (TreeView)this.getView().getControl("fieldruletree");
        fieldRuleTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search fieldRuleSearch = (Search)this.getView().getControl("fieldrulesearch");
        fieldRuleSearch.addEnterListener((SearchEnterListener)this);
        Search fieldMapSearch = (Search)this.getView().getControl("fieldmapsearch");
        fieldMapSearch.addEnterListener((SearchEnterListener)this);
        BasedataEdit payRollAct = (BasedataEdit)this.getView().getControl("payrollact");
        payRollAct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fieldMapObj = (BasedataEdit)this.getView().getControl("actgfieldmapobjview");
        fieldMapObj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fieldMapView = (BasedataEdit)this.getView().getControl("fieldmapview");
        fieldMapView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab policyTab = (Tab)this.getView().getControl("policytabap");
        policyTab.addTabBatchCloseListener((TabBatchCloseListener)this);
        BasedataEdit scene = (BasedataEdit)this.getView().getControl("scene");
        scene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit msgSub = (BasedataEdit)this.getView().getControl("msgsubscriber");
        msgSub.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void registerListeners() {
        TreeView fieldRuleTree;
        List ruleTreeNodeClickListeners;
        TreeView fieldMapTree;
        List treeNodeClickListeners;
        List batchCloseListeners;
        Tab fieldMapTab = (Tab)this.getView().getControl("tabap");
        List tabSelectListeners = (List)ReflectUtils.getFieldValue((String)"tabSelectListeners", (Object)fieldMapTab);
        if (tabSelectListeners == null || tabSelectListeners.isEmpty() || !tabSelectListeners.contains((Object)this)) {
            fieldMapTab.addTabSelectListener((TabSelectListener)this);
        }
        if ((batchCloseListeners = (List)ReflectUtils.getFieldValue((String)"tabBatchCloseListeners", (Object)fieldMapTab)) == null || batchCloseListeners.isEmpty() || !batchCloseListeners.contains((Object)this)) {
            fieldMapTab.addTabBatchCloseListener((TabBatchCloseListener)this);
        }
        if ((treeNodeClickListeners = (List)ReflectUtils.getFieldValue((String)"treeNodeClickListeners", (Object)(fieldMapTree = (TreeView)this.getView().getControl("fieldmaptree")))) == null || treeNodeClickListeners.isEmpty() || !treeNodeClickListeners.contains((Object)this)) {
            fieldMapTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        if ((ruleTreeNodeClickListeners = (List)ReflectUtils.getFieldValue((String)"treeNodeClickListeners", (Object)(fieldRuleTree = (TreeView)this.getView().getControl("fieldruletree")))) == null || ruleTreeNodeClickListeners.isEmpty() || !ruleTreeNodeClickListeners.contains((Object)this)) {
            fieldRuleTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("EXE_PRE_RULE_POLICY".equals(closedCallBackEvent.getActionId())) {
            this.exePreRuleCallBackHandler(closedCallBackEvent);
        }
        if ("CALLBACK_SHOW_PAY_ROLL_ACT_SETTING_NEW_PAGE".equals(closedCallBackEvent.getActionId())) {
            this.showPayRollActSettingNewPageCallBackHandler(closedCallBackEvent);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        if (SWCStringUtils.isEmpty((String)tabKey)) {
            return;
        }
        switch (tabKey) {
            case "fieldruletabpageap": {
                this.selectFieldRuleTabPage();
                break;
            }
            case "fieldmaptabpageap": {
                this.selectFieldMapTabPage();
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent event) {
        super.treeNodeClick(event);
        TreeView treeView = (TreeView)event.getSource();
        String key = treeView.getKey();
        String nodeId = (String)event.getNodeId();
        try {
            switch (key) {
                case "fieldmaptree": {
                    this.clickFieldMapTree(event);
                    break;
                }
                case "fieldruletree": {
                    this.clickFieldRuleTree(nodeId);
                    break;
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error("treeNodeClick,\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\u3002", (Object)event);
        }
    }

    public void search(SearchEnterEvent event) {
        Search source = (Search)event.getSource();
        String key = source.getKey();
        if (SWCStringUtils.isEmpty((String)key)) {
            return;
        }
        switch (key) {
            case "fieldmapsearch": {
                this.searchFieldMap(event.getText());
                break;
            }
            case "fieldrulesearch": {
                this.searchFieldRule(event.getText());
                break;
            }
        }
    }

    public void click(EventObject event) {
        super.click(event);
        Control source = (Control)event.getSource();
        String key = source.getKey();
        if ("ruledesignstr".equals(key)) {
            this.showExePreRuleDesignPage();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs event) {
        if (SWCStringUtils.equals((String)"fieldmapviewentryentity", (String)event.getEntryProp().getName())) {
            this.fieldMapEntryRefreshLayout();
        }
        if (SWCStringUtils.equals((String)"entryentity", (String)event.getEntryProp().getName())) {
            try {
                this.reloadMapRuleTreeView(null, false);
            }
            catch (IOException ex) {
                throw PayRollActGrpHelper.getDefaultException((Exception)ex);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs event) {
        this.registerListeners();
        if (SWCStringUtils.equals((String)"fieldmapviewentryentity", (String)event.getEntryProp().getName())) {
            this.fieldMapEntryRemoveDataRows(event.getRowIndexs());
            return;
        }
        if (SWCStringUtils.equals((String)"entryentity", (String)event.getEntryProp().getName())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            try {
                this.reloadMapRuleTreeView(entryEntity, true);
            }
            catch (IOException ex) {
                throw PayRollActGrpHelper.getDefaultException((Exception)ex);
            }
        }
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs event) {
        if (SWCStringUtils.equals((String)"fieldmapviewentryentity", (String)event.getEntryProp().getName())) {
            this.fieldMapEntrySaveData();
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs event) {
        if (SWCStringUtils.equals((String)"fieldmapviewentryentity", (String)event.getEntryProp().getName())) {
            this.fieldMapEntrySaveData();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "actgfieldmapobjview": {
                FormShowParameter formShowParameter = event.getFormShowParameter();
                formShowParameter.setFormId("bos_listf7");
                event.setCustomQFilters(PayRollActGrpHelper.getFiledMapObjctFilter((IFormView)this.getView(), (Integer)event.getRow()));
                break;
            }
            case "fieldmapview": {
                event.setCustomQFilters(this.getFieldMapFilter(event));
                break;
            }
            case "scene": {
                this.onBeforeSceneSelected(event);
                break;
            }
            case "msgsubscriber": {
                event.addCustomQFilter(new QFilter("subscribebd", "=", (Object)107010L));
                break;
            }
        }
    }

    private void onBeforeSceneSelected(BeforeF7SelectEvent event) {
        List<String> appIds = Arrays.asList("/UHMBBGZQ65X", "0NXW1VOPH+QV");
        event.addCustomQFilter(new QFilter("bizappid.id", "in", appIds));
        FormShowParameter formShowParameter = event.getFormShowParameter();
        formShowParameter.setCustomParam("bizappids", (Object)appIds.stream().collect(Collectors.joining("\",\"", "[\"", "\"]")));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "formsubmit": 
            case "changesave": 
            case "auditconfirmchange": {
                if (event.isCancel() || !this.beforeSaveOperation(formOperate, operateKey)) break;
                event.setCancel(true);
                break;
            }
            case "deleteentry": {
                if (!this.validateBeforeDeletePayrollactEntry()) break;
                event.setCancel(true);
                break;
            }
            case "donothing_newentryf7": {
                if (!this.validateBeforeNewPayrollactEntry()) break;
                event.setCancel(true);
                break;
            }
            case "refresh": {
                this.registerListeners();
                IPageCache pageCache = this.getView().getPageCache();
                pageCache.batchRemove(Arrays.asList("CACHE_CURRENT_FIELD_RULE_FOCUS_NODE_ID", "CACHE_NODE_PAGE_ID_MAP", "CACHE_CURRENT_FIELD_MAP_FOCUS_NODE_ID"));
                pageCache.saveChanges();
                break;
            }
        }
    }

    private boolean beforeSaveOperation(FormOperate formOperate, String operateKey) {
        try {
            List<String> batchValidPolicyResultList = this.getBatchValidPolicyResultList(this.getView());
            if (!CollectionUtils.isEmpty(batchValidPolicyResultList)) {
                formOperate.getOption().setVariableValue("batchValidPolicyResultMsgList", SWCJSONUtils.toString(batchValidPolicyResultList));
                return false;
            }
            if (!this.savePayRollActGroupPolicy(operateKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractPayRollActGrpEdit_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        catch (IOException ex) {
            LOGGER.info("json\u5e8f\u5217\u5316\u51fa\u73b0\u9519\u8bef", (Object)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractPayRollActGrpEdit_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": 
            case "formsubmit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "donothing_confirmchange": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult.isSuccess()) break;
                IPageCache pageCache = this.getView().getPageCache();
                pageCache.remove("CACHE_CREATED_FIELD_RULE_DATA");
                this.getView().invokeOperation("refresh");
                break;
            }
            case "changesave": {
                break;
            }
            case "auditconfirmchange": {
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) {
                    return;
                }
                if (!"hsas_payrollactg".equals(parentView.getEntityId())) {
                    return;
                }
                Boolean isChange = (Boolean)this.getView().getFormShowParameter().getCustomParam("isChange");
                if (isChange != null && isChange.booleanValue()) break;
                return;
            }
            case "deleteentry": {
                this.abstractSortEntryEntity();
                break;
            }
            case "donothing_newentryf7": {
                this.showPayRollActSettingNewPage();
                break;
            }
        }
    }

    private void reloadAfterOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult.isSuccess()) {
            try {
                this.reloadMapRuleTreeView(null, true);
            }
            catch (IOException e) {
                throw PayRollActGrpHelper.getDefaultException((Exception)e);
            }
        }
    }

    protected void createFieldRulePolicyCache() {
        int entryCount = this.getModel().getEntryRowCount("entryentity");
        ArrayList tempFieldRuleEntryEntityList = new ArrayList(10);
        for (int i = 0; i < entryCount; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", i);
            DynamicObjectCollection fieldRuleEntry = entryRowEntity.getDynamicObjectCollection("fieldrulesubentryentity");
            if (CollectionUtils.isEmpty((Collection)fieldRuleEntry)) continue;
            tempFieldRuleEntryEntityList.addAll(fieldRuleEntry);
            this.getModel().setValue("fieldrulesubentryentity", null, i);
        }
        this.getModel().deleteEntryData("fieldrulesubentryentity");
        if (CollectionUtils.isEmpty(tempFieldRuleEntryEntityList)) {
            return;
        }
        int policyCodeRuleSize = 0;
        int ruleCodeRuleSize = 0;
        for (DynamicObject dynamicObject : tempFieldRuleEntryEntityList) {
            DynamicObject policy = dynamicObject.getDynamicObject("frpolicy");
            if (policy == null) continue;
            DynamicObjectCollection ruleList = policy.getDynamicObjectCollection("entryrulelist");
            ++policyCodeRuleSize;
            if (ruleList == null || ruleList.size() == 0) continue;
            ruleCodeRuleSize += ruleList.size();
        }
        String[] policyCodes = PayRollActGrpHelper.newPolicyNumbers((int)policyCodeRuleSize);
        String[] ruleCodes = PayRollActGrpHelper.newRuleNumbers((int)ruleCodeRuleSize);
        int policyHead = 0;
        int ruleHead = 0;
        HashMap<String, String> fieldRuleMap = new HashMap<String, String>(16);
        for (DynamicObject dynamicObject : tempFieldRuleEntryEntityList) {
            String payRollActId = dynamicObject.getString("frpayrollact.id");
            String triggerCollaId = dynamicObject.getString("frtriggercolla.id");
            String object = dynamicObject.getString("frtriggercolla.entityobject.id");
            String fieldKeyId = dynamicObject.getString("frfieldkey");
            DynamicObject policy = dynamicObject.getDynamicObject("frpolicy");
            if (policy == null) continue;
            String key = "L3#" + String.join((CharSequence)"#", payRollActId, triggerCollaId, object, fieldKeyId);
            HRPolicyDTO hrPolicy = PayRollActGrpHelper.convertBrmPolicyDynamicToHrPolicy((DynamicObject)policy);
            hrPolicy.setId(null);
            String policyNumber = policyHead >= policyCodes.length ? PayRollActGrpHelper.newPolicyNumber() : policyCodes[policyHead++];
            hrPolicy.setNumber(policyNumber);
            hrPolicy.setName(policyNumber);
            List entryRuleList = hrPolicy.getEntryRuleList();
            if (!CollectionUtils.isEmpty((Collection)entryRuleList)) {
                for (HRRuleDTO hrRule : entryRuleList) {
                    String ruleNumber = ruleHead >= ruleCodes.length ? PayRollActGrpHelper.newRuleNumber() : ruleCodes[ruleHead++];
                    hrRule.setRuleNumber(ruleNumber);
                    hrRule.setRuleName(ruleNumber);
                    hrRule.setId(null);
                }
            }
            fieldRuleMap.put(key, hrPolicy.toJson());
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put("CACHE_CREATED_FIELD_RULE_DATA", fieldRuleMap);
    }

    protected void createExePreRuleCache() {
        int count = this.getModel().getEntryRowCount("entryentity");
        HashMap<String, String> exePreRuleCacheMap = new HashMap<String, String>(16);
        this.getModel().setValue("policy", null);
        for (int i = 0; i < count; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", i);
            DynamicObject ruleDesign = entryRowEntity.getDynamicObject("ruledesign");
            if (null == ruleDesign) continue;
            HRRuleDTO hrRule = HRRuleDTO.fromDynamicObject((DynamicObject)ruleDesign);
            hrRule.setId(null);
            hrRule.setRuleNumber(PayRollActGrpHelper.newRuleNumber());
            hrRule.setRuleName(hrRule.getRuleNumber());
            exePreRuleCacheMap.put(hrRule.getRuleNumber(), hrRule.toJson());
            this.getModel().setValue("ruledesign", null, i);
            this.getModel().setValue("ruledesignstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)hrRule.getFilterCondition()), i);
            this.getModel().setValue("ruledesignnumber", (Object)hrRule.getRuleNumber(), i);
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put("CACHE_RULE_DESIGN_DATA", exePreRuleCacheMap);
    }

    protected void showExePreRuleDesignPage() {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u524d\u63d0\u6761\u4ef6\u8bbe\u7f6e", (String)"AbstractPayRollActGrpEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        billShowParameter.setCustomParams(this.getRuleParaMap());
        billShowParameter.setFormId("hsas_ruledesignconfig");
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("600");
        inlineStyleCss.setWidth("1200");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        billShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "EXE_PRE_RULE_POLICY"));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private Map<String, Object> getRuleParaMap() {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("sceneId", PayRollActGrpHelper.getCurrentSceneId((IFormView)this.getView()));
        param.put("hrRule", this.getExePreHrRule());
        param.put("ruleResultVisibility", Boolean.FALSE);
        param.put("dataStatus", this.getPageStatus());
        return param;
    }

    private HRRuleDTO getExePreHrRule() {
        String ruleDesignNumber = (String)this.getModel().getValue("ruledesignnumber");
        return this.getExePreRuleCacheById(ruleDesignNumber);
    }

    private List<String> getBatchValidPolicyResultList(IFormView view) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        SWCPageCache swcPageCache = new SWCPageCache(view);
        Map nodePageMap = (Map)swcPageCache.get("CACHE_NODE_PAGE_ID_MAP", Map.class);
        String fieldRuleTreeStr = view.getPageCache().get("FIELD_RULE_TREE_DATA");
        List thirdChildrenTreeNodeList = PayRollActGrpHelper.getThirdLevelTreeNodeList((IFormView)this.getView());
        if (CollectionUtils.isEmpty((Map)nodePageMap) || CollectionUtils.isEmpty((Collection)thirdChildrenTreeNodeList)) {
            return result;
        }
        LinkedHashSet<TreeNode> mustInputFieldId = new LinkedHashSet<TreeNode>(16);
        for (TreeNode treeNode : thirdChildrenTreeNodeList) {
            List lastChildPath;
            String nodeId = treeNode.getId();
            HRPolicyDTO policy = this.getPolicyByNodeId(nodeId, nodePageMap);
            Map data = (Map)treeNode.getData();
            if (CollectionUtils.isEmpty((Map)data)) continue;
            Boolean isMustInput = (Boolean)data.get("isMustInput");
            if (null == policy) {
                if (isMustInput == null || !isMustInput.booleanValue()) continue;
                mustInputFieldId.add(treeNode);
                continue;
            }
            String results = policy.getResults();
            List entryRuleList = policy.getEntryRuleList();
            if (SWCStringUtils.isEmpty((String)results) && CollectionUtils.isEmpty((Collection)entryRuleList) && isMustInput != null && isMustInput.booleanValue()) {
                mustInputFieldId.add(treeNode);
            }
            if (PayRollActGrpHelper.validPolicyResults((HRPolicyDTO)policy).booleanValue() || (lastChildPath = PayRollActGrpHelper.getChildPathNodesByNodeId((IFormView)view, (String)nodeId, (String)fieldRuleTreeStr)).size() != 3) continue;
            result.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e>{0}>{1}\u201d\u4e2d\u201c{2}\u201d\u7684\u9ed8\u8ba4\u503c\u3002", (String)"AbstractPayRollActGrpEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[]{((TreeNode)lastChildPath.get(0)).getText(), ((TreeNode)lastChildPath.get(1)).getText(), ((TreeNode)lastChildPath.get(2)).getText()}));
        }
        result.addAll(this.parseNotifyString(mustInputFieldId));
        return result;
    }

    private List<String> parseNotifyString(Set<TreeNode> mustInputFieldId) {
        ArrayList<String> result = new ArrayList<String>(10);
        if (mustInputFieldId == null || mustInputFieldId.isEmpty()) {
            return result;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return result;
        }
        HashMap payRollActMap = new HashMap(entryEntity.size());
        entryEntity.forEach(item -> {
            DynamicObject tempObj = item.getDynamicObject("payrollact");
            payRollActMap.put(tempObj.getString("id"), tempObj);
        });
        HashMap<String, List> tempResult = new HashMap<String, List>(entryEntity.size());
        for (TreeNode treeNode : mustInputFieldId) {
            String id = treeNode.getId();
            String[] split = id.split("#");
            String temPayRollActGrpId = split[1];
            ArrayList<String> fieldNames = (ArrayList<String>)tempResult.get(temPayRollActGrpId);
            if (fieldNames == null) {
                fieldNames = new ArrayList<String>(10);
            }
            fieldNames.add(treeNode.getText());
            tempResult.put(temPayRollActGrpId, fieldNames);
        }
        tempResult.forEach((key, value) -> {
            DynamicObject payRollActg = (DynamicObject)payRollActMap.get(key);
            if (payRollActg != null) {
                String payRollActName = payRollActg.getString("name");
                String fileds = value.stream().collect(Collectors.joining("\u201d\u3001\u201c"));
                result.add(ResManager.loadKDString((String)"\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u4e2d\u201c{0}\u201d\u7684\u201c{1}\u201d\u672a\u8bbe\u7f6e\u5b57\u6bb5\u89c4\u5219\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"AbstractPayRollActGrpEdit_17", (String)"swc-hsas-formplugin", (Object[])new Object[]{payRollActName, fileds}));
            }
        });
        return result;
    }

    private boolean validateBeforePopRuleDesign() {
        if (null == this.getModel().getValue("scene")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u8ba2\u9605\u7684\u4e1a\u52a1\u4e8b\u4ef6\u3002", (String)"AbstractPayRollActGrpEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void reloadPayRollActgTplData(DynamicObject payRollActgTplDyobj) {
        if (null != payRollActgTplDyobj) {
            IDataModel model = this.getModel();
            DynamicObjectCollection tplEntryentities = payRollActgTplDyobj.getDynamicObjectCollection("entryentity");
            Table payRollActProps = PayRollActGrpHelper.getPayRollActProps((DynamicObjectCollection)tplEntryentities);
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)tplEntryentities)) {
                return;
            }
            model.beginInit();
            for (int i = 0; i < entryEntity.size() && i < tplEntryentities.size(); ++i) {
                DynamicObject tplEntryentity = (DynamicObject)tplEntryentities.get(i);
                model.setValue("ismustexecute", tplEntryentity.get("ismustexecute"), i);
                String payRollActId = tplEntryentity.getString("payrollact.id");
                Boolean isPayRollActPreset = (Boolean)payRollActProps.get((Object)payRollActId, (Object)"issyspreset");
                if (null == isPayRollActPreset || !isPayRollActPreset.booleanValue()) continue;
                model.setValue("ispayrollactsyspreset", (Object)"1", i);
            }
            model.endInit();
            this.getView().updateView("entryentity");
            this.setIsExecuteEnable(tplEntryentities);
        }
    }

    private void clearExePreRuleDesignData(PropertyChangedArgs event) {
        ChangeData[] changeSet = event.getChangeSet();
        if (null == changeSet || changeSet.length == 0) {
            return;
        }
        for (ChangeData changeData : changeSet) {
            String newValue = String.valueOf(changeData.getNewValue());
            if (!SWCStringUtils.isEmpty((String)newValue)) continue;
            this.getModel().setValue("ruledesignnumber", null);
            this.getModel().setValue("ruledesign", null);
        }
    }

    private void clearFieldMapValue(PropertyChangedArgs event) {
        ChangeData[] changeSet = event.getChangeSet();
        if (null == changeSet || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        DynamicObject dataEntity = changeData.getDataEntity();
        DynamicObject dynamicObject = dataEntity.getDynamicObject("fieldmapview");
        if (null == dynamicObject) {
            return;
        }
        DynamicObjectCollection oldValue = (DynamicObjectCollection)changeData.getOldValue();
        if (CollectionUtils.isEmpty((Collection)oldValue)) {
            this.getPageCache().put("fieldMapOldValue", "");
        } else {
            List collect = oldValue.stream().map(mo -> mo.getString("fbasedataid.id")).collect(Collectors.toList());
            String join = String.join((CharSequence)",", collect);
            this.getPageCache().put("fieldMapOldValue", join);
        }
        if (!"1".equals(this.getPageCache().get("showConfirm"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u201c\u9002\u7528\u5b9e\u4f53\u5bf9\u8c61\u201d\uff0c\u4f1a\u6e05\u7a7a\u201c\u5b57\u6bb5\u6620\u5c04\u65b9\u6848\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AbstractPayRollActGrpEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CALL_BACK_CLEAR_FIELD_MAP_VIEW", (IFormPlugin)this));
        } else {
            this.getPageCache().remove("showConfirm");
        }
    }

    private void resetRuleScene(Long msgSubscriberId) {
        if (null == msgSubscriberId || msgSubscriberId < 1L) {
            this.getModel().setValue("scene", null);
            return;
        }
        DynamicObject queryOne = PayRollActGrpHelper.querySceneByMsgSubscriberId((Long)msgSubscriberId);
        if (null == queryOne) {
            return;
        }
        this.getModel().setValue("scene", (Object)queryOne.getLong("scene.id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgSubscriberPropertyChanged(PropertyChangedArgs event) throws IOException {
        ChangeData changeData = event.getChangeSet()[0];
        DynamicObject msgSubscriberDyobj = (DynamicObject)changeData.getNewValue();
        DynamicObject oldMsgSubscriberDyobj = (DynamicObject)changeData.getOldValue();
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isChange = (Boolean)pageCache.get("msgsubscribercache", Boolean.class);
        if (null == isChange) {
            pageCache.put("msgsubscribercache", (Object)Boolean.TRUE);
            if (null != oldMsgSubscriberDyobj) {
                this.showMsgSubscriberConfirmIfOldNewValDiffer(pageCache, msgSubscriberDyobj, oldMsgSubscriberDyobj);
            } else {
                try {
                    if (this.validateSlectedMsgSubcriber(msgSubscriberDyobj.getPkValue()).booleanValue()) {
                        this.copyTplEntryentity(pageCache, this.getModel().getValue("payrollactgtpl"));
                        this.setFieldMapSubEntryDefaultValue();
                    }
                }
                finally {
                    pageCache.remove("msgsubscribercache");
                }
            }
        }
    }

    private void showMsgSubscriberConfirmIfOldNewValDiffer(SWCPageCache pageCache, DynamicObject msgSubscriberDyobj, DynamicObject oldMsgSubscriberDyobj) {
        HashMap<String, Long> msgMap = new HashMap<String, Long>(16);
        msgMap.put(NEW_VALUE, msgSubscriberDyobj == null ? null : Long.valueOf(msgSubscriberDyobj.getLong("id")));
        msgMap.put(LAST_VALUE, oldMsgSubscriberDyobj == null ? null : Long.valueOf(oldMsgSubscriberDyobj.getLong("id")));
        pageCache.put("msgsubscribervalcache", msgMap);
        pageCache.put("msgsubscribercache", (Object)Boolean.FALSE);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u5c06\u66f4\u65b0\u534f\u4f5c\u6d3b\u52a8\u8bbe\u7f6e\u5e76\u6e05\u7a7a\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AbstractPayRollActGrpEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("msgcallback", (IFormPlugin)this));
        this.getModel().setValue("msgsubscriber", (Object)oldMsgSubscriberDyobj);
    }

    private void payRollActGrpTplPropertyChanged(PropertyChangedArgs event) throws IOException {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isChange = (Boolean)pageCache.get("tplchangecache", Boolean.class);
        ChangeData changeData = event.getChangeSet()[0];
        Object newValObj = changeData.getNewValue();
        if (null == isChange && this.showTplConfirmIfOldNewValDiffer(changeData.getOldValue(), newValObj, pageCache)) {
            return;
        }
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (isChange == null || isChange.booleanValue()) {
            if (isChange != null && isChange.booleanValue()) {
                this.registerListeners();
            }
            this.copyTplEntryentity(pageCache, newValObj);
        }
    }

    private boolean showTplConfirmIfOldNewValDiffer(Object oldValObj, Object newValObj, SWCPageCache pageCache) {
        if (null != oldValObj) {
            pageCache.put("tplchangevalcache", ((DynamicObject)oldValObj).get("id"));
            pageCache.put("tplchangecache", (Object)Boolean.FALSE);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u82e5\u4fee\u6539\u534f\u4f5c\u89c4\u5219\u6a21\u677f\uff0c\u201c\u534f\u4f5c\u6d3b\u52a8\u8bbe\u7f6e\u201d\u548c\u201c\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u201d\u5c06\u4f1a\u88ab\u66f4\u65b0\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AbstractPayRollActGrpEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("tplcallback", (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private void clearFieldMapValueCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().setValue("fieldmapview", null);
            return;
        }
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
            String idCaches = this.getPageCache().get("fieldMapOldValue");
            if (SWCStringUtils.isEmpty((String)idCaches)) {
                this.getModel().setValue("fieldmapview", null);
                return;
            }
            String[] ids = idCaches.split(",");
            this.getPageCache().put("showConfirm", "1");
            this.getModel().setValue("actgfieldmapobjview", (Object)ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgSubscriberCallBack(MessageBoxClosedEvent messageBoxClosedEvent) throws IOException {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        try {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                Map msgMap = (Map)pageCache.get("msgsubscribervalcache", Map.class);
                if (!this.validateSelectedMsgSubcriber(msgMap.get(NEW_VALUE), msgMap.get(LAST_VALUE)).booleanValue()) {
                    return;
                }
                pageCache.put("msgsubscribercache", (Object)Boolean.TRUE);
                this.getModel().setValue("msgsubscriber", msgMap.get(NEW_VALUE));
                this.getModel().setValue("policy", null);
                this.registerListeners();
                this.copyTplEntryentity(pageCache, this.getModel().getValue("payrollactgtpl"));
                this.fieldMapEntryClearData();
                this.setFieldMapSubEntryDefaultValue();
            }
        }
        finally {
            pageCache.remove("msgsubscribercache");
        }
    }

    private void payrollActGrpTplCallback(MessageBoxClosedEvent messageBoxClosedEvent) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            pageCache.put("tplchangecache", (Object)Boolean.TRUE);
            pageCache.remove("CACHE_CURRENT_FIELD_MAP_FOCUS_NODE_ID");
            pageCache.remove("CACHE_CURRENT_FIELD_RULE_FOCUS_NODE_ID");
            pageCache.remove("FIELD_MAP_TREE_DATA");
            pageCache.remove("FIELD_RULE_TREE_DATA");
            pageCache.remove("IS_FIELD_MAP_ENABLED_DATA");
            pageCache.remove("CACHE_NODE_PAGE_ID_MAP");
            pageCache.remove("CACHE_FIELD_RULE_POLICY");
            pageCache.remove("tplchangevalcache");
            try {
                this.registerListeners();
                this.copyTplEntryentity(pageCache, this.getModel().getValue("payrollactgtpl"));
            }
            catch (IOException e) {
                LOGGER.info("copyTplEntryentity error.", (Object)e);
            }
        } else {
            Object oldValObj = pageCache.get("tplchangevalcache", Object.class);
            IDataModel model = this.getModel();
            model.setValue("payrollactgtpl", oldValObj);
            pageCache.remove("tplchangevalcache");
            pageCache.remove("tplchangecache");
        }
        pageCache.saveChanges();
    }

    private void copyTplEntryentity(SWCPageCache pageCache, Object tplObj) throws IOException {
        IDataModel model = this.getModel();
        if (null != tplObj) {
            model.deleteEntryData("entryentity");
            model.deleteEntryData("fieldmapviewentryentity");
            model.deleteEntryData("subentryentity");
            model.deleteEntryData("fieldrulesubentryentity");
            model.deleteEntryData("entryentity");
            DynamicObject tplDyobj = (DynamicObject)tplObj;
            DynamicObjectCollection tplEntryentities = tplDyobj.getDynamicObjectCollection("entryentity");
            if (!tplEntryentities.isEmpty()) {
                Table payRollActProps = PayRollActGrpHelper.getPayRollActProps((DynamicObjectCollection)tplEntryentities);
                model.beginInit();
                this.setDataIntoEntryentity(model, tplEntryentities, (Table<String, String, Boolean>)payRollActProps);
                this.getView().updateView("entryentity");
                model.endInit();
                this.setIsExecuteEnable(tplEntryentities);
                this.setFieldMapSubEntryDefaultValue();
            }
        } else {
            model.deleteEntryData("entryentity");
        }
        this.reloadMapRuleTreeView(null, true);
        pageCache.remove("tplchangecache");
    }

    private void setIsExecuteEnable(DynamicObjectCollection tplEntryEntities) {
        int size = tplEntryEntities.size();
        for (int i = 0; i < size; ++i) {
            if (((DynamicObject)tplEntryEntities.get(i)).getBoolean("ismustexecute")) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"isexecute"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"isexecute"});
        }
    }

    private void setDataIntoEntryentity(IDataModel model, DynamicObjectCollection tplEntryEntities, Table<String, String, Boolean> payRollActProps) {
        int size = tplEntryEntities.size();
        for (int i = 0; i < size; ++i) {
            model.insertEntryRow("entryentity", i);
            DynamicObject tplEntryentity = (DynamicObject)tplEntryEntities.get(i);
            Long payRollActId = tplEntryentity.getLong("payrollact.id");
            model.setValue("payrollact", (Object)payRollActId, i);
            model.setValue("executeseq", tplEntryentity.get("executeseq"), i);
            model.setValue("ismustexecute", tplEntryentity.get("ismustexecute"), i);
            Boolean isPayRollActPreset = (Boolean)payRollActProps.get((Object)String.valueOf(payRollActId), (Object)"issyspreset");
            if (null == isPayRollActPreset || !isPayRollActPreset.booleanValue()) continue;
            model.setValue("ispayrollactsyspreset", (Object)"1", i);
        }
    }

    private void showPayRollActSettingNewPageCallBackHandler(ClosedCallBackEvent event) {
        if (event.getReturnData() != null && SWCStringUtils.equals((String)"CALLBACK_SHOW_PAY_ROLL_ACT_SETTING_NEW_PAGE", (String)event.getActionId())) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
            if (CollectionUtils.isEmpty((Collection)returnData)) {
                return;
            }
            List<Long> payRollActIds = returnData.stream().map(rt -> (Long)rt.getPrimaryKeyValue()).collect(Collectors.toList());
            List fillPayRollActSettingEntry = PayRollActGrpHelper.findPayRollActSettingEntry((IFormView)this.getView(), payRollActIds);
            this.addDataToEntryEntityWithOrder(payRollActIds, fillPayRollActSettingEntry);
        }
    }

    private void addDataToEntryEntityWithOrder(List<Long> payRollActIds, List<DynamicObject> entryEntitys) {
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject tempEntryRow = entryEntitys.get(i);
            Long tmpPayRollActId = tempEntryRow.getLong("payrollact.id");
            if (!payRollActIds.contains(tmpPayRollActId)) continue;
            this.getModel().insertEntryRow("entryentity", i);
            this.getModel().setValue("payrollact", (Object)tmpPayRollActId, i);
            this.getModel().setValue("executeseq", (Object)(i + 1), i);
            this.getModel().setValue("ismustexecute", tempEntryRow.get("ismustexecute"), i);
        }
        dataModel.endInit();
        this.getView().updateView("entryentity");
        this.setFieldMapSubEntryDefaultValue();
        try {
            this.registerListeners();
            this.reloadMapRuleTreeView(null, true);
        }
        catch (IOException e) {
            LOGGER.info("reloadMapRuleTreeView error.", (Object)e);
        }
        this.abstractSortEntryEntity();
    }

    private void setFieldMapSubEntryDefaultValue() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        HashMap<Integer, List> payRollGrpTriggerMap = new HashMap<Integer, List>(entryEntity.size());
        ArrayList allTriggerIds = new ArrayList(10);
        ArrayList<Long> payRollActIds = new ArrayList<Long>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            List triggerIds;
            Object subEntry;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            payRollActIds.add(dynamicObject.getLong("payrollact.id"));
            DynamicObjectCollection payrollactEntryentity = dynamicObject.getDynamicObjectCollection("payrollact.entryentity");
            if (payrollactEntryentity == null || payrollactEntryentity.isEmpty() || !CollectionUtils.isEmpty((Collection)(subEntry = dynamicObject.getDynamicObjectCollection("subentryentity"))) || (triggerIds = payrollactEntryentity.stream().map(item -> item.getLong("triggercolla.id")).collect(Collectors.toList())) == null || triggerIds.isEmpty()) continue;
            allTriggerIds.addAll(triggerIds);
            ArrayList longs = (ArrayList)payRollGrpTriggerMap.get(i);
            if (longs == null || longs.isEmpty()) {
                longs = new ArrayList(10);
                payRollGrpTriggerMap.put(i, longs);
            }
            longs.addAll(triggerIds);
        }
        SWCDataServiceHelper triggerCollasOrm = new SWCDataServiceHelper("hsas_triggercolla");
        DynamicObjectCollection triggerCollas = triggerCollasOrm.queryOriginalCollection("id,entityobject.id,ismustfieldmapping", new QFilter[]{new QFilter("id", "in", allTriggerIds)});
        if (triggerCollas == null || triggerCollas.isEmpty()) {
            return;
        }
        HashMap<Long, DynamicObject> triggerCollaData = new HashMap<Long, DynamicObject>(triggerCollas.size());
        for (DynamicObject triggerColla : triggerCollas) {
            triggerCollaData.put(triggerColla.getLong("id"), triggerColla);
        }
        HashMap<Integer, List> payRollActGrpMap = new HashMap<Integer, List>(entryEntity.size());
        HashSet allObjectNumber = new HashSet(16);
        payRollGrpTriggerMap.forEach((index, triggerCollaIds) -> {
            for (Long triggerCollaId : triggerCollaIds) {
                String objectNumber;
                String isMustFieldMapping;
                DynamicObject triggerColla = (DynamicObject)triggerCollaData.get(triggerCollaId);
                if (triggerColla == null || !"1".equals(isMustFieldMapping = triggerColla.getString("ismustfieldmapping"))) continue;
                ArrayList<String> objects = (ArrayList<String>)payRollActGrpMap.get(index);
                if (objects == null) {
                    objects = new ArrayList<String>(10);
                    payRollActGrpMap.put((Integer)index, objects);
                }
                if (SWCStringUtils.isEmpty((String)(objectNumber = triggerColla.getString("entityobject.id")))) continue;
                objects.add(objectNumber);
                allObjectNumber.add(objectNumber);
            }
        });
        if (payRollActGrpMap.isEmpty()) {
            return;
        }
        SWCDataServiceHelper fieldMapOrm = new SWCDataServiceHelper("hsbs_fieldmap");
        QFilter sysPresetFilter = new QFilter("issyspreset", "=", (Object)"1");
        QFilter payRollActFilter = new QFilter("payrollact", "in", payRollActIds);
        QFilter objectFilter = new QFilter("entryentity.entityobject.number", "in", allObjectNumber);
        QFilter statusFilter = new QFilter("status", "in", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "in", (Object)"1");
        DynamicObject[] fieldMapObjects = fieldMapOrm.query("id,name,number,entityobject.number,apideploy", new QFilter[]{sysPresetFilter, objectFilter, payRollActFilter, enableFilter, statusFilter});
        HashMap<Long, Map<String, Long>> fieldMapObjectMap = new HashMap<Long, Map<String, Long>>(fieldMapObjects.length);
        for (int i = 0; i < fieldMapObjects.length; ++i) {
            DynamicObject fieldMapObject = fieldMapObjects[i];
            long fieldMapId = fieldMapObject.getLong("id");
            Map<String, Long> objectSet = this.getFileMapAllObjectSet(fieldMapObject);
            if (objectSet == null || objectSet.isEmpty()) continue;
            fieldMapObjectMap.put(fieldMapId, objectSet);
        }
        String msgSubNo = this.getModel().getDataEntity().getString("msgsubscriber.msgsubno");
        Set apiIds = PayRollActGrpHelper.getApiIds((String)msgSubNo);
        HashMap<Integer, Map<String, Long>> insertData = new HashMap<Integer, Map<String, Long>>(entryEntity.size());
        payRollActGrpMap.forEach((index, objectNameList) -> {
            Long fieldMapId = this.isFieldMapContainAllObject((Map<Long, Map<String, Long>>)fieldMapObjectMap, (List<String>)objectNameList, apiIds);
            if (fieldMapId != null && fieldMapId > 0L) {
                HashMap<String, Long> subEntryData = new HashMap<String, Long>(1);
                subEntryData.put(objectNameList.stream().collect(Collectors.joining("#")), fieldMapId);
                insertData.put((Integer)index, (Map<String, Long>)subEntryData);
            }
        });
        if (CollectionUtils.isEmpty(insertData)) {
            return;
        }
        this.initFieldRuleSubEntry(insertData);
    }

    private void initFieldRuleSubEntry(Map<Integer, Map<String, Long>> insertData) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int lastIndex = model.getEntryCurrentRowIndex("entryentity");
        model.beginInit();
        insertData.forEach((index, data) -> {
            model.setEntryCurrentRowIndex("entryentity", index.intValue());
            Set entries = data.entrySet();
            data.forEach((key, value) -> {
                String[] split = key.split("#");
                int newEntryRow = model.createNewEntryRow("subentryentity");
                model.setValue("actgfieldmapobj", (Object)split, newEntryRow, index.intValue());
                model.setValue("fieldmap", value, newEntryRow, index.intValue());
            });
        });
        model.endInit();
        model.setEntryCurrentRowIndex("entryentity", lastIndex);
    }

    private Long isFieldMapContainAllObject(Map<Long, Map<String, Long>> fieldMapObjectMap, List<String> objectNumbers, Set<Long> apiIds) {
        if (CollectionUtils.isEmpty(fieldMapObjectMap) || CollectionUtils.isEmpty(objectNumbers)) {
            return null;
        }
        Set<Map.Entry<Long, Map<String, Long>>> entries = fieldMapObjectMap.entrySet();
        for (Map.Entry<Long, Map<String, Long>> entry : entries) {
            Long fieldMapId = entry.getKey();
            Map<String, Long> objectNameMap = entry.getValue();
            if (CollectionUtils.isEmpty(objectNameMap)) continue;
            boolean flag = false;
            for (String objectNumber : objectNumbers) {
                Long apiId = objectNameMap.get(objectNumber);
                if (apiId == null || !apiIds.contains(apiId)) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            return fieldMapId;
        }
        return null;
    }

    private Map<String, Long> getFileMapAllObjectSet(DynamicObject fieldMapObject) {
        DynamicObjectCollection dynamicObjectCollection = fieldMapObject.getDynamicObjectCollection("entryentity");
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return null;
        }
        HashMap<String, Long> result = new HashMap<String, Long>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String objectNumber = dynamicObject.getString("entityobject.number");
            Long apiId = dynamicObject.getLong("apideploy.id");
            result.put(objectNumber, apiId);
        }
        return result;
    }

    private void exePreRuleCallBackHandler(ClosedCallBackEvent closedCallBackEvent) {
        HRRuleDTO rule = (HRRuleDTO)closedCallBackEvent.getReturnData();
        if (null == rule) {
            return;
        }
        this.getModel().setValue("ruledesignstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()));
        this.getModel().setValue("ruledesignnumber", (Object)rule.getRuleNumber());
        this.putExePreRuleToCache(rule);
    }

    private void selectFieldMapTabPage() {
        TreeView mapView = (TreeView)this.getControl("fieldmaptree");
        String focusNodeId = mapView.getTreeState().getFocusNodeId();
        this.setMapRuleFlexVisible(SWCStringUtils.isNotEmpty((String)focusNodeId), Boolean.FALSE);
        try {
            this.focusFieldMapNodeById(focusNodeId, Boolean.TRUE);
        }
        catch (IOException e) {
            LOGGER.info("focusFieldMapNodeById error.", (Object)e);
        }
    }

    private void setMapRuleFlexVisible(Boolean isFieldMapFlexVisible, Boolean isFieldRuleFlexVisible) {
        if (isFieldMapFlexVisible != null) {
            this.getView().setVisible(isFieldMapFlexVisible, new String[]{"fieldmapflex"});
        }
        if (isFieldRuleFlexVisible != null) {
            this.getView().setVisible(isFieldRuleFlexVisible, new String[]{"fieldruleflex"});
        }
    }

    private void selectFieldRuleTabPage() {
        TreeView ruleView = (TreeView)this.getControl("fieldruletree");
        this.setMapRuleFlexVisible(Boolean.FALSE, null);
        String focusNodeId = ruleView.getTreeState().getFocusNodeId();
        try {
            this.focusFieldRuleNodeById(focusNodeId, Boolean.TRUE);
        }
        catch (IOException e) {
            LOGGER.info("selectFieldRuleTabPage error.", (Object)e);
        }
    }

    private void reloadMapRuleTreeView(DynamicObjectCollection entryEntity, boolean isForce) throws IOException {
        DynamicObjectCollection reloadData = entryEntity;
        if (CollectionUtils.isEmpty((Collection)reloadData)) {
            reloadData = this.getModel().getEntryEntity("entryentity");
        }
        Map fieldMap = PayRollActGrpHelper.getAllTriggerCollaIsFiledMaps((DynamicObjectCollection)reloadData);
        this.reloadFieldMapTree(reloadData, fieldMap, isForce);
        this.reloadFieldRuleTree(reloadData, fieldMap, isForce);
        List<String> fieldRuleThirdNodeList = this.getFieldRuleThirdNodeList();
        this.clearPolicyTabPages(fieldRuleThirdNodeList);
        this.updateFieldRuleCache(fieldRuleThirdNodeList);
        Tab control = (Tab)this.getView().getControl("tabap");
        control.activeTab("fieldruletabpageap");
        control.selectTab("fieldruletabpageap");
    }

    private void updateFieldRuleCache(List<String> nodeIdList) throws IOException {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        if (CollectionUtils.isEmpty(nodeIdList)) {
            swcPageCache.remove("CACHE_CREATED_FIELD_RULE_DATA");
            return;
        }
        Map map = (Map)swcPageCache.get("CACHE_CREATED_FIELD_RULE_DATA", Map.class);
        if (!CollectionUtils.isEmpty((Map)map) && !CollectionUtils.isEmpty(nodeIdList)) {
            for (String nodeId : nodeIdList) {
                if (map.containsKey(nodeId)) continue;
                map.remove(nodeId);
            }
        }
        swcPageCache.put("CACHE_CREATED_FIELD_RULE_DATA", (Object)map);
    }

    private void clearPolicyTabPages(List<String> nodeIdList) {
        Tab policyTab = (Tab)this.getView().getControl("policytabap");
        List items = policyTab.getItems();
        if (CollectionUtils.isEmpty((Collection)items) || CollectionUtils.isEmpty(nodeIdList)) {
            this.getPageCache().remove("CACHE_NODE_PAGE_ID_MAP");
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map map = (Map)swcPageCache.get("CACHE_NODE_PAGE_ID_MAP", Map.class);
        if (CollectionUtils.isEmpty(nodeIdList) && !CollectionUtils.isEmpty((Map)map)) {
            map.clear();
        }
        if (!CollectionUtils.isEmpty((Map)map) && !CollectionUtils.isEmpty(nodeIdList)) {
            for (String nodeId : nodeIdList) {
                if (map.containsKey(nodeId)) continue;
                map.remove(nodeId);
            }
        }
        swcPageCache.put("CACHE_NODE_PAGE_ID_MAP", (Object)map);
    }

    private List<String> getFieldRuleThirdNodeList() throws IOException {
        List<String> nodeIdList = new ArrayList<String>(10);
        String fieldRuleCacheData = this.getPageCache().get("FIELD_RULE_TREE_DATA");
        if (SWCStringUtils.isEmpty((String)fieldRuleCacheData)) {
            return null;
        }
        List firstLeverTreeNodes = (List)SWCJSONUtils.cast((String)fieldRuleCacheData, List.class, (Class[])new Class[]{TreeNode.class});
        List secondLeverTreeNodes = PayRollActGrpHelper.getAllChildrenTreeNodeList((List)firstLeverTreeNodes);
        List thirdChildrenTreeNodeList = PayRollActGrpHelper.getAllChildrenTreeNodeList((List)secondLeverTreeNodes);
        if (!CollectionUtils.isEmpty((Collection)thirdChildrenTreeNodeList)) {
            nodeIdList = thirdChildrenTreeNodeList.stream().map(TreeNode::getId).collect(Collectors.toList());
        }
        return nodeIdList;
    }

    private void closeAllPolicyTab() {
        Tab policyTab = (Tab)this.getView().getControl("policytabap");
        List items = policyTab.getItems();
        List keyList = items.stream().map(Control::getKey).collect(Collectors.toList());
        policyTab.batchCloseTabs(keyList);
    }

    public void tabBatchClose(TabBatchCloseEvent tabBatchCloseEvent) {
    }

    private void initMapRuleTree(PropertyChangedArgs args) throws IOException {
        this.reloadExePreRuleDesignCache();
        ChangeData[] changeSet = args.getChangeSet();
        if (null == changeSet || changeSet.length < 1) {
            return;
        }
        this.reloadMapRuleTreeView(null, true);
    }

    private void reloadExePreRuleDesignCache() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map lastCacheMap = (Map)swcPageCache.get("CACHE_RULE_DESIGN_DATA", Map.class);
        HashMap<String, String> cacheDataMap = new HashMap<String, String>(16);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            DynamicObject ruleDesignDy = dynamicObject.getDynamicObject("ruledesign");
            String ruleNumber = dynamicObject.getString("ruledesignnumber");
            if (null != ruleDesignDy) {
                HRRuleDTO rule = HRRuleDTO.fromDynamicObject((DynamicObject)ruleDesignDy);
                String number = rule.getRuleNumber();
                cacheDataMap.put(number, rule.toJson());
                if (SWCStringUtils.isEmpty((String)number)) continue;
                this.getModel().setValue("ruledesignstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()), i);
                this.getModel().setValue("ruledesignnumber", (Object)number, i);
                this.getModel().setDataChanged(false);
                continue;
            }
            if (SWCStringUtils.isEmpty((String)ruleNumber) || CollectionUtils.isEmpty((Map)lastCacheMap)) continue;
            cacheDataMap.put(ruleNumber, (String)lastCacheMap.get(ruleNumber));
        }
        swcPageCache.put("CACHE_RULE_DESIGN_DATA", cacheDataMap);
    }

    private void reloadFieldRuleTree(DynamicObjectCollection dyList, Map<Long, Map<Long, Map<String, Object>>> fieldMap, boolean isClearSetData) throws IOException {
        TreeView filedRuleTreeView = (TreeView)this.getView().getControl("fieldruletree");
        filedRuleTreeView.deleteAllNodes();
        if (CollectionUtils.isEmpty((Collection)dyList) || CollectionUtils.isEmpty(fieldMap) || PayRollActGrpHelper.isValueNull((IFormView)this.getView(), (String)"scene") || PayRollActGrpHelper.isValueNull((IFormView)this.getView(), (String)"payrollactgtpl")) {
            this.setMapRuleFlexVisible(null, Boolean.FALSE);
            this.getView().getPageCache().put("FIELD_RULE_TREE_DATA", null);
            return;
        }
        List triggerIds = dyList.stream().filter(dy -> !CollectionUtils.isEmpty((Collection)dy.getDynamicObjectCollection("payrollact.entryentity"))).flatMap(dy -> dy.getDynamicObjectCollection("payrollact.entryentity").stream().map(en -> en.getLong("triggercolla.id"))).distinct().collect(Collectors.toList());
        DynamicObject[] query = PayRollActGrpHelper.getTriggerListByIds(triggerIds);
        HashMap<Long, DynamicObject> triggerMap = new HashMap<Long, DynamicObject>();
        if (null != query && query.length > 0) {
            for (DynamicObject temp : query) {
                triggerMap.put(temp.getLong("id"), temp);
            }
        }
        TreeNode focusNode = null;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (DynamicObject newValue : dyList) {
            Long payRollActId = newValue.getLong("payrollact.id");
            Map<Long, Map<String, Object>> map = fieldMap.get(payRollActId);
            if (map == null || !this.isContain(map, Boolean.FALSE).booleanValue()) continue;
            TreeNode node = new TreeNode(null, "L1#" + payRollActId, newValue.getString("payrollact.name"));
            node.setDisabled(true);
            node.setColor("black");
            node.setData((Object)DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)newValue.getDynamicObject("payrollact")));
            node.setIsOpened(true);
            DynamicObjectCollection secondLever = newValue.getDynamicObjectCollection("payrollact.entryentity");
            if (CollectionUtils.isEmpty((Collection)secondLever)) continue;
            for (DynamicObject dynamicObject : secondLever) {
                DynamicObject dyobj;
                Long triggerCollaId = dynamicObject.getLong("triggercolla.id");
                if (map.get(triggerCollaId) == null || ((Boolean)map.get(triggerCollaId).get("isMust")).booleanValue()) continue;
                dynamicObject.getDataEntityType();
                DynamicObject queryOne = (DynamicObject)triggerMap.get(triggerCollaId);
                if (null == queryOne || null == (dyobj = queryOne.getDynamicObject("entityobject"))) continue;
                Object objeId = dyobj.getPkValue();
                String name = dyobj.getString("name");
                StringBuilder secondLevelNodeId = new StringBuilder().append(payRollActId).append(RULE_DESIGN_NODE_ID_SEPARATOR_CHAR).append(triggerCollaId).append(RULE_DESIGN_NODE_ID_SEPARATOR_CHAR).append(objeId);
                TreeNode treeNode = new TreeNode(node.getId(), "L2#" + secondLevelNodeId, name);
                treeNode.setDisabled(true);
                treeNode.setColor("black");
                treeNode.setIsOpened(true);
                treeNode.setData((Object)DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)dyobj));
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dyobj.getString("number"));
                DataEntityPropertyCollection properties = entityType.getProperties();
                DynamicObjectCollection object = queryOne.getDynamicObjectCollection("paramentryentity");
                for (DynamicObject dyo : object) {
                    IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)dyo.getString("fieldkey"));
                    if (property == null) continue;
                    String displayName = property.getDisplayName().toString();
                    boolean isMustInput = property instanceof FieldProp && ((FieldProp)property).isMustInput() || property instanceof BasedataProp && ((BasedataProp)property).isMustInput();
                    String thirdLevelNodeId = secondLevelNodeId + "#" + property.getName();
                    TreeNode fieldNode = new TreeNode(treeNode.getId(), "L3#" + thirdLevelNodeId, displayName);
                    HashMap<String, Object> thirdLevelData = new HashMap<String, Object>(16);
                    fieldNode.setData(thirdLevelData);
                    thirdLevelData.put("property", property.getName());
                    if (isMustInput) {
                        thirdLevelData.put("isMustInput", Boolean.TRUE);
                        fieldNode.setIcon("mustinput");
                    } else {
                        fieldNode.setIcon("notmustinput");
                    }
                    if (focusNode == null) {
                        focusNode = fieldNode;
                    }
                    treeNode.addChild(fieldNode);
                }
                DynamicObjectCollection exeParamEntryEntity = queryOne.getDynamicObjectCollection("exeparamentryentity");
                for (DynamicObject exeParam : exeParamEntryEntity) {
                    String pFieldKey = exeParam.getString("pfieldkey");
                    String pFieldName = exeParam.getString("pfieldname");
                    String pFieldType = exeParam.getString("pfieldtype");
                    boolean pIsMustInput = exeParam.getBoolean("pismustinput");
                    boolean pIsSetRule = exeParam.getBoolean("pissetrule");
                    String thirdLevelNodeId = secondLevelNodeId + "#" + pFieldKey;
                    TreeNode fieldNode = new TreeNode(treeNode.getId(), "L3#" + thirdLevelNodeId, pFieldName);
                    HashMap<String, Object> thirdLevelData = new HashMap<String, Object>(16);
                    fieldNode.setData(thirdLevelData);
                    thirdLevelData.put("property", pFieldKey);
                    thirdLevelData.put("isShowRuleList", pIsSetRule);
                    thirdLevelData.put("isExeParam", Boolean.TRUE);
                    if (pIsMustInput) {
                        thirdLevelData.put("isMustInput", Boolean.TRUE);
                        fieldNode.setIcon("mustinput");
                    }
                    if (focusNode == null) {
                        focusNode = fieldNode;
                    }
                    treeNode.addChild(fieldNode);
                }
                if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) continue;
                node.addChild(treeNode);
            }
            if (CollectionUtils.isEmpty((Collection)node.getChildren())) continue;
            nodes.add(node);
        }
        this.getView().getPageCache().put("FIELD_RULE_TREE_DATA", SWCJSONUtils.toString(nodes));
        filedRuleTreeView.addNodes(nodes);
        filedRuleTreeView.focusNode(focusNode);
    }

    private void reloadFieldMapTree(DynamicObjectCollection dyList, Map<Long, Map<Long, Map<String, Object>>> fieldMap, boolean isClearSettingData) throws IOException {
        TreeView filedMapTreeView = (TreeView)this.getView().getControl("fieldmaptree");
        filedMapTreeView.deleteAllNodes();
        if (CollectionUtils.isEmpty((Collection)dyList) || CollectionUtils.isEmpty(fieldMap) || PayRollActGrpHelper.isValueNull((IFormView)this.getView(), (String)"payrollactgtpl")) {
            this.getModel().deleteEntryData("fieldmapviewentryentity");
            this.setMapRuleFlexVisible(Boolean.FALSE, null);
            this.getView().getPageCache().put("FIELD_MAP_TREE_DATA", null);
            this.getView().getPageCache().put("IS_FIELD_MAP_ENABLED_DATA", null);
            return;
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (DynamicObject newValue : dyList) {
            Long payRollActId = newValue.getLong("payrollact.id");
            Map<Long, Map<String, Object>> map = fieldMap.get(payRollActId);
            if (map == null || !this.isContain(map, Boolean.TRUE).booleanValue()) continue;
            TreeNode node = new TreeNode(null, "L1#" + payRollActId, newValue.getString("payrollact.name"));
            node.setData((Object)DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)newValue.getDynamicObject("payrollact")));
            nodes.add(node);
        }
        this.getView().getPageCache().put("FIELD_MAP_TREE_DATA", SWCJSONUtils.toString(nodes));
        this.getView().getPageCache().put("IS_FIELD_MAP_ENABLED_DATA", SWCJSONUtils.toString(fieldMap));
        filedMapTreeView.addNodes(nodes);
    }

    private Boolean isContain(Map<Long, Map<String, Object>> map, Boolean value) {
        if (CollectionUtils.isEmpty(map)) {
            return Boolean.FALSE;
        }
        long count = map.entrySet().stream().filter(ma -> value.equals(((Map)ma.getValue()).get("isMust"))).count();
        return count > 0L ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean validPolicyResultsAndNotify(String nodeId) throws IOException {
        List lastChildPath;
        if (SWCStringUtils.isEmpty((String)nodeId)) {
            return true;
        }
        HRPolicyDTO policy = this.getPolicyByNodeId(nodeId, null);
        if (!PayRollActGrpHelper.validPolicyResults((HRPolicyDTO)policy).booleanValue() && (lastChildPath = PayRollActGrpHelper.getChildPathNodesByNodeId((IFormView)this.getView(), (String)nodeId)).size() == 3) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e>{0}>{1}\u201d\u4e2d\u201c{2}\u201d\u7684\u9ed8\u8ba4\u503c\u3002", (String)"AbstractPayRollActGrpEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[]{((TreeNode)lastChildPath.get(0)).getText(), ((TreeNode)lastChildPath.get(1)).getText(), ((TreeNode)lastChildPath.get(2)).getText()}));
            return false;
        }
        return true;
    }

    private boolean clickFieldRuleTree(String nodeId) throws IOException {
        DynamicObject entryRowEntity;
        LOGGER.info("AbstractPayRollActGrpEdit.clickFieldRuleTree,nodeId = {}", (Object)nodeId);
        if (SWCStringUtils.isEmpty((String)nodeId)) {
            return true;
        }
        Integer index = PayRollActGrpHelper.getRowIndexByPayRollActId((IFormView)this.getView(), (String)nodeId.split("#")[1]);
        if (index == null) {
            return true;
        }
        String lastNodeId = this.getPageCache().get("CACHE_CURRENT_FIELD_RULE_FOCUS_NODE_ID");
        if (nodeId.equals(lastNodeId)) {
            return true;
        }
        if (!this.validPolicyResultsAndNotify(lastNodeId)) {
            this.focusFieldRuleNodeById(lastNodeId, Boolean.FALSE);
            return false;
        }
        if (!SWCStringUtils.startsWithIgnoreCase((String)nodeId, (String)"L3#")) {
            this.setMapRuleFlexVisible(Boolean.FALSE, Boolean.FALSE);
            return true;
        }
        this.getPageCache().put("CACHE_CURRENT_FIELD_RULE_FOCUS_NODE_ID", nodeId);
        HashMap nodeDataMap = new HashMap(16);
        List childPathNodes = PayRollActGrpHelper.getChildPathNodesByNodeId((IFormView)this.getView(), (String)nodeId);
        if (!CollectionUtils.isEmpty((Collection)childPathNodes) && childPathNodes.size() == 3) {
            nodeDataMap.put("frpayrollact", childPathNodes.get(0));
            nodeDataMap.put("frtriggercolla", childPathNodes.get(1));
            nodeDataMap.put("frfieldkey", childPathNodes.get(2));
        }
        if (null == (entryRowEntity = this.getModel().getEntryRowEntity("entryentity", index.intValue()))) {
            return true;
        }
        DynamicObjectCollection fieldRuleEntryEntity = entryRowEntity.getDynamicObjectCollection("fieldrulesubentryentity");
        if (CollectionUtils.isEmpty((Collection)fieldRuleEntryEntity) || CollectionUtils.isEmpty(nodeDataMap)) {
            this.filedRulePageFlexShowPage(nodeId, null);
            return true;
        }
        Long id = null;
        for (DynamicObject dynamicObject : fieldRuleEntryEntity) {
            long payRollActId = dynamicObject.getLong("frpayrollact.id");
            long triggerCollaId = dynamicObject.getLong("frtriggercolla.id");
            String fieldKey = dynamicObject.getString("frfieldkey");
            long policyId = dynamicObject.getLong("frpolicy.id");
            if (!Long.toString(payRollActId).equals(((TreeNode)nodeDataMap.get("frpayrollact")).getId().substring(3)) || !Long.toString(triggerCollaId).equals(((TreeNode)nodeDataMap.get("frtriggercolla")).getId().split("#")[2]) || !fieldKey.equals(((TreeNode)nodeDataMap.get("frfieldkey")).getData())) continue;
            id = policyId;
            break;
        }
        this.filedRulePageFlexShowPage(nodeId, id);
        return true;
    }

    private void clickFieldMapTree(TreeNodeEvent event) {
        String nodeId = (String)event.getNodeId();
        this.getPageCache().put("CACHE_CURRENT_FIELD_MAP_FOCUS_NODE_ID", nodeId);
        if (SWCStringUtils.isEmpty((String)nodeId)) {
            return;
        }
        this.fieldMapEntryLoadData(this.getCurrentEntryRowByNodeId(nodeId));
        this.setMapRuleFlexVisible(Boolean.TRUE, Boolean.FALSE);
    }

    private Integer getCurrentEntryRowByNodeId(String nodeId) {
        if (SWCStringUtils.isEmpty((String)nodeId) || nodeId.split("#").length < 1) {
            return null;
        }
        Integer index = PayRollActGrpHelper.getRowIndexByPayRollActId((IFormView)this.getView(), (String)nodeId.split("#")[1]);
        return index;
    }

    private void searchFieldRule(String searchText) {
        PayRollActSearchDTO search = this.beforeDoTreeSearch(searchText, "FIELD_RULE_TREE_DATA", "CACHE_FIELD_RULE_SEARCH_DATA", "fieldruletree");
        Integer resultindex = this.doTreeSearch(search);
        this.afterDoTreeSearch(search, resultindex, "CACHE_FIELD_RULE_SEARCH_DATA");
    }

    private void searchFieldMap(String searchText) {
        PayRollActSearchDTO search = this.beforeDoTreeSearch(searchText, "FIELD_MAP_TREE_DATA", "CACHE_FIELD_MAP_SEARCH_DATA", "fieldmaptree");
        Integer resultindex = this.doTreeSearch(search);
        this.afterDoTreeSearch(search, resultindex, "CACHE_FIELD_MAP_SEARCH_DATA");
    }

    private void afterDoTreeSearch(PayRollActSearchDTO search, Integer resultindex, String cacheName) {
        if (null == resultindex) {
            this.clearTreeNodeSearchCache(cacheName);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u66f4\u591a\u641c\u7d22\u7ed3\u679c\u3002", (String)"AbstractPayRollActGrpEdit_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode treeNode = (TreeNode)search.getTreeNodeList().get(resultindex);
        TreeView treeView = (TreeView)this.getView().getControl(search.getTreeName());
        treeView.focusNode(treeNode);
        treeView.expand(treeNode.getId());
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        this.setTreeNodeSearchCache(cacheName, search.getSearchText(), resultindex);
    }

    private void setTreeNodeSearchCache(String cahceName, String searchText, Integer currentResultIndex) {
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        cacheMap.put("lastSearchText", searchText);
        cacheMap.put("currentResultIndex", currentResultIndex);
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put(cahceName, cacheMap);
    }

    private void clearTreeNodeSearchCache(String cahceName) {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put(cahceName, null);
    }

    private PayRollActSearchDTO beforeDoTreeSearch(String searchText, String treeDataCacheName, String searchDataCacheName, String treeName) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        List treeNodes = null;
        PayRollActSearchDTO search = new PayRollActSearchDTO();
        try {
            String treeDataCache = this.getView().getPageCache().get(treeDataCacheName);
            if (!SWCStringUtils.isEmpty((String)treeDataCache)) {
                treeNodes = (List)SWCJSONUtils.cast((String)treeDataCache, List.class, (Class[])new Class[]{TreeNode.class});
                List allTreeNodes = PayRollActGrpHelper.getAllTreeNodes((List)treeNodes);
                search.setTreeNodeList(allTreeNodes);
            }
        }
        catch (IOException e) {
            LOGGER.error("json\u5e8f\u5217\u5316\u9519\u8bef", (Throwable)e);
            throw new KDBizException((Throwable)e, PayRollActGrpHelper.getDefaultErrorCode(), new Object[0]);
        }
        search.setTreeName(treeName);
        search.setSearchText(searchText);
        Map fieldMapSearchCache = (Map)pageCache.get(searchDataCacheName, Map.class);
        if (!CollectionUtils.isEmpty((Map)fieldMapSearchCache)) {
            search.setLastSearchText((String)fieldMapSearchCache.get("lastSearchText"));
            search.setCurrentResultIndex((Integer)fieldMapSearchCache.get("currentResultIndex"));
        }
        return search;
    }

    private Integer doTreeSearch(PayRollActSearchDTO search) {
        String searchText = search.getSearchText();
        String lastSearchText = search.getLastSearchText();
        List treeNodeList = search.getTreeNodeList();
        if (CollectionUtils.isEmpty((Collection)treeNodeList)) {
            return null;
        }
        if (!SWCStringUtils.equalsIgnoreCase((String)lastSearchText, (String)searchText)) {
            search.setCurrentResultIndex(Integer.valueOf(-1));
        }
        for (int i = search.getCurrentResultIndex() + 1; i < treeNodeList.size(); ++i) {
            TreeNode tempTreeNode = (TreeNode)treeNodeList.get(i);
            if (!tempTreeNode.getText().contains(searchText)) continue;
            return i;
        }
        return null;
    }

    private void showPayRollActSettingNewPage() {
        DynamicObject payRollActGrpTpl = this.getModel().getDataEntity().getDynamicObject("payrollactgtpl");
        if (null == payRollActGrpTpl) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u3002", (String)"AbstractPayRollActGrpEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_payrollact", (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_SHOW_PAY_ROLL_ACT_SETTING_NEW_PAGE"));
        DynamicObjectCollection payRollActCollection = payRollActGrpTpl.getDynamicObjectCollection("entryentity");
        ArrayList<Long> inIds = new ArrayList<Long>(10);
        if (!CollectionUtils.isEmpty((Collection)payRollActCollection)) {
            for (DynamicObject payRollActEntry : payRollActCollection) {
                DynamicObject payRollAct = payRollActEntry.getDynamicObject("payrollact");
                if (null == payRollAct) continue;
                inIds.add((Long)payRollAct.getPkValue());
            }
        }
        if (inIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u4e0d\u5305\u542b\u534f\u4f5c\u6d3b\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractPayRollActGrpEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> notInIds = new ArrayList<Long>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            for (DynamicObject entity : entryEntity) {
                DynamicObject payRollAct = entity.getDynamicObject("payrollact");
                if (null == payRollAct) continue;
                notInIds.add((Long)payRollAct.getPkValue());
            }
        }
        if (notInIds.containsAll(inIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6dfb\u52a0\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u201c{0}\u201d\u4e2d\u7684\u6240\u6709\u534f\u4f5c\u6d3b\u52a8\u3002", (String)"AbstractPayRollActGrpEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("payrollactgtpl.name")}));
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("id", "in", inIds));
        qFilters.add(new QFilter("id", "not in", notInIds));
        ListFilterParameter listFilterParameter = new ListFilterParameter(qFilters, "id");
        showParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected HRRuleDTO getExePreRuleCacheById(String key) {
        if (SWCStringUtils.isEmpty((String)key)) {
            return null;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map map = (Map)swcPageCache.get("CACHE_RULE_DESIGN_DATA", Map.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            return null;
        }
        String ruleStr = (String)map.get(key);
        if (SWCStringUtils.isEmpty((String)ruleStr)) {
            return null;
        }
        HRRuleDTO cast = null;
        try {
            cast = (HRRuleDTO)SWCJSONUtils.cast((String)ruleStr, HRRuleDTO.class);
        }
        catch (IOException e) {
            LOGGER.error("\u89e3\u6790json\u5b57\u7b26\u4e32\u51fa\u73b0\u9519\u8bef.", (Throwable)e);
            throw new KDBizException((Throwable)e, PayRollActGrpHelper.getDefaultErrorCode(), new Object[0]);
        }
        return cast;
    }

    private void putExePreRuleToCache(HRRuleDTO rule) {
        if (null == rule) {
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        HashMap<String, String> map = (HashMap<String, String>)swcPageCache.get("CACHE_RULE_DESIGN_DATA", Map.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            map = new HashMap<String, String>();
        }
        map.put(rule.getRuleNumber(), rule.toJson());
        swcPageCache.put("CACHE_RULE_DESIGN_DATA", map);
    }

    private void removeDeleteRows(int[] rowIndexs, DynamicObjectCollection entryEntity) {
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        ArrayList<Object> removeDynamisList = new ArrayList<Object>();
        if (null != rowIndexs && rowIndexs.length > 0) {
            for (int i = 0; i < rowIndexs.length && rowIndexs[i] < entryEntity.size(); ++i) {
                removeDynamisList.add(entryEntity.get(rowIndexs[i]));
            }
        }
        entryEntity.removeAll(removeDynamisList);
    }

    private List<QFilter> getFieldMapFilter(BeforeF7SelectEvent event) {
        int row = event.getRow();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject fieldMapRow = this.getModel().getEntryRowEntity("fieldmapviewentryentity", row);
        DynamicObjectCollection dynamicObjectCollection = fieldMapRow.getDynamicObjectCollection("actgfieldmapobjview");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            List objIds = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.entityobject.number", "in", objIds));
        }
        return filters;
    }

    private Boolean focusNodeById(TreeView treeView, String treeNodeCacheName, String nodeId, Boolean isClick) throws IOException {
        String fieldRuleTreeStr = this.getView().getPageCache().get(treeNodeCacheName);
        if (SWCStringUtils.isEmpty((String)fieldRuleTreeStr)) {
            return Boolean.FALSE;
        }
        List treeNodes = (List)SWCJSONUtils.cast((String)fieldRuleTreeStr, List.class, (Class[])new Class[]{TreeNode.class});
        if (CollectionUtils.isEmpty((Collection)treeNodes)) {
            return Boolean.FALSE;
        }
        for (TreeNode treeNode : treeNodes) {
            if (SWCStringUtils.isEmpty((String)nodeId)) {
                TreeNode leafChild = this.getFirstLeafChild(treeNode);
                if (isClick.booleanValue() && leafChild != null) {
                    treeView.focusNode(leafChild);
                    treeView.treeNodeClick(SWCStringUtils.isEmpty((String)leafChild.getParentid()) ? null : leafChild.getParentid(), leafChild.getId());
                }
                return Boolean.TRUE;
            }
            TreeNode tmpNode = treeNode.getTreeNode(nodeId, 3);
            if (null == tmpNode) continue;
            treeView.focusNode(tmpNode);
            if (isClick.booleanValue()) {
                treeView.treeNodeClick(tmpNode.getParentid(), nodeId);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public TreeNode getFirstLeafChild(TreeNode treeNode) {
        List children = treeNode.getChildren();
        if (children == null || children.isEmpty()) {
            return treeNode;
        }
        return this.getFirstLeafChild((TreeNode)children.get(0));
    }

    private Boolean focusFieldMapNodeById(String nodeId, Boolean isClick) throws IOException {
        Boolean result = this.focusNodeById((TreeView)this.getControl("fieldmaptree"), "FIELD_MAP_TREE_DATA", nodeId, isClick);
        if (result.booleanValue()) {
            this.setMapRuleFlexVisible(Boolean.TRUE, Boolean.FALSE);
            TreeView treeView = (TreeView)this.getControl("fieldmaptree");
            String focusNodeId = treeView.getTreeState().getFocusNodeId();
            this.fieldMapEntryLoadData(this.getCurrentEntryRowByNodeId(focusNodeId));
        }
        return result;
    }

    private Boolean focusFieldRuleNodeById(String nodeId, Boolean isClick) throws IOException {
        Boolean result = this.focusNodeById((TreeView)this.getControl("fieldruletree"), "FIELD_RULE_TREE_DATA", nodeId, isClick);
        if (!result.booleanValue() || !SWCStringUtils.isEmpty((String)nodeId) && !SWCStringUtils.startsWithIgnoreCase((String)nodeId, (String)"L3#")) {
            this.setMapRuleFlexVisible(Boolean.FALSE, Boolean.FALSE);
        } else {
            this.setMapRuleFlexVisible(Boolean.FALSE, Boolean.TRUE);
        }
        return result;
    }

    private Boolean validateSlectedMsgSubcriber(Object msgId) {
        return this.validateSelectedMsgSubcriber(msgId, null);
    }

    private Boolean validateSelectedMsgSubcriber(Object msgSubscriberId, Object lastMsgId) {
        if (null == msgSubscriberId) {
            return Boolean.TRUE;
        }
        SWCDataServiceHelper msgSubscriberOrm = new SWCDataServiceHelper("hrcs_msgsubscriber");
        DynamicObject msgSubscriberDy = msgSubscriberOrm.queryOne("name, msgpublisher.id", new QFilter[]{new QFilter("id", "=", msgSubscriberId)});
        if (null == msgSubscriberDy) {
            return Boolean.TRUE;
        }
        SWCDataServiceHelper msgSceneOrm = new SWCDataServiceHelper("hsas_msgscene");
        DynamicObject msgSceneDy = msgSceneOrm.queryOne("msgsubscriber,msgsubscriber.name,scene", new QFilter[]{new QFilter("msgsubscriber", "=", msgSubscriberDy.get("id"))});
        if (null == msgSceneDy) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u201c{0}\u201d\u6ca1\u6709\u5173\u8054\u7684\u573a\u666f\uff0c\u8bf7\u5173\u8054\u573a\u666f\u540e\u91cd\u8bd5\u3002", (String)"AbstractPayRollActGrpEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[]{msgSubscriberDy.getString("name")}));
            this.getModel().setValue("msgsubscriber", lastMsgId);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected boolean savePayRollActGroupPolicy(String operationKey) throws IOException {
        HRPolicyDTO exePreRulePolicy = PayRollActGrpHelper.getExePreRulePolicyFromCache((IFormView)this.getView());
        this.afterGetExePreRulePolicy(exePreRulePolicy, operationKey);
        List<HRPolicyDTO> fieldRulePolicyList = this.getFieldRulePolicyList();
        this.afterGetFiledRulePolicyList(fieldRulePolicyList, operationKey);
        ArrayList<HRPolicyDTO> policyList = new ArrayList<HRPolicyDTO>();
        if (exePreRulePolicy != null) {
            policyList.add(exePreRulePolicy);
        }
        policyList.addAll(fieldRulePolicyList);
        List<HRPolicyDTO> insertOrUpdatePolicyList = this.preHandlerRuleEngineDataId(policyList);
        ResponseDTO response = PayRollActGrpHelper.batchInsertOrUpdateHrPolicy(insertOrUpdatePolicyList);
        if (response.isSuccess()) {
            Map numberIdMap = (Map)response.getResult();
            PayRollActGrpHelper.writeBackPolicyId(policyList, (Map)numberIdMap);
            PayRollActGrpHelper.writeBackExePreRulePolicyId((IFormView)this.getView(), (HRPolicyDTO)exePreRulePolicy);
            this.saveFieldRuleEntry(fieldRulePolicyList);
            return true;
        }
        return false;
    }

    private List<HRPolicyDTO> preHandlerRuleEngineDataId(List<HRPolicyDTO> policyList) {
        if (policyList == null || policyList.isEmpty()) {
            return policyList;
        }
        String ruleEnginDataMode = (String)this.getView().getFormShowParameter().getCustomParam(RULE_ENGINE_DATA_MODE);
        if (ruleEnginDataMode == null || !"NEW".equals(ruleEnginDataMode)) {
            return policyList;
        }
        for (HRPolicyDTO hrPolicyDTO : policyList) {
            List entryBuList;
            hrPolicyDTO.setId(null);
            List entryRuleList = hrPolicyDTO.getEntryRuleList();
            if (entryRuleList != null && entryRuleList.size() != 0) {
                entryRuleList.stream().forEach(item -> item.setId(null));
            }
            if ((entryBuList = hrPolicyDTO.getEntryBuList()) == null || entryBuList.size() == 0) continue;
            entryBuList.stream().forEach(item -> item.setId(null));
        }
        return policyList;
    }

    private void saveFieldRuleEntry(List<HRPolicyDTO> fieldRuleDyList) {
        if (CollectionUtils.isEmpty(fieldRuleDyList)) {
            return;
        }
        String fieldRuleTreeStr = this.getView().getPageCache().get("FIELD_RULE_TREE_DATA");
        for (HRPolicyDTO policy : fieldRuleDyList) {
            String nodeId = policy.getNodeId();
            List childPathNodes = PayRollActGrpHelper.getChildPathNodesByNodeId((IFormView)this.getView(), (String)nodeId, (String)fieldRuleTreeStr);
            if (CollectionUtils.isEmpty((Collection)childPathNodes)) {
                return;
            }
            String frPayRollActId = ((TreeNode)childPathNodes.get(0)).getId().substring(3);
            String frTriggerCollaId = ((TreeNode)childPathNodes.get(1)).getId().split("#")[2];
            Map data = (Map)((TreeNode)childPathNodes.get(2)).getData();
            String fieldKey = (String)data.get("property");
            this.getView().updateView("fieldrulesubentryentity");
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            int row = -1;
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", i);
                if (!frPayRollActId.equals(entryRowEntity.getString("payrollact.id"))) continue;
                row = i;
                break;
            }
            if (row == -1) continue;
            AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
            int currentRow = dataModel.getEntryCurrentRowIndex("entryentity");
            Integer ruleRowIndex = PayRollActGrpHelper.isPolicyDataExist((IFormView)this.getView(), (String)frPayRollActId, (String)frTriggerCollaId, (String)fieldKey, (String)policy.getNumber(), (Integer)row);
            if (ruleRowIndex >= 0) {
                this.getModel().setValue("frpolicy", (Object)policy.getId(), ruleRowIndex.intValue(), row);
                continue;
            }
            dataModel.beginInit();
            TableValueSetter setter = new TableValueSetter(new String[0]);
            setter.addField("frpayrollact", new Object[0]);
            setter.addField("frtriggercolla", new Object[0]);
            setter.addField("frfieldkey", new Object[0]);
            setter.addField("frpolicy", new Object[0]);
            setter.addRow(new Object[]{frPayRollActId, frTriggerCollaId, fieldKey, policy.getId()});
            dataModel.setEntryCurrentRowIndex("entryentity", row);
            dataModel.batchCreateNewEntryRow("fieldrulesubentryentity", setter);
            dataModel.endInit();
            dataModel.setEntryCurrentRowIndex("entryentity", currentRow);
            this.getModel().setDataChanged(false);
        }
        this.getView().updateView("fieldrulesubentryentity");
    }

    private void abstractSortEntryEntity() {
        DynamicObjectCollection entryEntityObjs = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntityObjs.size(); ++i) {
            this.getModel().setValue("executeseq", (Object)(i + 1), i);
        }
    }

    private boolean validateBeforeNewPayrollactEntry() {
        DynamicObjectCollection doc = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        List existList = doc.stream().map(ee -> ee.getLong("payrollact.id")).collect(Collectors.toList());
        long payrollactgtplId = this.getModel().getDataEntity().getLong("payrollactgtpl.id");
        if (0L == payrollactgtplId) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u3002", (String)"AbstractPayRollActGrpEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject payRollObj = PayRollActGrpHelper.getPayRollActGrpTplById((long)payrollactgtplId);
        DynamicObjectCollection payRollCollections = payRollObj.getDynamicObjectCollection("entryentity");
        if (payRollCollections.size() == existList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6dfb\u52a0\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u201c{0}\u201d\u4e2d\u7684\u6240\u6709\u534f\u4f5c\u6d3b\u52a8\u3002", (String)"AbstractPayRollActGrpEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("payrollactgtpl.name")}));
            return true;
        }
        Set idSet = payRollCollections.stream().map(ee -> ee.getLong("payrollact.id")).filter(ee -> !existList.contains(ee)).collect(Collectors.toSet());
        if (idSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u4e0d\u5305\u542b\u534f\u4f5c\u6d3b\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractPayRollActGrpEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("payrollactid", idSet);
        return false;
    }

    private boolean validateBeforeDeletePayrollactEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRowNumber = entryGrid.getSelectRows();
        boolean isMustExecute = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(selectRowNumber[0])).getBoolean("ismustexecute");
        if (isMustExecute) {
            String payrollactName = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(selectRowNumber[0])).getString("payrollact.name");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u4f5c\u6d3b\u52a8\u201c{0}\u201d\u5fc5\u987b\u6267\u884c\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AbstractPayRollActGrpEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[]{payrollactName}));
        }
        return isMustExecute;
    }

    private void fieldMapEntryRefreshLayout() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fieldmapviewentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryRowData = (DynamicObject)entryEntity.get(i);
            DynamicObjectCollection filedMapObjects = entryRowData.getDynamicObjectCollection("actgfieldmapobjview");
            this.getView().setEnable(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)filedMapObjects)), i, new String[]{"fieldmapview"});
        }
    }

    private void fieldMapEntryLoadData(Integer entryRowNum) {
        if (null == entryRowNum) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IDataModel entryOperate = this.getModel();
        entryOperate.setEntryCurrentRowIndex("entryentity", entryRowNum.intValue());
        model.deleteEntryData("fieldmapviewentryentity");
        DynamicObjectCollection subEntryEntity = model.getEntryEntity("subentryentity");
        if (CollectionUtils.isEmpty((Collection)subEntryEntity)) {
            return;
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("actgfieldmapobjview", new Object[0]);
        setter.addField("fieldmapview", new Object[0]);
        for (DynamicObject dynamicObject : subEntryEntity) {
            DynamicObjectCollection actgFiledMapObjs = dynamicObject.getDynamicObjectCollection("actgfieldmapobj");
            DynamicObject fieldMapDyObj = dynamicObject.getDynamicObject("fieldmap");
            setter.addRow(new Object[]{actgFiledMapObjs, null == fieldMapDyObj ? null : fieldMapDyObj.get("id")});
        }
        dataModel.batchCreateNewEntryRow("fieldmapviewentryentity", setter);
        dataModel.endInit();
        model.setDataChanged(false);
        view.updateView("fieldmapviewentryentity");
        view.updateView("subentryentity");
        this.fieldMapEntryRefreshLayout();
    }

    private void fieldMapEntryClearData() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (!PayRollActGrpHelper.isValueNull((IFormView)view, (String)"fieldmapviewentryentity")) {
            model.deleteEntryData("fieldmapviewentryentity");
        }
        if (!PayRollActGrpHelper.isValueNull((IFormView)view, (String)"entryentity")) {
            int lastIndex = model.getEntryCurrentRowIndex("entryentity");
            int entryRowCount = model.getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                model.setEntryCurrentRowIndex("entryentity", i);
                model.deleteEntryData("subentryentity");
            }
            model.setEntryCurrentRowIndex("entryentity", lastIndex);
        }
    }

    private void fieldMapEntrySaveData() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntityView = model.getEntryEntity("fieldmapviewentryentity");
        TreeView treeView = (TreeView)view.getControl("fieldmaptree");
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        Integer index = this.getCurrentEntryRowByNodeId(focusNodeId);
        if (null == index) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)entryEntityView)) {
            model.deleteEntryData("subentryentity");
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        int currentRow = dataModel.getEntryCurrentRowIndex("entryentity");
        IDataModel entryOperate = model;
        entryOperate.setEntryCurrentRowIndex("entryentity", index.intValue());
        model.deleteEntryData("subentryentity");
        dataModel.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("actgfieldmapobj", new Object[0]);
        setter.addField("fieldmap", new Object[0]);
        for (DynamicObject dynamicObject : entryEntityView) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("actgfieldmapobjview");
            DynamicObject fieldMapView = dynamicObject.getDynamicObject("fieldmapview");
            setter.addRow(new Object[]{dynamicObjectCollection, null == fieldMapView ? null : fieldMapView.get("id")});
        }
        dataModel.batchCreateNewEntryRow("subentryentity", setter);
        dataModel.endInit();
        dataModel.setEntryCurrentRowIndex("entryentity", currentRow);
        view.updateView("subentryentity");
    }

    private void fieldMapEntryRemoveDataRows(int[] rows) {
        int entryRowCount = this.getModel().getEntryRowCount("subentryentity");
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] >= entryRowCount) continue;
            this.getModel().deleteEntryRow("subentryentity", rows[i]);
        }
    }

    private String filedRulePageFlexShowPage(String nodeId, Long policyId) throws IOException {
        this.setMapRuleFlexVisible(Boolean.FALSE, Boolean.TRUE);
        String pageId = PayRollActGrpHelper.getPageIdByNodeIdFromCache((IFormView)this.getView(), (String)nodeId);
        Tab tab = (Tab)this.getView().getControl("policytabap");
        List items = tab.getItems();
        List keyList = items.stream().map(Control::getKey).collect(Collectors.toList());
        if (!SWCStringUtils.isEmpty((String)pageId) && keyList.contains(pageId)) {
            tab.activeTab(pageId);
            return pageId;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setSendToClient(true);
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey("policytabap");
        showParameter.setFormId("hsas_policyconfig");
        showParameter.setStatus(this.getPageStatus());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "HSAS_RULE_POLICY"));
        showParameter.setCustomParams(this.getPolicyParaMap(nodeId));
        this.getView().showForm((FormShowParameter)showParameter);
        String subPageId = showParameter.getPageId();
        PayRollActGrpHelper.putPolicyPageMapCache((IFormView)this.getView(), (String)nodeId, (String)subPageId);
        return subPageId;
    }

    private Map<String, Object> getPolicyParaMap(String nodeId) throws IOException {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(16);
        paraMap.put("hrPolicy", this.getPolicyByNodeId(nodeId, null));
        paraMap.put("sceneId", PayRollActGrpHelper.getCurrentSceneId((IFormView)this.getView()));
        paraMap.put("createOrg", this.getModel().getDataEntity().getString("createorg.id"));
        LOGGER.info("[payrollactg] get create Org id = {}:long", (Object)this.getModel().getDataEntity().getLong("createorg.id"));
        LOGGER.info("[payrollactg] get create Org id = {}:string", (Object)this.getModel().getDataEntity().getString("createorg.id"));
        List childPathNodes = PayRollActGrpHelper.getChildPathNodesByNodeId((IFormView)this.getView(), (String)nodeId);
        if (!CollectionUtils.isEmpty((Collection)childPathNodes) && childPathNodes.size() == 3) {
            TreeNode treeNode = (TreeNode)childPathNodes.get(2);
            paraMap.put("resultParamStr", this.getResultParamValue(treeNode));
            paraMap.put("isShowRuleList", this.getIsSetRuleValue(treeNode));
            String[] split = nodeId.split("#");
            paraMap.put("entityobject", split[3]);
            paraMap.put("fieldnumber", split[4]);
        }
        return paraMap;
    }

    private Boolean getIsSetRuleValue(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        Map data = (Map)treeNode.getData();
        return (Boolean)data.get("isShowRuleList");
    }

    private String getResultParamValue(TreeNode treeNode) {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("scene");
        DynamicObjectCollection outputParams = dynamicObject.getDynamicObjectCollection("sceneoutputparams");
        if (CollectionUtils.isEmpty((Collection)outputParams)) {
            return null;
        }
        String[] nodeIdSplit = treeNode.getId().split("#");
        String objectName = nodeIdSplit[3];
        String propertyName = nodeIdSplit[4];
        Map data = (Map)treeNode.getData();
        Boolean isExeParam = (Boolean)data.get("isExeParam");
        if (isExeParam != null && isExeParam.booleanValue()) {
            return this.generateExeParamResult(objectName, propertyName);
        }
        return this.generateResult(objectName, propertyName);
    }

    private String generateExeParamResult(String objectName, String propertyName) {
        String param = objectName + "_" + propertyName;
        try {
            return this.getResultJson(objectName + "_" + propertyName, param);
        }
        catch (IOException e) {
            LOGGER.info("[payrollactg] parse json erro", (Object)e);
            return null;
        }
    }

    private String generateResult(String objectName, String propertyName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)objectName);
        DynamicProperty property = dataEntityType.getProperty(propertyName);
        Class propertyType = property.getPropertyType();
        String displayParam = dataEntityType.getDisplayName().getLocaleValue() + "." + property.getDisplayName().getLocaleValue();
        String param = objectName + "." + objectName + "." + propertyName;
        if (property.getPropertyType().equals(DynamicObject.class)) {
            ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
            param = param + "." + primaryKey.getName();
        }
        String resultJson = "";
        try {
            resultJson = this.getResultJson(displayParam, param);
        }
        catch (IOException e) {
            LOGGER.error("\u8bbe\u7f6e\u9ed8\u8ba4\u7ed3\u679c\u5b57\u6bb5\u51fa\u9519.", (Throwable)e);
            return null;
        }
        return resultJson;
    }

    private String getResultJson(String displayParam, String param) throws IOException {
        RuleResultInfo ruleResultInfo = new RuleResultInfo();
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setDisplayParam(displayParam);
        resultInfo.setParam(param);
        resultInfo.setOperators("==");
        resultInfo.setValueType("2");
        resultInfo.setIndex(0);
        ArrayList<ResultInfo> resultDataList = new ArrayList<ResultInfo>();
        resultDataList.add(resultInfo);
        ruleResultInfo.setResultList(resultDataList);
        return SWCJSONUtils.toString((Object)ruleResultInfo);
    }
}

