/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcolla;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cloudcolla.HSASCloudCollaHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCBaseUtils;

public class PayRollActGrpTplEdit
extends AbstractFormPlugin
implements IBillPlugin,
BeforeF7SelectListener {
    private static final SWCDataServiceHelper actHelper = new SWCDataServiceHelper("hsas_payrollact");
    private static final SWCDataServiceHelper actgTplHelper = new SWCDataServiceHelper("hsas_payrollactgtpl");
    public static final String CALLBACK_BIZ_APP_CHANGED = "CALLBACK_BIZ_APP_CHANGED";
    public static final String CALLBACK_BIZ_APP_CHANGED_DATA = "CALLBACK_BIZ_APP_CHANGED_DATA";

    public void afterCreateNewData(EventObject e) {
        this.getView().getFormShowParameter().getCustomParams().put("IS_NEW", Boolean.TRUE);
    }

    public void afterLoadData(EventObject e) {
        String parentEntityId;
        HSASCloudCollaHelper.getInstance().initEntryIsSysPreset(this.getView(), "payrollact", "ispayrollactsyspreset");
        this.getModel().setDataChanged(false);
        switch (parentEntityId = this.getView().getParentView().getEntityId()) {
            case "hsas_payrollactg": {
                IFormView view = this.getView();
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify"});
                break;
            }
        }
    }

    public void afterBindData(EventObject eventObject) {
        Boolean isNew = this.getView().getFormShowParameter().getCustomParams().getOrDefault("IS_NEW", Boolean.FALSE);
        this.getView().setEnable(isNew, new String[]{"bizapp"});
        this.refreshEntryEntityExecSeq();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "payrollact": {
                ChangeData changeData = e.getChangeSet()[0];
                HSASCloudCollaHelper.getInstance().setEntryIsSysPreset(changeData, this.getView(), "ispayrollactsyspreset");
                break;
            }
            case "bizapp": {
                this.onBizAppPropertyChanged(e);
                break;
            }
        }
    }

    private void onBizAppPropertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (oldValue == null || entryRowCount == 0) {
            return;
        }
        SWCPageCache swcPageCache = this.getSwcPageCache();
        Boolean isShowConfirm = (Boolean)swcPageCache.get("CALLBACK_BIZ_APP_CHANGED_IS_SHOW_CONFIRM", Boolean.class);
        if (isShowConfirm != null) {
            swcPageCache.remove("CALLBACK_BIZ_APP_CHANGED_IS_SHOW_CONFIRM");
            return;
        }
        HashMap<String, String> datas = new HashMap<String, String>(2);
        datas.put("newValue", newValue == null ? null : newValue.getString("id"));
        datas.put("oldValue", oldValue.getString("id"));
        swcPageCache.put(CALLBACK_BIZ_APP_CHANGED_DATA, datas);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u534f\u4f5c\u5e94\u7528\uff0c\u5c06\u6e05\u7a7a\u534f\u4f5c\u6d3b\u52a8\u53ca\u6267\u884c\u987a\u5e8f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayRollActGrpTplEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACK_BIZ_APP_CHANGED, (IFormPlugin)this), null, "12");
    }

    private SWCPageCache getSwcPageCache() {
        return new SWCPageCache(this.getView());
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "CALLBACK_BIZ_APP_CHANGED": {
                this.bizAppChangedCallback(event);
                break;
            }
        }
    }

    private void bizAppChangedCallback(MessageBoxClosedEvent event) {
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getSwcPageCache().remove(CALLBACK_BIZ_APP_CHANGED_DATA);
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        Map map = (Map)this.getSwcPageCache().get(CALLBACK_BIZ_APP_CHANGED_DATA, Map.class);
        if (!CollectionUtils.isEmpty((Map)map)) {
            this.getSwcPageCache().remove(CALLBACK_BIZ_APP_CHANGED_DATA);
            this.getSwcPageCache().put("CALLBACK_BIZ_APP_CHANGED_IS_SHOW_CONFIRM", (Object)Boolean.TRUE);
            this.getModel().setValue("bizapp", map.get("oldValue"));
        }
    }

    private void refreshEntryEntityExecSeq() {
        DynamicObjectCollection entities = this.getView().getModel().getEntryEntity("entryentity");
        if (entities.isEmpty()) {
            return;
        }
        for (int i = 0; i < entities.size(); ++i) {
            this.getView().getModel().setValue("executeseq", (Object)(i + 1), i);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit payRollAct = (BasedataEdit)this.getView().getControl("payrollact");
        payRollAct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizApp = (BasedataEdit)this.getView().getControl("bizapp");
        bizApp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "payrollact": {
                ArrayList<QFilter> filterList = new ArrayList<QFilter>();
                filterList.add(this.getPayRollActF7Filter());
                beforeF7SelectEvent.setCustomQFilters(filterList);
                break;
            }
            case "bizapp": {
                ArrayList<QFilter> appFilter = new ArrayList<QFilter>(1);
                appFilter.add(new QFilter("number", "in", (Object)new String[]{"hsas", "hcsi", "itc"}));
                beforeF7SelectEvent.setCustomQFilters(appFilter);
                break;
            }
        }
    }

    private QFilter getPayRollActF7Filter() {
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObjectCollection entryObjs = this.getModel().getEntryEntity("entryentity");
        if (entryObjs.size() == 1) {
            return null;
        }
        for (DynamicObject entryObj : entryObjs) {
            idList.add(entryObj.getLong("payrollact.id"));
        }
        return new QFilter("id", "not in", idList);
    }

    private List<Long> getEntryItemIds() {
        DynamicObjectCollection coll = this.getModel().getEntryEntity("entryentity");
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject dynamicObject : coll) {
            long id;
            DynamicObject obj = (DynamicObject)dynamicObject.get("payrollact");
            if (SWCBaseUtils.isEmpty((DynamicObject)obj) || ids.contains(id = obj.getLong("ID"))) continue;
            ids.add(id);
        }
        return ids;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String callStr = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        ListSelectedRowCollection dataColl = null;
        switch (callStr) {
            case "CALLBACK_ADD_PAYROLLACT_ENTRY": {
                dataColl = (ListSelectedRowCollection)returnData;
                this.addEntryEntityRows(dataColl);
                break;
            }
        }
    }

    private void addEntryEntityRows(ListSelectedRowCollection data) {
        if (data == null || data.size() == 0) {
            return;
        }
        List fIds = data.stream().map(dataRow -> (Long)dataRow.getPrimaryKeyValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", fIds);
        DynamicObject[] actgs = actHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_payrollact"), new QFilter[]{qFilter}, "number");
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        List<DynamicObject> resortedEntry = this.resortPayRollActEntry(Arrays.asList(actgs));
        entryentity.clear();
        for (int i = 0; i < resortedEntry.size(); ++i) {
            DynamicObject dynamicObject = resortedEntry.get(i);
            dynamicObject.set("executeseq", (Object)(i + 1));
            entryentity.add((Object)dynamicObject);
        }
        this.getModel().updateEntryCache(entryentity);
        this.getView().updateView("entryentity");
        this.freezeEntryRow();
    }

    private List<DynamicObject> resortPayRollActEntry(List<DynamicObject> dataList) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty(dataList)) {
            return entryEntity;
        }
        LinkedList<DynamicObject> result = new LinkedList<DynamicObject>();
        result.addAll((Collection<DynamicObject>)entryEntity);
        block0: for (DynamicObject insertActData : dataList) {
            DynamicObject insertData = actgTplHelper.generateEmptyEntryDynamicObject("entryentity");
            insertData.set("payrollact", (Object)insertActData);
            insertData.set("ispayrollactsyspreset", (Object)(insertActData.getBoolean("issyspreset") ? "1" : "0"));
            long tempId = insertActData.getLong("id");
            long preId = insertActData.getLong("prepayrollact.id");
            if (CollectionUtils.isEmpty(result)) {
                result.add(insertData);
                continue;
            }
            int size = result.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject comparedEntryData = (DynamicObject)result.get(i);
                DynamicObject entryPayRollAct = ((DynamicObject)result.get(i)).getDynamicObject("payrollact");
                long entryTempId = entryPayRollAct.getLong("id");
                long entryPreId = entryPayRollAct.getLong("prepayrollact.id");
                if (tempId == entryPreId) {
                    insertData.set("ismustexecute", (Object)Boolean.TRUE);
                    result.add(i, insertData);
                    continue block0;
                }
                if (preId == entryTempId) {
                    comparedEntryData.set("ismustexecute", (Object)Boolean.TRUE);
                    result.add(i + 1, insertData);
                    continue block0;
                }
                if (i != size - 1) continue;
                result.add(insertData);
            }
        }
        return result;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "newentry": {
                this.newEntry(args);
                break;
            }
            case "deleteentry": {
                this.deleteEntry(args);
                break;
            }
            case "moveentrydown": {
                this.moveDown(args);
                break;
            }
            case "moveentryup": {
                this.moveUp(args);
                break;
            }
        }
    }

    private void newEntry(BeforeDoOperationEventArgs args) {
        args.setCancel(true);
        DynamicObject bizapp = this.getModel().getDataEntity().getDynamicObject("bizapp");
        if (bizapp == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u534f\u4f5c\u5e94\u7528\u201d\u3002", (String)"PayRollActGrpTplEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_payrollact", (boolean)true, (int)2);
        showParameter.setFormId("hsas_collatpllistf7");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_ADD_PAYROLLACT_ENTRY"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList<Long> payRollActIds = new ArrayList<Long>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            payRollActIds.add(dynamicObject.getLong("payrollact.id"));
        }
        showParameter.getCustomParams().put("payRollActList", payRollActIds);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        List<Long> billIds = this.getEntryItemIds();
        if (billIds.size() > 0) {
            qFilters.add(new QFilter("id", "not in", billIds));
        }
        qFilters.add(new QFilter("bizapp", "=", (Object)this.getModel().getDataEntity().getString("bizapp.id")));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, "number"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void deleteEntry(BeforeDoOperationEventArgs args) {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        Set<Integer> rowSet = this.toSet(selectedRows);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        HashSet<Long> deletedPayRollActIds = new HashSet<Long>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!rowSet.contains(i)) continue;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            deletedPayRollActIds.add(dynamicObject.getLong("payrollact.id"));
        }
        ArrayList<String> msgs = new ArrayList<String>(entryEntity.size());
        Boolean isSuccess = Boolean.TRUE;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject;
            if (rowSet.contains(i) || !deletedPayRollActIds.contains((dynamicObject = (DynamicObject)entryEntity.get(i)).getLong("payrollact.prepayrollact.id"))) continue;
            msgs.add(ResManager.loadKDString((String)"\u201c{0}\u201d\u662f\u201c{1}\u201d\u7684\u524d\u7f6e\u534f\u4f5c\u6d3b\u52a8\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u5220\u9664\u3002", (String)"PayRollActGrpTplEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[]{dynamicObject.getString("payrollact.prepayrollact.name"), dynamicObject.getString("payrollact.name")}));
            isSuccess = Boolean.FALSE;
        }
        if (!isSuccess.booleanValue()) {
            this.showMessage(msgs);
            args.setCancel(true);
        }
    }

    private void moveDown(BeforeDoOperationEventArgs args) {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (selectedRows[selectedRows.length - 1] >= entryEntity.size()) {
            return;
        }
        Set<Integer> rowSet = this.toSet(selectedRows);
        DynamicObject nextEntryRow = this.getModel().getEntryRowEntity("entryentity", selectedRows[selectedRows.length - 1] + 1);
        long prePayRollActId = nextEntryRow.getLong("payrollact.prepayrollact.id");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject;
            long tempId;
            if (!rowSet.contains(i) || prePayRollActId != (tempId = (dynamicObject = (DynamicObject)entryEntity.get(i)).getLong("payrollact.id"))) continue;
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u4f5c\u6d3b\u52a8\u7684\u6267\u884c\u987a\u5e8f\u5e94\u5728\u524d\u7f6e\u534f\u4f5c\u6d3b\u52a8\u4e4b\u540e\u3002", (String)"PayRollActGrpTplEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void moveUp(BeforeDoOperationEventArgs args) {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (selectedRows[0] <= 0) {
            return;
        }
        Set<Integer> rowSet = this.toSet(selectedRows);
        DynamicObject preEntryRow = this.getModel().getEntryRowEntity("entryentity", selectedRows[0] - 1);
        long prePayRollActId = preEntryRow.getLong("payrollact.id");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject;
            long tempId;
            if (!rowSet.contains(i) || prePayRollActId != (tempId = (dynamicObject = (DynamicObject)entryEntity.get(i)).getLong("payrollact.prepayrollact.id"))) continue;
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u4f5c\u6d3b\u52a8\u7684\u6267\u884c\u987a\u5e8f\u5e94\u5728\u524d\u7f6e\u534f\u4f5c\u6d3b\u52a8\u4e4b\u540e\u3002", (String)"PayRollActGrpTplEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private Set<Integer> toSet(int[] selectedRows) {
        HashSet<Integer> rowSet = new HashSet<Integer>(selectedRows.length);
        for (int i = 0; i < selectedRows.length; ++i) {
            rowSet.add(selectedRows[i]);
        }
        return rowSet;
    }

    private int[] getSelectedRows() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        return entryGrid.getSelectRows();
    }

    private void showMessage(List<String> msgs) {
        if (CollectionUtils.isEmpty(msgs)) {
            return;
        }
        if (msgs.size() == 1) {
            this.getView().showTipNotification(msgs.get(0));
            return;
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u9519\u8bef", (String)"PayRollActGrpTplEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), msgs.stream().collect(Collectors.joining(System.lineSeparator())), MessageTypes.Default);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "newentry": 
            case "deleteentry": 
            case "moveentrydown": 
            case "moveentryup": {
                this.refreshEntryEntityExecSeq();
                this.freezeEntryRow();
                break;
            }
        }
    }

    private void freezeEntryRow() {
        this.getModel().updateCache();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        HashSet<Long> preIds = new HashSet<Long>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            long tempPreIds = dynamicObject.getLong("payrollact.prepayrollact.id");
            if (tempPreIds == 0L) continue;
            preIds.add(tempPreIds);
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject;
            dynamicObject = (DynamicObject)entryEntity.get(i);
            long tempId = dynamicObject.getLong("payrollact.id");
            this.getView().setEnable(Boolean.valueOf(!preIds.contains(tempId)), i, new String[]{"ismustexecute"});
        }
    }
}

