/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcollaplugin;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.personhr.SyncPersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.AbstractCloudCollaExecutePlugin;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;
import org.apache.commons.collections.MapUtils;

public class CloudCollaCommonUpdateDataAssemblePlugin
implements AbstractCloudCollaExecutePlugin {
    private static final Log LOGGER = LogFactory.getLog(CloudCollaCommonUpdateDataAssemblePlugin.class);
    private CollaRuleExecuteContext executeInfo;
    private String currentEntityNumber;

    public List<String> execute(List<DynamicObject> dynamicObjects, Map<String, Object> ruleEngineData) {
        this.deleteData();
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return new ArrayList<String>();
        }
        ArrayList<String> resultMsg = new ArrayList<String>(1);
        String entityName = dynamicObjects.get(0).getDataEntityType().getName();
        LOGGER.info("[colla],CloudCollaCommonUpdateDataAssemblePlugin.entityName = {}", (Object)entityName);
        try {
            List ids = dynamicObjects.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
            SWCDataServiceHelper orm = new SWCDataServiceHelper(entityName);
            orm.delete(ids.toArray());
            DataEntityPropertyCollection properties = dynamicObjects.get(0).getDataEntityType().getProperties();
            for (DynamicObject object : dynamicObjects) {
                if (!properties.containsKey((Object)"ismodify")) continue;
                object.set("ismodify", (Object)Boolean.FALSE);
            }
            orm.save(dynamicObjects.toArray(new DynamicObject[0]));
            this.afterDoSaveData(dynamicObjects);
            if (this.executeInfo != null && !CollectionUtils.isEmpty(dynamicObjects)) {
                this.executeInfo.getExeResult().put(entityName, dynamicObjects);
                this.executeInfo.getResult().put(entityName, ids.stream().map(item -> {
                    ImmutableMap tempMap = ImmutableMap.of((Object)"entityNumber", (Object)entityName, (Object)"dataId", (Object)item, (Object)"type", (Object)"SYNC");
                    return tempMap;
                }).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            LOGGER.error("[colla]:save data error. entityName = {} ", (Object)entityName, (Object)e);
            resultMsg.add(ResManager.loadKDString((String)"\u6570\u636e\u201c{0}\u201d\u4fdd\u5b58\u5931\u8d25\uff1a{1}\u3002", (String)"CloudCollaCommonUpdateDataAssemblePlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{entityName, e.getMessage()}));
        }
        return resultMsg;
    }

    private void deleteData() {
        if (SWCStringUtils.isEmpty((String)this.currentEntityNumber) || this.executeInfo == null) {
            LOGGER.info("[colla] deleteData currentEntityNumber is null or executeInfo is null. ");
            return;
        }
        Map formIdMap = SyncPersonHelper.getInstance().getFormIdMap();
        String hrpiEntityName = null;
        for (Map.Entry stringStringEntry : formIdMap.entrySet()) {
            if (!this.currentEntityNumber.equals(stringStringEntry.getValue())) continue;
            hrpiEntityName = (String)stringStringEntry.getKey();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.currentEntityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        LOGGER.info("[colla] begin deleteData currentEntityNumber = {}", (Object)this.currentEntityNumber);
        if (!CollectionUtils.isEmpty((Map)this.executeInfo.getRecordDetails()) && properties.containsKey((Object)"datastatus") && SWCStringUtils.isNotEmpty((String)hrpiEntityName)) {
            LOGGER.info("[colla] CloudCollaCommonUpdateDataAssemblePlugin.execute delete data = {}", JSON.toJSON((Object)this.executeInfo.getRecordDetails()));
            List deleteList = (List)MapUtils.getObject((Map)this.executeInfo.getRecordDetails(), (Object)hrpiEntityName, Collections.emptyList());
            List collect = deleteList.stream().filter(item -> "3".equals(MapUtils.getString((Map)item, (Object)"chgmode"))).map(item -> MapUtils.getLong((Map)item, (Object)"idbefore", (Long)0L)).filter(item -> item != 0L).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                SWCDataServiceHelper orm;
                DynamicObject[] query;
                String idKey = "boid";
                if (!properties.containsKey((Object)"boid")) {
                    idKey = "id";
                }
                if ((query = (orm = new SWCDataServiceHelper(this.currentEntityNumber)).query("id,datastatus", new QFilter[]{new QFilter(idKey, "in", collect)})) != null && query.length != 0) {
                    for (DynamicObject dynamicObject : query) {
                        dynamicObject.set("datastatus", (Object)"-1");
                    }
                    orm.save(query);
                }
            }
        }
    }

    protected void afterDoSaveData(List<DynamicObject> dynamicObjects) {
    }

    public List<String> afterAssembleData(Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonDatas, Map<String, Object> ruleEngineData, String currentTriggerObjectName) {
        this.executeInfo = (CollaRuleExecuteContext)commonDatas.get("executeInfo");
        this.currentEntityNumber = currentTriggerObjectName;
        ArrayList<String> result = new ArrayList<String>(1);
        if (CollectionUtils.isEmpty(fieldMapResult)) {
            return result;
        }
        List datas = fieldMapResult.getOrDefault(currentTriggerObjectName, Collections.emptyList());
        for (DynamicObject fieldMapResultObject : datas) {
            String name = fieldMapResultObject.getDataEntityType().getName();
            List<DynamicObject> dynamicObjects = assembleSaveData.get(name);
            if (dynamicObjects == null) {
                dynamicObjects = new ArrayList<DynamicObject>(10);
                assembleSaveData.put(name, dynamicObjects);
            }
            dynamicObjects.add(fieldMapResultObject);
        }
        return result;
    }
}

