/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcollaplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsas.formplugin.web.basedata.cloudcollaplugin.CloudCollaCommonUpdateDataAssemblePlugin;
import kd.swc.hsas.formplugin.web.basedata.cloudcollaplugin.CloudCollaEmployeeDataAssemblePlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CloudCollaDepEmpDataAssemblePlugin
extends CloudCollaCommonUpdateDataAssemblePlugin {
    private static final Log LOGGER = LogFactory.getLog(CloudCollaEmployeeDataAssemblePlugin.class);

    @Override
    public List<String> afterAssembleData(Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, String currentTriggerObjectName) {
        ArrayList<String> result = new ArrayList<String>(10);
        List<String> msg = super.afterAssembleData(fieldMapResult, fieldRuleResult, assembleSaveData, commonParams, ruleEngineData, currentTriggerObjectName);
        result.addAll(msg);
        if (fieldMapResult == null || fieldMapResult.isEmpty()) {
            return result;
        }
        List<DynamicObject> dynamicObjects = fieldMapResult.get(currentTriggerObjectName);
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return result;
        }
        String showName = this.getDepEmpName(dynamicObjects);
        if (SWCStringUtils.isEmpty((String)showName)) {
            LOGGER.info("[colla]: hsas_depemp showname is empty, depempNumber = {} showname = {}", dynamicObjects.get(0).get("number"), (Object)showName);
            return result;
        }
        for (DynamicObject currentObject : dynamicObjects) {
            currentObject.set("showname", (Object)showName);
        }
        return result;
    }

    @Override
    protected void afterDoSaveData(List<DynamicObject> dynamicObjects) {
        super.afterDoSaveData(dynamicObjects);
        Set depEmpIds = dynamicObjects.stream().map(single -> single.getLong("id")).collect(Collectors.toSet());
        Set employeeIds = dynamicObjects.stream().map(single -> single.getLong("employee.id")).collect(Collectors.toSet());
        SalaryFileEmpPosOrgRelHelper.updateDepEmpTimeRemainedFlag(depEmpIds);
        SalaryFileEmpPosOrgRelHelper.updateEmployeeRemainedFlag(employeeIds);
    }

    private String getDepEmpName(List<DynamicObject> depEmpList) {
        if (depEmpList == null || depEmpList.isEmpty()) {
            return null;
        }
        for (DynamicObject depemp : depEmpList) {
            Boolean isCurrentVersion = depemp.getBoolean("iscurrentversion");
            if (!Boolean.TRUE.equals(isCurrentVersion)) continue;
            long dutyWorkRoleId = depemp.getLong("dutyworkroles.id");
            LOGGER.info("[colla] CloudCollaDepEmpDataAssemblePlugin dutyworkroles.id = {}", (Object)dutyWorkRoleId);
            if (dutyWorkRoleId == 0L) {
                return null;
            }
            SWCDataServiceHelper orm = new SWCDataServiceHelper("hbpm_dutyworkroles");
            DynamicObject dynamicObject = orm.queryOne((Object)dutyWorkRoleId);
            return Optional.ofNullable(dynamicObject).map(item -> item.getString("name")).orElse(" ");
        }
        return null;
    }
}

