/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcollaplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsas.formplugin.web.basedata.cloudcollaplugin.CloudCollaCommonUpdateDataAssemblePlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CloudCollaEmployeeDataAssemblePlugin
extends CloudCollaCommonUpdateDataAssemblePlugin {
    private static final Log LOGGER = LogFactory.getLog(CloudCollaEmployeeDataAssemblePlugin.class);

    @Override
    public List<String> afterAssembleData(Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, String currentTriggerObjectName) {
        ArrayList<String> result = new ArrayList<String>(10);
        List<String> msg = super.afterAssembleData(fieldMapResult, fieldRuleResult, assembleSaveData, commonParams, ruleEngineData, currentTriggerObjectName);
        result.addAll(msg);
        if (fieldMapResult == null || fieldMapResult.isEmpty()) {
            return result;
        }
        List<DynamicObject> dynamicObjects = fieldMapResult.get(currentTriggerObjectName);
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return result;
        }
        String personName = this.getPersonName(fieldMapResult.get("hsas_personhr"));
        if (SWCStringUtils.isEmpty((String)personName)) {
            LOGGER.info("[colla]: hsas_personhr showname is empty, employeeNumber = {} showname = {}", dynamicObjects.get(0).get("empnumber"), (Object)personName);
            return result;
        }
        for (DynamicObject currentObject : dynamicObjects) {
            currentObject.set("showname", (Object)personName);
            currentObject.set("datasource", (Object)"C");
        }
        return result;
    }

    @Override
    protected void afterDoSaveData(List<DynamicObject> dynamicObjects) {
        super.afterDoSaveData(dynamicObjects);
        Set employeeIds = dynamicObjects.stream().map(single -> single.getLong("id")).collect(Collectors.toSet());
        SalaryFileEmpPosOrgRelHelper.updateEmployeeRemainedFlag(employeeIds);
    }

    private String getPersonName(List<DynamicObject> personList) {
        if (personList == null || personList.isEmpty()) {
            return null;
        }
        for (DynamicObject person : personList) {
            Boolean isCurrentVersion = person.getBoolean("iscurrentversion");
            if (!Boolean.TRUE.equals(isCurrentVersion)) continue;
            return person.getString("name");
        }
        return null;
    }
}

