/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcollaplugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.personhr.SyncPersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.vo.AbstractCloudCollaExecutePlugin;

public class CloudCollaPersonReEntryDataAssemblePlugin
implements AbstractCloudCollaExecutePlugin {
    private static final Log LOGGER = LogFactory.getLog(CloudCollaPersonReEntryDataAssemblePlugin.class);
    private static final Map<String, String> syncDataConfig = new HashMap<String, String>(16);

    public List<String> execute(List<DynamicObject> executeData, Map<String, Object> ruleEngineData) {
        return super.execute(executeData, ruleEngineData);
    }

    public List<String> afterAssembleData(Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, String currentTriggerObjectName) {
        QFilter boIdFilter;
        DynamicObject employee = this.getPersonName(fieldMapResult.get(currentTriggerObjectName));
        if (employee == null) {
            return Collections.emptyList();
        }
        SWCDataServiceHelper personOrm = new SWCDataServiceHelper("hsas_personhr");
        QFilter numberFilter = new QFilter("number", "=", (Object)employee.getString("number"));
        DynamicObject[] query = personOrm.query("id,boid,empnumber", new QFilter[]{numberFilter, boIdFilter = new QFilter("boid", "!=", (Object)employee.getLong("boid"))});
        if (query == null || query.length == 0) {
            return Collections.emptyList();
        }
        List personList = Arrays.stream(query).map(item -> item.getLong("boid")).collect(Collectors.toList());
        syncDataConfig.forEach((target, source) -> this.syncPersonData((String)source, (String)target, personList));
        return Collections.emptyList();
    }

    private void syncPersonData(String sourceFormId, String targetFormId, List<Long> boIdList) {
        if ("hsas_personhr".equalsIgnoreCase(targetFormId)) {
            SyncPersonHelper.getInstance().syncPersonOneEntity(syncDataConfig.get("hsas_personhr"), "hsas_personhr", boIdList);
            return;
        }
        QFilter filter = this.getFilter(targetFormId, boIdList);
        if (filter == null) {
            return;
        }
        SWCDataServiceHelper orm = new SWCDataServiceHelper(targetFormId);
        DynamicObject[] query = orm.queryOriginalArray("id,boid", new QFilter[]{filter});
        List queryBoIdList = Arrays.stream(query).map(item -> item.getLong("boid")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(queryBoIdList)) {
            return;
        }
        SyncPersonHelper.getInstance().syncPersonOneEntity(sourceFormId, targetFormId, queryBoIdList);
    }

    private QFilter getFilter(String targetFormId, List<Long> personBoId) {
        switch (targetFormId) {
            case "hsas_personhr": 
            case "hsas_pernontsprop": {
                return new QFilter("boid", "in", personBoId);
            }
            case "hsas_employee": 
            case "hsas_cmpemp": 
            case "hsas_depemp": 
            case "hsas_empentrel": 
            case "hsas_managingscope": 
            case "hsas_empposorgrelhr": {
                return new QFilter("person", "in", personBoId);
            }
        }
        return null;
    }

    private DynamicObject getPersonName(List<DynamicObject> employeeList) {
        if (CollectionUtils.isEmpty(employeeList)) {
            return null;
        }
        for (DynamicObject emp : employeeList) {
            Boolean isCurrentVersion = emp.getBoolean("iscurrentversion");
            if (!Boolean.TRUE.equals(isCurrentVersion)) continue;
            return emp;
        }
        return null;
    }

    static {
        syncDataConfig.put("hsas_personhr", "hrpi_person");
        syncDataConfig.put("hsas_employee", "hrpi_employee");
        syncDataConfig.put("hsas_cmpemp", "hrpi_cmpemp");
        syncDataConfig.put("hsas_depemp", "hrpi_depemp");
        syncDataConfig.put("hsas_pernontsprop", "hrpi_pernontsprop");
        syncDataConfig.put("hsas_empentrel", "hrpi_empentrel");
        syncDataConfig.put("hsas_empjobrel", "hrpi_empjobrel");
        syncDataConfig.put("hsas_trialperiod", "hrpi_trialperiod");
        syncDataConfig.put("hsas_empposorgrelhr", "hrpi_empposorgrel");
        syncDataConfig.put("hsas_managingscope", "hrpi_managingscope");
        syncDataConfig.put("hsas_perprotitlehr", "hrpi_perprotitle");
        syncDataConfig.put("hsas_perserlen", "hrpi_perserlen");
        syncDataConfig.put("hsas_pertsprop", "hrpi_pertsprop");
        syncDataConfig.put("hsas_pereduexp", "hrpi_pereduexp");
        syncDataConfig.put("hsas_projectmember", "hrpi_projectmember");
    }
}

