/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcollaplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cloudcolla.CloudSalaryFileDataHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.UpdatePaySettingService;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdateErrorResult;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingErrorEnum;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingResult;
import kd.swc.hsas.business.salaryfile.SalaryFileServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.vo.AbstractCloudCollaExecutePlugin;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CloudCollaSalaryFilePaySettingAssemblePlugin
implements AbstractCloudCollaExecutePlugin {
    private static final Log LOGGER = LogFactory.getLog(CloudCollaSalaryFilePaySettingAssemblePlugin.class);
    private Long depEmpId;
    private Date effectTime;
    private Map<String, List<DynamicObject>> assembleSaveData;
    private Map<String, Object> commonParams;

    public List<String> afterAssembleData(Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, String currentTriggerObjectName) {
        LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin.afterAssembleData start...");
        ArrayList<String> result = new ArrayList<String>(10);
        CloudSalaryFileDataHelper helper = CloudSalaryFileDataHelper.getInstance();
        Optional currentEntity = helper.getCurrentEntity(assembleSaveData, "hsas_depemp");
        if (!currentEntity.isPresent()) {
            LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin.depEmp is null...");
            return result;
        }
        DynamicObject depEmp = (DynamicObject)currentEntity.get();
        this.depEmpId = depEmp.getLong("id");
        this.effectTime = (Date)commonParams.get("effectTime");
        this.assembleSaveData = assembleSaveData;
        this.commonParams = commonParams;
        LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin.afterAssembleData end...");
        return result;
    }

    public List<String> execute(List<DynamicObject> executeData, Map<String, Object> ruleEngineData) {
        LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin.execute start...");
        ArrayList<String> result = new ArrayList<String>(10);
        ArrayList<String> warnList = new ArrayList<String>(10);
        Boolean isHandUpdateBankCard = MapUtils.getBoolean(ruleEngineData, (Object)"hsas_paysetting_isupdate");
        LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin.isHandUpdateBankCard is: {}...", (Object)isHandUpdateBankCard);
        List<DynamicObject> salaryFiles = this.matchSalaryFiles();
        List salaryFileIds = salaryFiles.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin.salaryFiles size: {}...", (Object)salaryFiles.size());
        UpdatePaySettingService service = new UpdatePaySettingService();
        UpdatePaySettingResult updatePaySettingResult = service.synUpdatePaySetting(salaryFileIds, isHandUpdateBankCard);
        List errorList = updatePaySettingResult.getErrorList();
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin.errorList size: {}...", (Object)errorList.size());
            for (UpdateErrorResult errorResult : errorList) {
                String errCode = errorResult.getErrorEnum().getCode();
                switch (errorResult.getErrorLevel()) {
                    case FatalError: 
                    case Error: {
                        if (UpdatePaySettingErrorEnum.NOT_UPDATE_RULE.getCode().equals(errCode) || UpdatePaySettingErrorEnum.NOT_UPDATE_BANK_CARD.getCode().equals(errCode)) {
                            warnList.add(errorResult.getErrorReason());
                            break;
                        }
                        result.add(errorResult.getErrorReason());
                        break;
                    }
                    case Warning: 
                    case Info: {
                        warnList.add(errorResult.getErrorReason());
                        break;
                    }
                }
            }
            LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin.result size: {}...", (Object)result.size());
            LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin.warnList size: {}...", (Object)warnList.size());
        } else if (updatePaySettingResult.getFailNum() != 0) {
            LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin. Invoke synUpdatePaySetting Fail!");
            result.add(ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u653e\u8bbe\u7f6e\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"CloudCollaSalaryFilePaySettingAssemblePlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        if (CollectionUtils.isNotEmpty(warnList)) {
            CollaRuleExecuteContext context = (CollaRuleExecuteContext)this.commonParams.get("executeInfo");
            context.getWarnMsgs().addAll(warnList);
        }
        LOGGER.info("[colla][paysetting] CloudCollaSalaryFilePaySettingAssemblePlugin.execute end...");
        return result;
    }

    private List<DynamicObject> matchSalaryFiles() {
        CloudSalaryFileDataHelper helper = CloudSalaryFileDataHelper.getInstance();
        HashMap<String, Comparable<Long>> fileParam = new HashMap<String, Comparable<Long>>(2);
        fileParam.put("depEmpId", this.depEmpId);
        fileParam.put("endDate", this.effectTime);
        SalaryFileServiceHelper fileHelper = new SalaryFileServiceHelper();
        List fileResult = fileHelper.matchSalaryFile(Collections.singletonList(fileParam));
        int queryRowCount = ((Map)fileResult.get(0)).getOrDefault("queryRowCount", 0);
        if (queryRowCount == 0) {
            Optional depEmpObjectOp = helper.getCurrentEntity(this.assembleSaveData, "hsas_depemp");
            Optional employeeObjectOp = helper.getCurrentEntity(this.assembleSaveData, "hsas_employee");
            Optional personObjectOp = helper.getCurrentEntity(this.assembleSaveData, "hsas_personhr");
            String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5c97\u4f4d({2})\u5728{3}\u4e0d\u5b58\u5728\u85aa\u8d44\u6863\u6848\uff0c\u65e0\u6cd5\u66f4\u65b0\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e\u3002", (String)"CloudCollaSalaryFilePaySettingAssemblePlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{personObjectOp.isPresent() ? ((DynamicObject)personObjectOp.get()).getString("name") : "", employeeObjectOp.isPresent() ? ((DynamicObject)employeeObjectOp.get()).getString("empnumber") : "", depEmpObjectOp.isPresent() ? ((DynamicObject)depEmpObjectOp.get()).getString("number") : "", this.effectTime == null ? "" : SWCDateTimeUtils.format((Date)this.effectTime, (String)"yyyy-MM-dd")});
            throw new KDBizException(msg);
        }
        List matchSalaryFileVers = (List)((Map)fileResult.get(0)).get("matchSalaryFileVers");
        return matchSalaryFileVers;
    }
}

