/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcollaplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cloudcolla.CloudSalaryFileDataHelper;
import kd.swc.hsas.business.personchange.PersonChangeService;
import kd.swc.hsas.business.salaryfile.SalaryFileServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.vo.AbstractCloudCollaExecutePlugin;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;
import org.apache.commons.collections4.MapUtils;

public class CloudCollaSalaryFilePersonChangeAssemblePlugin
implements AbstractCloudCollaExecutePlugin {
    private static final Log LOGGER = LogFactory.getLog(CloudCollaSalaryFilePersonChangeAssemblePlugin.class);
    private Long depEmpId;
    private Date changeDate;
    private Map<String, List<DynamicObject>> assembleSaveData;
    private String taskCenterClass;

    public List<String> afterAssembleData(Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, String currentTriggerObjectName) {
        LOGGER.info("[colla][personchange] CloudCollaSalaryFilePersonChangeAssemblePlugin.afterAssembleData start...");
        ArrayList<String> result = new ArrayList<String>();
        CloudSalaryFileDataHelper helper = CloudSalaryFileDataHelper.getInstance();
        Optional depEmpOp = helper.getCurrentEntity(assembleSaveData, "hsas_depemp");
        if (!depEmpOp.isPresent()) {
            LOGGER.info("[colla] 0. CloudSalaryFileFlowInHandler: depEmp == null");
            return result;
        }
        DynamicObject depEmpObject = (DynamicObject)depEmpOp.get();
        List personchanges = (List)fieldRuleResult.get("hsas_personchange");
        DynamicObject personChange = (DynamicObject)personchanges.get(0);
        Date fieldRuleChangeDate = personChange.getDate("changedate");
        if (fieldRuleChangeDate == null) {
            String msg = ResManager.loadKDString((String)"\u53d8\u52a8\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u4eba\u5458\u53d8\u52a8\u8bb0\u5f55\u3002", (String)"CloudCollaSalaryFilePersonChangeAssemblePlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        this.depEmpId = depEmpObject.getLong("id");
        this.changeDate = fieldRuleChangeDate;
        this.assembleSaveData = assembleSaveData;
        DynamicObject taskcenter = new SWCDataServiceHelper("hpdi_taskcenter").generateEmptyDynamicObject();
        taskcenter.set("id", (Object)((CollaRuleExecuteContext)commonParams.get("executeInfo")).getTaskCenterId());
        personChange.set("taskcenter", (Object)taskcenter);
        CollaRuleExecuteContext context = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        Map msgEntity = context.getMsgEntity();
        this.taskCenterClass = ((CollaRuleExecuteContext)commonParams.get("executeInfo")).getTaskCenterClass();
        assembleSaveData.put(currentTriggerObjectName, personchanges);
        return result;
    }

    public List<String> execute(List<DynamicObject> executeData, Map<String, Object> ruleEngineData) {
        PersonChangeService personChangeService;
        Map rstMap;
        LOGGER.info("[colla][personchange] CloudCollaSalaryFilePersonChangeAssemblePlugin.execute start...");
        ArrayList<String> result = new ArrayList<String>(10);
        if (CollectionUtils.isEmpty(executeData)) {
            return result;
        }
        ArrayList genPersonParams = new ArrayList(10);
        HashMap<String, Object> genPersonParam = null;
        for (DynamicObject dataEntity : executeData) {
            this.matchSalaryFile(dataEntity);
            Long changeReason = dataEntity.getLong("changereason.id");
            Date changeDate = dataEntity.getDate("changeDate");
            long taskCenterId = dataEntity.getLong("taskcenter.id");
            LOGGER.info("[colla][personchange] CloudCollaSalaryFilePersonChangeAssemblePlugin.execute for...{}...{}", (Object)changeReason, (Object)SWCDateTimeUtils.format((Date)changeDate));
            if (changeReason == 0L || changeDate == null) continue;
            genPersonParam = new HashMap<String, Object>(16);
            genPersonParam.put("salaryFileId", dataEntity.getLong("salaryfile.id"));
            genPersonParam.put("changeReasonId", changeReason);
            genPersonParam.put("changeDate", changeDate);
            genPersonParam.put("taskCenterId", taskCenterId);
            genPersonParam.put("taskCenterClass", this.taskCenterClass);
            genPersonParams.add(genPersonParam);
        }
        if (!genPersonParams.isEmpty() && !MapUtils.getBoolean((Map)(rstMap = (personChangeService = new PersonChangeService()).genPersonChangeForColla(genPersonParams)), (Object)"success").booleanValue()) {
            result.add(MapUtils.getString((Map)rstMap, (Object)"message"));
        }
        LOGGER.info("[colla][personchange] CloudCollaSalaryFilePersonChangeAssemblePlugin.execute end");
        return result;
    }

    private void matchSalaryFile(DynamicObject personChange) {
        CloudSalaryFileDataHelper helper = CloudSalaryFileDataHelper.getInstance();
        SalaryFileServiceHelper fileHelper = new SalaryFileServiceHelper();
        HashMap<String, Comparable<Long>> fileParam = new HashMap<String, Comparable<Long>>(2);
        fileParam.put("depEmpId", this.depEmpId);
        fileParam.put("endDate", this.changeDate);
        List fileResult = fileHelper.matchSalaryFile(Collections.singletonList(fileParam));
        Optional employeeOp = helper.getCurrentEntity(this.assembleSaveData, "hsas_employee");
        String empNumber = employeeOp.isPresent() ? ((DynamicObject)employeeOp.get()).getString("empnumber") : "";
        Optional personOp = helper.getCurrentEntity(this.assembleSaveData, "hsas_personhr");
        String personName = personOp.isPresent() ? ((DynamicObject)personOp.get()).getString("name") : "";
        Optional depEmpOp = helper.getCurrentEntity(this.assembleSaveData, "hsas_depemp");
        String depEmpNumber = depEmpOp.isPresent() ? ((DynamicObject)depEmpOp.get()).getString("number") : "";
        int queryRowCount = (Integer)((Map)fileResult.get(0)).get("queryRowCount");
        if (queryRowCount == 1) {
            List matchSalaryFileVers = (List)((Map)fileResult.get(0)).get("matchSalaryFileVers");
            personChange.set("salaryfile", matchSalaryFileVers.get(0));
        } else {
            if (queryRowCount == 0) {
                String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5c97\u4f4d({2})\u5728{3}\u4e0d\u5b58\u5728\u85aa\u8d44\u6863\u6848\uff0c\u65e0\u6cd5\u751f\u6210\u4eba\u5458\u53d8\u52a8\u8bb0\u5f55\u3002", (String)"CloudCollaSalaryFilePersonChangeAssemblePlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{personName, empNumber, depEmpNumber, SWCDateTimeUtils.format((Date)this.changeDate, (String)"yyyy-MM-dd")});
                throw new KDBizException(msg);
            }
            if (queryRowCount >= 2) {
                String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5c97\u4f4d({2})\u5728{3}\u5b58\u5728\u591a\u4e2a\u85aa\u8d44\u6863\u6848\uff0c\u65e0\u6cd5\u751f\u6210\u4eba\u5458\u53d8\u52a8\u8bb0\u5f55\u3002", (String)"CloudCollaSalaryFilePersonChangeAssemblePlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[]{personName, empNumber, depEmpNumber, SWCDateTimeUtils.format((Date)this.changeDate, (String)"yyyy-MM-dd")});
                throw new KDBizException(msg);
            }
        }
    }
}

