/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.importtask;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class ImportTaskEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String MIGRATION_TPL_CHANGE_KEY = "migrationtpl_change";

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        showParameter.setCaption(ResManager.loadKDString((String)"\u521b\u5efa\u4efb\u52a1", (String)"ImportTaskEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit migrationTpl = (BasedataEdit)this.getView().getControl("migrationtpl");
        migrationTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "isarchiveddata": {
                this.setNumberPrix();
                break;
            }
            case "migrationtpl": {
                this.setWriteTaskTypeByMigrationTpl();
                break;
            }
            case "writetasktype": {
                if (this.getPageCache().get(MIGRATION_TPL_CHANGE_KEY) == null) {
                    this.clearMigrationTplByWriteTaskType();
                    break;
                }
                this.getPageCache().remove(MIGRATION_TPL_CHANGE_KEY);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "migrationtpl": {
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                qFilter.and(new QFilter("status", "=", (Object)"C"));
                boolean isArchivedData = (Boolean)this.getModel().getValue("isarchiveddata");
                qFilter.and(new QFilter("isarchiveddata", "=", (Object)(isArchivedData ? "1" : "0")));
                qFilter.and(new QFilter("org.id", "=", (Object)((DynamicObject)this.getModel().getValue("org")).getLong("id")));
                String writeTaskType = (String)this.getModel().getValue("writetasktype");
                if (SWCStringUtils.isNotEmpty((String)writeTaskType)) {
                    qFilter.and(new QFilter("writetasktype", "=", (Object)writeTaskType));
                }
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                listFilterParameter.getQFilters().add(qFilter);
                break;
            }
        }
    }

    private void setNumberPrix() {
        boolean isArchivedData = (Boolean)this.getModel().getValue("isarchiveddata");
        if (isArchivedData) {
            this.getModel().setValue("numberprix", (Object)"TP");
        } else {
            this.getModel().setValue("numberprix", (Object)"TC");
        }
    }

    private void setWriteTaskTypeByMigrationTpl() {
        DynamicObject migrationTemple = (DynamicObject)this.getModel().getValue("migrationtpl");
        if (migrationTemple != null && SWCStringUtils.isEmpty((String)((String)this.getModel().getValue("writetasktype")))) {
            this.getPageCache().put(MIGRATION_TPL_CHANGE_KEY, "1");
            this.getModel().setValue("writetasktype", (Object)migrationTemple.getString("writetasktype"));
        }
    }

    private void clearMigrationTplByWriteTaskType() {
        DynamicObject migrationTemple = (DynamicObject)this.getModel().getValue("migrationtpl");
        if (migrationTemple != null && !SWCStringUtils.equals((String)migrationTemple.getString("writetasktype"), (String)((String)this.getModel().getValue("writetasktype")))) {
            this.getModel().setValue("migrationtpl", null);
        }
    }
}

