/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.importtask;

import java.text.MessageFormat;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class ImportTaskList
extends SWCDataBaseList {
    private static String CLOSE_TASK_AFTER_CONFIRM = "close_task_after_confirm";
    private static String CLEAR_TASK_AFTER_CONFIRM = "clear_task_after_confirm";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)opKey, (String)"delete")) {
            formOperate.getOption().setVariableValue("ignorerefentityids", "hsas_verifyrecord");
        } else if (SWCStringUtils.equals((String)opKey, (String)"donothing_closetask")) {
            RefObject closeAfterConfirm = new RefObject();
            if (!formOperate.getOption().tryGetVariableValue(CLOSE_TASK_AFTER_CONFIRM, closeAfterConfirm)) {
                this.showConfirmPage(opKey);
                args.setCancel(true);
            }
        } else if (SWCStringUtils.equals((String)opKey, (String)"donothing_cleartask")) {
            RefObject clearAfterConfirm = new RefObject();
            if (!formOperate.getOption().tryGetVariableValue(CLEAR_TASK_AFTER_CONFIRM, clearAfterConfirm)) {
                this.showConfirmPage(opKey);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String opKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)"donothing_closetask", (String)opKey)) {
            this.getView().invokeOperation("refresh");
        } else if (SWCStringUtils.equals((String)"donothing_unclosetask", (String)opKey)) {
            this.getView().invokeOperation("refresh");
        } else if (SWCStringUtils.equals((String)"donothing_cleartask", (String)opKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (SWCStringUtils.equals((String)"name", (String)fieldName)) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            ListSelectedRow selectRow = listView.getCurrentSelectedRowInfo();
            Long importTaskId = (Long)selectRow.getPrimaryKeyValue();
            this.openGidePage(importTaskId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "donothing_closetask": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(CLOSE_TASK_AFTER_CONFIRM, "true");
                this.getView().invokeOperation("donothing_closetask", operateOption);
                break;
            }
            case "donothing_cleartask": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(CLEAR_TASK_AFTER_CONFIRM, "true");
                this.getView().invokeOperation("donothing_cleartask", operateOption);
                break;
            }
        }
    }

    private void openGidePage(Long importTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_importtask");
        DynamicObject data = helper.queryOne("id,name,org.id,writetasktype,migrationtpl.id,creator.id,taskstatus", (Object)importTaskId);
        if (data == null) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ImportTaskList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        if (SWCStringUtils.equals((String)"8", (String)data.getString("taskstatus"))) {
            String msg = ResManager.loadKDString((String)"\u6240\u9009\u4efb\u52a1\u5df2\u6e05\u9664\u4e2d\u95f4\u8868\u6570\u636e\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"ImportTaskList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("hsas_importtaskguide");
        String caption = MessageFormat.format(ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1 - {0}", (String)"ImportTaskList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), data.getString("name"));
        parameter.setCaption(caption);
        parameter.setCustomParam("importTaskId", (Object)importTaskId);
        parameter.setCustomParam("importTaskName", (Object)data.getString("name"));
        parameter.setCustomParam("writetasktype", (Object)data.getString("writetasktype"));
        parameter.setCustomParam("migrationtplId", (Object)data.getLong("migrationtpl.id"));
        parameter.setCustomParam("orgId", (Object)String.valueOf(data.getLong("org.id")));
        parameter.setCustomParam("creator", (Object)String.valueOf(data.getLong("creator.id")));
        String pageId = this.getView().getMainView() == null ? this.getView().getPageId() : this.getView().getMainView().getPageId();
        pageId = pageId + '_' + importTaskId;
        parameter.setPageId(pageId);
        this.getView().showForm(parameter);
    }

    private void showConfirmPage(String opKey) {
        int size = this.getSelectedRows().size();
        String msg = null;
        if (SWCStringUtils.equals((String)opKey, (String)"donothing_closetask")) {
            msg = MessageFormat.format(ResManager.loadKDString((String)"\u5173\u95ed\u9009\u4e2d\u7684{0}\u4e2a\u4efb\u52a1\u540e\uff0c\u4efb\u52a1\u5c06\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff0c\u786e\u5b9a\u8981\u5173\u95ed\u8be5\u4efb\u52a1\u5417\uff1f", (String)"ImportTaskList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), size);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_closetask"));
        } else if (SWCStringUtils.equals((String)opKey, (String)"donothing_cleartask")) {
            msg = MessageFormat.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684{0}\u4e2a\u4efb\u52a1\u7684\u4e2d\u95f4\u8868\u6570\u636e\u6e05\u9664\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\u5e76\u65e0\u6cd5\u518d\u6b21\u8fdb\u5165\u4efb\u52a1\u3002\u786e\u5b9a\u6e05\u9664\u5417\uff1f", (String)"ImportTaskList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), size);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_cleartask"));
        }
    }
}

