/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.importtask.guide;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.importtaskguide.utils.ImportTaskUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DataCheckProgressPlugin
extends AbstractListPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(DataCheckProgressPlugin.class);
    public static final String CHECKPROGRESS = "checkprogress";
    public static final String DONOTHING_STOP = "donothing_stop";
    public static final String DONOTHING_MINSIZE = "donothing_minsize";

    public void initialize() {
        super.initialize();
        ProgressBar checkProgressBar = (ProgressBar)this.getControl(CHECKPROGRESS);
        checkProgressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel"});
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String progressType = (String)parameter.getCustomParam("progressType");
        Integer totalCount = (Integer)parameter.getCustomParam("totalCount");
        Label totalLable = (Label)this.getControl("totallable");
        String totalText = MessageFormat.format(ResManager.loadKDString((String)"\u8bb0\u5f55\u603b\u6570\uff1a{0}\u6761", (String)"DataCheckProgressPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), totalCount);
        totalLable.setText(totalText);
        Html opDescription = (Html)this.getControl("opdescription");
        StringBuilder opDesc = new StringBuilder();
        opDesc.append("<div><span style='font-size:12px'>");
        opDesc.append(this.getStartOpDescription(progressType));
        opDesc.append("</span></div>");
        opDescription.setConent(opDesc.toString());
        ProgressBar checkProgressBar = (ProgressBar)this.getControl(CHECKPROGRESS);
        checkProgressBar.start();
    }

    private String getStartOpDescription(String progressType) {
        String msg = "";
        switch (progressType) {
            case "4": {
                msg = ResManager.loadKDString((String)"\u6570\u636e\u6267\u884c\u6821\u9a8c\u4e2d\u3002", (String)"DataCheckProgressPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "3": {
                msg = ResManager.loadKDString((String)"\u6570\u636e\u9884\u5904\u7406\u4e2d...", (String)"DataCheckProgressPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "5": {
                msg = ResManager.loadKDString((String)"\u6570\u636e\u5199\u5165\u4e2d...", (String)"DataCheckProgressPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "6": {
                msg = ResManager.loadKDString((String)"\u6570\u636e\u53cd\u5199\u4e2d...", (String)"DataCheckProgressPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "22": {
                msg = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u4e2d...", (String)"DataCheckProgressPlugin_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return msg;
    }

    private String getStopOpDescription(String progressType) {
        String msg = "";
        switch (progressType) {
            case "4": {
                msg = ResManager.loadKDString((String)"\u672c\u6b21\u6267\u884c\u6821\u9a8c\u5df2\u7ec8\u6b62\u3002", (String)"DataCheckProgressPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "3": {
                msg = ResManager.loadKDString((String)"\u672c\u6b21\u6570\u636e\u9884\u5904\u7406\u5df2\u7ec8\u6b62\u3002", (String)"DataCheckProgressPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "5": {
                msg = ResManager.loadKDString((String)"\u672c\u6b21\u6570\u636e\u5199\u5165\u5df2\u7ec8\u6b62\u3002", (String)"DataCheckProgressPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "6": {
                msg = ResManager.loadKDString((String)"\u672c\u6b21\u6570\u636e\u53cd\u5199\u5165\u5df2\u7ec8\u6b62\u3002", (String)"DataCheckProgressPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "22": {
                msg = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u5df2\u7ec8\u6b62\u3002", (String)"DataCheckProgressPlugin_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return msg;
    }

    private String getEndOpDescription(String progressType, String timeMsg) {
        String msg = "";
        switch (progressType) {
            case "4": {
                msg = ResManager.loadKDString((String)"\u672c\u6b21\u6267\u884c\u6821\u9a8c\u5df2\u5b8c\u6210\uff0c\u5171\u8017\u65f6{0}\u3002", (String)"DataCheckProgressPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "3": {
                msg = ResManager.loadKDString((String)"\u672c\u6b21\u6570\u636e\u9884\u5904\u7406\u5df2\u5b8c\u6210\uff0c\u5171\u8017\u65f6{0}\u3002", (String)"DataCheckProgressPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "5": {
                msg = ResManager.loadKDString((String)"\u672c\u6b21\u6570\u636e\u5199\u5165\u5df2\u5b8c\u6210\uff0c\u5171\u8017\u65f6{0}\u3002", (String)"DataCheckProgressPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "6": {
                msg = ResManager.loadKDString((String)"\u672c\u6b21\u6570\u636e\u53cd\u5199\u5165\u5df2\u5b8c\u6210\uff0c\u5171\u8017\u65f6{0}\u3002", (String)"DataCheckProgressPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "22": {
                msg = ResManager.loadKDString((String)"\u672c\u6b21\u5bfc\u5165\u5df2\u5b8c\u6210\uff0c\u5171\u8017\u65f6{0}\u3002", (String)"DataCheckProgressPlugin_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        msg = MessageFormat.format(msg, timeMsg);
        return msg;
    }

    public void onProgress(ProgressEvent evt) {
        Control control = (Control)evt.getSource();
        String progressKey = control.getKey();
        if (CHECKPROGRESS.equals(progressKey)) {
            this.queryAndSetCheckProgress(evt);
        }
    }

    private void queryAndSetCheckProgress(ProgressEvent evt) {
        String startProgress = this.getPageCache().get("cachekey_startpropgress");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String startTime = (String)parameter.getCustomParam("startTime");
        String progressType = (String)parameter.getCustomParam("progressType");
        Integer totalCount = (Integer)parameter.getCustomParam("totalCount");
        String verifyRecord = (String)parameter.getCustomParam("verifyId");
        Long importTask = (Long)parameter.getCustomParam("importTaskId");
        Label calConsumeTimeLabel = (Label)this.getView().getControl("calconsumetime");
        Date time = null;
        try {
            time = SWCDateTimeUtils.parseDate((String)startTime, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            time = new Date();
        }
        String timeMsg = SWCDateTimeUtils.getConsumeTime((Date)time);
        calConsumeTimeLabel.setText(timeMsg);
        Map<Object, Object> dataProgressMap = null;
        switch (progressType) {
            case "4": {
                dataProgressMap = this.getProgressData(String.format(Locale.ROOT, "dataCheck_progress_%s", verifyRecord));
                break;
            }
            case "3": {
                dataProgressMap = this.getProgressData(String.format(Locale.ROOT, "datapredeal_cache_%s", verifyRecord));
                break;
            }
            case "5": {
                dataProgressMap = this.getProgressData(MessageFormat.format("dataWriteIn_progress_{0}", importTask));
                break;
            }
            case "6": {
                dataProgressMap = this.getProgressData(MessageFormat.format("dataUnWriteIn_progress_{0}", importTask));
                break;
            }
            case "22": {
                dataProgressMap = this.getProgressData(String.format(Locale.ROOT, "import_cache_%s", verifyRecord));
                break;
            }
            default: {
                dataProgressMap = new HashMap(0);
            }
        }
        Integer succCount = 0;
        Integer failCount = 0;
        if (dataProgressMap != null) {
            succCount = dataProgressMap.get("successCount") == null ? Integer.valueOf(0) : (Integer)dataProgressMap.get("successCount");
            failCount = dataProgressMap.get("failCount") == null ? Integer.valueOf(0) : (Integer)dataProgressMap.get("failCount");
        }
        Label checkSuccLabel = (Label)this.getView().getControl("checksucccount");
        Label checkFailLabel = (Label)this.getView().getControl("checkfailcount");
        Label checkPendingLabel = (Label)this.getView().getControl("checktodocount");
        Html calhtml = (Html)this.getView().getControl("htmlap_checkstatus");
        BigDecimal caledCount = new BigDecimal(succCount.toString()).add(new BigDecimal(failCount.toString()));
        BigDecimal checkCount = new BigDecimal(totalCount.toString());
        BigDecimal pendingCount = checkCount.subtract(caledCount);
        checkSuccLabel.setText(succCount.toString());
        checkFailLabel.setText(failCount.toString());
        checkPendingLabel.setText(pendingCount.toString());
        Integer progress = this.setProgress(evt, checkCount, caledCount, calhtml);
        Html opDescription = (Html)this.getControl("opdescription");
        if (progress == 100) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btncancel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"stopop", "minsize"});
            StringBuilder opDesc = new StringBuilder();
            opDesc.append("<div><span style='font-size:12px;color:#5fbf00'>");
            opDesc.append(this.getEndOpDescription(progressType, timeMsg));
            opDesc.append("</span></div>");
            opDescription.setConent(opDesc.toString());
            if ("22".equals(progressType) && failCount > 0) {
                this.openImportingView(succCount.toString(), failCount.toString(), verifyRecord);
            }
        }
        if (SWCStringUtils.equals((String)startProgress, (String)"false")) {
            ProgressBar checkProgressBar = (ProgressBar)this.getControl(CHECKPROGRESS);
            checkProgressBar.stop();
            this.getView().setVisible(Boolean.FALSE, new String[]{"stopop", "minsize"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btncancel"});
            StringBuilder calText = new StringBuilder();
            calText.append("<div><span style='font-size:12px;color:#b2b2b2'>");
            String stopMsg = ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"CalProgressPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            calText.append(stopMsg);
            calText.append("</span></div>");
            calhtml.setConent(calText.toString());
            StringBuilder opDesc = new StringBuilder();
            opDesc.append("<div><span style='font-size:12px;color:#f90d58'>");
            opDesc.append(this.getStopOpDescription(progressType));
            opDesc.append("</span></div>");
            opDescription.setConent(opDesc.toString());
        }
    }

    private void openImportingView(String successCount, String failCount, String cacheKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hsas_taskguideimportret");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("importTaskId", this.getView().getFormShowParameter().getCustomParam("importTaskId"));
        formShowParameter.setCustomParam("successCout", (Object)successCount);
        formShowParameter.setCustomParam("failCout", (Object)failCount);
        formShowParameter.setCustomParam("cacheKey", (Object)cacheKey);
        this.getView().getParentView().showForm(formShowParameter);
        this.getView().close();
    }

    private Map<String, Integer> getProgressData(String key) {
        Integer failCount;
        ISWCAppCache appCache = SWCAppCache.get((String)key);
        Integer succCount = (Integer)appCache.get("successCount", Integer.class);
        if (succCount == null) {
            succCount = 0;
        }
        if ((failCount = (Integer)appCache.get("failCount", Integer.class)) == null) {
            failCount = 0;
        }
        HashMap<String, Integer> dataProgressMap = new HashMap<String, Integer>(2);
        dataProgressMap.put("successCount", succCount);
        dataProgressMap.put("failCount", failCount);
        return dataProgressMap;
    }

    private Integer setProgress(ProgressEvent evt, BigDecimal calCount, BigDecimal caledCount, Html html) {
        StringBuilder calText = null;
        Integer calProgressPercent = this.calProgress(caledCount, calCount);
        if (calProgressPercent <= 0) {
            calText = new StringBuilder();
            calText.append("<div><span style='font-size:12px;color:#007fff'>");
            calText.append(ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"CalProgressPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        } else if (calProgressPercent >= 100) {
            calText = new StringBuilder();
            calText.append("<div><span style='font-size:12px;color:#5fbf00'>");
            calText.append(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"CalProgressPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        } else {
            calText = new StringBuilder();
            calText.append("<div><span style='font-size:12px;color:#007fff'>");
            calText.append(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"CalProgressPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        calText.append("</span></div>");
        evt.setProgress(calProgressPercent.intValue());
        evt.setText(calText.toString());
        html.setConent(calText.toString());
        return calProgressPercent;
    }

    private int calProgress(BigDecimal caledCount, BigDecimal calCount) {
        if (caledCount.compareTo(calCount) == 0) {
            return 100;
        }
        if (BigDecimal.ZERO.compareTo(caledCount) == 0) {
            return 0;
        }
        BigDecimal progress = caledCount.divide(calCount, 2, 4).multiply(new BigDecimal("100"));
        if (progress.intValue() == 100 && caledCount.compareTo(calCount) != 0) {
            return 99;
        }
        return progress.intValue();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (DONOTHING_STOP.equals(args.getOperateKey())) {
            String progressType;
            this.getPageCache().put("cachekey_startpropgress", "false");
            FormShowParameter parameter = this.getView().getFormShowParameter();
            switch (progressType = (String)parameter.getCustomParam("progressType")) {
                case "4": {
                    this.stopDataCheck();
                    break;
                }
                case "3": {
                    this.stopDataCheck();
                    break;
                }
                case "5": {
                    this.stopDataWriteIn(false);
                    break;
                }
                case "6": {
                    this.stopDataWriteIn(true);
                    break;
                }
                case "22": {
                    this.stopImport();
                    break;
                }
            }
        } else if (DONOTHING_MINSIZE.equals(args.getOperateKey())) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String verifyRecord = (String)parameter.getCustomParam("verifyId");
            ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "bggroud_taskid_%s", verifyRecord));
            String bgTaskId = (String)bgAppCache.get("bgTaskId", String.class);
            if (SWCStringUtils.isNotEmpty((String)bgTaskId)) {
                HRBackgroundTaskHelper.getInstance().showBaskgroundTask(bgTaskId);
            }
            this.getView().close();
        }
    }

    private void stopImport() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String verifyRecord = (String)parameter.getCustomParam("verifyId");
        String msg = ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f", (String)"DataCheckProgressPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String key = String.format(Locale.ROOT, "import_cache_%s", verifyRecord);
        ISWCAppCache appCache = SWCAppCache.get((String)key);
        appCache.put(String.format(Locale.ROOT, "isCancel_%s", verifyRecord), (Object)Boolean.TRUE);
        this.getView().showSuccessNotification(msg);
    }

    private void stopDataWriteIn(boolean isUnWirteIn) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long importTaskId = (Long)parameter.getCustomParam("importTaskId");
        String msg = ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f", (String)"DataCheckProgressPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String key = isUnWirteIn ? MessageFormat.format("dataUnWriteIn_progress_{0}", importTaskId) : MessageFormat.format("dataWriteIn_progress_{0}", importTaskId);
        ISWCAppCache appCache = SWCAppCache.get((String)key);
        appCache.put("isCancel", (Object)Boolean.TRUE);
        ImportTaskUtils.updateImportTaskStatus((Long)importTaskId, (String)"1");
        this.getView().showSuccessNotification(msg);
    }

    private void stopDataCheck() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String verifyRecord = (String)parameter.getCustomParam("verifyId");
        Long verifyRecordId = Long.valueOf(verifyRecord);
        Long importTaskId = (Long)parameter.getCustomParam("importTaskId");
        String msg = ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f", (String)"DataCheckProgressPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        try (TXHandle txHandle = TX.requiresNew();){
            String key = String.format(Locale.ROOT, "dataCheck_progress_%s", verifyRecordId);
            ISWCAppCache appCache = SWCAppCache.get((String)key);
            appCache.put(String.format(Locale.ROOT, "isCancel_%s", verifyRecordId), (Object)Boolean.TRUE);
            ImportTaskUtils.updateImportTaskStatus((Long)importTaskId, (String)"1");
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_verifyrecord");
            DynamicObject verify = helper.queryOne((Object)verifyRecordId);
            verify.set("status", (Object)"3");
            verify.set("modifier", (Object)RequestContext.get().getCurrUserId());
            verify.set("modifytime", (Object)new Date());
            helper.updateOne(verify);
        }
        this.getView().showSuccessNotification(msg);
    }
}

