/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.importtask.guide;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.importtaskguide.DataPreDealTask;
import kd.swc.hsas.business.importtaskguide.utils.ImportTaskUtils;
import kd.swc.hsas.common.constants.ImportTaskConstants;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillList;
import org.apache.commons.collections.CollectionUtils;

public class ImportTaskGuideOpereateBillList
extends SWCCoreBaseBillList {
    private static final Log logger = LogFactory.getLog(ImportTaskGuideOpereateBillList.class);
    private static final String DONOTHING_DATAPREDEAL = "donothing_datapredeal";
    private static final String DONOTHING_CHECK = "donothing_check";
    private static final String DONOTHING_IMPORT = "donothing_import";
    private static final String IMPORTDATA = "importData";
    private static final String CHECKPROGRESS = "checkprogress";
    private static final String DATAPREDEAL = "dataPreDeal";
    private static final String IMPORTINGDATA = "importingData";
    private static final String VIEW_VERIFYREPORT = "donothing_viewverifyreport";
    private static final String AUDIT = "donothing_audit";
    private static final String UNAUDIT = "donothing_unaudit";
    private static final String WRITEIN = "donothing_writein";
    private static final String UNWRITEIN = "donothing_unwritein";
    private static String UNWRITE_PARAM_CALTASK = "unwrite_param_caltask_{0}";
    private static String UNWRITE_PARAM_TEMPORARY_BATCH = "unwrite_param_temporary_batch_{0}_{1}";
    private static String UNWRITE_PARAM_TEMPORARYID = "unwrite_param_temporaryid_{0}_{1}";
    private static final Set<String> OPERATIONTYPE_SET_DEALANDCHECK = new HashSet<String>(2);
    private static final Set<String> OPERATIONTYPE_SET_APPROVEANDWRITE = new HashSet<String>(2);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long importTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("importTaskId");
        String creatorId = (String)this.getView().getFormShowParameter().getCustomParam("creator");
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (!this.checkHaveButtonPerm(opKey)) {
            args.setCancel(true);
            return;
        }
        OperateOption operateOption = this.batchOpCompleted(formOperate);
        switch (opKey) {
            case "donothing_import": {
                this.opeanImportStartPage();
                break;
            }
            case "donothing_datapredeal": {
                this.preDealData(importTaskId, args, Long.parseLong(creatorId));
                break;
            }
            case "donothing_check": {
                this.checkData(importTaskId, args);
                break;
            }
            case "delete": {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u4efb\u52a1\u6b63\u5728\u6267\u884c\u6821\u9a8c\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u3002", (String)"ImportTaskGuideOpereateBillList_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                if (this.checkTaskStatus(false, true)) {
                    args.setCancel(true);
                    break;
                }
                if (!this.checkIsChecking(importTaskId, msg)) break;
                args.setCancel(true);
                break;
            }
            case "donothing_viewverifyreport": {
                if (this.checkTaskStatus(false, true)) {
                    return;
                }
                this.openVerifyReportView();
                break;
            }
            case "donothing_audit": {
                if (operateOption == null || this.checkUpdateStatusData(this.getSelectedDataIdList(), "3")) break;
                args.setCancel(true);
                break;
            }
            case "donothing_unaudit": {
                if (operateOption == null || this.checkUpdateStatusData(this.getSelectedDataIdList(), "4")) break;
                args.setCancel(true);
                break;
            }
            case "donothing_writein": {
                this.writeIn(importTaskId);
                break;
            }
            case "donothing_unwritein": {
                this.unWriteIn(importTaskId, this.getSelectedDataIdList());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if ("delete".equals(opKey)) {
            Long importTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("importTaskId");
            ImportTaskUtils.updateImportTaskStatus((Long)importTaskId);
        } else if (AUDIT.equals(opKey)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"ImportTaskGuideOpereateBillList_31", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else if (UNAUDIT.equals(opKey)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"ImportTaskGuideOpereateBillList_32", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void checkData(Long importTaskId, BeforeDoOperationEventArgs args) {
        if (this.checkTaskStatus(true, true)) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u4efb\u52a1\u6b63\u5728\u6267\u884c\u6821\u9a8c\uff0c\u65e0\u6cd5\u8fdb\u884c\u6267\u884c\u6821\u9a8c\u64cd\u4f5c\u3002", (String)"ImportTaskGuideOpereateBillList_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        if (this.checkIsChecking(importTaskId, msg)) {
            args.setCancel(true);
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        QFilter filter = new QFilter("importtask.id", "=", (Object)importTaskId);
        filter.and("datastatus", "in", Arrays.asList("1", "2"));
        int count = helper.count(new QFilter[]{filter});
        if (count == 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7684\u6570\u636e\u72b6\u6001\u90fd\u4e0d\u662f\u5df2\u9884\u5904\u7406\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u6267\u884c\u6821\u9a8c\u3002", (String)"ImportTaskGuideOpereateBillList_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        Date startTime = new Date();
        String writeTaskType = (String)this.getView().getFormShowParameter().getCustomParam("writetasktype");
        Long verifyRecordId = this.saveVerifyRecord(count, importTaskId, startTime, "1", "4");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String name = ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u6267\u884c\u6821\u9a8c-%s", (String)"ImportTaskGuideOpereateBillList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String importTaskName = (String)this.getView().getFormShowParameter().getCustomParam("importTaskName");
        name = String.format(Locale.ROOT, name, importTaskName);
        params.put("importTaskId", importTaskId);
        params.put("verifyId", String.valueOf(verifyRecordId));
        params.put("totalCount", count);
        params.put("startTime", SWCDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        params.put("progressType", "4");
        String bgTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_importtaskguide_datacheck", name, true, this.getView().getPageId(), params);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "bggroud_taskid_%s", verifyRecordId));
        appCache.put("bgTaskId", (Object)bgTaskId);
        SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IImportTaskService", (String)"hisDataCheck", (Object[])new Object[]{verifyRecordId, importTaskId, writeTaskType});
        String caption = ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c", (String)"ImportTaskGuideOpereateBillList_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.openProgressPage(count, importTaskId, "4", CHECKPROGRESS, caption, verifyRecordId.toString());
    }

    private boolean checkIsChecking(Long importTaskId, String msg) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_verifyrecord");
        QFilter filter = new QFilter("importtask", "=", (Object)importTaskId);
        filter.and("status", "=", (Object)"1");
        int count = helper.count(new QFilter[]{filter});
        if (count > 0) {
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    private Long saveVerifyRecord(int totalCount, Long importTaskId, Date startTime, String operationType, String taskStatus) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_verifyrecord");
        DynamicObject obj = helper.generateEmptyDynamicObject();
        Long verifyRecordId = DB.genLongId((String)"t_hsas_verifyrecord");
        obj.set("id", (Object)verifyRecordId);
        obj.set("reportnum", (Object)CalHelper.getReportNum());
        obj.set("importtask", (Object)importTaskId);
        obj.set("totalcount", (Object)totalCount);
        obj.set("starttime", (Object)startTime);
        obj.set("status", (Object)"1");
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        obj.set("createtime", (Object)new Date());
        obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        obj.set("modifytime", (Object)new Date());
        obj.set("operationtype", (Object)operationType);
        try (TXHandle txHandle = TX.requiresNew();){
            helper.saveOne(obj);
            ImportTaskUtils.updateImportTaskStatus((Long)importTaskId, (String)taskStatus);
        }
        return verifyRecordId;
    }

    private void preDealData(Long importTaskId, BeforeDoOperationEventArgs args, Long creatorId) {
        if (this.checkTaskStatus(true, true)) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u4efb\u52a1\u6b63\u5728\u6267\u884c\u6821\u9a8c\uff0c\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u9884\u5904\u7406\u3002", (String)"ImportTaskGuideOpereateBillList_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        if (this.checkIsChecking(importTaskId, msg)) {
            args.setCancel(true);
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        String fields = "id";
        QFilter filter = new QFilter("importtask", "=", (Object)importTaskId);
        filter.and("datastatus", "=", (Object)"0");
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter}, "payrollgroup,payrollscene,periodtypename,periodname desc");
        if (result.size() == 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7684\u6570\u636e\u72b6\u6001\u90fd\u4e0d\u662f\u5df2\u5bfc\u5165\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u9884\u5904\u7406\u3002", (String)"ImportTaskGuideOpereateBillList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        helper.setEntityName("hbss_empgroup");
        DynamicObject empObj = helper.queryOriginalOne("id,name", (Object)ImportTaskConstants.DEFAULT_EMPGROUPID);
        String writeTaskType = (String)this.getView().getFormShowParameter().getCustomParam("writetasktype");
        List idList = result.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Long verifyRecordId = this.saveVerifyRecord(result.size(), importTaskId, new Date(), "0", "3");
        ImportTaskUtils.updateImportTaskStatus((Long)importTaskId, (String)"3");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String name = ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u6570\u636e\u9884\u5904\u7406-%s", (String)"ImportTaskGuideOpereateBillList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String importTaskName = (String)this.getView().getFormShowParameter().getCustomParam("importTaskName");
        name = String.format(Locale.ROOT, name, importTaskName);
        params.put("importTaskId", importTaskId);
        params.put("verifyId", String.valueOf(verifyRecordId));
        params.put("totalCount", result.size());
        params.put("startTime", SWCDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        params.put("progressType", "3");
        String bgTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_importtaskguide_predeal", name, true, this.getView().getPageId(), params);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "bggroud_taskid_%s", verifyRecordId));
        appCache.put("bgTaskId", (Object)bgTaskId);
        List splitIdList = SWCListUtils.split(idList, (int)1000);
        for (List tempIdList : splitIdList) {
            SWCThreadPoolFactory.getHisdataIntegrateThreadpool().submit((Callable)new DataPreDealTask(tempIdList, creatorId, RequestContext.get(), importTaskId, verifyRecordId, writeTaskType, empObj.getString("name")));
        }
        String caption = ResManager.loadKDString((String)"\u6570\u636e\u9884\u5904\u7406\u770b\u677f", (String)"ImportTaskGuideOpereateBillList_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.openProgressPage(result.size(), importTaskId, "3", DATAPREDEAL, caption, String.valueOf(verifyRecordId));
    }

    private void opeanImportStartPage() {
        if (this.checkTaskStatus(false, true)) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setShowTitle(false);
        formShowParameter.setFormId("hsas_taskguideimport");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("importTaskName", this.getView().getFormShowParameter().getCustomParam("importTaskName"));
        formShowParameter.setCustomParam("migrationtplId", this.getView().getFormShowParameter().getCustomParam("migrationtplId"));
        formShowParameter.setCustomParam("importTaskId", this.getView().getFormShowParameter().getCustomParam("importTaskId"));
        formShowParameter.setCustomParam("writetasktype", this.getView().getFormShowParameter().getCustomParam("writetasktype"));
        formShowParameter.setCustomParam("orgId", this.getView().getFormShowParameter().getCustomParam("orgId"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORTDATA));
        this.getView().showForm(formShowParameter);
    }

    private boolean checkHaveButtonPerm(String operateKey) {
        boolean flag = true;
        switch (operateKey) {
            case "donothing_import": {
                if (SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_importtask", (String)"2PAWH9DYXXLZ")) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u201d\u7684\u201c\u5bfc\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportTaskGuideOpereateBillList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                flag = false;
                break;
            }
            case "delete": {
                if (SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_importtask", (String)"4715e1f1000000ac")) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportTaskGuideOpereateBillList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                flag = false;
                break;
            }
            case "donothing_datapredeal": {
                if (SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_importtask", (String)"2PAWI4KR1R18")) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u201d\u7684\u201c\u6570\u636e\u9884\u5904\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportTaskGuideOpereateBillList_21", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                flag = false;
                break;
            }
            case "donothing_check": {
                if (SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_importtask", (String)"2PAWOQ7PIDRD")) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u201d\u7684\u201c\u6267\u884c\u6821\u9a8c\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportTaskGuideOpereateBillList_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                flag = false;
                break;
            }
            case "donothing_viewverifyreport": {
                if (SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_importtask", (String)"2PAWR=M+=PVS")) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u201d\u7684\u201c\u67e5\u770b\u62a5\u544a\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportTaskGuideOpereateBillList_23", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                flag = false;
                break;
            }
            case "donothing_writein": {
                if (SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_importtask", (String)"2PAWPH3B1PUM")) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u201d\u7684\u201c\u5199\u5165\u5386\u53f2\u6570\u636e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportTaskGuideOpereateBillList_24", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                flag = false;
                break;
            }
            case "donothing_unwritein": {
                if (SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_importtask", (String)"2PAWQHQVKI08")) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u201d\u7684\u201c\u53cd\u5199\u5165\u5386\u53f2\u6570\u636e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportTaskGuideOpereateBillList_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                flag = false;
                break;
            }
            case "donothing_audit": {
                if (SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_importtask", (String)"47162f66000000ac")) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u201d\u7684\u201c\u5ba1\u6838\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportTaskGuideOpereateBillList_26", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                flag = false;
                break;
            }
            case "donothing_unaudit": {
                if (SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_importtask", (String)"47165e8e000000ac")) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u201d\u7684\u201c\u53cd\u5ba1\u6838\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportTaskGuideOpereateBillList_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                flag = false;
                break;
            }
        }
        return flag;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (IMPORTDATA.equals(actionId)) {
            Map returnData = (Map)event.getReturnData();
            if (returnData == null) {
                return;
            }
            if (((Boolean)returnData.get("isOk")).booleanValue()) {
                int totalCount = Integer.parseInt(returnData.get("totalCount").toString());
                Long importTaskId = (Long)returnData.get("importTaskId");
                String cacheKey = (String)returnData.get("cacheKey");
                String caption = ResManager.loadKDString((String)"\u5bfc\u5165\u770b\u677f", (String)"ImportTaskGuideOpereateBillList_33", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.openProgressPage(totalCount, importTaskId, "22", IMPORTINGDATA, caption, cacheKey);
            }
        } else if (IMPORTINGDATA.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (CHECKPROGRESS.equals(actionId) || DATAPREDEAL.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (WRITEIN.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (UNWRITEIN.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void openVerifyReportView() {
        ListShowParameter show = new ListShowParameter();
        show.setFormId("bos_list");
        show.setBillFormId("hsas_verifyrecord");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Long importTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("importTaskId");
        show.setCustomParam("importTaskId", (Object)importTaskId);
        QFilter filter = new QFilter("importtask.id", "=", (Object)importTaskId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(filter);
        String tabKey = (String)this.getView().getFormShowParameter().getCustomParam("tabKey");
        QFilter operationTypeFilter = null;
        switch (tabKey) {
            case "dealandcheck": {
                operationTypeFilter = new QFilter("operationtype", "in", OPERATIONTYPE_SET_DEALANDCHECK);
                break;
            }
            case "approveandwrite": {
                operationTypeFilter = new QFilter("operationtype", "in", OPERATIONTYPE_SET_APPROVEANDWRITE);
                break;
            }
        }
        if (operationTypeFilter != null) {
            filters.add(operationTypeFilter);
        }
        show.setListFilterParameter(new ListFilterParameter(filters, "starttime desc"));
        show.setPageId(this.getView().getPageId() + "_" + importTaskId);
        this.getView().showForm((FormShowParameter)show);
    }

    private List<Long> getSelectedDataIdList() {
        ListSelectedRowCollection listSelectedData = ((ListView)this.getView()).getSelectedRows();
        List<Long> selectedIdList = listSelectedData.stream().map(selectData -> (Long)selectData.getPrimaryKeyValue()).collect(Collectors.toList());
        return selectedIdList;
    }

    private boolean checkUpdateStatusData(List<Long> selectedDataIdList, String fromStatus) {
        boolean checkResult;
        if (this.checkTaskStatus(true, true)) {
            return false;
        }
        if (CollectionUtils.isEmpty(selectedDataIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImportTaskGuideOpereateBillList_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        QFilter filter = new QFilter("id", "in", selectedDataIdList);
        filter.and(new QFilter("datastatus", "=", (Object)fromStatus));
        boolean bl = checkResult = helper.count(new QFilter[]{filter}) > 0;
        if (!checkResult) {
            if (SWCStringUtils.equals((String)fromStatus, (String)"4")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u80fd\u53cd\u5ba1\u6838\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u6570\u636e\u3002", (String)"ImportTaskGuideOpereateBillList_28", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            } else if (SWCStringUtils.equals((String)fromStatus, (String)"3")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u80fd\u5ba1\u6838\u6570\u636e\u72b6\u6001\u4e3a\u6821\u9a8c\u6210\u529f\u7684\u6570\u636e\u3002", (String)"ImportTaskGuideOpereateBillList_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIn(Long importTaskId) {
        if (this.checkTaskStatus(true, true)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        QFilter filter = new QFilter("importtask", "=", (Object)importTaskId);
        DynamicObjectCollection temporaryDatas = helper.queryOriginalCollection("id,datastatus", new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)temporaryDatas)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"ImportTaskGuideOpereateBillList_30", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> effectiveIdList = new ArrayList<Long>(temporaryDatas.size());
        for (DynamicObject temporaryData : temporaryDatas) {
            String dataStatus = temporaryData.getString("datastatus");
            if (SWCStringUtils.equals((String)"4", (String)dataStatus)) {
                effectiveIdList.add(temporaryData.getLong("id"));
                continue;
            }
            if (SWCStringUtils.equals((String)dataStatus, (String)"5")) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u8bb0\u5f55\u7684\u6570\u636e\u72b6\u6001\u5747\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u624d\u53ef\u8fdb\u884c\u5199\u5165\u3002", (String)"ImportTaskGuideOpereateBillList_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (CollectionUtils.isEmpty(effectiveIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"ImportTaskGuideOpereateBillList_30", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        Date startTime = new Date();
        Long verifyRecordId = this.saveVerifyRecord(effectiveIdList.size(), importTaskId, startTime, "2", "5");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String name = ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u5199\u5165-%s", (String)"ImportTaskGuideOpereateBillList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String importTaskName = (String)this.getView().getFormShowParameter().getCustomParam("importTaskName");
        name = String.format(Locale.ROOT, name, importTaskName);
        params.put("importTaskId", importTaskId);
        params.put("verifyId", String.valueOf(verifyRecordId));
        params.put("totalCount", effectiveIdList.size());
        params.put("startTime", SWCDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        params.put("progressType", "5");
        String bgTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_importtaskguide_write", name, true, this.getView().getPageId(), params);
        ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "bggroud_taskid_%s", verifyRecordId));
        bgAppCache.put("bgTaskId", (Object)bgTaskId);
        boolean isFail = false;
        try (TXHandle txHandle = TX.requiresNew();){
            helper.setEntityName("hsas_importtask");
            DynamicObject importTask = helper.queryOne("id,taskstatus,modifytime,modifier", new QFilter[]{new QFilter("id", "=", (Object)importTaskId)});
            importTask.set("modifytime", (Object)startTime);
            importTask.set("modifier", (Object)RequestContext.get().getCurrUserId());
            importTask.set("taskstatus", (Object)"5");
            helper.updateOne(importTask);
            ISWCAppCache appCache = SWCAppCache.get((String)MessageFormat.format("dataWriteIn_progress_{0}", importTaskId));
            appCache.put("totalCount", (Object)effectiveIdList.size());
            appCache.put("failCount", (Object)0);
            appCache.put("successCount", (Object)0);
            appCache.put("isCancel", (Object)Boolean.FALSE);
            SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IImportTaskService", (String)"writeIn", (Object[])new Object[]{importTaskId, verifyRecordId});
        }
        if (!isFail) {
            String caption = ResManager.loadKDString((String)"\u5199\u5165\u770b\u677f", (String)"ImportTaskGuideOpereateBillList_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.openProgressPage(effectiveIdList.size(), importTaskId, "5", WRITEIN, caption, String.valueOf(verifyRecordId));
        }
    }

    private void unWriteIn(Long importTaskId, List<Long> selectedDataIdList) {
        if (this.checkTaskStatus(true, true)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        QFilter filter = new QFilter("importtask", "=", (Object)importTaskId);
        filter.and(new QFilter("id", "in", selectedDataIdList));
        filter.and("datastatus", "=", (Object)"5");
        DynamicObjectCollection temporaryDatas = helper.queryOriginalCollection("id,datastatus,caltask.id", new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)temporaryDatas)) {
            return;
        }
        helper.setEntityName("hsas_importtask");
        DynamicObject importTask = helper.queryOriginalOne("taskstatus", new QFilter[]{new QFilter("id", "=", (Object)importTaskId)});
        String preTaskStatus = importTask.getString("taskstatus");
        Date startTime = new Date();
        Long verifyRecordId = this.saveVerifyRecord(temporaryDatas.size(), importTaskId, startTime, "3", "6");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String name = ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u53cd\u5199\u5165-%s", (String)"ImportTaskGuideOpereateBillList_34", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String importTaskName = (String)this.getView().getFormShowParameter().getCustomParam("importTaskName");
        name = String.format(Locale.ROOT, name, importTaskName);
        params.put("importTaskId", importTaskId);
        params.put("verifyId", String.valueOf(verifyRecordId));
        params.put("totalCount", temporaryDatas.size());
        params.put("startTime", SWCDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        params.put("progressType", "6");
        String bgTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_importtaskguide_unwrite", name, true, this.getView().getPageId(), params);
        ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "bggroud_taskid_%s", verifyRecordId));
        bgAppCache.put("bgTaskId", (Object)bgTaskId);
        boolean isFail = false;
        try {
            ISWCAppCache appCache = SWCAppCache.get((String)MessageFormat.format("dataUnWriteIn_progress_{0}", importTaskId));
            appCache.put("totalCount", (Object)temporaryDatas.size());
            appCache.put("isCancel", (Object)Boolean.FALSE);
            appCache.put("failCount", (Object)0);
            appCache.put("successCount", (Object)0);
            appCache.put("preTaskStatus", (Object)preTaskStatus);
            this.cacheUnWriteParam(appCache, verifyRecordId, temporaryDatas);
            SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IImportTaskService", (String)"unWriteIn", (Object[])new Object[]{importTaskId, verifyRecordId});
        }
        catch (Exception exception) {
            logger.error("\u8c03\u7528\u53cd\u5199\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)exception);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u5fae\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u5904\u7406\u3002", (String)"ImportTaskGuideOpereateBillList_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            isFail = true;
            ImportTaskUtils.updateImportTaskStatus((Long)importTaskId, (String)"1");
        }
        if (!isFail) {
            String caption = ResManager.loadKDString((String)"\u53cd\u5199\u5165\u770b\u677f", (String)"ImportTaskGuideOpereateBillList_20", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.openProgressPage(temporaryDatas.size(), importTaskId, "6", UNWRITEIN, caption, String.valueOf(verifyRecordId));
        }
    }

    private void cacheUnWriteParam(ISWCAppCache appCache, Long verifyRecordId, DynamicObjectCollection temporaryDatas) {
        List temporaryIdList;
        HashMap<Long, List> temporaryIdListMap = new HashMap<Long, List>(16);
        HashSet<Long> calTaskIdSet = new HashSet<Long>(16);
        for (DynamicObject temporaryData : temporaryDatas) {
            Long calTaskId = temporaryData.getLong("caltask.id");
            calTaskIdSet.add(calTaskId);
            Long temporaryId = temporaryData.getLong("id");
            temporaryIdList = temporaryIdListMap.computeIfAbsent(calTaskId, key -> new ArrayList(10));
            temporaryIdList.add(temporaryId);
        }
        try {
            appCache.put(MessageFormat.format(UNWRITE_PARAM_CALTASK, String.valueOf(verifyRecordId)), (Object)JSONUtils.toString(calTaskIdSet));
            int batchIndex = 0;
            for (Map.Entry entry : temporaryIdListMap.entrySet()) {
                Long calTaskId = (Long)entry.getKey();
                temporaryIdList = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)temporaryIdList)) continue;
                int batchCount = temporaryIdList.size() / 10000 + 1;
                ArrayList<Integer> batchIndexList = new ArrayList<Integer>(batchCount);
                for (int index = 0; index < batchCount; ++index) {
                    int startIndex = index * 10000;
                    int endIndex = startIndex + 10000;
                    if (endIndex > temporaryIdList.size()) {
                        endIndex = temporaryIdList.size();
                    }
                    List partIdList = temporaryIdList.subList(startIndex, endIndex);
                    batchIndexList.add(batchIndex);
                    appCache.put(MessageFormat.format(UNWRITE_PARAM_TEMPORARYID, String.valueOf(verifyRecordId), String.valueOf(batchIndex)), (Object)JSONUtils.toString(partIdList));
                    ++batchIndex;
                }
                appCache.put(MessageFormat.format(UNWRITE_PARAM_TEMPORARY_BATCH, String.valueOf(verifyRecordId), String.valueOf(calTaskId)), (Object)JSONUtils.toString(batchIndexList));
            }
        }
        catch (Exception exception) {
            logger.error("\u7f13\u5b58\u53cd\u5199\u53c2\u6570\u4fe1\u606f\u5931\u8d25", (Throwable)exception);
        }
    }

    private void openProgressPage(int totalCount, Long importTaskId, String progressType, String closeCalBackId, String caption, String verifyId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hsas_datacheckprogress");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParam("importTaskId", (Object)importTaskId);
        formShowParameter.setCustomParam("totalCount", (Object)totalCount);
        formShowParameter.setCustomParam("verifyId", (Object)verifyId);
        formShowParameter.setCustomParam("startTime", (Object)SWCDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        formShowParameter.setCustomParam("progressType", (Object)progressType);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCalBackId));
        this.getView().showForm(formShowParameter);
    }

    private boolean checkTaskStatus(boolean checkIsRunning, boolean checkIsClosed) {
        Long importTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("importTaskId");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_importtask");
        DynamicObject importTask = helper.queryOriginalOne("id,taskstatus", new QFilter[]{new QFilter("id", "=", (Object)importTaskId)});
        String taskStatus = importTask.getString("taskstatus");
        String msg = null;
        if (checkIsRunning) {
            if (SWCStringUtils.equals((String)taskStatus, (String)"4")) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u540e\u53f0\u6267\u884c\u6821\u9a8c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ImportTaskGuideOpereateBillList_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)taskStatus, (String)"3")) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u540e\u53f0\u6267\u884c\u9884\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ImportTaskGuideOpereateBillList_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)taskStatus, (String)"6")) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u540e\u53f0\u6267\u884c\u53cd\u5199\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ImportTaskGuideOpereateBillList_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)taskStatus, (String)"5")) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u540e\u53f0\u6267\u884c\u5199\u5165\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ImportTaskGuideOpereateBillList_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            } else if (SWCStringUtils.equals((String)taskStatus, (String)"9")) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u540e\u53f0\u6267\u884c\u6e05\u9664\u4e2d\u95f4\u8868\u6570\u636e\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ImportTaskGuideOpereateBillList_36", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            }
            if (msg != null) {
                this.getView().showTipNotification(msg);
                return true;
            }
        }
        if (checkIsClosed && (SWCStringUtils.equals((String)taskStatus, (String)"7") || SWCStringUtils.equals((String)taskStatus, (String)"8"))) {
            msg = ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"ImportTaskGuideOpereateBillList_35", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return true;
        }
        return false;
    }

    private OperateOption batchOpCompleted(FormOperate formOperate) {
        OperateOption operateOption = formOperate.getOption();
        if (operateOption.tryGetVariableValue("batchop_completed", new RefObject())) {
            logger.info("operate batch execute completed");
            return null;
        }
        return operateOption;
    }

    static {
        OPERATIONTYPE_SET_DEALANDCHECK.add("0");
        OPERATIONTYPE_SET_DEALANDCHECK.add("1");
        OPERATIONTYPE_SET_APPROVEANDWRITE.add("2");
        OPERATIONTYPE_SET_APPROVEANDWRITE.add("3");
    }
}

