/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.importtask.guide;

import java.io.IOException;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ImportTaskGuidePlugin
extends AbstractListPlugin
implements TabSelectListener {
    private static final String DATAIMPORTFLEX = "dataimportflex";
    private static final String DEALANDCHECKFLEX = "dealandcheckflex";
    private static final String APPROVEANDWRITEFLEX = "approveandwriteflex";

    public void registerListener(EventObject args) {
        Tab tabSteps = (Tab)this.getControl("tabap");
        tabSteps.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeBindData(EventObject arg) {
        this.applyMutexLock();
        this.clearAppCache();
        Tab tabSteps = (Tab)this.getControl("tabap");
        tabSteps.activeTab("dataimport");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)opKey, (String)"innerrefresh")) {
            ISWCAppCache appCache = SWCAppCache.get((String)"verifyRecordId");
            String verifyRecordId = (String)appCache.get(this.getView().getPageId(), String.class);
            this.getPageCache().put("verifyRecordId", verifyRecordId);
            appCache.put(this.getView().getPageId(), null);
            String tabKey = this.getPageCache().get("tabKey");
            String targetKey = this.getPageCache().get("targetKey");
            this.loadChildrenPage(tabKey, targetKey);
        }
    }

    private void applyMutexLock() {
        Long importTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("importTaskId");
        StringBuilder msg = new StringBuilder();
        boolean require = MutexHelper.require((String)"hsas_importtask", (Object)importTaskId, (String)"modify", (boolean)true, (StringBuilder)msg);
        SWCPageCache cache = new SWCPageCache(this.getView());
        if (require) {
            cache.put("currentPageLocked", (Object)Boolean.TRUE);
            return;
        }
        cache.put("isLocked", (Object)Boolean.TRUE);
        this.getView().showTipNotification(msg.toString());
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.getPageCache().put("tabKey", tabKey);
        switch (tabKey) {
            case "dataimport": {
                this.loadChildrenPage("dataimport", DATAIMPORTFLEX);
                this.getPageCache().put("targetKey", DATAIMPORTFLEX);
                break;
            }
            case "dealandcheck": {
                this.loadChildrenPage("dealandcheck", DEALANDCHECKFLEX);
                this.getPageCache().put("targetKey", DEALANDCHECKFLEX);
                break;
            }
            case "approveandwrite": {
                this.loadChildrenPage("approveandwrite", APPROVEANDWRITEFLEX);
                this.getPageCache().put("targetKey", APPROVEANDWRITEFLEX);
                break;
            }
        }
    }

    private void loadChildrenPage(String tabKey, String targetKey) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isLocked = (Boolean)pageCache.get("isLocked", Boolean.class);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setBillFormId("hsas_temporarydata");
        showParameter.setFormId("bos_list");
        showParameter.setLookUp(false);
        showParameter.setShowTitle(false);
        showParameter.setCustomParam("importTaskId", parameter.getCustomParam("importTaskId"));
        showParameter.setCustomParam("importTaskName", parameter.getCustomParam("importTaskName"));
        showParameter.setCustomParam("migrationtplId", parameter.getCustomParam("migrationtplId"));
        showParameter.setCustomParam("writetasktype", parameter.getCustomParam("writetasktype"));
        showParameter.setCustomParam("orgId", parameter.getCustomParam("orgId"));
        if (isLocked != null && isLocked.booleanValue()) {
            showParameter.setCustomParam("isLocked", (Object)Boolean.TRUE);
        } else {
            showParameter.setCustomParam("isLocked", (Object)Boolean.FALSE);
        }
        String title = null;
        title = "dealandcheck".equals(tabKey) ? ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u4e0e\u6821\u9a8c", (String)"ImportTaskGuidePlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ("approveandwrite".equals(tabKey) ? ResManager.loadKDString((String)"\u5ba1\u6838\u5e76\u5199\u5165\u85aa\u8d44\u7ed3\u679c", (String)"ImportTaskGuidePlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165", (String)"ImportTaskGuidePlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCaption(title);
        showParameter.setCustomParam("creator", parameter.getCustomParam("creator"));
        showParameter.setCustomParam("tabKey", (Object)tabKey);
        showParameter.setCustomParam("verifyRecordId", (Object)this.getPageCache().get("verifyRecordId"));
        this.getPageCache().put("verifyRecordId", null);
        showParameter.setSendToClient(true);
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("importtask", "=", parameter.getCustomParam("importTaskId")));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pageRelease(EventObject e) {
        String groupId = MutexHelper.getMutexGroupId((String)"hsas_importtask", (String)"modify");
        Long importTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("importTaskId");
        DataMutex dataMutex = null;
        try {
            String currentOwner;
            dataMutex = DataMutex.create();
            Map mutex = dataMutex.getLockInfo(String.valueOf(importTaskId), groupId, "hsas_importtask");
            if (null == mutex) return;
            if (mutex.isEmpty()) {
                return;
            }
            String lockOwner = (String)mutex.get("GLOBALSESSION");
            if (!ObjectUtils.nullSafeEquals((Object)lockOwner, (Object)(currentOwner = RequestContext.get().getGlobalSessionId()))) {
                return;
            }
            SWCPageCache cache = new SWCPageCache(this.getView());
            Boolean isCurrentPageLocked = (Boolean)cache.get("currentPageLocked", Boolean.class);
            if (isCurrentPageLocked == null) {
                return;
            }
            MutexHelper.release((String)"hsas_importtask", (String)"modify", (String)String.valueOf(importTaskId));
            return;
        }
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.clearAppCache();
    }

    private void clearAppCache() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String cacheKey = parameter.getCustomParam("importTaskId") + "_" + parameter.getCustomParam("migrationtplId");
        ISWCAppCache appCache = SWCAppCache.get((String)cacheKey);
        appCache.remove("columnHeadList");
    }
}

