/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.importtask.guide;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.DateListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.importtaskguide.utils.ImportTaskUtils;
import kd.swc.hsas.formplugin.web.basedata.importtask.guide.ImportTaskGuideEntityTypeBillList;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillList;
import org.apache.commons.collections.CollectionUtils;

public class ImportTaskGuideViewBillList
extends SWCCoreBaseBillList {
    private static final Log logger = LogFactory.getLog(ImportTaskGuideViewBillList.class);
    private static final String KEY_BILL_LIST_AP = "billlistap";
    private static final String[] DATAIMPORT_HIDE = new String[]{"datapredeal", "check", "tblaudit", "tblwritein", "viewverifyreport"};
    private static final String[] DATAIMPORT_SHOW = new String[]{"import", "tbldel"};
    private static final String[] DEALANDCHECK_HIDE = new String[]{"import", "tbldel", "tblaudit", "tblwritein"};
    private static final String[] DEALANDCHECK_SHOW = new String[]{"datapredeal", "check", "viewverifyreport"};
    private static final String[] APPROVEANDWRITE_HIDE = new String[]{"import", "tbldel", "datapredeal", "check"};
    private static final String[] APPROVEANDWRITE_SHOW = new String[]{"tblaudit", "tblwritein", "viewverifyreport"};
    private static final Set<String> COMMONCOLUMNSET = new HashSet<String>(8);
    private static final String[] FIELD_UNVISIBLED = new String[]{"import", "tbldel", "datapredeal", "check", "tblaudit", "tblwritein", "tblunaudit", "tblunwritein", "viewverifyreport"};
    private static final String[] FIELD_LOCKED_ARRAY = new String[]{"import", "tbldel", "datapredeal", "check", "tblaudit", "tblwritein", "viewverifyreport", "tblunaudit", "tblunwritein"};
    private ImportTaskGuideEntityTypeBillList billList;

    public void initialize() {
        super.initialize();
        String verifyRecordId = (String)this.getView().getFormShowParameter().getCustomParam("verifyRecordId");
        this.getView().getFormShowParameter().setCustomParam("verifyRecordId", null);
        this.getPageCache().put("verifyRecordId", verifyRecordId);
    }

    public void beforeBindData(EventObject arg) {
        String tabKey = (String)this.getView().getFormShowParameter().getCustomParam("tabKey");
        Boolean isLocked = (Boolean)this.getView().getFormShowParameter().getCustomParam("isLocked");
        if (tabKey == null) {
            return;
        }
        String[] showBtn = null;
        String[] hideBtn = null;
        switch (tabKey) {
            case "dataimport": {
                showBtn = DATAIMPORT_SHOW;
                hideBtn = DATAIMPORT_HIDE;
                break;
            }
            case "dealandcheck": {
                showBtn = DEALANDCHECK_SHOW;
                hideBtn = DEALANDCHECK_HIDE;
                break;
            }
            case "approveandwrite": {
                showBtn = APPROVEANDWRITE_SHOW;
                hideBtn = APPROVEANDWRITE_HIDE;
                break;
            }
        }
        this.getView().setVisible(Boolean.FALSE, hideBtn);
        this.getView().setVisible(Boolean.TRUE, showBtn);
        Long importTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("importTaskId");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_importtask");
        DynamicObject importTask = helper.queryOriginalOne("taskstatus", new QFilter[]{new QFilter("id", "=", (Object)importTaskId)});
        if (SWCStringUtils.equals((String)"7", (String)importTask.getString("taskstatus")) || SWCStringUtils.equals((String)"8", (String)importTask.getString("taskstatus"))) {
            this.getView().setVisible(Boolean.FALSE, FIELD_UNVISIBLED);
        } else if (isLocked != null && isLocked.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, FIELD_LOCKED_ARRAY);
        } else {
            this.getView().setEnable(Boolean.TRUE, FIELD_LOCKED_ARRAY);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        super.getEntityType(args);
        args.setNewEntityType(this.getEntityType());
    }

    private MainEntityType getEntityType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hsas_temporarydata");
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = (MainEntityType)mainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            logger.error("getNewEntityType: ", (Throwable)e1);
        }
        if (mainEntityType == null) {
            return mainType;
        }
        List<Map<String, String>> columnHeadList = this.getColumnHeadList();
        this.addItemProp((DynamicObjectType)mainEntityType, columnHeadList);
        return mainEntityType;
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        BillList customControl = null;
        if (KEY_BILL_LIST_AP.equals(key)) {
            customControl = this.createBillList(key);
        }
        if (customControl != null) {
            args.setControl((Control)customControl);
        }
    }

    protected BillList createBillList(String key) {
        if (this.billList != null) {
            return this.billList;
        }
        this.billList = new ImportTaskGuideEntityTypeBillList((EntityType)this.getEntityType());
        this.billList.setKey(key);
        this.billList.setEntityId("hsas_temporarydata");
        ListView listView = (ListView)this.getView();
        this.billList.setBillFormId(listView.getBillFormId());
        this.billList.setView((IFormView)listView);
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.billList);
        return this.billList;
    }

    private void replaceBillList(List<Control> items, Control billList) {
        for (int i = 0; i < items.size(); ++i) {
            Control control = items.get(i);
            if (control.getKey().equals(billList.getKey())) {
                items.set(i, billList);
                return;
            }
            if (!(control instanceof Container)) continue;
            this.replaceBillList(((Container)control).getItems(), billList);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columnList = args.getListColumns();
        ArrayList<IListColumn> commonColumnList = new ArrayList<IListColumn>(10);
        HashMap<String, IListColumn> otherFixColumnMap = new HashMap<String, IListColumn>(16);
        for (IListColumn obj : columnList) {
            if (COMMONCOLUMNSET.contains(obj.getListFieldKey())) {
                commonColumnList.add(obj);
                continue;
            }
            otherFixColumnMap.put(obj.getListFieldKey(), obj);
        }
        columnList.clear();
        columnList.addAll(commonColumnList);
        List<Map<String, String>> columnHeadList = this.getColumnHeadList();
        if (SWCListUtils.isEmpty((List)columnList)) {
            return;
        }
        int seq = columnList.size() + 1;
        String key = null;
        String itemType = null;
        for (Map<String, String> tempMap : columnHeadList) {
            Long dataTypeId = Long.valueOf(tempMap.get("datatypeid"));
            String name = tempMap.get("name");
            key = tempMap.get("key");
            itemType = tempMap.get("itemType");
            if ("0".equals(itemType)) {
                IListColumn tempColumn;
                if (COMMONCOLUMNSET.contains(key) || (tempColumn = (IListColumn)otherFixColumnMap.get(key)) == null) continue;
                columnList.add(tempColumn);
                ++seq;
                continue;
            }
            if (1050L == dataTypeId) {
                DateListColumn dateListColumn = new DateListColumn();
                dateListColumn.setDisplayFormatString("yyyy-MM-dd");
                dateListColumn.setCaption(new LocaleString(name));
                dateListColumn.setKey(key);
                dateListColumn.setListFieldKey(key);
                dateListColumn.setSeq(seq);
                columnList.add(dateListColumn);
            } else {
                ListColumn column = new ListColumn();
                column.setCaption(new LocaleString(name));
                column.setKey(key);
                column.setListFieldKey(key);
                column.setSeq(seq);
                columnList.add(column);
            }
            ++seq;
        }
    }

    private List<Map<String, String>> getColumnHeadList() {
        ArrayList<Map<String, String>> columnHeadList = new ArrayList<Map<String, String>>(10);
        Long migrationtplId = (Long)this.getView().getFormShowParameter().getCustomParam("migrationtplId");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (migrationtplId == null || migrationtplId == 0L) {
            return columnHeadList;
        }
        return ImportTaskUtils.getColumnHeadList((Long)migrationtplId, (Long)((Long)parameter.getCustomParam("importTaskId")));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ImportItemDataResultImpl());
    }

    private void addItemProp(DynamicObjectType mainEntityType, List<Map<String, String>> columnHeadList) {
        String key = null;
        Long dataTypeId = null;
        String name = null;
        String itemType = null;
        for (Map<String, String> temMap : columnHeadList) {
            TextProp property;
            key = temMap.get("key");
            itemType = temMap.get("itemType");
            if ("0".equals(itemType)) continue;
            dataTypeId = Long.valueOf(temMap.get("datatypeid"));
            name = temMap.get("name");
            if (1030L == dataTypeId || 1010L == dataTypeId || 1020L == dataTypeId) {
                property = new TextProp();
                property.setName(key);
                property.setDisplayName(new LocaleString(name));
                property.setMaxLenth(200);
                mainEntityType.addProperty((DynamicProperty)property);
                continue;
            }
            if (1050L != dataTypeId) continue;
            property = new DateProp();
            property.setName(key);
            property.setDisplayName(new LocaleString(name));
            mainEntityType.addProperty((DynamicProperty)property);
        }
    }

    public void beforeClosed(BeforeClosedEvent arg) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("close");
            this.getView().sendFormAction(parentView);
        }
    }

    public void setFilter(SetFilterEvent event) {
        String verifyRecordId = this.getPageCache().get("verifyRecordId");
        if (SWCStringUtils.isEmpty((String)verifyRecordId)) {
            return;
        }
        event.getQFilters().add(this.getVerifyRecordFilter(Long.valueOf(verifyRecordId)));
        this.getPageCache().put("verifyRecordId", null);
    }

    private QFilter getVerifyRecordFilter(Long verifyRecordId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_verifydetail");
        DynamicObjectCollection verifyDetails = helper.queryOriginalCollection("temporarydata", new QFilter[]{new QFilter("verifyrecord", "=", (Object)verifyRecordId)});
        if (CollectionUtils.isEmpty((Collection)verifyDetails)) {
            return new QFilter("1", "=", (Object)2);
        }
        List temporaryDataIdList = verifyDetails.stream().map(verifyDetail -> verifyDetail.getLong("temporarydata")).collect(Collectors.toList());
        return new QFilter("id", "in", temporaryDataIdList);
    }

    static {
        COMMONCOLUMNSET.add("fseq");
        COMMONCOLUMNSET.add("datastatus");
        COMMONCOLUMNSET.add("caltaskname");
        COMMONCOLUMNSET.add("caltask.tasktype");
    }

    public class ImportItemDataResultImpl
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection list = super.getData(start, limit);
            if (this.getQueryBuilder().isSelectedAllRows()) {
                return list;
            }
            List columnHeadList = ImportTaskGuideViewBillList.this.getColumnHeadList();
            if (SWCListUtils.isEmpty((List)columnHeadList)) {
                return list;
            }
            ImportTaskGuideViewBillList.this.addItemProp(list.getDynamicObjectType(), columnHeadList);
            List<Long> idList = list.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            Map<Long, Map<String, Object>> itemDataMap = this.getItemDataMap(idList);
            if (itemDataMap.size() == 0) {
                return list;
            }
            Map<String, Object> tempMap = null;
            for (DynamicObject obj2 : list) {
                tempMap = itemDataMap.get(obj2.getLong("id"));
                if (tempMap == null || tempMap.size() == 0) continue;
                for (Map.Entry<String, Object> entry : tempMap.entrySet()) {
                    obj2.set(entry.getKey(), entry.getValue());
                }
            }
            return list;
        }

        private Map<Long, Map<String, Object>> getItemDataMap(List<Long> idList) {
            HashMap<Long, Map<String, Object>> itemDataMap = new HashMap<Long, Map<String, Object>>(16);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
            String fields = "id,itementry.itemtype,itementry.itemid,itementry.datatype,itementry.itemvalue";
            QFilter qFilter = new QFilter("id", "in", idList);
            DynamicObjectCollection itemData = helper.queryOriginalCollection(fields, new QFilter[]{qFilter});
            if (itemData.size() == 0) {
                return itemDataMap;
            }
            HashMap<String, Object> tempMap = null;
            long dataTypeId = 0L;
            String itemValue = null;
            String columnKey = null;
            for (DynamicObject obj : itemData) {
                tempMap = (HashMap<String, Object>)itemDataMap.get(obj.getLong("id"));
                if (tempMap == null) {
                    tempMap = new HashMap<String, Object>(16);
                    itemDataMap.put(obj.getLong("id"), tempMap);
                }
                dataTypeId = obj.getLong("itementry.datatype");
                itemValue = obj.getString("itementry.itemvalue");
                if (itemValue == null) continue;
                columnKey = this.getColumnKey(obj.getString("itementry.itemtype"), obj.getLong("itementry.itemid"));
                if (1020L == dataTypeId || 1010L == dataTypeId) {
                    tempMap.put(columnKey, new BigDecimal(itemValue));
                    continue;
                }
                if (1050L == dataTypeId) {
                    try {
                        tempMap.put(columnKey, SWCDateTimeUtils.parseDate((String)itemValue, (String)"yyyy-MM-dd"));
                    }
                    catch (ParseException e) {
                        logger.error("parse itemValue error", (Throwable)e);
                    }
                    continue;
                }
                tempMap.put(columnKey, itemValue);
            }
            return itemDataMap;
        }

        private String getColumnKey(String itemType, long itemId) {
            String columnKey = "";
            if ("4".equals(itemType)) {
                columnKey = "ft" + itemId;
            } else if ("1".equals(itemType)) {
                columnKey = "sl" + itemId;
            } else if ("3".equals(itemType)) {
                columnKey = "bs" + itemId;
            } else if ("2".equals(itemType)) {
                columnKey = "sp" + itemId;
            }
            return columnKey;
        }
    }
}

