/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.importtask.guide;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class TaskGuideImportingPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTN_ERRORDETAIL = "errordetail";
    private static final String LABEL_SUCCESSCOUNT = "successcount";
    private static final String LABEL_FAILCOUNT = "failcount";
    private static final String IMPORT_EXCEL_URL_KEY = "importExcelUrlKey";

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BTN_ERRORDETAIL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter params = this.getView().getFormShowParameter();
        String successCout = (String)params.getCustomParam("successCout");
        String failCout = (String)params.getCustomParam("failCout");
        this.updateRetLabel(successCout, failCout);
    }

    private void updateRetLabel(String successCount, String failCount) {
        Label success = (Label)this.getView().getControl(LABEL_SUCCESSCOUNT);
        Label fail = (Label)this.getView().getControl(LABEL_FAILCOUNT);
        success.setText(successCount);
        fail.setText(failCount);
        if (Integer.parseInt(failCount) == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap111", "imageap11", "labelap3", LABEL_FAILCOUNT, "labelap21", KEY_BTN_ERRORDETAIL});
        }
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if (KEY_BTN_ERRORDETAIL.equals(controlKey)) {
            FormShowParameter params = this.getView().getFormShowParameter();
            String cacheKey = (String)params.getCustomParam("cacheKey");
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "import_cache_%s", cacheKey));
            String errFilePath = (String)appCache.get("fileUrl", String.class);
            if (StringUtils.isNotBlank((CharSequence)errFilePath)) {
                this.getView().download(errFilePath);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u5931\u8d25\u6587\u4ef6\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TaskGuideImportingPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

