/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.importtask.report;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cal.calreport.dto.CalDetailExportDto;
import kd.swc.hsas.business.importtaskguide.export.MigrationDetailExportHelper;
import kd.swc.hsas.common.utils.TaskUtil;
import kd.swc.hsas.formplugin.web.basedata.importtask.report.FailInfoEntryControl;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class VerifyReportPlugin
extends SWCDataBaseEdit {
    private static final String IMPORT_TASK_NAME = "importtaskname";
    private static final String FAIL_DETAIL_LAP = "faildetaillap";
    private static final String FAIL_DETAIL_ENTRY = "entryentity";
    private static final String TOTAL_COUNT = "totalcount";
    private static final String SUCCESS_COUNT = "successcount";
    private static final String FAIL_COUNT = "failcount";
    private static final String FAIL_1_COUNT = "fail1count";
    private static final String FAIL_2_COUNT = "fail2count";
    private static final String FAIL_3_COUNT = "fail3count";
    private static final String FAIL_4_COUNT = "fail4count";
    private static final String FAIL_5_COUNT = "fail5count";
    private static final String FAIL_6_COUNT = "fail6count";
    private static final String TOTAL_COUNT_LABEL = "totalcount";
    private static final String SUCCESS_COUNT_LABEL = "successcount";
    private static final String FAIL_COUNT_LABEL = "failcount";
    private static final String DONOTHING_EXPORT = "donothing_export";
    private static final String PROGRESS = "progress";
    private static final String COMPLETE = "complete";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{FAIL_DETAIL_ENTRY});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"totalcount", "successcount", "failcount"});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String entryKey = e.getKey();
        if (entryKey.equalsIgnoreCase(FAIL_DETAIL_ENTRY)) {
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                return;
            }
            FailInfoEntryControl newCustGrid = oldGrid instanceof FailInfoEntryControl ? (FailInfoEntryControl)oldGrid : new FailInfoEntryControl();
            newCustGrid.setView(this.getView());
            newCustGrid.setKey(entryKey);
            newCustGrid.setEntryKey(entryKey);
            newCustGrid.setSplitPage(true);
            if (oldGrid instanceof EntryGrid) {
                newCustGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
                newCustGrid.setPageRow(((EntryGrid)oldGrid).getPageRow());
            }
            e.setControl((Control)newCustGrid);
        }
    }

    public void beforeBindData(EventObject e) {
        this.loadData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entry = (EntryGrid)this.getView().getControl(FAIL_DETAIL_ENTRY);
        entry.setPageRows(entry.getPageRow());
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (SWCStringUtils.equals((String)"failcount", (String)key)) {
            this.openGuidePage();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)operKey, (String)DONOTHING_EXPORT)) {
            this.entryDataExport();
        }
    }

    private void loadData() {
        DynamicObject verifyReportInfo = this.getVerifyReportInfo();
        if (verifyReportInfo == null) {
            return;
        }
        String importTaskName = verifyReportInfo.getString("importtask.name");
        this.modifyLabelValue(IMPORT_TASK_NAME, importTaskName);
        int totalCount = verifyReportInfo.getInt("totalcount");
        this.modifyLabelValue("totalcount", String.valueOf(totalCount));
        int successCount = verifyReportInfo.getInt("sucesscount");
        this.modifyLabelValue("successcount", String.valueOf(successCount));
        int failCount = verifyReportInfo.getInt("failcount");
        this.modifyLabelValue("failcount", String.valueOf(failCount));
        DynamicObjectCollection verifyDetailInfo = this.getVerifyDetailInfo();
        if (CollectionUtils.isEmpty((Collection)verifyDetailInfo)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FAIL_DETAIL_LAP});
            return;
        }
        HashMap<String, Integer> failCountMap = new HashMap<String, Integer>(5);
        failCountMap.put(FAIL_1_COUNT, 0);
        failCountMap.put(FAIL_2_COUNT, 0);
        failCountMap.put(FAIL_3_COUNT, 0);
        failCountMap.put(FAIL_4_COUNT, 0);
        failCountMap.put(FAIL_5_COUNT, 0);
        for (DynamicObject verifyDetail : verifyDetailInfo) {
            this.setFailCout(verifyDetail, failCountMap);
        }
        this.modifyLabelValue(FAIL_1_COUNT, String.valueOf(failCountMap.get(FAIL_1_COUNT)));
        this.modifyLabelValue(FAIL_2_COUNT, String.valueOf(failCountMap.get(FAIL_2_COUNT)));
        this.modifyLabelValue(FAIL_3_COUNT, String.valueOf(failCountMap.get(FAIL_3_COUNT)));
        this.modifyLabelValue(FAIL_4_COUNT, String.valueOf(failCountMap.get(FAIL_4_COUNT)));
        this.modifyLabelValue(FAIL_5_COUNT, String.valueOf(failCountMap.get(FAIL_5_COUNT)));
        int rowCount = verifyDetailInfo != null ? verifyDetailInfo.size() : 0;
        this.getPageCache().put("rowCount", String.valueOf(rowCount));
    }

    private void setFailCout(DynamicObject verifyDetail, Map<String, Integer> failCountMap) {
        String errorElement = verifyDetail.getString("errorelement");
        if (ImportTaskFailMsgEnum.PAYROLLGROUP_NOT_EXIST.getErrorElement().equals(errorElement)) {
            failCountMap.put(FAIL_1_COUNT, failCountMap.get(FAIL_1_COUNT) + 1);
        } else if (ImportTaskFailMsgEnum.PAYROLLSCENCE_NOT_AUDIT.getErrorElement().equals(errorElement)) {
            failCountMap.put(FAIL_2_COUNT, failCountMap.get(FAIL_2_COUNT) + 1);
        } else if (ImportTaskFailMsgEnum.CALPERIODTYPE_NOT_EXIST.getErrorElement().equals(errorElement) || ImportTaskFailMsgEnum.CALPERIOD_NOT_EXIST.getErrorElement().equals(errorElement)) {
            failCountMap.put(FAIL_3_COUNT, failCountMap.get(FAIL_3_COUNT) + 1);
        } else if (ImportTaskFailMsgEnum.CALTASK_NOT_EXIST.getErrorElement().equals(errorElement)) {
            failCountMap.put(FAIL_4_COUNT, failCountMap.get(FAIL_4_COUNT) + 1);
        } else if (ImportTaskFailMsgEnum.PERSON_NOT_EXIST.getErrorElement().equals(errorElement) || ImportTaskFailMsgEnum.SALARYFILE_NOT_EXIST.getErrorElement().equals(errorElement)) {
            failCountMap.put(FAIL_5_COUNT, failCountMap.get(FAIL_5_COUNT) + 1);
        }
    }

    private void openGuidePage() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_importtask");
        Long importTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("importTaskId");
        DynamicObject data = helper.queryOne("id,name,migrationtpl.id,creator.id", (Object)importTaskId);
        if (data == null) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"VerifyReportPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("hsas_importtaskguide");
        String caption = MessageFormat.format(ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1 - {0}", (String)"VerifyReportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), data.getString("name"));
        parameter.setCaption(caption);
        parameter.setCustomParam("importTaskId", (Object)importTaskId);
        parameter.setCustomParam("importTaskName", (Object)data.getString("name"));
        parameter.setCustomParam("migrationtplId", (Object)data.getLong("migrationtpl.id"));
        parameter.setCustomParam("creator", (Object)String.valueOf(data.getLong("creator.id")));
        String pageId = this.getView().getMainView() == null ? this.getView().getPageId() : this.getView().getMainView().getPageId();
        pageId = pageId + '_' + importTaskId;
        parameter.setPageId(pageId);
        this.getView().showForm(parameter);
        ISWCAppCache appCache = SWCAppCache.get((String)"verifyRecordId");
        appCache.put(pageId, (Object)this.getView().getFormShowParameter().getCustomParam("verifyReportId").toString());
        IFormView guidePageView = this.getView().getView(parameter.getPageId());
        guidePageView.invokeOperation("innerrefresh");
        this.getView().sendFormAction(guidePageView);
    }

    private DynamicObjectCollection getVerifyDetailInfo() {
        Long verifyReportId = (Long)this.getView().getFormShowParameter().getCustomParam("verifyReportId");
        if (verifyReportId == null) {
            return null;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_verifydetail");
        DynamicObjectCollection verifyDetails = helper.queryOriginalCollection("errorelement", new QFilter[]{new QFilter("verifyrecord.id", "=", (Object)verifyReportId)});
        return verifyDetails;
    }

    private DynamicObject getVerifyReportInfo() {
        Long verifyReportId = (Long)this.getView().getFormShowParameter().getCustomParam("verifyReportId");
        if (verifyReportId == null) {
            return null;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_verifyrecord");
        DynamicObject verifyRecord = helper.queryOriginalOne("id,importtask.id,importtask.name,sucesscount,failcount,totalcount", new QFilter[]{new QFilter("id", "=", (Object)verifyReportId)});
        return verifyRecord;
    }

    private void modifyLabelValue(String labelName, String modifyStr) {
        Label lable = (Label)this.getControl(labelName);
        lable.setText(modifyStr);
    }

    private void entryDataExport() {
        DynamicObject verifyReport = this.getVerifyReportInfo();
        if (verifyReport == null) {
            return;
        }
        this.doExport(verifyReport.getLong("id"));
    }

    private void doExport(Long recordId) {
        QFilter filter = new QFilter("verifyrecord", "=", (Object)recordId);
        MigrationDetailExportHelper helper = new MigrationDetailExportHelper();
        Map headers = helper.getExportHeaders();
        CalDetailExportDto.Builder builder = new CalDetailExportDto.Builder();
        builder.setFilters(new QFilter[]{filter}).setHeaders(headers);
        String downLoadTaskId = TaskUtil.getExportTaskID();
        this.startExport(builder, downLoadTaskId, helper);
    }

    public void startExport(CalDetailExportDto.Builder builder, String downLoadTaskId, MigrationDetailExportHelper helper) {
        CalDetailExportDto dto = builder.build();
        QFilter[] filters = dto.getFilters();
        SWCDataServiceHelper verifyDetailHelper = new SWCDataServiceHelper("hsas_verifydetail");
        DynamicObjectCollection verifyDetails = verifyDetailHelper.queryOriginalCollection("id", filters);
        List verifyDetailList = verifyDetails.stream().map(verifyDetail -> verifyDetail.getLong("id")).collect(Collectors.toList());
        int totalElements = verifyDetails.size();
        int totalPages = (int)Math.ceil((double)totalElements * 1.0 / 100.0);
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        this.openExportProgressBar(totalElements, totalPages, countDownLatch, downLoadTaskId);
        Map headers = dto.getHeaders();
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u5931\u8d25\u8be6\u7ec6\u4fe1\u606f\u5bfc\u51fa_%s", (String)"VerifyReportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), date);
        RequestContext ctx = RequestContext.get();
        helper.mutiThreadExport(ctx, fileName, headers, totalPages, countDownLatch, this.getView(), totalElements, downLoadTaskId, verifyDetailList);
    }

    private void openExportProgressBar(int totalCount, int totalPages, CountDownLatch countDownLatch, String downLoadTaskId) {
        String pageId = this.getView().getPageId();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_caltableexportprog");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("pageId", (Object)pageId);
        para.setCustomParam("totalCount", (Object)totalCount);
        para.setCustomParam("status", (Object)0);
        para.setCustomParam("downLoadTaskId", (Object)downLoadTaskId);
        para.setCustomParam("exportMsg", (Object)ResManager.loadKDString((String)"\u5171\u9009\u4e2d%s\u6761\u6570\u636e", (String)"VerifyReportPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        para.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"VerifyReportPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (totalPages <= 0) {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)100);
            para.setCustomParam(PROGRESS, (Object)100);
        } else {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) / (long)totalPages));
            pageCache.put(COMPLETE + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) * 100L));
        }
        pageCache.saveChanges();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "openExportProgressBar");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }
}

