/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.itemgroup;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ItemGroupSettingVersionPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ITEMGROUP_NOLIMIT = "0";

    public void registerListener(EventObject args) {
        super.registerListener(args);
        this.addItemClickListeners(new String[]{"type", "bsed"});
        BasedataEdit itemGroup = (BasedataEdit)this.getView().getControl("itemgrp");
        itemGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.changeItemGroupType();
    }

    public void beforeClosed(BeforeClosedEvent args) {
        super.beforeClosed(args);
        IFormView parentView = this.getView().getParentView();
        parentView.invokeOperation("refresh");
        this.getView().sendFormAction(parentView);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        super.propertyChanged(args);
        switch (fieldKey = args.getProperty().getName()) {
            case "type": {
                this.changeItemGroupType();
                break;
            }
            case "bsed": {
                Date newValue = (Date)args.getChangeSet()[0].getNewValue();
                Date bsed = this.getModel().getDataEntity().getDate("itemgrp.firstbsed");
                if (bsed == null || !SWCDateTimeUtils.dayBefore((Date)newValue, (Date)bsed)) break;
                this.getModel().setValue("itemgrp", null);
                this.getView().updateView("itemgrp");
                break;
            }
        }
    }

    public void afterBindData(EventObject args) {
        super.afterBindData(args);
        this.getView().getModel().beginInit();
        this.getModel().setValue("status", (Object)"A");
        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
        this.getModel().setDataChanged(false);
        this.getView().getModel().endInit();
    }

    private void changeItemGroupType() {
        String selectType = this.getModel().getDataEntity().getString("type");
        FieldEdit control = (FieldEdit)this.getControl("itemgrp");
        if (SWCStringUtils.equals((String)selectType, (String)ITEMGROUP_NOLIMIT)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"itemgrp"});
            control.setMustInput(false);
            this.getView().getModel().setValue("itemgrp", null);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"itemgrp"});
            control.setMustInput(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "itemgrp": {
                this.setItemGroupF7(event);
                break;
            }
        }
    }

    private void setItemGroupF7(BeforeF7SelectEvent event) {
        Date bsed = this.getModel().getDataEntity().getDate("bsed");
        QFilter qFilter = new QFilter("firstbsed", "<=", (Object)bsed);
        long payRollRegion = this.getModel().getDataEntity().getLong("salaryfile.payrollregion.id");
        QFilter areaTypeFilter = new QFilter("country.id", "=", (Object)0L);
        if (payRollRegion != 0L) {
            areaTypeFilter.or(new QFilter("country.id", "=", (Object)payRollRegion));
        }
        qFilter.and(areaTypeFilter);
        long orgId = this.getModel().getDataEntity().getLong("salaryfile.org.id");
        if (orgId != 0L) {
            qFilter.and(new QFilter("org.id", "=", (Object)orgId));
        }
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }
}

