/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.migrationtpl.MigrationTemplateHelper;
import kd.swc.hsas.common.enums.PresetItemEnum;
import kd.swc.hsas.formplugin.web.basedata.HisBaseDataSummaryEdit;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class MigrationTemplateEdit
extends HisBaseDataSummaryEdit {
    private static final String WRITE_TASK_TYPE_CHANGE = "write_task_type_change";
    private static final String WRITE_TASK_TYPE_CHANGE_OLD_VALUE = "write_task_type_change_old";

    public void afterCreateNewData(EventObject e) {
        this.createPresetData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadMatchRelationInfo();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        int[] selectRowIndexs = ((EntryGrid)this.getControl("hsas_migrationtplent")).getSelectRows();
        switch (opKey) {
            case "donothing_addmaprelation": {
                this.openAddMatchRelationPage();
                break;
            }
            case "donothing_deleteentry": {
                if (selectRowIndexs.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MigrationTemplateEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                int[] rowIndexs = this.getChangeableRowIndexs(selectRowIndexs);
                if (rowIndexs.length < selectRowIndexs.length) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5b57\u6bb5\u4e0d\u53ef\u5220\u9664\u3002", (String)"MigrationTemplateEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                }
                this.deleteEntry(rowIndexs);
                break;
            }
            case "donothing_moveup": {
                if (selectRowIndexs.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MigrationTemplateEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                int[] rowIndexs = this.getChangeableRowIndexs(selectRowIndexs);
                this.moveUpEntry(rowIndexs);
                break;
            }
            case "donothing_movedown": {
                if (selectRowIndexs.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MigrationTemplateEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                int[] rowIndexs = this.getChangeableRowIndexs(selectRowIndexs);
                this.moveDownEntry(rowIndexs);
                break;
            }
            case "save": {
                ((FormOperate)args.getSource()).getOption().setVariableValue("save", Boolean.TRUE.toString());
                break;
            }
            case "submit": {
                ((FormOperate)args.getSource()).getOption().setVariableValue("save", Boolean.TRUE.toString());
                ((FormOperate)args.getSource()).getOption().setVariableValue("isList", Boolean.FALSE.toString());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "org": {
                this.clearUnPresetItemData();
                break;
            }
            case "writetasktype": {
                String newValue = (String)e.getChangeSet()[0].getNewValue();
                String oldValue = (String)e.getChangeSet()[0].getOldValue();
                if (SWCStringUtils.isEmpty((String)oldValue) && SWCStringUtils.isNotEmpty((String)newValue)) {
                    this.changePresetItemData();
                    break;
                }
                if (!SWCStringUtils.equals((String)String.valueOf(Boolean.TRUE), (String)this.getPageCache().get(WRITE_TASK_TYPE_CHANGE))) {
                    this.getPageCache().put(WRITE_TASK_TYPE_CHANGE, String.valueOf(Boolean.TRUE));
                    this.getPageCache().put(WRITE_TASK_TYPE_CHANGE_OLD_VALUE, oldValue);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5199\u5165\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u6620\u5c04\u5173\u7cfb\u914d\u7f6e\u5206\u5f55\u9884\u7f6e\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MigrationTemplateEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(WRITE_TASK_TYPE_CHANGE));
                    break;
                }
                this.getPageCache().remove(WRITE_TASK_TYPE_CHANGE);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "donothing_addmaprelation": {
                this.addMatchRelationCloseEvent((DynamicObjectCollection)evt.getReturnData());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "write_task_type_change": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.getPageCache().remove(WRITE_TASK_TYPE_CHANGE);
                    this.changePresetItemData();
                } else {
                    this.getModel().setValue("writetasktype", (Object)this.getPageCache().get(WRITE_TASK_TYPE_CHANGE_OLD_VALUE));
                }
                this.getPageCache().remove(WRITE_TASK_TYPE_CHANGE_OLD_VALUE);
                break;
            }
        }
    }

    private void clearUnPresetItemData() {
        int row = this.getModel().getEntryEntity("hsas_migrationtplent").getRowCount();
        int[] allRowIndex = new int[row];
        for (int index = 0; index < row; ++index) {
            allRowIndex[index] = index;
        }
        this.deleteEntry(this.getChangeableRowIndexs(allRowIndex));
    }

    private void createPresetData(boolean needUpdateView) {
        Boolean isArchivedData = (Boolean)this.getModel().getValue("isarchiveddata");
        if (isArchivedData.booleanValue()) {
            return;
        }
        TableValueSetter tableValueSetter = this.createTableValueSetter();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        List presetItemEnumsList = MigrationTemplateHelper.getPresetItemEnumList((String)((String)this.getModel().getValue("writetasktype")));
        if (CollectionUtils.isEmpty((Collection)presetItemEnumsList)) {
            return;
        }
        for (PresetItemEnum presetItemEnum : presetItemEnumsList) {
            tableValueSetter.addRow(new Object[]{presetItemEnum.getMatchColumn(), "0", presetItemEnum.getItemId(), Character.valueOf('-'), presetItemEnum.getItemName(), presetItemEnum.getDataTypeId(), presetItemEnum.getComment().getLocaleString(), ""});
        }
        model.batchCreateNewEntryRow("hsas_migrationtplent", tableValueSetter);
        model.endInit();
        if (needUpdateView) {
            this.getView().updateView("hsas_migrationtplent");
        }
    }

    private void createPresetData() {
        this.createPresetData(true);
    }

    private TableValueSetter createTableValueSetter() {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("matchcolumn", new Object[0]);
        setter.addField("itemtype", new Object[0]);
        setter.addField("itemid", new Object[0]);
        setter.addField("itemnumber", new Object[0]);
        setter.addField("itemname", new Object[0]);
        setter.addField("datatype", new Object[0]);
        setter.addField("comment", new Object[0]);
        setter.addField("uniquecode", new Object[0]);
        return setter;
    }

    private int[] getChangeableRowIndexs(int[] selectRowIndexs) {
        int presetDataSize = this.getPresetDataSize();
        ArrayList<Integer> selectRowIndexList = new ArrayList<Integer>(selectRowIndexs.length);
        for (int index : selectRowIndexs) {
            if (index < presetDataSize) continue;
            selectRowIndexList.add(index);
        }
        selectRowIndexs = new int[selectRowIndexList.size()];
        for (int index = 0; index < selectRowIndexList.size(); ++index) {
            selectRowIndexs[index] = (Integer)selectRowIndexList.get(index);
        }
        return selectRowIndexs;
    }

    private void deleteEntry(int[] rowIndexs) {
        if (rowIndexs.length == 0) {
            return;
        }
        this.getModel().deleteEntryRows("hsas_migrationtplent", rowIndexs);
    }

    private void moveUpEntry(int[] rowIndexs) {
        if (rowIndexs.length == 0) {
            return;
        }
        int presetDataSize = this.getPresetDataSize();
        if (rowIndexs[0] == presetDataSize) {
            int index;
            int continueIndex = 0;
            while (continueIndex + 1 < rowIndexs.length && rowIndexs[continueIndex + 1] == rowIndexs[continueIndex] + 1) {
                ++continueIndex;
            }
            ArrayList<Integer> filterIndexList = new ArrayList<Integer>(rowIndexs.length);
            for (index = continueIndex + 1; index < rowIndexs.length; ++index) {
                filterIndexList.add(rowIndexs[index]);
            }
            rowIndexs = new int[filterIndexList.size()];
            for (index = 0; index < filterIndexList.size(); ++index) {
                rowIndexs[index] = (Integer)filterIndexList.get(index);
            }
        }
        if (rowIndexs.length == 0) {
            return;
        }
        this.getModel().moveEntryRowsUp("hsas_migrationtplent", rowIndexs);
    }

    private void moveDownEntry(int[] rowIndexs) {
        if (rowIndexs.length == 0) {
            return;
        }
        this.getModel().moveEntryRowsDown("hsas_migrationtplent", rowIndexs);
    }

    private void openAddMatchRelationPage() {
        if (this.getModel().getValue("org") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u540e\uff0c\u518d\u6dfb\u52a0\u6620\u5c04\u5173\u7cfb\u3002", (String)"MigrationTemplateEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calitemselect");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u9879\u76ee", (String)"MigrationTemplateEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_addmaprelation"));
        this.getView().showForm(showParameter);
    }

    public void addMatchRelationCloseEvent(DynamicObjectCollection itemDatas) {
        if (itemDatas == null || itemDatas.size() == 0) {
            return;
        }
        int presetDataSize = this.getPresetDataSize();
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity("hsas_migrationtplent");
        HashMap existItemDataMap = new HashMap(entryDatas.size() - presetDataSize);
        int[] deleteRowIndex = new int[entryDatas.size() - presetDataSize];
        for (int index = presetDataSize; index < entryDatas.size(); ++index) {
            DynamicObject entryData = (DynamicObject)entryDatas.get(index);
            HashMap<String, String> existItemData = new HashMap<String, String>(2);
            existItemData.put("matchcolumn", entryData.getString("matchcolumn"));
            existItemData.put("comment", entryData.getString("comment"));
            existItemDataMap.put(entryData.getLong("itemid"), existItemData);
            deleteRowIndex[index - presetDataSize] = index;
        }
        if (deleteRowIndex.length != 0) {
            this.getModel().deleteEntryRows("hsas_migrationtplent", deleteRowIndex);
        }
        Map itemParamMap = MigrationTemplateHelper.analyzeItemDatas((DynamicObjectCollection)itemDatas, existItemDataMap);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tableValueSetter = this.createTableValueSetter();
        for (DynamicObject dataObj : itemDatas) {
            String matchColumn;
            String common;
            String unicode = dataObj.getString("itemunicodeid");
            Map itemParam = (Map)itemParamMap.get(unicode);
            if (itemParam == null) continue;
            Map existItemData = (Map)existItemDataMap.get(itemParam.get("id"));
            if (existItemData != null) {
                common = (String)existItemData.get("comment");
                matchColumn = (String)existItemData.get("matchcolumn");
            } else {
                common = "";
                matchColumn = "";
            }
            tableValueSetter.addRow(new Object[]{matchColumn, itemParam.get("itemType"), itemParam.get("id"), dataObj.get("itemnumber"), dataObj.get("itemname"), itemParam.get("dataTypeId"), common, unicode});
        }
        model.batchCreateNewEntryRow("hsas_migrationtplent", tableValueSetter);
        model.endInit();
        this.getView().updateView("hsas_migrationtplent");
    }

    private void loadMatchRelationInfo() {
        DynamicObject entry;
        int index;
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity("hsas_migrationtplent");
        int presetDataSize = this.getPresetDataSize();
        if (CollectionUtils.isEmpty((Collection)entryDatas)) {
            return;
        }
        Map itemParamMap = MigrationTemplateHelper.analyzeMatchItem((DynamicObjectCollection)entryDatas);
        IDataModel model = this.getModel();
        for (index = 0; index < presetDataSize; ++index) {
            entry = (DynamicObject)entryDatas.get(index);
            Long itemId = entry.getLong("itemid");
            PresetItemEnum presetItemEnum = MigrationTemplateHelper.getPresetItemEnum((Long)itemId);
            if (presetItemEnum == null) continue;
            model.setValue("itemnumber", (Object)Character.valueOf('-'), index);
            model.setValue("itemname", (Object)presetItemEnum.getItemName(), index);
            model.setValue("uniquecode", (Object)"", index);
        }
        for (index = presetDataSize; index < entryDatas.size(); ++index) {
            entry = (DynamicObject)entryDatas.get(index);
            String itemType = entry.getString("itemtype");
            Long itemId = entry.getLong("itemid");
            Map itemParam = (Map)itemParamMap.get(itemType + '-' + itemId);
            if (itemParam == null) continue;
            model.setValue("itemnumber", itemParam.get("itemnumber"), index);
            model.setValue("itemname", itemParam.get("itemname"), index);
            model.setValue("uniquecode", itemParam.get("uniquecode"), index);
        }
        this.getView().updateView("hsas_migrationtplent");
        this.getModel().setDataChanged(false);
    }

    private int getPresetDataSize() {
        DynamicObject entry;
        int index;
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity("hsas_migrationtplent");
        for (index = 0; index < entryDatas.size() && SWCStringUtils.equals((String)(entry = (DynamicObject)entryDatas.get(index)).getString("itemtype"), (String)"0"); ++index) {
        }
        return index;
    }

    private void changePresetItemData() {
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity("hsas_migrationtplent");
        Iterator iterator = entryDatas.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            if (!SWCStringUtils.equals((String)next.getString("itemtype"), (String)"0")) continue;
            iterator.remove();
        }
        ArrayList entryList = new ArrayList(entryDatas.size());
        entryList.addAll(entryDatas);
        this.getModel().deleteEntryData("hsas_migrationtplent");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tableValueSetter = this.createTableValueSetter();
        List presetItemEnumsList = MigrationTemplateHelper.getPresetItemEnumList((String)((String)this.getModel().getValue("writetasktype")));
        if (CollectionUtils.isEmpty((Collection)presetItemEnumsList)) {
            return;
        }
        for (PresetItemEnum presetItemEnum : presetItemEnumsList) {
            tableValueSetter.addRow(new Object[]{presetItemEnum.getMatchColumn(), "0", presetItemEnum.getItemId(), Character.valueOf('-'), presetItemEnum.getItemName(), presetItemEnum.getDataTypeId(), presetItemEnum.getComment().getLocaleString(), ""});
        }
        for (DynamicObject entryData : entryList) {
            tableValueSetter.addRow(new Object[]{entryData.getString("matchcolumn"), entryData.getString("itemtype"), entryData.getLong("itemid"), entryData.getString("itemnumber"), entryData.getString("itemname"), entryData.getLong("datatype.id"), entryData.getString("comment"), entryData.getString("uniquecode")});
        }
        model.batchCreateNewEntryRow("hsas_migrationtplent", tableValueSetter);
        model.endInit();
        this.getView().updateView("hsas_migrationtplent");
    }
}

