/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.sdk.swc.hsas.common.events.paydetail.BankAccountModifyFilterEvent;
import kd.swc.hsas.business.modifybankaccount.helper.BankAccountModifyHelper;
import kd.swc.hsas.business.modifybankaccount.view.SetCommonViewProperties;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCPayDetailAndModifyAcctList
extends AbstractListPlugin
implements SetCommonViewProperties {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean permFlag;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("querybankacctmodified".equals(formOperate.getOperateKey()) && !(permFlag = SWCPermissionServiceHelper.hasViewPermission((String)"/UHMBBGZQ65X", (String)"hsas_acctmodifybill"))) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u94f6\u884c\u5361\u53d8\u66f4\u5355-\u53d1\u653e\u660e\u7ec6\u53d8\u66f4\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"SWCPayDetailAndModifyAcctList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "modifybankacct": {
                this.viewF7OfModifyBankAccount(args);
                break;
            }
            case "querybankacctmodified": {
                this.viewRecordsOfModifiedBankAccount(args);
                break;
            }
            case "setnoticeaftermodified": {
                this.openNoticeViewOfModifyBankAccount();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("hsas_acctmodifyf7".equals(actionId)) {
            String returnData = (String)closedCallBackEvent.getReturnData();
            if ("successfully".equals(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"SWCPayDetailAndModifyAcctList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            } else if (returnData != null) {
                JSONObject returnDataJson = JSON.parseObject((String)returnData);
                String errMsg = ResManager.loadKDString((String)"\u5171\u9009\u4e2d{0}\u6761\u53d1\u653e\u660e\u7ec6\uff0c{1}\u6761\u5df2\u5728\u4ed8\u6b3e\u6d41\u7a0b\u4e2d\u6216\u5df2\u8fdb\u884c\u505c\u7f13\u53d1\u6216\u5df2\u5728\u8fdb\u884c\u94f6\u884c\u5361\u53d8\u66f4\u6216\u5df2\u5e9f\u5f03\u6216\u4e0d\u9700\u8981\u94f6\u884c\u5361\u4fe1\u606f\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u6392\u9664\u3002", (String)"SWCPayDetailAndModifyAcctList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                String errTip = MessageFormat.format(errMsg, (Integer)returnDataJson.get((Object)"allSize"), (Integer)returnDataJson.get((Object)"invalidSize"));
                this.getView().showTipNotification(errTip);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void viewF7OfModifyBankAccount(AfterDoOperationEventArgs args) {
        List successPkIdList = args.getOperationResult().getSuccessPkIds();
        if (successPkIdList == null || successPkIdList.isEmpty()) {
            return;
        }
        Set<Long> allPkIdSet = successPkIdList.stream().map(pkId -> (Long)pkId).collect(Collectors.toSet());
        HashSet<Long> validPkIdSet = new HashSet<Long>();
        HashSet<Long> invalidPkIdSet = new HashSet<Long>();
        this.separateDataToValidAndInvalid(allPkIdSet, validPkIdSet, invalidPkIdSet);
        if (validPkIdSet.isEmpty()) {
            return;
        }
        this.checkMsgTmplHadBeenSet();
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)16);
        customParams.put("successPkIdSet", validPkIdSet);
        customParams.put("failedPkIdSet", invalidPkIdSet.size());
        this.openPopupOfF7Name("hsas_acctmodifyf7", (AbstractFormPlugin)this, customParams, true);
    }

    private void checkMsgTmplHadBeenSet() {
        int msgTmplCount = BankAccountModifyHelper.queryMsgTmplCount();
        if (msgTmplCount == 0) {
            String errMsg = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u94f6\u884c\u5361\u901a\u77e5\u6a21\u677f\uff0c\u5c06\u65e0\u6cd5\u5411\u5458\u5de5\u53d1\u9001\u94f6\u884c\u5361\u53d8\u66f4\u901a\u77e5\u3002", (String)"SWCPayDetailAndModifyAcctList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
        }
    }

    private void separateDataToValidAndInvalid(Set<Long> allPkIdSet, Set<Long> validPkIdSet, Set<Long> invalidPkIdSet) {
        BankAccountModifyFilterEvent filterEvent = BankAccountModifyHelper.beforeBankAccountModifyFilterEvent();
        DynamicObject[] pkDyObjArr = BankAccountModifyHelper.queryValidPkIdList(allPkIdSet, (BankAccountModifyFilterEvent)filterEvent);
        if (pkDyObjArr == null || pkDyObjArr.length == 0) {
            String msg = filterEvent.getInvalidMessage();
            msg = SWCStringUtils.isEmpty((String)msg) ? ResManager.loadKDString((String)"\u9009\u4e2d\u660e\u7ec6\u672a\u5ba1\u6279\u5b8c\u6210\u3001\u6216\u5df2\u5728\u4ed8\u6b3e\u6d41\u7a0b\u4e2d\u3001\u6216\u5df2\u8fdb\u884c\u505c\u7f13\u53d1\u3001\u6216\u5df2\u5728\u8fdb\u884c\u94f6\u884c\u5361\u53d8\u66f4\u3001\u6216\u5df2\u5e9f\u5f03\u3001\u6216\u4e0d\u9700\u8981\u94f6\u884c\u5361\u4fe1\u606f\uff0c\u65e0\u6cd5\u53d8\u66f4\u94f6\u884c\u5361\u3002", (String)"SWCPayDetailAndModifyAcctList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : msg;
            this.getView().showErrorNotification(msg);
            return;
        }
        for (DynamicObject pkDyObj : pkDyObjArr) {
            validPkIdSet.add(pkDyObj.getLong("id"));
        }
        allPkIdSet.forEach(pkId -> {
            if (!validPkIdSet.contains(pkId)) {
                invalidPkIdSet.add((Long)pkId);
            }
        });
    }

    private void viewRecordsOfModifiedBankAccount(AfterDoOperationEventArgs args) {
        FormShowParameter showParameter = new FormShowParameter();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (!selectedRows.isEmpty()) {
            Set<Long> bankAccountBillPKIdSet = this.getBankAccountBillPkIdList(selectedRows.getPrimaryKeyValues());
            if (!bankAccountBillPKIdSet.isEmpty()) {
                showParameter.setCustomParam("filterIdSet", bankAccountBillPKIdSet);
            } else {
                String errMsg = ResManager.loadKDString((String)"\u6240\u9009\u660e\u7ec6\u65e0\u5173\u8054\u53d8\u66f4\u5355\uff0c\u65e0\u53ef\u67e5\u8be2\u8bb0\u5f55\u3002", (String)"SWCPayDetailAndModifyAcctList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
                return;
            }
        }
        showParameter.setFormId("hsas_bceditbilllist");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("isFromPayDetail", (Object)"1");
        showParameter.setParentPageId(this.getView().getPageId());
        this.getView().showForm(showParameter);
    }

    private Set<Long> getBankAccountBillPkIdList(Object[] payDetailIdArr) {
        Set payDetailIdSet = Arrays.asList(payDetailIdArr).stream().map(id -> (Long)id).collect(Collectors.toSet());
        DynamicObjectCollection bankAccountBillInfo = BankAccountModifyHelper.getBankAccountBillPkIdList(payDetailIdSet);
        return bankAccountBillInfo.stream().map(info -> info.getLong("id")).collect(Collectors.toSet());
    }

    private void openNoticeViewOfModifyBankAccount() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hsas_acctmodifymsg");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        this.getView().showForm(formShowParameter);
    }
}

